/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ValueType;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.exception.AssertException;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.ParseStatGroups;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.SimpleValue;
import java.sql.ResultSet;
import java.sql.SQLException;

class GroupingCols {
    protected ResultSet rows;
    protected InnerCol[] ctxCols;
    private int groupCount;

    void init(ParseStatGroups ctx) {
        this.rows = ctx.getRows();
        this.ctxCols = ctx.getCols();
        this.groupCount = ctx.getGroupCount() - ctx.getGroupTotal();
    }

    public final ResultSet getRows() {
        return this.rows;
    }

    public final int getGroupCount() {
        return this.groupCount;
    }

    public final SimpleValue findColValue(int colIdx) throws SQLException {
        for (int i = 0; i < this.ctxCols.length; ++i) {
            InnerCol icol = this.ctxCols[i];
            if (icol.colIndex != colIdx) continue;
            return icol.value;
        }
        throw new AssertException("\u627e\u4e0d\u5230\u5217");
    }

    private void syncValues() throws SQLException {
        for (int i = 0; i < this.ctxCols.length; ++i) {
            InnerCol col = this.ctxCols[i];
            int colIdx = col.getColIndex();
            SimpleValue colVal = col.getValue();
            ValueType valType = colVal.getType();
            if (ValueType.INTEGER == valType) {
                colVal.intValue = this.rows.getInt(colIdx);
                continue;
            }
            if (ValueType.DOUBLE == valType) {
                colVal.dblValue = this.rows.getDouble(colIdx);
                continue;
            }
            if (ValueType.LONG == valType) {
                colVal.longValue = this.rows.getLong(colIdx);
                continue;
            }
            colVal.objValue = ValueType.DECIMAL == valType ? this.rows.getBigDecimal(colIdx) : this.rows.getObject(colIdx);
        }
    }

    public final void syncLastValues(int level) {
        for (int i = level; i < this.groupCount; ++i) {
            this.ctxCols[i].syncLastValue();
        }
    }

    public final boolean nextRow() throws SQLException {
        if (this.rows.next()) {
            this.syncValues();
            return true;
        }
        return false;
    }

    public final int findDifferent() {
        for (int i = 0; i < this.groupCount; ++i) {
            if (this.ctxCols[i].isDifferent()) continue;
            return i;
        }
        return this.groupCount;
    }

    static class InnerCol {
        private int colIndex;
        private SimpleValue value;
        private SimpleValue lastValue;

        InnerCol(int colIdx, SimpleValue val) {
            this.colIndex = colIdx;
            this.value = val;
        }

        final int getColIndex() {
            return this.colIndex;
        }

        final SimpleValue getValue() {
            return this.value;
        }

        final SimpleValue getLastValue() {
            return this.lastValue;
        }

        final void setGroup() {
            this.lastValue = new SimpleValue(this.value.getType());
        }

        final boolean isGroup() {
            return this.lastValue != null;
        }

        final void syncLastValue() {
            this.lastValue.setAs(this.value);
        }

        final boolean isDifferent() {
            return this.value.equals(this.lastValue);
        }
    }
}

