/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ValueType;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.GroupingCols;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.SimpleValue;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.StatCell;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.StatGroup;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.stat.AGroupingStat;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.stat.GroupingStatFactory;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

final class ParseStatGroups {
    private ResultSet rows;
    private GroupingCols.InnerCol[] allCols;
    private int groupCount;
    private int groupTotal;
    private List colList;
    private List baseStatList;
    private List advStatList;

    public final ResultSet getRows() {
        return this.rows;
    }

    public final int getGroupCount() {
        return this.groupCount;
    }

    public final int getGroupTotal() {
        return this.groupTotal;
    }

    public final GroupingCols.InnerCol[] getCols() {
        GroupingCols.InnerCol[] cols = new GroupingCols.InnerCol[this.colList.size()];
        this.colList.toArray(cols);
        return cols;
    }

    public final AGroupingStat[] getBaseStats() {
        AGroupingStat[] rv = new AGroupingStat[this.baseStatList.size()];
        this.baseStatList.toArray(rv);
        return rv;
    }

    public final AGroupingStat[] getAdvStats() {
        AGroupingStat[] rv = new AGroupingStat[this.advStatList.size()];
        this.advStatList.toArray(rv);
        return rv;
    }

    private AGroupingStat getxStat(String statType, SimpleValue detalVal) {
        int z = this.baseStatList.size();
        for (int i = 0; i < z; ++i) {
            AGroupingStat gstat = (AGroupingStat)this.baseStatList.get(i);
            if (!gstat.equals(statType, detalVal)) continue;
            return gstat;
        }
        AGroupingStat gstat = (AGroupingStat)GroupingStatFactory.getInstance().createNode(statType);
        gstat.init(detalVal, this.groupCount);
        String[] baseTypes = gstat.getBaseTypes();
        if (baseTypes == null) {
            this.baseStatList.add(gstat);
        } else {
            this.advStatList.add(gstat);
            for (int i = 0; i < baseTypes.length; ++i) {
                gstat.addBase(this.getxStat(baseTypes[i], detalVal));
            }
        }
        return gstat;
    }

    private GroupingCols.InnerCol getxColumn(int colIdx) throws SQLException {
        GroupingCols.InnerCol ctxCol = this.allCols[colIdx];
        if (ctxCol == null) {
            ResultSetMetaData rsmd = this.rows.getMetaData();
            SimpleValue colVal = new SimpleValue(ValueType.fromJdbcType(rsmd.getColumnType(colIdx)));
            this.allCols[colIdx] = ctxCol = new GroupingCols.InnerCol(colIdx, colVal);
        }
        return ctxCol;
    }

    public void parse(ResultSet rows, StatGroup[] groups) throws SQLException {
        this.rows = rows;
        this.allCols = new GroupingCols.InnerCol[1 + rows.getMetaData().getColumnCount()];
        this.colList = new ArrayList();
        this.baseStatList = new ArrayList();
        this.advStatList = new ArrayList();
        this.parseGroups(groups);
        for (int i = 0; i < this.allCols.length; ++i) {
            GroupingCols.InnerCol ctxCol = this.allCols[i];
            if (ctxCol == null || ctxCol.isGroup()) continue;
            this.colList.add(ctxCol);
        }
        this.allCols = null;
    }

    private void parseGroups(StatGroup[] groups) throws SQLException {
        this.groupCount = groups.length;
        this.groupTotal = 0;
        this.getxStat("COUNT", null);
        for (int i = 0; i < groups.length; ++i) {
            StatGroup group = groups[i];
            int byCol = group.getByCol();
            if (byCol == 0) {
                if (i != 0) {
                    throw new SQLException("Grouping column not be null");
                }
                this.groupTotal = 1;
            } else {
                GroupingCols.InnerCol ctxCol = this.getxColumn(byCol);
                ctxCol.setGroup();
                this.colList.add(ctxCol);
            }
            this.parseStatCells(group);
        }
    }

    private void parseStatCells(StatGroup group) throws SQLException {
        int z = group.getStatCellCount();
        for (int i = 0; i < z; ++i) {
            StatCell cell = group.getStatCell(i);
            GroupingCols.InnerCol ctxCol = this.getxColumn(cell.getDataCol());
            this.getxStat(cell.getStatType(), ctxCol.getValue());
        }
    }
}

