/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.SimpleResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CachedResultSet
extends SimpleResultSet {
    private ResultSet rs;
    private int fetchSize;
    private boolean hasNextPage = true;

    public CachedResultSet(ResultSet rs, int fetchSize) throws SQLException {
        super(rs.getMetaData());
        this.rs = rs;
        this.fetchSize = fetchSize;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        super.absolute(row);
        int rowCount = super.getRowCount();
        if (row > rowCount) {
            if (!this.hasNextPage) {
                return false;
            }
            int rowCount2 = (row / this.fetchSize + 1) * this.fetchSize;
            int dataIdx = super.getLastDataIndex();
            int colCount = super.getColCount();
            super.resize(rowCount2, 0);
            Object[] datas = super.getDatas();
            for (int i = rowCount; i < rowCount2; ++i) {
                if (this.rs.next()) {
                    for (int j = 1; j <= colCount; ++j) {
                        datas[dataIdx] = this.rs.getObject(j);
                        ++dataIdx;
                    }
                    continue;
                }
                this.hasNextPage = false;
                super.resize(i, 0);
                return i >= row;
            }
        }
        return true;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.hasNextPage) {
            return super.relative(1);
        }
        return super.next();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1001;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }
}

