/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ValueType;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.LogUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.Logger;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.AResultSet;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.SimpleColumnMD;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.SimpleResultSetMD;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.formats.csv.CsvReader;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class CsvResultSet
extends AResultSet {
    private static final Logger log = LogUtil.getLogger(CsvResultSet.class);
    private CsvReader csvReader;
    private String[] csvRow;
    private int colCount = 0;
    private boolean beforeFirst = true;
    SimpleResultSetMD rsmd;

    private SimpleResultSetMD makeMetaData(CsvReader csvReader) throws SQLException {
        int i;
        try {
            this.csvRow = this.csvReader.readRow();
        }
        catch (IOException ex) {
            log.error("IO Exception", ex);
            throw new SQLException(ex.getMessage());
        }
        this.colCount = this.csvRow.length;
        this.rsmd = new SimpleResultSetMD(this.colCount);
        SimpleColumnMD[] cols = new SimpleColumnMD[this.colCount];
        int validTypes = 0;
        for (i = 0; i < this.csvRow.length; ++i) {
            SimpleColumnMD col;
            cols[i] = col = new SimpleColumnMD();
            this.rsmd.setColumn(i + 1, col);
            ValueType type = ValueType.fromName(this.csvRow[i]);
            if (type == null) continue;
            col.setType(type.getJdbcType());
            ++validTypes;
        }
        if (validTypes == this.colCount) {
            if (this.nextCsvRow()) {
                for (i = 0; i < this.colCount; ++i) {
                    cols[i].setName(this.csvRow[i]);
                }
                this.nextCsvRow();
            }
        } else {
            for (i = 0; i < this.csvRow.length; ++i) {
                ValueType type = ValueType.typeofText(this.csvRow[i]);
                cols[i].setType(type.getJdbcType());
            }
        }
        return this.rsmd;
    }

    public CsvResultSet(CsvReader csvReader) throws SQLException {
        this.csvReader = csvReader;
        this.makeMetaData(csvReader);
    }

    public void checkColumnIndex(int colIdx) throws SQLException {
        if (colIdx < 1 || colIdx > this.colCount) {
            throw new SQLException("Invalid column index: " + colIdx + ", count: " + this.colCount);
        }
    }

    private boolean nextCsvRow() throws SQLException {
        try {
            return 0 < this.csvReader.readRow(this.csvRow);
        }
        catch (IOException ex) {
            log.error("IO Exception", ex);
            throw new SQLException(ex.getMessage());
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rsmd;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.beforeFirst) {
            this.beforeFirst = false;
            return this.colCount > 0;
        }
        if (this.csvReader.isEnd()) {
            return false;
        }
        return this.nextCsvRow();
    }

    @Override
    public int getInt(int colIndex) throws SQLException {
        return Integer.valueOf(this.getString(colIndex));
    }

    @Override
    public Object getObject(int colIndex) throws SQLException {
        return this.getString(colIndex);
    }

    @Override
    public String getString(int colIndex) throws SQLException {
        this.checkColumnIndex(colIndex);
        return this.csvRow[colIndex - 1];
    }

    public Object getObject(int columnIndex, Class type) throws SQLException {
        return null;
    }

    public Object getObject(String columnLabel, Class type) throws SQLException {
        return null;
    }
}

