/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.LogUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.Logger;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.AModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.MvcEvent;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.ASwingView;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.SwingViewUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.swing.Rows4ComboBoxModel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class VComboBox
extends ASwingView {
    private static final Logger log = LogUtil.getLogger(VComboBox.class, 2);

    public VComboBox() {
        super(new JComboBox());
    }

    protected VComboBox(JComponent mainComp) {
        super(mainComp);
    }

    @Override
    protected JComponent init(JComponent mainComp) {
        JComboBox mainView = (JComboBox)mainComp;
        mainView.addItemListener(new Ctrl());
        return mainView;
    }

    public final JComboBox getMainView() {
        return (JComboBox)this.getComponent();
    }

    public final ComboBoxModel getViewModel() {
        return this.getMainView().getModel();
    }

    public final void setViewModel(ComboBoxModel x) {
        this.getMainView().setModel(x);
    }

    public final int getSelectedIndex() {
        return this.getMainView().getSelectedIndex();
    }

    public final void setSelectedIndex(int x) {
        this.getMainView().setSelectedIndex(x);
    }

    public final Object getSelectedItem() {
        return this.getMainView().getSelectedItem();
    }

    public final void setSelectedItem(Object x) {
        this.getMainView().setSelectedItem(x);
    }

    @Override
    protected void update(MvcEvent mvc) {
        AModel model = (AModel)mvc.getSource();
        ResultSet rows = (ResultSet)model.getResult();
        if (mvc.isMessage(1)) {
            try {
                int displayCol = SwingViewUtil.locateCols(this.getBinding(), rows);
                int valueCol = this.getBinding().getCol().getIndex();
                this.setViewModel(new Rows4ComboBoxModel(rows, valueCol, displayCol));
            }
            catch (SQLException ex) {
                log.error(ex, ex);
                DefaultComboBoxModel<String> cbxModel = new DefaultComboBoxModel<String>();
                cbxModel.addElement(ex.getMessage());
                this.setViewModel(cbxModel);
                return;
            }
        }
        if (mvc.isMessage(2)) {
            int activeRow = mvc.getIndex();
            this.setSelectedIndex(activeRow - 1);
        }
    }

    protected class Ctrl
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            if (VComboBox.this.isUpdating()) {
                return;
            }
            JComboBox mainView = VComboBox.this.getMainView();
            VComboBox.this.fireValueChanged(1 + mainView.getSelectedIndex(), mainView.getSelectedItem());
        }
    }
}

