/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.LogUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.log.Logger;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.AModel;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.MvcEvent;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.ASwingView;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.SwingViewUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.swing.Rows4ListModel;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VList
extends ASwingView {
    private static final Logger log = LogUtil.getLogger(VList.class, 2);
    private boolean autoShowSelection;
    protected JList mainView;

    public VList() {
        super(new JList());
    }

    protected VList(JComponent mainComp) {
        super(mainComp);
    }

    @Override
    protected JComponent init(JComponent mainComp) {
        this.mainView = (JList)mainComp;
        this.mainView.addListSelectionListener(new Ctrl());
        return new JScrollPane(this.mainView);
    }

    public final JList getMainView() {
        return this.mainView;
    }

    public final ListModel getViewModel() {
        return this.getMainView().getModel();
    }

    public final void setViewModel(ListModel x) {
        this.getMainView().setModel(x);
    }

    public final boolean isAutoShowSelection() {
        return this.autoShowSelection;
    }

    public final void setAutoShowSelection(boolean x) {
        this.autoShowSelection = x;
    }

    public final int getSelectedIndex() {
        return this.getMainView().getSelectedIndex();
    }

    public final void setSelectedIndex(int x) {
        this.getMainView().setSelectedIndex(x);
    }

    @Override
    protected void update(MvcEvent mvc) {
        AModel model = (AModel)mvc.getSource();
        ResultSet rows = (ResultSet)model.getResult();
        if (mvc.isMessage(1)) {
            try {
                int displayCol = SwingViewUtil.locateCols(this.getBinding(), rows);
                int valueCol = this.getBinding().getCol().getIndex();
                this.setViewModel(new Rows4ListModel(rows, valueCol, displayCol));
            }
            catch (SQLException ex) {
                log.error(ex, ex);
                DefaultListModel<String> cbxModel = new DefaultListModel<String>();
                cbxModel.addElement(ex.getMessage());
                this.setViewModel(cbxModel);
                return;
            }
        }
        if (mvc.isMessage(2)) {
            int activeRow = mvc.getIndex();
            int idx = activeRow - 1;
            this.setSelectedIndex(idx);
            if (this.autoShowSelection) {
                JList comp = this.getMainView();
                comp.scrollRectToVisible(comp.getCellBounds(idx, idx));
            }
        }
    }

    protected class Ctrl
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (VList.this.isUpdating()) {
                return;
            }
            VList.this.fireValueChanged(1 + VList.this.mainView.getSelectedIndex(), VList.this.mainView.getSelectedValue());
        }
    }
}

