/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.tree;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.tree.ATreeBuilder;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.mvc.swing.tree.VTreeNode;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;

class FastTreeBuilder
extends ATreeBuilder {
    private String lastLevels;
    private int lastLevel;
    private int[] lastLengths;
    private VTreeNode[] lastNodes;

    @Override
    public final void setRootNode(VTreeNode rootNode) {
        this.lastLengths = new int[8];
        this.lastLengths[0] = 0;
        this.lastNodes = new VTreeNode[8];
        this.lastNodes[0] = rootNode;
        this.lastLevels = null;
        this.lastLevel = 0;
    }

    @Override
    public final void addTreeNode() {
        int level = this.findLevel(this.colLevels);
        VTreeNode treeNode = new VTreeNode();
        this.initTreeNode(treeNode);
        this.lastNodes[level] = treeNode;
        this.lastNodes[level - 1].add(treeNode);
        this.lastLevel = level;
        this.lastLevels = this.colLevels;
        this.lastLengths[level] = this.colLevels.length();
    }

    private int findLevel(String levels) {
        int equalLength = StringUtil.findEqualsLength(levels, this.lastLevels);
        if (equalLength == 0) {
            return 1;
        }
        int lastLength = this.lastLevels.length();
        if (equalLength < lastLength) {
            for (int i = this.lastLevel - 1; i >= 1; --i) {
                int levelLength = this.lastLengths[i];
                if (equalLength > levelLength) {
                    return i + 1;
                }
                if (equalLength != levelLength) continue;
                return i;
            }
            return 1;
        }
        if (levels.length() == lastLength) {
            return this.lastLevel;
        }
        return this.lastLevel + 1;
    }
}

