/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode;

import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.BindField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.IReportObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.DataUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeBindSource;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.BarcodeRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.data.R1PrintBindDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.AbstractR1PrintObjectWidthData;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.icon.R1PrintIcons;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;

public class BarcodeObject
extends AbstractR1PrintObjectWidthData {
    private String barcodeType = "code128";
    public static final int ZOOM_NONE = 0;
    public static final int ZOOM_SCALE = 3;
    private int scale = 0;
    private double modelWidth = 0.0;
    private double barHeight = 0.0;
    private int dpi = 300;
    private String shape = null;
    private String sampleTxt = "12345678";
    private boolean showSample = true;
    private int fontSize = 11;
    private List<BarcodeBindSource> fields = new ArrayList<BarcodeBindSource>();
    public static final Map SAMPLE_BARCODE = new HashMap();

    public boolean isShowSample() {
        return this.showSample;
    }

    public void setShowSample(boolean showSample) {
        this.showSample = showSample;
    }

    public String getSampleTxt() {
        return this.sampleTxt;
    }

    public void setSampleTxt(String sampleTxt) {
        this.sampleTxt = sampleTxt;
    }

    public String getShape() {
        return this.shape;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public double getModelWidth() {
        return this.modelWidth;
    }

    public void setModelWidth(double modelWidth) {
        this.modelWidth = modelWidth;
    }

    public double getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(double barHeight) {
        this.barHeight = barHeight;
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setDpi(int dpi) {
        this.dpi = dpi;
    }

    public List<BarcodeBindSource> getFields() {
        return this.fields;
    }

    public void setFields(List<BarcodeBindSource> fields) {
        this.fields = fields;
    }

    public String getBarcodeType() {
        return this.barcodeType;
    }

    public void setBarcodeType(String barcodeType) {
        this.barcodeType = barcodeType;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String fieldsToString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fields.size(); ++i) {
            BarcodeBindSource bbs = this.fields.get(i);
            sb.append(bbs.toXML());
            sb.append(",");
        }
        return sb.toString();
    }

    public List StringToList(String str) {
        this.fields = new ArrayList<BarcodeBindSource>();
        if (str != null && !"".equals(str.trim())) {
            String[] ts = str.split(",");
            for (int i = 0; i < ts.length; ++i) {
                String temp = ts[i];
                BarcodeBindSource bbs = new BarcodeBindSource();
                bbs.fromXML(temp);
                this.fields.add(bbs);
            }
        }
        return this.fields;
    }

    @Override
    public String getIdPrefix() {
        return "barcode";
    }

    @Override
    public void initTreeNode(DefaultKingdeeTreeNode node) {
        node.setCustomIcon((Icon)R1PrintIcons.SEC_PICTURE);
    }

    @Override
    public String getTypePrompt() {
        return "\u6761\u5f62\u7801";
    }

    @Override
    protected IReportObjectRenderer createRenderer() {
        return new BarcodeRenderer();
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public String getType() {
        return "Barcode";
    }

    @Override
    public String[] getPropertyPanelKeys(ICompositeObject co) {
        return new String[]{"barcode", "border", "objectCommon"};
    }

    @Override
    public void bindDraggedData(String dsName, MetaField mf, IElement subElement, JComponent ctrl, String promptTitle, MouseEvent mouseEvent) {
        if (dsName != null && mf != null) {
            R1PrintBindDataSource bindDs = new R1PrintBindDataSource();
            bindDs.setDs(dsName);
            this.getDataSource().setDs(dsName);
            BindField bindField = new BindField();
            bindField.setField(Field.fromMetaField(mf));
            BarcodeBindSource bbs = new BarcodeBindSource();
            bbs.setBindDs(bindDs);
            bbs.setBindField(bindField);
            this.fields.add(bbs);
        }
    }

    @Override
    public void updateFieldInfo(IR1DataManager dm) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field f;
            Object dataObj;
            BarcodeBindSource bbs = this.fields.get(i);
            if (!"DataSource".equals(bbs) || !((dataObj = dm.getObject(bbs.getBindDs().getDs())) instanceof MetaClass)) continue;
            MetaClass mc = (MetaClass)dataObj;
            if (this.getBindField() == null || (f = DataUtil.updateFieldInfo(bbs.getBindField().getField(), mc)) == null) continue;
            bbs.getBindField().setField(f);
        }
    }

    static {
        SAMPLE_BARCODE.put("code128", "12345678");
        SAMPLE_BARCODE.put("ean-128", "123456789123");
        SAMPLE_BARCODE.put("datamatrix", "12345678");
        SAMPLE_BARCODE.put("qr", "12345678");
        SAMPLE_BARCODE.put("code39", "12345678");
        SAMPLE_BARCODE.put("code39-ext", "12345678");
        SAMPLE_BARCODE.put("code93", "12345678");
        SAMPLE_BARCODE.put("code11", "12345678");
        SAMPLE_BARCODE.put("code93-ext", "12345678");
        SAMPLE_BARCODE.put("codabar", "12345678");
        SAMPLE_BARCODE.put("intl2of5", "12345678");
        SAMPLE_BARCODE.put("standard2of5", "12345678");
        SAMPLE_BARCODE.put("ean-13", "012345678901");
        SAMPLE_BARCODE.put("ean-8", "1234567");
        SAMPLE_BARCODE.put("upc-a", "01234567890");
        SAMPLE_BARCODE.put("upc-e", "0123456");
        SAMPLE_BARCODE.put("postnet", "12345678");
        SAMPLE_BARCODE.put("msi", "12345678");
        SAMPLE_BARCODE.put("pdf417", "12345678");
    }
}

