/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter;

import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.BarcodeContext;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.BaseBarPainter;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.GraphicsForBarcode;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.MathUtils;
import java.awt.Color;
import org.jbarcode.encode.BarSet;

public class HeightCodedPainter
extends BaseBarPainter {
    @Override
    public void doPaint(BarcodeContext barcodeContext) {
        BarSet[] barSets = barcodeContext.getBarSets();
        double width = barcodeContext.getWidth();
        double height = barcodeContext.getHeight();
        GraphicsForBarcode g = barcodeContext.getGraphics();
        int totalBars = 0;
        for (int i = 0; i < barSets.length; ++i) {
            totalBars += barSets[i].length();
        }
        totalBars = totalBars * 2 - 1;
        double barWidth = width / (double)totalBars;
        if (!barcodeContext.isScale()) {
            barWidth = MathUtils.floor(barWidth);
        }
        barcodeContext.setBarWidth(barWidth);
        double barZoneWidth = barWidth * (double)totalBars;
        barcodeContext.setBarZoneWidth(barZoneWidth);
        double barZoneHeight = height;
        barcodeContext.setBarZoneHeight(barZoneHeight);
        double barZoneStartX = (width - barZoneWidth) / 2.0;
        barcodeContext.setBarZoneStartX(barZoneStartX);
        double barPaddingX = 0.0;
        barcodeContext.setBarPaddingX(barPaddingX);
        g.setColor(Color.WHITE);
        g.fillRect(0.0, 0.0, width, height);
        g.setColor(Color.BLACK);
        g.setBackground(Color.WHITE);
        double x = barZoneStartX;
        for (int i = 0; i < barSets.length; ++i) {
            BarSet barSet = barSets[i];
            for (int j = 0; j < barSet.length(); ++j) {
                boolean bit = barSet.get(j);
                if (!bit) {
                    g.fillRect(x, height / 2.0, barWidth, height / 2.0 - 2.0);
                } else {
                    g.fillRect(x, 2.0, barWidth, height - 4.0);
                }
                x += barWidth;
                x += barWidth;
            }
        }
    }
}

