/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.actions.operate.data;

import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.TableView;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataParamSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.util.CustomMetaField;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;

class EditParamPanel
extends KDPanel
implements SimpleDialog.PanelOfSimpleDialog {
    private final int COL_DATA = 0;
    private final int COL_PARAMETER = 1;
    private final int COL_REFERENCE = 2;
    private final int COL_VALUE = 3;
    private final int COL_DELAY = 4;
    private final String REFERENCE_BLANK = "";
    private IR1DataManager _dataManager;
    private TableView _tableView;
    private KDComboBox _cmbReference;
    private KDComboBox _cmbValue;
    private KDCheckBox _cbDelay;
    private boolean _isChanged = false;

    public EditParamPanel() {
        this.initComponent();
    }

    public boolean isChanged() {
        return this._isChanged;
    }

    private void initComponent() {
        this.initTable();
        this.installListener();
        this.setLayout(new BorderLayout());
        this.add((Component)this._tableView.getPanel(), "Center");
    }

    private void initTable() {
        this._tableView = new CustomTableView();
        KDTable table = this._tableView.getTable();
        table.addHeadRow();
        table.addColumns(5);
        table.getColumn(0).setWidth(150);
        table.getColumn(0).getStyleAttributes().setBackground(new Color(214, 214, 214));
        table.getColumn(0).getStyleAttributes().setLocked(true);
        table.getColumn(1).setWidth(120);
        table.getColumn(2).setWidth(150);
        table.getColumn(3).setWidth(150);
        table.getColumn(4).setWidth(100);
        IRow row = table.getHeadRow(0);
        row.getCell(0).setValue((Object)MultiLanguageUtil.getMLS("data.EditParamPanel.dataObject", ""));
        row.getCell(1).setValue((Object)MultiLanguageUtil.getMLS("data.EditParamPanel.parameter", ""));
        row.getCell(2).setValue((Object)MultiLanguageUtil.getMLS("data.EditParamPanel.quoteObject", ""));
        row.getCell(3).setValue((Object)MultiLanguageUtil.getMLS("data.EditParamPanel.value", ""));
        row.getCell(4).setValue((Object)MultiLanguageUtil.getMLS("data.EditParamPanel.delay", ""));
        this._cmbReference = new KDComboBox();
        KDTDefaultCellEditor ceType = new KDTDefaultCellEditor((JComboBox)this._cmbReference);
        table.getColumn(2).setEditor((ICellEditor)ceType);
        this._cmbValue = new KDComboBox();
        this._cbDelay = new KDCheckBox();
        KDTDefaultCellEditor delayCellEditor = new KDTDefaultCellEditor((JCheckBox)this._cbDelay);
        table.getColumn(4).setEditor((ICellEditor)delayCellEditor);
    }

    private void installListener() {
        KDTable table = this._tableView.getTable();
        table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                EditParamPanel.this.editStopped(e);
            }

            public void editStarting(KDTEditEvent e) {
                EditParamPanel.this.editStarting(e);
            }
        });
        table.getActionMap().remove("Copy");
        table.getActionMap().remove("Cut");
        table.getActionMap().remove("Paste");
    }

    private void editStarting(KDTEditEvent e) {
        if (e.getColIndex() == 3) {
            this.updateColValueSupply(e.getRowIndex());
        } else if (e.getColIndex() == 2) {
            this.updateColReferenceSupply(e.getRowIndex());
        }
    }

    private void editStopped(KDTEditEvent e) {
        if (!(e.getValue() != null && !e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() != null)) {
            return;
        }
        this._isChanged = true;
        if (e.getColIndex() == 2) {
            int row = e.getRowIndex();
            this.swapColValueEditor(row);
            Object ref = this._tableView.getTable().getValueAt(row, 2);
            Object value = this._tableView.getTable().getValueAt(row, 3);
            if (ref != "" || !(value instanceof String)) {
                this._tableView.getTable().getCell(row, 3).setValue(null);
            }
            this.selectCell(row - 1, 3);
        }
    }

    private void updateColValueSupply(int rowIdx) {
        MetaClass mc;
        this._cmbValue.removeAllItems();
        Object ref = this._tableView.getTable().getCell(rowIdx, 2).getValue();
        if (ref instanceof DataExtend && (mc = (MetaClass)this._dataManager.getObject(((DataExtend)((Object)ref)).getName())) != null) {
            int c = mc.getFields().size();
            for (int i = 0; i < c; ++i) {
                MetaField mf = (MetaField)mc.getFields().get(i);
                this._cmbValue.addItem((Object)new CustomMetaField(mf));
            }
        }
    }

    private void updateColReferenceSupply(int rowIdx) {
        this._cmbReference.removeAllItems();
        this._cmbReference.addItem((Object)"");
        DataExtend currentExt = (DataExtend)((Object)this._tableView.getTable().getCell(rowIdx, 0).getValue());
        DataExtend[] exts = this._dataManager.getAllDataExtends(new String[]{"param.context"});
        for (int i = 0; i < exts.length; ++i) {
            if (StringUtil.equals((String)exts[i].getName(), (String)currentExt.getName())) continue;
            this._cmbReference.addItem((Object)exts[i]);
        }
    }

    private void swapColValueEditor(int row) {
        Object reference = this._tableView.getTable().getValueAt(row, 2);
        ICell cell = this._tableView.getTable().getCell(row, 3);
        if (reference == "") {
            KDTextField txtField = new KDTextField();
            Object value = cell.getValue();
            if (value != null) {
                txtField.setText(value.toString());
            }
            KDTDefaultCellEditor ceType = new KDTDefaultCellEditor((JTextField)txtField);
            cell.setEditor((ICellEditor)ceType);
        } else {
            KDTDefaultCellEditor ceType = new KDTDefaultCellEditor((JComboBox)this._cmbValue);
            cell.setEditor((ICellEditor)ceType);
        }
    }

    public boolean verify() {
        return this.verifyEmpty() && this.verifyRepeatedParamName() && this.verifyRepeatedReference() && this.verifyCircle();
    }

    private boolean verifyRepeatedParamName() {
        HashMap map = new HashMap();
        int c = this._tableView.getTable().getRowCount();
        for (int i = 0; i < c; ++i) {
            IRow row = this._tableView.getTable().getRow(i);
            String paramName = (String)row.getCell(1).getValue();
            if (StringUtil.isEmptyString((String)paramName)) continue;
            DataExtend dataExt = (DataExtend)((Object)row.getCell(0).getValue());
            ArrayList<String> namesOfData = (ArrayList<String>)map.get((Object)dataExt);
            if (namesOfData == null) {
                namesOfData = new ArrayList<String>();
                map.put(dataExt, namesOfData);
            }
            if (namesOfData.contains(paramName)) {
                WindowUtil.msgboxError((Object)(MultiLanguageUtil.getMLS("data.EditParamPanel.The", "") + (i + 1) + MultiLanguageUtil.getMLS("data.EditParamPanel.info1", "")), (String)MultiLanguageUtil.getMLS("data.EditParamPanel.KingdeeCue", ""), (Component)((Object)this));
                return false;
            }
            namesOfData.add(paramName);
        }
        return true;
    }

    private boolean verifyRepeatedReference() {
        ArrayList<DataExtend> dataHasRef = new ArrayList<DataExtend>();
        int c = this._tableView.getTable().getRowCount();
        for (int i = 0; i < c; ++i) {
            boolean isRefEmpty;
            IRow row = this._tableView.getTable().getRow(i);
            DataExtend dataExt = (DataExtend)((Object)row.getCell(0).getValue());
            Object reference = row.getCell(2).getValue();
            boolean bl = isRefEmpty = reference == null || reference == "";
            if (isRefEmpty) continue;
            if (dataHasRef.contains((Object)dataExt)) {
                WindowUtil.msgboxError((Object)(MultiLanguageUtil.getMLS("data.EditParamPanel.info2", "") + (Object)((Object)dataExt) + MultiLanguageUtil.getMLS("data.EditParamPanel.amend", "")), (String)MultiLanguageUtil.getMLS("data.EditParamPanel.KingdeeCue", ""), (Component)((Object)this));
                return false;
            }
            dataHasRef.add(dataExt);
        }
        return true;
    }

    private boolean verifyEmpty() {
        int c = this._tableView.getTable().getRowCount();
        for (int i = 0; i < c; ++i) {
            boolean isValueEmpty;
            IRow row = this._tableView.getTable().getRow(i);
            String paramName = (String)row.getCell(1).getValue();
            Object reference = row.getCell(2).getValue();
            Object value = row.getCell(3).getValue();
            boolean isNameEmpty = StringUtil.isEmptyString((String)paramName);
            boolean isRefEmpty = reference == null || reference == "";
            boolean bl = isValueEmpty = value == null;
            if (isNameEmpty && isRefEmpty && isValueEmpty || !isNameEmpty && !isValueEmpty) continue;
            WindowUtil.msgboxError((Object)(MultiLanguageUtil.getMLS("data.EditParamPanel.The", "") + (i + 1) + MultiLanguageUtil.getMLS("data.EditParamPanel.info3", "")), (String)MultiLanguageUtil.getMLS("data.EditParamPanel.KingdeeCue", ""), (Component)((Object)this));
            return false;
        }
        return true;
    }

    private boolean verifyCircle() {
        DataExtend dataExt;
        IRow row;
        int i;
        HashMap map = new HashMap();
        int c = this._tableView.getTable().getRowCount();
        for (i = 0; i < c; ++i) {
            row = this._tableView.getTable().getRow(i);
            dataExt = (DataExtend)((Object)row.getCell(0).getValue());
            if (map.containsKey((Object)dataExt)) continue;
            map.put(dataExt, new ArrayList());
        }
        c = this._tableView.getTable().getRowCount();
        for (i = 0; i < c; ++i) {
            row = this._tableView.getTable().getRow(i);
            dataExt = (DataExtend)((Object)row.getCell(0).getValue());
            Object reference = row.getCell(2).getValue();
            ArrayList aData = (ArrayList)map.get((Object)dataExt);
            ArrayList aRef = (ArrayList)map.get(reference);
            if (aRef == null) continue;
            aData.add(aRef);
        }
        for (ArrayList aData : map.values()) {
            if (!this.isCircle(aData, aData)) continue;
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("data.EditParamPanel.info4", ""), (String)MultiLanguageUtil.getMLS("data.EditParamPanel.KingdeeCue", ""), (Component)((Object)this));
            return false;
        }
        return true;
    }

    private boolean isCircle(ArrayList aData, ArrayList self) {
        int i = 0;
        if (i < aData.size()) {
            ArrayList temp = (ArrayList)aData.get(i);
            if (temp == self) {
                return true;
            }
            return this.isCircle(temp, self);
        }
        return false;
    }

    public void acceptChanged() {
        DataExtend dataExt = null;
        int c = this._tableView.getTable().getRowCount();
        for (int i = 0; i < c; ++i) {
            IRow row = this._tableView.getTable().getRow(i);
            DataExtend tempDataExt = (DataExtend)((Object)row.getCell(0).getValue());
            List listParamSources = tempDataExt.getParamSources();
            if (tempDataExt != dataExt) {
                dataExt = tempDataExt;
                listParamSources.clear();
            }
            DataParamSource paramSource = new DataParamSource();
            String paramName = (String)row.getCell(1).getValue();
            if (StringUtil.isEmptyString((String)paramName)) continue;
            paramSource.setName(paramName);
            Object reference = row.getCell(2).getValue();
            Object value = row.getCell(3).getValue();
            if (value != null) {
                if (reference instanceof DataExtend) {
                    String dataName = ((DataExtend)((Object)reference)).getName();
                    String fieldName = ((MetaField)value).getName();
                    paramSource.setReferenceDataName(dataName);
                    paramSource.setValue(fieldName);
                } else if (reference == "" || reference == null) {
                    paramSource.setReferenceDataName(null);
                    paramSource.setValue((String)value);
                }
            } else {
                paramSource.setReferenceDataName(null);
                paramSource.setValue(null);
            }
            Boolean delayValue = (Boolean)row.getCell(4).getValue();
            boolean delay = false;
            if (delayValue != null) {
                delay = delayValue;
            }
            paramSource.setDelay(delay);
            listParamSources.add(paramSource);
        }
    }

    public void initUi(IR1DataManager dataManager) {
        this._dataManager = dataManager;
        this._tableView.getTable().removeRows();
        DataExtend[] allDataExts = dataManager.getAllDataExtends(null);
        for (int i = 0; i < allDataExts.length; ++i) {
            this.addDataExtend(allDataExts[i]);
        }
        this.mergeColData();
    }

    private void mergeColData() {
        this._tableView.getTable().getMergeManager().mergeBlock(0, 0, this._tableView.getTable().getRowCount() - 1, 0, 1);
    }

    private void selectCell(int row, int col) {
        this._tableView.getTable().getSelectManager().select(row, col);
    }

    private void addDataExtend(DataExtend ext) {
        List ps = ext.getParamSources();
        int psCount = ps.size();
        if (psCount == 0) {
            IRow row = this._tableView.getTable().addRow();
            row.getCell(0).setValue((Object)ext);
            row.getCell(4).setValue((Object)false);
        } else {
            for (int i = 0; i < psCount; ++i) {
                DataParamSource paramSource = (DataParamSource)((Object)ps.get(i));
                IRow row = this._tableView.getTable().addRow();
                row.getCell(0).setValue((Object)ext);
                row.getCell(1).setValue((Object)paramSource.getName());
                Object reference = this.searchReferenceObject(paramSource);
                Object value = this.searchValueObject(paramSource, reference);
                row.getCell(2).setValue(reference);
                row.getCell(3).setValue(value);
                Boolean delayValue = paramSource.isDelay();
                row.getCell(4).setValue((Object)delayValue);
                this.swapColValueEditor(this._tableView.getTable().getRowCount() - 1);
            }
        }
    }

    private Object searchReferenceObject(DataParamSource paramSource) {
        String dataName;
        DataExtend ext;
        if (!StringUtil.isEmptyString((String)paramSource.getReferenceDataName()) && (ext = this._dataManager.getDataExtend(dataName = paramSource.getReferenceDataName())) != null) {
            return ext;
        }
        return "";
    }

    private Object searchValueObject(DataParamSource paramSource, Object dataExt) {
        MetaClass mc;
        if (StringUtil.isEmptyString((String)paramSource.getReferenceDataName())) {
            return paramSource.getValue();
        }
        if (dataExt instanceof DataExtend && (mc = (MetaClass)this._dataManager.getObject(((DataExtend)((Object)dataExt)).getName())) != null) {
            String fieldName = paramSource.getValue();
            for (MetaField mf : mc.getFields()) {
                if (!StringUtil.equals((String)mf.getName(), (String)fieldName)) continue;
                return new CustomMetaField(mf);
            }
        }
        return null;
    }

    class CustomTableView
    extends TableView {
        @Override
        protected void actionPerformedAddRow() {
            IRow row;
            int rowIdx;
            if (this.getTable().getSelectManager().get() == null) {
                rowIdx = this.getTable().getRowCount() - 1;
                row = this.getTable().addRow();
            } else {
                rowIdx = this.getTable().getSelectManager().get().getEndRow();
                row = this.getTable().addRow(rowIdx + 1);
            }
            Object data = this.getTable().getValueAt(rowIdx, 0);
            row.getCell(0).setValue(data);
            EditParamPanel.this.mergeColData();
            EditParamPanel.this.selectCell(rowIdx + 1, 1);
        }

        @Override
        protected void actionPerformedMoveUp() {
            Object data;
            EditParamPanel.this._isChanged = true;
            KDTSelectBlock sel = this.getTable().getSelectManager().get();
            if (sel == null) {
                return;
            }
            int idx = sel.getBeginRow();
            if (idx == 0) {
                return;
            }
            int upRowIdx = idx - 1;
            Object upData = this.getTable().getValueAt(upRowIdx, 0);
            if (upData != (data = this.getTable().getValueAt(idx, 0))) {
                return;
            }
            super.actionPerformedMoveUp();
            EditParamPanel.this.mergeColData();
            EditParamPanel.this.selectCell(upRowIdx, 1);
        }

        @Override
        protected void actionPerformedMoveDown() {
            Object data;
            EditParamPanel.this._isChanged = true;
            KDTSelectBlock sel = this.getTable().getSelectManager().get();
            if (sel == null) {
                return;
            }
            int idx = sel.getBeginRow();
            if (idx == this.getTable().getRowCount() - 1) {
                return;
            }
            int downRowIdx = idx + 1;
            Object downData = this.getTable().getValueAt(downRowIdx, 0);
            if (downData != (data = this.getTable().getValueAt(idx, 0))) {
                return;
            }
            super.actionPerformedMoveDown();
            EditParamPanel.this.mergeColData();
            EditParamPanel.this.selectCell(downRowIdx, 1);
        }

        @Override
        protected void actionPerformedRemoveRow() {
            EditParamPanel.this._isChanged = true;
            int selection = 0;
            ArrayList blocks = this.getTable().getSelectManager().getBlocks();
            for (KDTSelectBlock block : blocks) {
                int selEnd;
                int selBegin = block.getBeginRow();
                for (int i = selEnd = block.getEndRow(); i >= selBegin; --i) {
                    selection = i;
                    boolean isOnlyOne = true;
                    Object data = this.getTable().getValueAt(i, 0);
                    if (i > 0) {
                        int upRowIdx = i - 1;
                        Object upData = this.getTable().getValueAt(upRowIdx, 0);
                        if (data == upData) {
                            isOnlyOne = false;
                        }
                    }
                    if (isOnlyOne && i < this.getTable().getRowCount() - 1) {
                        int downRowIdx = i + 1;
                        Object downData = this.getTable().getValueAt(downRowIdx, 0);
                        if (data == downData) {
                            isOnlyOne = false;
                        }
                    }
                    if (isOnlyOne) {
                        IRow row = this.getTable().getRow(i);
                        row.getCell(1).setValue(null);
                        row.getCell(2).setValue(null);
                        row.getCell(3).setValue(null);
                        continue;
                    }
                    this.getTable().getCell(i, 0).setValue(null);
                }
            }
            for (int i = this.getTable().getRowCount() - 1; i >= 0; --i) {
                if (this.getTable().getValueAt(i, 0) != null) continue;
                this.getTable().removeRow(i);
            }
            EditParamPanel.this.mergeColData();
            EditParamPanel.this.selectCell(selection, 1);
        }
    }
}

