/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.StructureTree;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.icon.R1DesignerIcons;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.IR1PrintScriptable;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.R1PrintPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.script.ScriptEditor;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ScriptSystemMethod;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ScriptViewer {
    private ComboPanel _core;
    private Action _action;
    private KDDialog _dlg;
    private ScriptEditor _edtPreScript;
    private ScriptEditor _edtScript;
    private KDWorkButton _btnNext;
    private KDWorkButton _btnPrevious;
    private KDButton _btnClose;
    private ElementChangeHandler _elementChangeHandler;
    private Color _treeNodeOriColor;
    private int _treeOriSelectionMode;

    public ScriptViewer(ComboPanel core) {
        this._core = core;
        this._elementChangeHandler = new ElementChangeHandler();
    }

    public Action getAction() {
        if (this._action == null) {
            this._action = new Action();
        }
        return this._action;
    }

    private void updateNode(StructureTree.Node node) {
        IElement ele = (IElement)node.getUserObject();
        if (ele != null && ScriptViewer.hasAnyScript(ele)) {
            node.setPrompt("* " + node.getPrompt());
            node.setTextColor(Color.RED);
            ((DefaultTreeModel)this.getTree().getModel()).nodeChanged((TreeNode)((Object)node));
        }
    }

    private void reUpdateNode(StructureTree.Node node) {
        boolean hasScript;
        IElement ele = (IElement)node.getUserObject();
        if (ele == null) {
            return;
        }
        boolean hasPreScript = !StringUtil.isEmptyString((String)ele.getPreScript());
        boolean bl = hasScript = !StringUtil.isEmptyString((String)ele.getScript());
        if (hasPreScript || hasScript) {
            node.setPrompt(node.getPrompt().substring(2));
            node.setTextColor(this._treeNodeOriColor == null ? Color.BLACK : this._treeNodeOriColor);
            ((DefaultTreeModel)this.getTree().getModel()).nodeChanged((TreeNode)((Object)node));
        }
    }

    private void updateStructureTree() {
        KDTree tree = this.getTree();
        StructureTree.Node root = (StructureTree.Node)((Object)tree.getModel().getRoot());
        Enumeration em = root.preorderEnumeration();
        while (em.hasMoreElements()) {
            StructureTree.Node node = (StructureTree.Node)((Object)em.nextElement());
            if (this._treeNodeOriColor == null) {
                this._treeNodeOriColor = node.getTextColor();
            }
            this.updateNode(node);
        }
        this._treeOriSelectionMode = tree.getSelectionModel().getSelectionMode();
        tree.getSelectionModel().setSelectionMode(1);
        tree.repaint();
    }

    private void reUpdateStructureTree() {
        KDTree tree = this.getTree();
        StructureTree.Node root = (StructureTree.Node)((Object)tree.getModel().getRoot());
        Enumeration em = root.preorderEnumeration();
        while (em.hasMoreElements()) {
            StructureTree.Node node = (StructureTree.Node)((Object)em.nextElement());
            this.reUpdateNode(node);
        }
        tree.getSelectionModel().setSelectionMode(this._treeOriSelectionMode);
        tree.repaint();
    }

    private void createDialog() {
        final KDSplitPane pan = new KDSplitPane();
        pan.setLeftComponent((Component)this.getPreScriptEditor().getUI());
        pan.setRightComponent((Component)this.getScriptEditor().getUI());
        Window win = SwingUtilities.getWindowAncestor((Component)this._core.getPanel());
        this._dlg = win instanceof Dialog ? new KDDialog((Dialog)win) : (win instanceof Frame ? new KDDialog((Frame)win) : new KDDialog());
        this._dlg.setModal(false);
        WindowHandler windowHandler = new WindowHandler();
        this._dlg.addWindowListener((WindowListener)windowHandler);
        this._dlg.addWindowFocusListener((WindowFocusListener)windowHandler);
        this._dlg.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if ((double)ScriptViewer.this._dlg.getWidth() * 0.75 > (double)ScriptViewer.this._dlg.getHeight()) {
                    ScriptViewer.this.reLayout(pan, true);
                } else {
                    ScriptViewer.this.reLayout(pan, false);
                }
            }
        });
        KDSeparator separator = new KDSeparator(0);
        this._btnPrevious = new KDWorkButton(MultiLanguageUtil.getMLS("gui.Color.previous", ""));
        this._btnNext = new KDWorkButton(MultiLanguageUtil.getMLS("gui.Color.next", ""));
        this._btnClose = new KDButton(MultiLanguageUtil.getMLS("gui.Color.close", ""));
        ButtonActionHandler bah = new ButtonActionHandler();
        this._btnPrevious.addActionListener((ActionListener)bah);
        this._btnNext.addActionListener((ActionListener)bah);
        this._btnClose.addActionListener((ActionListener)bah);
        TableLayout ly = TableLayout.splitRow((int)4);
        ly.rowStyle(0).setHeight(20);
        ly.rowStyle(1).setPriY(1);
        ly.rowStyle(2).setHeight(2);
        ly.rowStyle(3).setHeight(20);
        ly.rowStyle(0).setMargin(10, 10, 10, 0);
        ly.rowStyle(1).setMargin(10, 0, 10, 10);
        ly.rowStyle(3).setMargin(10);
        Table row2 = ly.cell(3).splitCol(5);
        row2.colStyle(0).setWidth(120);
        row2.colStyle(2).setMarginLeft(3);
        row2.colStyle(3).setPriX(1);
        Container dlgPan = this._dlg.getContentPane();
        dlgPan.setLayout((LayoutManager)ly);
        dlgPan.add((Component)new KDLabel(MultiLanguageUtil.getMLS("gui.Color.explain", "")), ly.cell(0));
        dlgPan.add((Component)pan, ly.cell(1));
        dlgPan.add((Component)separator, ly.cell(2));
        dlgPan.add((Component)new KDLabel(MultiLanguageUtil.getMLS("gui.Color.hasScript", "")), row2.cell(0));
        dlgPan.add((Component)this._btnPrevious, row2.cell(1));
        dlgPan.add((Component)this._btnNext, row2.cell(2));
        dlgPan.add((Component)this._btnClose, row2.cell(4));
        JComponent tree = this._core.getStructureTree().getCtrl();
        Point location = tree.getLocation();
        SwingUtilities.convertPointToScreen(location, tree);
        location.translate(tree.getWidth(), -40);
        this._dlg.setLocation(location);
        this._dlg.setSize(win.getWidth() - tree.getWidth() - 10, tree.getHeight() + 40);
    }

    private void reLayout(KDSplitPane pan, boolean isLR) {
        if (isLR) {
            pan.setOrientation(1);
            pan.setDividerLocation(0.5);
        } else {
            pan.setOrientation(0);
            pan.setDividerLocation(0.5);
        }
        pan.validate();
        pan.repaint();
    }

    private ScriptEditor getPreScriptEditor() {
        if (this._edtPreScript == null) {
            this._edtPreScript = new ScriptEditor(MultiLanguageUtil.getMLS("gui.Color.preScript", ""));
            this._edtPreScript.addHeavyColorInterface(ScriptSystemMethod.class);
            this._edtPreScript.addHeavyColorInterface(IR1PrintScriptable.class);
            this._edtPreScript.setDataManager(this._core.getModel().getDataManager());
        }
        return this._edtPreScript;
    }

    private ScriptEditor getScriptEditor() {
        if (this._edtScript == null) {
            this._edtScript = new ScriptEditor(MultiLanguageUtil.getMLS("gui.Color.edtScript", ""));
            this._edtScript.addHeavyColorInterface(ScriptSystemMethod.class);
            this._edtScript.addHeavyColorInterface(IR1PrintScriptable.class);
            this._edtScript.setDataManager(this._core.getModel().getDataManager());
        }
        return this._edtScript;
    }

    private void elementChange() {
        ElementPath ep = this._core.getSelectionModel().getCurrent();
        String preScript = null;
        String script = null;
        StringBuffer title = new StringBuffer(MultiLanguageUtil.getMLS("gui.Color.scriptView", ""));
        boolean enabled = false;
        if (ep != null) {
            IElement ele = (IElement)ep.getLastPathComponent();
            enabled = !(ele instanceof R1PrintPage);
            preScript = ele.getPreScript();
            script = ele.getScript();
            title.append("  " + ele.getId());
        }
        this._dlg.setTitle(title.toString());
        if (enabled) {
            this.getPreScriptEditor().setEnabled(true);
            this.getScriptEditor().setEnabled(true);
            this.getPreScriptEditor().setText(preScript);
            this.getScriptEditor().setText(script);
        } else {
            this.getPreScriptEditor().setEnabled(false);
            this.getScriptEditor().setEnabled(false);
            this.getPreScriptEditor().setText(MultiLanguageUtil.getMLS("gui.Color.notSupport", ""));
            this.getScriptEditor().setText(MultiLanguageUtil.getMLS("gui.Color.notSupport", ""));
        }
    }

    private void doWhenCloseWindow() {
        this._core.removeSelectionChangeListener(this._elementChangeHandler);
        this.reUpdateStructureTree();
    }

    private KDTree getTree() {
        return this._core.getStructureTree().getTreeCtrl();
    }

    private StructureTree.Node getCurrentNode() {
        return (StructureTree.Node)((Object)this.getTree().getSelectionPath().getLastPathComponent());
    }

    private static boolean hasAnyScript(IElement ele) {
        if (ele == null) {
            return false;
        }
        return !StringUtil.isEmptyString((String)ele.getPreScript()) || !StringUtil.isEmptyString((String)ele.getScript());
    }

    private StructureTree.Node searchPreviousNode() {
        StructureTree.Node node;
        StructureTree.Node currentNode = this.getCurrentNode();
        StructureTree.Node foundNode = null;
        KDTree tree = this.getTree();
        StructureTree.Node root = (StructureTree.Node)((Object)tree.getModel().getRoot());
        Enumeration em = root.preorderEnumeration();
        while (em.hasMoreElements() && (node = (StructureTree.Node)((Object)em.nextElement())) != currentNode) {
            IElement ele = (IElement)node.getUserObject();
            if (!ScriptViewer.hasAnyScript(ele)) continue;
            foundNode = node;
        }
        return foundNode;
    }

    private StructureTree.Node searchNextNode() {
        boolean isAfterCurrent = false;
        StructureTree.Node currentNode = this.getCurrentNode();
        StructureTree.Node foundNode = null;
        KDTree tree = this.getTree();
        StructureTree.Node root = (StructureTree.Node)((Object)tree.getModel().getRoot());
        Enumeration em = root.preorderEnumeration();
        while (em.hasMoreElements()) {
            IElement ele;
            StructureTree.Node node = (StructureTree.Node)((Object)em.nextElement());
            if (node == currentNode) {
                isAfterCurrent = true;
                continue;
            }
            if (!isAfterCurrent || !ScriptViewer.hasAnyScript(ele = (IElement)node.getUserObject())) continue;
            foundNode = node;
            break;
        }
        return foundNode;
    }

    private void changeButtonEnabled() {
        this._btnNext.setEnabled(this.searchNextNode() != null);
        this._btnPrevious.setEnabled(this.searchPreviousNode() != null);
    }

    private void modifyEdited() {
        boolean needUpdateUI = this._dlg.isVisible();
        boolean modified = false;
        String NUL = "";
        String preScript = "";
        String script = "";
        if (this.getPreScriptEditor().isEdited()) {
            modified = true;
            this.getPreScriptEditor().clearEditedMark();
            preScript = this.getPreScriptEditor().getText();
        }
        if (this.getScriptEditor().isEdited()) {
            modified = true;
            this.getScriptEditor().clearEditedMark();
            script = this.getScriptEditor().getText();
        }
        if (modified) {
            StructureTree.Node node = this.getCurrentNode();
            if (needUpdateUI) {
                this.reUpdateNode(node);
            }
            IElement ele = (IElement)node.getUserObject();
            if (preScript != "") {
                ele.setPreScript(preScript);
            }
            if (script != "") {
                ele.setScript(script);
            }
            if (needUpdateUI) {
                this.updateNode(node);
            }
            this._core.getModel().setDirty(true);
        }
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ScriptViewer.this._btnClose) {
                ScriptViewer.this.doWhenCloseWindow();
                ScriptViewer.this._dlg.setVisible(false);
            } else if (e.getSource() == ScriptViewer.this._btnPrevious) {
                this.toPrevious();
            } else if (e.getSource() == ScriptViewer.this._btnNext) {
                this.toNext();
            }
        }

        private void toPrevious() {
            ScriptViewer.this.modifyEdited();
            StructureTree.Node foundNode = ScriptViewer.this.searchPreviousNode();
            if (foundNode == null) {
                ScriptViewer.this._btnPrevious.setEnabled(false);
            } else {
                ScriptViewer.this._core.setSelection(StructureTree.node2ElementPath(new TreePath(foundNode.getPath())));
                ScriptViewer.this._core.getPanel().repaint();
            }
        }

        private void toNext() {
            ScriptViewer.this.modifyEdited();
            StructureTree.Node foundNode = ScriptViewer.this.searchNextNode();
            if (foundNode == null) {
                ScriptViewer.this._btnNext.setEnabled(false);
            } else {
                ScriptViewer.this._core.setSelection(StructureTree.node2ElementPath(new TreePath(foundNode.getPath())));
                ScriptViewer.this._core.getPanel().repaint();
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ScriptViewer.this.doWhenCloseWindow();
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            ScriptViewer.this.modifyEdited();
        }
    }

    private class ElementChangeHandler
    implements ChangeListener {
        private ElementChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ScriptViewer.this.elementChange();
            ScriptViewer.this.changeButtonEnabled();
        }
    }

    public class Action
    extends AbstractAction {
        public Action() {
            this.putValue("SmallIcon", R1DesignerIcons.createIcon("tbtn/tbtn_attributeset.gif"));
            this.putValue("ShortDescription", MultiLanguageUtil.getMLS("gui.Color.scriptView", ""));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ScriptViewer.this.getTree().getSelectionPath() == null) {
                WindowUtil.msgboxInfo((Object)MultiLanguageUtil.getMLS("gui.Color.noChooseNode", ""), (String)MultiLanguageUtil.getMLS("gui.Color.scriptView", ""), (Component)ScriptViewer.this.getTree());
                return;
            }
            if (ScriptViewer.this._dlg == null) {
                ScriptViewer.this.createDialog();
            }
            if (ScriptViewer.this._dlg.isVisible()) {
                ScriptViewer.this.doWhenCloseWindow();
                ScriptViewer.this._dlg.setVisible(false);
            } else {
                KDTree tree = ScriptViewer.this.getTree();
                StructureTree.Node root = (StructureTree.Node)((Object)tree.getModel().getRoot());
                tree.expandAllNodes(true, (TreeNode)((Object)root));
                ScriptViewer.this.updateStructureTree();
                ScriptViewer.this._core.addSelectionChangeListener(ScriptViewer.this._elementChangeHandler);
                ScriptViewer.this.elementChange();
                ScriptViewer.this.changeButtonEnabled();
                ScriptViewer.this._dlg.setVisible(true);
            }
        }
    }
}

