/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.common.RadioButtonGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.LayoutGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.layoutgrid.cellvalue.CellAloneField;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell.ACellPane;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell.AloneFieldPane;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell.PanelDGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.cell.TextPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PanelLGridCell
extends AbstractPropertyPanel {
    private static final int TypeDefault = 0;
    private static final int TypeText = 1;
    private static final int TypeAloneField = 2;
    private ComboPanel _core;
    private ElementPath[] _selecteds;
    private RadioButtonGroup _rbgCellType;
    private KDPanel _specialPaneOwner;
    private TextPane _textPane;
    private AloneFieldPane _fieldPane;

    public PanelLGridCell() {
        this.init();
    }

    private void init() {
        RadioButtonHandler handler = new RadioButtonHandler();
        this._rbgCellType = new RadioButtonGroup();
        this.initRadioButton(MultiLanguageUtil.getMLS("cell.PanelLGridCell.text", ""), 1, handler);
        this.initRadioButton(MultiLanguageUtil.getMLS("cell.PanelLGridCell.field", ""), 2, handler);
        this.initRadioButton(MultiLanguageUtil.getMLS("cell.PanelLGridCell.container", ""), 0, handler);
        KDPanel panCellType = PanelDGridCell.createTitlePane(this._rbgCellType, MultiLanguageUtil.getMLS("cell.PanelLGridCell.typeLGcell", ""));
        this._specialPaneOwner = new KDPanel((LayoutManager)new BorderLayout());
        TableLayout tl = TableLayout.splitRow((int)3);
        tl.style().setMargin(8);
        tl.rowStyle(0).setHeight(60);
        tl.rowStyle(1).setMarginTop(8);
        tl.rowStyle(1).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)panCellType, tl.cell(0));
        this.add((Component)this._specialPaneOwner, tl.cell(1));
    }

    private void initRadioButton(String text, int value, RadioButtonHandler handler) {
        KDRadioButton rad = new KDRadioButton(text);
        rad.setUserObject((Object)new Integer(value));
        this._rbgCellType.add(rad);
        rad.addActionListener((ActionListener)handler);
    }

    private void setSelectedCellType(int type) {
        if (type == -1) {
            this._rbgCellType.setSelectedValueUnsure();
        } else if (0 <= type && type <= 2) {
            this._rbgCellType.setSelectedValue(new Integer(type));
        } else {
            throw new IllegalArgumentException("Error");
        }
    }

    private int getSelectedCellType() {
        Object value = this._rbgCellType.getSelectedValue();
        if (value == null) {
            return -1;
        }
        return (Integer)value;
    }

    private ACellPane getSpecialPanel(int type) {
        switch (type) {
            case 1: {
                return this.getTextPane();
            }
            case 2: {
                return this.getFieldPane();
            }
        }
        return null;
    }

    private void changSpecialPanel(ACellPane pane) {
        this._specialPaneOwner.removeAll();
        if (pane != null) {
            pane.prepareSupplyValue(this._core, this._selecteds);
            this._specialPaneOwner.add((Component)((Object)pane), (Object)"Center");
        }
        this._specialPaneOwner.validate();
        this._specialPaneOwner.repaint();
    }

    private TextPane getTextPane() {
        if (this._textPane == null) {
            this._textPane = new TextPane();
        }
        return this._textPane;
    }

    private AloneFieldPane getFieldPane() {
        if (this._fieldPane == null) {
            this._fieldPane = new AloneFieldPane();
        }
        return this._fieldPane;
    }

    @Override
    public String getTitle() {
        return MultiLanguageUtil.getMLS("cell.PanelLGridCell.cell", "");
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eles) {
        this._core = core;
        this._selecteds = eles;
        if (this._fieldPane != null) {
            this._fieldPane.initCtrlValue();
        }
        if (this._textPane != null) {
            this._textPane.initCtrlValue();
        }
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        LayoutGridCell cell = (LayoutGridCell)eps[0].getLastPathComponent();
        ICellValue cellValue = cell.getValue();
        boolean isCellValueUnsure = false;
        for (int i = 1; i < eps.length; ++i) {
            cell = (LayoutGridCell)eps[i].getLastPathComponent();
            if (isCellValueUnsure) continue;
            ICellValue tempCellValue = cell.getValue();
            isCellValueUnsure = cellValue == null ? tempCellValue != null : (tempCellValue == null ? true : cellValue.getClass() != tempCellValue.getClass());
        }
        int selectedCellType = isCellValueUnsure ? -1 : (cellValue instanceof Text ? 1 : (cellValue instanceof CellAloneField ? 2 : 0));
        this.setSelectedCellType(selectedCellType);
        ACellPane specialPane = this.getSpecialPanel(selectedCellType);
        this.changSpecialPanel(specialPane);
        if (specialPane != null) {
            specialPane.prepareCtrlValue(eps);
        }
    }

    @Override
    public void updateElementValue(ElementPath[] eles) {
        int selectedCellType = this.getSelectedCellType();
        ACellPane specialPane = this.getSpecialPanel(selectedCellType);
        if (specialPane != null) {
            specialPane.updateElementValue(eles);
        } else if (selectedCellType == 0) {
            for (int i = 0; i < eles.length; ++i) {
                this.updateElementValue(eles[i]);
            }
        }
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        LayoutGridCell cell = (LayoutGridCell)elePath.getLastPathComponent();
        cell.setValue(null);
    }

    @Override
    public boolean verify() {
        int selectedCellType = this.getSelectedCellType();
        ACellPane specialPane = this.getSpecialPanel(selectedCellType);
        if (specialPane != null) {
            return specialPane.verify();
        }
        return true;
    }

    private class RadioButtonHandler
    implements ActionListener {
        private RadioButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ACellPane pane = PanelLGridCell.this.getSpecialPanel(PanelLGridCell.this.getSelectedCellType());
            PanelLGridCell.this.changSpecialPanel(pane);
            if (pane != null) {
                pane.enter();
            }
        }
    }
}

