/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid;

import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.wizard.datagrid.AbstractGridCreatorStep;
import com.kingdee.bos.ctrl.swing.KDList;
import java.awt.Component;
import javax.swing.JComponent;

class StepSelectField
extends AbstractGridCreatorStep {
    private WizardDialog.StepsManager _stepsManager;
    private FieldSelector _selector;

    StepSelectField() {
    }

    FieldSelector getSelector() {
        if (this._selector == null) {
            this._selector = new FieldSelector();
        }
        return this._selector;
    }

    @Override
    protected JComponent getRealContent() {
        return this.getSelector();
    }

    @Override
    protected String getPromptText() {
        return MultiLanguageUtil.getMLS("datagrid.StepSelectField.promptText", "");
    }

    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        this._stepsManager.setFinishEnabled(true);
        if (!isOppose) {
            this.prepareSupply();
            this.syncModel2Ui();
        }
    }

    private void syncModel2Ui() {
        KDList ctrl = this.getSelector().getSelectedList();
        ctrl.removeAllElements();
        Field[] fields = this.getModel().getSelectedFields();
        int c = fields.length;
        for (int i = 0; i < c; ++i) {
            ctrl.addElement((Object)fields[i]);
        }
    }

    public IWizardStep outThisStep(boolean isOppose) {
        KDList ctrl = this.getSelector().getSelectedList();
        int fieldsCount = ctrl.getElementCount();
        this.getModel().clearSelectedField();
        for (int i = 0; i < fieldsCount; ++i) {
            this.getModel().addSelectedField((Field)ctrl.getElement(i));
        }
        if (!isOppose && fieldsCount == 0) {
            WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("datagrid.StepSelectField.warning", ""), (String)this.getStepName(), (Component)((Object)this.getSelector()));
            return this;
        }
        return null;
    }

    public boolean isReturnable() {
        return true;
    }

    public void initStep(WizardDialog.StepsManager manager) {
        this._stepsManager = manager;
    }

    private void prepareSupply() {
        KDList list = this.getSelector().getSupplyCtrl();
        list.removeAllElements();
        for (MetaField mf : this.getModel().getSelectedDataSource().getFields()) {
            Field field = Field.fromMetaField(mf);
            list.addElement((Object)field);
        }
        this.getSelector().getSupplyCtrl().setSelectedIndex(0);
        this.getSelector().syncButton();
    }

    public void destroy(boolean isFinished) {
    }

    private String getStepName() {
        return MultiLanguageUtil.getMLS("datagrid.StepSelectField.createCol", "");
    }

    class FieldSelector
    extends NormalSelector {
        private KDList lstSupply;

        public FieldSelector() {
            this.init();
        }

        public KDList getSupplyCtrl() {
            return this.lstSupply;
        }

        private void init() {
            this.lstSupply = new KDList();
            this.setSupplyCtrl((JComponent)this.lstSupply);
            this.setSupplyTitle(MultiLanguageUtil.getMLS("datagrid.StepSelectField.backField", ""));
            this.setSelectedTitle(MultiLanguageUtil.getMLS("datagrid.StepSelectField.createCol", ""));
        }

        public void syncButton() {
            this.syncListViewButton();
        }

        protected void onSelect() {
            int currentSupplyIdx;
            StringBuffer sbExist = null;
            int currectIdx = this.getSelectedList().getSelectedIndex();
            Object[] objToSelect = this.getSupplyCtrl().getSelectedValues();
            for (int i = objToSelect.length - 1; i >= 0; --i) {
                if (this.getSelectedList().getIndexOfElement(objToSelect[i]) == -1) {
                    this.getSelectedList().insertElement(objToSelect[i], currectIdx + 1);
                    this.getSelectedList().setSelectedValue(objToSelect[i], true);
                    continue;
                }
                if (sbExist == null) {
                    sbExist = new StringBuffer();
                }
                if (sbExist.length() > 0) {
                    sbExist.append(", ");
                }
                sbExist.append(objToSelect[i]);
            }
            if (sbExist != null) {
                sbExist.append(StringUtil.RETURN);
                sbExist.append(MultiLanguageUtil.getMLS("datagrid.StepSelectField.notDeplay", ""));
                WindowUtil.msgboxWarning((Object)sbExist.toString(), (String)StepSelectField.this.getStepName(), (Component)((Object)this));
            }
            if ((currentSupplyIdx = this.getSupplyCtrl().getSelectedIndex()) + 1 < this.getSupplyCtrl().getElementCount()) {
                this.getSupplyCtrl().setSelectedValue(this.getSupplyCtrl().getElement(currentSupplyIdx + 1), true);
            }
        }

        protected void onSelectAll() {
            this.getSelectedList().removeAllElements();
            int c = this.getSupplyCtrl().getElementCount();
            for (int i = 0; i < c; ++i) {
                this.getSelectedList().addElement(this.getSupplyCtrl().getElement(i));
            }
        }
    }
}

