/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.model.xmltrans.grid;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractHExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.CompositeExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.CompositeHExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.ConstantHExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.FieldHExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.Oper;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.VExpr;
import java.math.BigDecimal;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

class ExprXmlTransUtil {
    ExprXmlTransUtil() {
    }

    static AbstractExpr load(Element node) {
        String exprType = node.getAttributeValue("exprType");
        if ("constant".equalsIgnoreCase(exprType)) {
            ConstantHExpr expr;
            String text = node.getTextTrim();
            try {
                expr = new ConstantHExpr(new BigDecimal(text));
            }
            catch (NumberFormatException ex) {
                expr = new ConstantHExpr(new BigDecimal("0"));
            }
            return expr;
        }
        if ("field".equalsIgnoreCase(exprType)) {
            String text = node.getTextTrim();
            if (StringUtil.isEmptyString((String)text)) {
                return null;
            }
            FieldHExpr expr = new FieldHExpr(text);
            return expr;
        }
        if ("compositeHorizontal".equalsIgnoreCase(exprType)) {
            String strOper = node.getAttributeValue("oper");
            Oper oper = Oper.fromString(strOper);
            List children = node.getChildren("Expr");
            if (children.size() == 2 && oper != null) {
                Element nodeLeft = (Element)children.get(0);
                Element nodeRight = (Element)children.get(1);
                AbstractExpr leftExpr = ExprXmlTransUtil.load(nodeLeft);
                AbstractExpr rightExpr = ExprXmlTransUtil.load(nodeRight);
                if (leftExpr instanceof AbstractHExpr && rightExpr instanceof AbstractHExpr) {
                    CompositeHExpr expr = new CompositeHExpr((AbstractHExpr)leftExpr, oper, (AbstractHExpr)rightExpr);
                    return expr;
                }
            }
        } else if ("vertical".equalsIgnoreCase(exprType)) {
            AbstractExpr targetExpr;
            String strLevel = node.getAttributeValue("groupLevel");
            String strStatType = node.getAttributeValue("statType");
            String strStatRange = node.getAttributeValue("statRange");
            int level = Integer.parseInt(strLevel);
            int statType = VExpr.typeFromString(strStatType);
            int statRange = VExpr.rangeFromString(strStatRange);
            Element nodeTargetExpr = node.getChild("Expr");
            if (nodeTargetExpr != null && (targetExpr = ExprXmlTransUtil.load(nodeTargetExpr)) instanceof AbstractHExpr) {
                VExpr expr = new VExpr(statType, statRange, level, (AbstractHExpr)targetExpr);
                expr.setShowGroupStatLast("true".equalsIgnoreCase(node.getAttributeValue("showGroupStatLast")));
                return expr;
            }
        } else if ("composite".equalsIgnoreCase(exprType)) {
            String strOper = node.getAttributeValue("oper");
            Oper oper = Oper.fromString(strOper);
            List children = node.getChildren("Expr");
            if (children.size() == 2 && oper != null) {
                Element nodeLeft = (Element)children.get(0);
                Element nodeRight = (Element)children.get(1);
                AbstractExpr leftExpr = ExprXmlTransUtil.load(nodeLeft);
                AbstractExpr rightExpr = ExprXmlTransUtil.load(nodeRight);
                if (leftExpr != null && rightExpr != null) {
                    CompositeExpr expr = new CompositeExpr(leftExpr, oper, rightExpr);
                    return expr;
                }
            }
        }
        return null;
    }

    static Element save(AbstractExpr expr) {
        Element nodeExpr = new Element("Expr");
        if (expr instanceof ConstantHExpr) {
            nodeExpr.setAttribute("exprType", "constant");
            ConstantHExpr che = (ConstantHExpr)expr;
            String constant = che.getValue().toString();
            nodeExpr.addContent(constant);
        } else if (expr instanceof FieldHExpr) {
            nodeExpr.setAttribute("exprType", "field");
            FieldHExpr fhe = (FieldHExpr)expr;
            nodeExpr.addContent(fhe.getFiledName());
        } else if (expr instanceof CompositeHExpr) {
            nodeExpr.setAttribute("exprType", "compositeHorizontal");
            CompositeHExpr comhe = (CompositeHExpr)expr;
            Element nodeLeft = ExprXmlTransUtil.save(comhe.getLeftExpr());
            Element nodeRight = ExprXmlTransUtil.save(comhe.getRightExpr());
            nodeExpr.addContent((Content)nodeLeft);
            nodeExpr.addContent((Content)nodeRight);
            nodeExpr.setAttribute("oper", comhe.getOper().toString());
        } else if (expr instanceof VExpr) {
            nodeExpr.setAttribute("exprType", "vertical");
            VExpr ve = (VExpr)expr;
            Element nodeTargetExpr = ExprXmlTransUtil.save(ve.getTargetExpr());
            nodeExpr.addContent((Content)nodeTargetExpr);
            nodeExpr.setAttribute("groupLevel", String.valueOf(ve.getLevel()));
            nodeExpr.setAttribute("statType", VExpr.typeToString(ve.getType()));
            nodeExpr.setAttribute("statRange", VExpr.rangeToString(ve.getRange()));
            if (ve.isShowGroupStatLast()) {
                nodeExpr.setAttribute("showGroupStatLast", "true");
            }
        } else if (expr instanceof CompositeExpr) {
            nodeExpr.setAttribute("exprType", "composite");
            CompositeExpr ce = (CompositeExpr)expr;
            Element nodeLeft = ExprXmlTransUtil.save(ce.getLeftExpr());
            Element nodeRight = ExprXmlTransUtil.save(ce.getRightExpr());
            nodeExpr.addContent((Content)nodeLeft);
            nodeExpr.addContent((Content)nodeRight);
            nodeExpr.setAttribute("oper", ce.getOper().toString());
        } else {
            return null;
        }
        return nodeExpr;
    }
}

