/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.data;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiCursorRowSet {
    private static final Logger log = LogUtil.getPackageLogger(MultiCursorRowSet.class);
    private static final ArrayList EmptyRow = new ArrayList();
    private Cursor _currentCursor;
    private int[] _colTypes;
    private Map _mapFieldIdx = new HashMap();
    private List _cacheRows = new ArrayList();

    public MultiCursorRowSet(IRowSet rowSet) throws R1PrintDataException {
        this.initMeta(rowSet);
        this.cacheData(rowSet);
        if (rowSet == null) {
            log.error((Object)"RowSet is null.");
        } else {
            log.error((Object)("RowSet has rows: " + this.getRowsCount()));
        }
    }

    private void initMeta(IRowSet rowSet) throws R1PrintDataException {
        if (rowSet == null) {
            this._colTypes = new int[0];
            return;
        }
        try {
            IRowSetMetaData rsmd = rowSet.getRowSetMetaData();
            int size = rsmd.getColumnCount();
            this._colTypes = new int[size];
            for (int i = 0; i < size; ++i) {
                String name = rsmd.getColumnName(i + 1).toUpperCase();
                this._colTypes[i] = rsmd.getColumnType(i + 1);
                this._mapFieldIdx.put(name, new Integer(i));
            }
        }
        catch (SQLException sqle) {
            throw new R1PrintDataException(sqle);
        }
    }

    private void cacheData(IRowSet rowSet) throws R1PrintDataException {
        if (rowSet == null) {
            return;
        }
        try {
            while (rowSet.next()) {
                ArrayList row = this.getRecordOfRow(rowSet);
                this._cacheRows.add(row);
            }
        }
        catch (SQLException e) {
            throw new R1PrintDataException(e);
        }
        catch (IOException e) {
            throw new R1PrintDataException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getRecordOfRow(IRowSet rowSet) throws SQLException, IOException {
        ArrayList<Variant> row = new ArrayList<Variant>();
        block34: for (int i = 0; i < this._colTypes.length; ++i) {
            Variant var = new Variant();
            row.add(var);
            int index = i + 1;
            switch (this._colTypes[i]) {
                case -9: 
                case -1: 
                case 12: 
                case 2005: {
                    Reader reader = rowSet.getCharacterStream(index);
                    if (reader == null) {
                        var.setObject(null, 0);
                        continue block34;
                    }
                    StringBuffer sb = new StringBuffer();
                    int len = 0;
                    char[] chrText = new char[1024];
                    while ((len = reader.read(chrText, 0, chrText.length)) != -1) {
                        sb.append(chrText, 0, len);
                    }
                    var.setObject((Object)sb.toString(), 11);
                    continue block34;
                }
                case 8: {
                    var.setDouble(rowSet.getDouble(index));
                    continue block34;
                }
                case 6: {
                    var.setFloat(rowSet.getFloat(index));
                    continue block34;
                }
                case 4: {
                    var.setInt(rowSet.getInt(index));
                    continue block34;
                }
                case 1: {
                    String tmp = rowSet.getString(index);
                    if (tmp == null) {
                        tmp = "";
                    }
                    var.setObject((Object)tmp, 11);
                    continue block34;
                }
                case -7: {
                    var.setBoolean(rowSet.getBoolean(index));
                    continue block34;
                }
                case 91: {
                    var.setObject((Object)rowSet.getDate(index), 12);
                    continue block34;
                }
                case 3: {
                    var.setObject((Object)rowSet.getBigDecimal(index), 10);
                    continue block34;
                }
                case 16: {
                    var.setBoolean(rowSet.getBoolean(index));
                    continue block34;
                }
                case 92: {
                    var.setObject((Object)rowSet.getTime(index), 12);
                    continue block34;
                }
                case 93: {
                    var.setObject((Object)rowSet.getTimestamp(index), 12);
                    continue block34;
                }
                case 5: {
                    var.setInt(rowSet.getInt(index));
                    continue block34;
                }
                case -6: {
                    var.setInt(rowSet.getInt(index));
                    continue block34;
                }
                case -5: {
                    var.setLong(rowSet.getLong(index));
                    continue block34;
                }
                case 2: {
                    var.setObject((Object)rowSet.getBigDecimal(index), 10);
                    continue block34;
                }
                case -2: {
                    byte[] binary = rowSet.getBytes(index);
                    var.setObject((Object)binary, 512);
                    continue block34;
                }
                case -4: 
                case -3: 
                case 2004: {
                    InputStream is = null;
                    try {
                        byte[] binarys;
                        if (this._colTypes[i] == 2004) {
                            Blob blob = rowSet.getBlob(index);
                            if (blob != null) {
                                is = blob.getBinaryStream();
                            }
                        } else {
                            is = rowSet.getBinaryStream(index);
                        }
                        if (is != null) {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            int len = 0;
                            byte[] c = new byte[1024];
                            while ((len = is.read(c, 0, c.length)) != -1) {
                                baos.write(c, 0, len);
                            }
                            binarys = baos.toByteArray();
                        } else {
                            binarys = new byte[]{};
                        }
                        var.setObject((Object)binarys, 512);
                        if (is == null) continue block34;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                    continue block34;
                }
                case 70: {
                    continue block34;
                }
                case 2001: {
                    continue block34;
                }
                case 2000: {
                    var.setObject(rowSet.getObject(index));
                    continue block34;
                }
                case 0: {
                    continue block34;
                }
                case 1111: {
                    continue block34;
                }
                case 7: {
                    var.setDouble(rowSet.getDouble(index));
                    continue block34;
                }
                case 2006: {
                    continue block34;
                }
                case 2002: {
                    continue block34;
                }
                case 2003: {
                    var.setObject((Object)rowSet.getArray(index), 512);
                }
            }
        }
        return row;
    }

    private ArrayList getRow(int rowIdx) {
        if (rowIdx < 0 || rowIdx >= this.getRowsCount()) {
            if (rowIdx == -1 || rowIdx == this.getRowsCount()) {
                return EmptyRow;
            }
            throw new R1PrintRuntimeException("Row index out of range. " + rowIdx);
        }
        return (ArrayList)this._cacheRows.get(rowIdx);
    }

    Cursor getCurrentCursor() {
        if (this._currentCursor == null) {
            this._currentCursor = new Cursor();
        }
        return this._currentCursor;
    }

    private int getColsCount() {
        return this._colTypes.length;
    }

    private int getFieldIndex(String field) {
        Object index = this._mapFieldIdx.get(field.toUpperCase());
        if (index != null) {
            return (Integer)index;
        }
        return -1;
    }

    public int getRowsCount() {
        return this._cacheRows.size();
    }

    public int getFieldType(String field) {
        int idx = this.getFieldIndex(field);
        if (idx >= 0 && idx < this.getColsCount()) {
            return this._colTypes[idx];
        }
        return 0;
    }

    public boolean isBOF() {
        return this.getCurrentCursor().getRowIdx() == -1;
    }

    public boolean isEOF() {
        if (this.isBOF() && !this.hasNext()) {
            return true;
        }
        return this.getCurrentCursor().getRowIdx() >= this.getRowsCount();
    }

    public boolean hasNext() {
        int rc = this.getRowsCount();
        return rc > 0 && this.getCurrentCursor().getRowIdx() < rc - 1;
    }

    public void next() {
        this.getCurrentCursor().next();
    }

    public Variant getFieldData(String field) {
        ArrayList row = this.getRow(this.getCurrentCursor().getRowIdx());
        return this.getRowFieldData(row, field);
    }

    public Variant getPropheticRowFieldData(String field) {
        ArrayList row = this.getRow(this.getCurrentCursor().getRowIdx() + 1);
        return this.getRowFieldData(row, field);
    }

    private Variant getRowFieldData(List row, String field) {
        if (row != null) {
            if (row == EmptyRow) {
                return Variant.emptyVariant;
            }
            int colIdx = this.getFieldIndex(field);
            if (colIdx >= 0) {
                return (Variant)row.get(colIdx);
            }
        }
        return Variant.emptyVariant;
    }

    public Variant getPreviousRowFieldData(String field) {
        ArrayList row = this.getRow(this.getCurrentCursor().getRowIdx() - 1);
        return this.getRowFieldData(row, field);
    }

    public void secondSpring() {
        this.getCurrentCursor()._rowIdx = -1;
    }

    static class Cursor {
        private int _rowIdx = -1;

        Cursor() {
        }

        public int getRowIdx() {
            return this._rowIdx;
        }

        public void next() {
            ++this._rowIdx;
        }
    }
}

