/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.importer.impl;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.AbstractExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.ICompositeExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.common.gridcompute.VExpr;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.IDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.IDisplayEveryPage;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.R1PrintGroup;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.cellvalue.GridCompute;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.importer.AR1PNode_D2W;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.AbstractPWDataGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.GroupDesc;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDataGridColumn;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.PWGroupRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueCompute;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueField;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueStat;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.cellvalue.CellValueText;
import java.util.ArrayList;
import java.util.List;

public class R1PDataGrid_D2W
extends AR1PNode_D2W {
    @Override
    protected IPrintWidget createWidget(IReportObject node) {
        return new PWDataGrid();
    }

    @Override
    protected void importSpecial(IReportObject design, IPrintWidget widget) {
        DataGrid designGrid = (DataGrid)design;
        PWDataGrid widgetGrid = (PWDataGrid)widget;
        widgetGrid.setDatasource(designGrid.getDataSource().getDs());
        int lc = designGrid.getColumnsCount();
        for (int j = 0; j < lc; ++j) {
            AbstractColumn designCol = designGrid.getColumn(j);
            PWDataGridColumn widgetCol = widgetGrid.addColumn();
            R1PDataGrid_D2W.importElementCommon(designCol, widgetCol);
            widgetCol.setWidth(designCol.getWidthLom());
        }
        ArrayList<String> listGroupDesc = new ArrayList<String>();
        listGroupDesc.add(null);
        int rc = designGrid.getRowsCount();
        for (int i = 0; i < rc; ++i) {
            AbstractPWDataGridRow widgetRow;
            AbstractRow designRow = designGrid.getRow(i);
            if (designRow instanceof AbstractDetailRow) {
                widgetRow = widgetGrid.addRow(2);
                if (designRow instanceof DataGridDetailRow) {
                    DataGridDetailRow dRow = (DataGridDetailRow)designRow;
                    if (dRow.isBackwardForward()) {
                        widgetRow.setGroupLevel(listGroupDesc.size() - 1);
                    } else {
                        widgetRow.setGroupLevel(listGroupDesc.size());
                        int repeatTimes = dRow.getRepeatTimes();
                        ((PWDetailRow)widgetRow).setRepeatAtPage(repeatTimes);
                        boolean dealPrintBlankLine = dRow.isDealPrintBlankLine();
                        ((PWDetailRow)widgetRow).setDealPrintBlankLineAtPage(dealPrintBlankLine);
                    }
                }
            } else {
                widgetRow = widgetGrid.addRow(1);
                PWGroupRow groupRow = (PWGroupRow)widgetRow;
                if (designRow instanceof IDisplayEveryPage) {
                    IDisplayEveryPage ipage = (IDisplayEveryPage)((Object)designRow);
                    boolean isAppearEveryPage = ipage.isDisplayEveryPage();
                    groupRow.setAppearEveryPage(isAppearEveryPage);
                }
                String groupField = null;
                boolean isDividePageWhenDifferentGroup = false;
                boolean isDividePageWhenEconomicPrint = false;
                if (designRow instanceof AbstractGroupRow) {
                    R1PrintGroup group = (R1PrintGroup)((AbstractGroupRow)designRow).getGroup();
                    groupField = group.getAccording();
                    isDividePageWhenDifferentGroup = group.isDividePageWhenDifferGroup();
                    isDividePageWhenEconomicPrint = group.isDividePageWhenEconomicPrint();
                }
                GroupDesc groupDesc = new GroupDesc();
                groupDesc.setGroupField(groupField);
                groupDesc.setDividePageWhenDifferent(isDividePageWhenDifferentGroup);
                groupDesc.setDividePageWhenEconomicPrint(isDividePageWhenEconomicPrint);
                groupRow.setGroupDesc(groupDesc);
                if (listGroupDesc.contains(groupField)) {
                    int level = listGroupDesc.indexOf(groupField);
                    groupRow.setGroupLevel(level);
                } else {
                    listGroupDesc.add(groupField);
                    groupRow.setGroupLevel(listGroupDesc.size() - 1);
                }
            }
            R1PDataGrid_D2W.importElementCommon(designRow, widgetRow);
            widgetRow.setHeight(designRow.getHeightLom());
            widgetRow.setAdjustHeight(!designRow.isFixedHeight());
            widgetRow.setBackwardForward(((IDataGridRow)((Object)designRow)).isBackwardForward());
            this.importCell(designRow, widgetRow, widgetGrid.getMergeBlocks());
        }
    }

    private void importCell(AbstractRow designRow, AbstractPWDataGridRow widgetRow, List mergeBlocks) {
        int lc = designRow.getCellCount();
        block6: for (int j = 0; j < lc; ++j) {
            ICellValue designCellValue;
            DataGridCell designCell = (DataGridCell)designRow.getCell(j);
            PWDataGridCell widgetCell = widgetRow.getCell(j);
            R1PDataGrid_D2W.importElementCommon(designCell, widgetCell);
            widgetCell.setDivideCharNums(designCell.getDivideCharNums());
            widgetCell.setDivideModel(designCell.getDivideModel());
            MergeBlock mb = designCell.getMergeBlock();
            if (mb != null) {
                widgetCell.setBeMerged(true);
                if (!mergeBlocks.contains(mb)) {
                    mergeBlocks.add((MergeBlock)mb.clone());
                }
            }
            if ((designCellValue = designCell.getValue()) == null) {
                this.importChildren(designCell, widgetCell);
                continue;
            }
            switch (designCellValue.getCellType()) {
                case 2: {
                    String field = ((CellField)designCellValue).getName();
                    widgetCell.setCellValue(new CellValueField(field));
                    continue block6;
                }
                case 1: {
                    String text = ((Text)designCellValue).getText();
                    widgetCell.setCellValue(new CellValueText(text));
                    continue block6;
                }
                case 3: {
                    StatField statField = (StatField)designCellValue;
                    String fieldName = statField.getField().getName();
                    int statType = R1PDataGrid_D2W.toEngineType(statField.getType());
                    int statRange = R1PDataGrid_D2W.toEngineRange(statField.getRange());
                    CellValueStat cellValueStat = new CellValueStat(fieldName);
                    cellValueStat.setStatType(statType + statRange);
                    if (statField.isShowGroupStatLast()) {
                        widgetCell.getExtProps().put("showGroupStatLast", Boolean.TRUE);
                    }
                    widgetCell.setCellValue(cellValueStat);
                    continue block6;
                }
                case 11: {
                    GridCompute compute = (GridCompute)designCellValue;
                    CellValueCompute cellValueCompute = new CellValueCompute(compute.getExpr());
                    this.ShowGroupStatLast(compute.getExpr(), widgetCell, widgetRow);
                    widgetCell.setCellValue(cellValueCompute);
                    continue block6;
                }
            }
        }
    }

    private static int toEngineRange(int range) {
        switch (range) {
            case 18: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 19: {
                return 8;
            }
        }
        return 4;
    }

    private static int toEngineType(int type) {
        switch (type) {
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 64;
            }
            case 4: {
                return 128;
            }
            case 5: {
                return 256;
            }
        }
        return 16;
    }

    private void ShowGroupStatLast(AbstractExpr currentExpr, PWDataGridCell widgetCell, AbstractPWDataGridRow widgetRow) {
        if (currentExpr instanceof VExpr) {
            if (((VExpr)currentExpr).getLevel() == widgetRow.getGroupLevel() && ((VExpr)currentExpr).isShowGroupStatLast()) {
                widgetCell.getExtProps().put("showGroupStatLast", Boolean.TRUE);
            }
            return;
        }
        if (currentExpr instanceof ICompositeExpr) {
            if (((ICompositeExpr)((Object)currentExpr)).getLeftExpr() != null) {
                this.ShowGroupStatLast(((ICompositeExpr)((Object)currentExpr)).getLeftExpr(), widgetCell, widgetRow);
            }
            if (((ICompositeExpr)((Object)currentExpr)).getRightExpr() != null) {
                this.ShowGroupStatLast(((ICompositeExpr)((Object)currentExpr)).getRightExpr(), widgetCell, widgetRow);
            }
        }
    }
}

