/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.layoutgrid;

import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.merge.MergeBlock;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.ExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.R1PrintEngine;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPaginationSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.datagrid.merge.MergeHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.layoutgrid.PWLayoutGridCell;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.layoutgrid.PWLayoutGridColumn;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.layoutgrid.PWLayoutGridRow;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.layoutgrid.context.LayoutGridCellExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.layoutgrid.context.LayoutGridExecuteContext;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class PWLayoutGrid
extends AbstractPrintWidget
implements IPaginationSupport {
    private static final String ExtProp_NewPageNextRow = "newPageNextRow";
    private ArrayList _rows = new ArrayList();
    private ArrayList _columns = new ArrayList();
    private ArrayList _outputRows = new ArrayList();
    private ArrayList _outputColumns;
    private List _mergeBlocks = new ArrayList();

    public PWLayoutGridRow addRow() {
        PWLayoutGridRow row = new PWLayoutGridRow(this._columns.size());
        this._rows.add(row);
        return row;
    }

    public int getRowsCount() {
        return this._rows.size();
    }

    public PWLayoutGridRow getRow(int rowIndex) {
        return (PWLayoutGridRow)this._rows.get(rowIndex);
    }

    public int getIndexOfRow(PWLayoutGridRow row) {
        return this._rows.indexOf(row);
    }

    public PWLayoutGridColumn addColumn() {
        PWLayoutGridColumn col = new PWLayoutGridColumn();
        this._columns.add(col);
        int c = this.getRowsCount();
        for (int i = 0; i < c; ++i) {
            this.getRow(i).addCell();
        }
        return col;
    }

    public int getColumnCount() {
        return this._columns.size();
    }

    public PWLayoutGridColumn getColumn(int colIndex) {
        return (PWLayoutGridColumn)this._columns.get(colIndex);
    }

    public List getOutputRows() {
        return this._outputRows;
    }

    public PWLayoutGridRow getOutputRow(int idx) {
        return (PWLayoutGridRow)this.getOutputRows().get(idx);
    }

    public List getOutputColumns() {
        return this._outputColumns;
    }

    public PWLayoutGridColumn getOutputColumn(int colIndex) {
        return (PWLayoutGridColumn)this._outputColumns.get(colIndex);
    }

    public List getMergeBlocks() {
        return this._mergeBlocks;
    }

    @Override
    public IPrintWidget copy() {
        int i;
        PWLayoutGrid outputGrid = (PWLayoutGrid)super.copy();
        outputGrid._rows = this._rows;
        outputGrid._columns = this._columns;
        outputGrid._outputColumns = new ArrayList();
        int c = this._columns.size();
        for (i = 0; i < c; ++i) {
            outputGrid._outputColumns.add(((PWLayoutGridColumn)this._columns.get(i)).copy());
        }
        if (this.getMergeBlocks() != null) {
            c = this.getMergeBlocks().size();
            for (i = 0; i < c; ++i) {
                outputGrid.getMergeBlocks().add(((MergeBlock)this.getMergeBlocks().get(i)).clone());
            }
        }
        return outputGrid;
    }

    private LayoutGridExecuteContext getGridExecuteContext() {
        if (this._executeContext == null) {
            this._executeContext = new LayoutGridExecuteContext();
        }
        return (LayoutGridExecuteContext)this._executeContext;
    }

    @Override
    public ExecuteContext getContext() {
        return this.getGridExecuteContext();
    }

    @Override
    public boolean isOutputEnd() {
        return this.getGridExecuteContext().getRowCursorMemo() == -1;
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
        PWLayoutGrid outputGrid = (PWLayoutGrid)outputWidget;
        int c = outputGrid.getOutputColumns().size();
        for (int i = 0; i < c; ++i) {
            helper.runScript(outputGrid.getOutputColumn(i), 1);
        }
        R1PrintEngine.markOutputId(helper, outputGrid._outputColumns);
        int parentHeight = this.getContext().isAdjustHeight() ? this.getContext().getMaxHeightToAdjust() : this.getContext().getContainerHeight();
        int parentWidth = this.getContext().getContainerWidth();
        int rowsCount = outputGrid.getRowsCount();
        int rowCursor = this.getGridExecuteContext().getRowCursorMemo();
        if (rowCursor == -1) {
            rowCursor = 0;
        }
        int addedY = outputGrid.getRectangle().y;
        PWLayoutGridRow rowDelayFromLastPage = this.getGridExecuteContext().getRowDelayOutput();
        if (rowDelayFromLastPage != null) {
            this.getGridExecuteContext().setRowDelayOutput(null);
            outputGrid.hideRow(0, rowCursor - 2);
            outputGrid.getOutputRows().add(rowDelayFromLastPage);
            addedY += rowDelayFromLastPage.getHeight();
        } else {
            outputGrid.hideRow(0, rowCursor - 1);
        }
        ArrayList mbsAcrossRow = new ArrayList();
        while (rowCursor < rowsCount) {
            int outputHeight;
            PWLayoutGridRow outputRow;
            boolean b2;
            int remainHeight = parentHeight - addedY;
            if (remainHeight <= 0) {
                this.getGridExecuteContext().setRowCursorMemo(rowCursor, true);
                outputGrid.hideTailRow(rowCursor);
                break;
            }
            PWLayoutGridRow row = outputGrid.getRow(rowCursor);
            boolean adjustHeight = row.isAdjustHeight();
            if (!adjustHeight && remainHeight < row.getHeight()) {
                this.getGridExecuteContext().setRowCursorMemo(rowCursor, true);
                outputGrid.hideTailRow(rowCursor);
                break;
            }
            boolean b1 = rowDelayFromLastPage != null && rowCursor >= this.getGridExecuteContext().getRowCursorMemo();
            boolean bl = b2 = rowDelayFromLastPage == null && rowCursor > this.getGridExecuteContext().getRowCursorMemo();
            if (b1 || b2) {
                PWLayoutGrid.resetCellContext(row);
            }
            if ((outputRow = PWLayoutGrid.executeRow(helper, this, outputGrid, row, rowCursor, remainHeight, parentWidth, mbsAcrossRow)).getContext().isChildrenPaginating()) {
                helper.getDataContext().removeOverdoData(outputGrid);
            }
            if (adjustHeight && (outputHeight = outputRow.getHeight()) > remainHeight) {
                this.getGridExecuteContext().setRowDelayOutput(outputRow);
                outputGrid.fixMbToDelayOutputRow(outputRow);
                this.getGridExecuteContext().setRowCursorMemo(rowCursor + 1, false);
                outputGrid.hideTailRow(rowCursor);
                break;
            }
            if (outputGrid.isPrintable() && outputRow.isPrintable()) {
                outputGrid.getOutputRows().add(outputRow);
                addedY += outputRow.getHeight();
                if (adjustHeight && row.getContext().isChildrenPaginating() && !helper.paginationByGroupDiffs()) {
                    this.getGridExecuteContext().setRowCursorMemo(rowCursor, false);
                    outputGrid.hideTailRow(rowCursor + 1);
                    break;
                }
            } else {
                outputGrid.hideRow(rowCursor, rowCursor);
            }
            if (outputRow.getExtProps().getBoolean(ExtProp_NewPageNextRow, false)) {
                this.getGridExecuteContext().setRowCursorMemo(rowCursor + 1, true);
                outputGrid.hideTailRow(rowCursor + 1);
                break;
            }
            ++rowCursor;
        }
        outputGrid.getRectangle().height = addedY - outputGrid.getRectangle().y;
        if (rowCursor == rowsCount) {
            this.getGridExecuteContext().setRowCursorMemo(-1, false);
            helper.getDataContext().removeOverdoData(outputGrid);
        }
        outputGrid.calculateMerge();
        outputGrid.syncOutputRectangle();
        outputGrid.clearReferCell(0, outputGrid.getRowsCount() - 1);
        int c2 = outputGrid.getOutputColumns().size();
        for (int i = 0; i < c2; ++i) {
            helper.runScript(outputGrid.getOutputColumn(i), 2);
        }
    }

    private static void resetCellContext(PWLayoutGridRow row) {
        int c = row.getCellCount();
        for (int i = 0; i < c; ++i) {
            PWLayoutGridCell cell = row.getCell(i);
            PWLayoutGrid.resetCellContext(cell);
        }
    }

    private static void resetCellContext(PWLayoutGridCell cell) {
        ((LayoutGridCellExecuteContext)cell.getContext()).setOutputedWhenAdjustHeight(false);
        ((LayoutGridCellExecuteContext)cell.getContext()).setChildrenPaginating(false);
    }

    private void syncOutputRectangle() {
        int height = 0;
        for (PWLayoutGridRow row : this.getOutputRows()) {
            height += row.getHeight();
        }
        this.getRectangle().height = height;
    }

    private static PWLayoutGridRow executeRow(IWidgetExecuteHelper helper, PWLayoutGrid grid, PWLayoutGrid outputGrid, PWLayoutGridRow row, int rowIdx, int maxHeightToAdjust, int rowWidth, List mbsAcrossRow) throws R1PrintException {
        PWLayoutGridRow outputRow = (PWLayoutGridRow)row.copy();
        helper.runScript(outputRow, 1);
        if (!outputRow.isPrintable()) {
            outputRow.setHeight(0);
            return outputRow;
        }
        boolean isChildrenPaginating = false;
        int realMaxHeight = -1;
        List mbsAcrossThisRow = PWLayoutGrid.createCurrentRowMBAR(mbsAcrossRow, rowIdx);
        int c = row.getCellCount();
        for (int i = 0; i < c; ++i) {
            int cellAtRowIdx = rowIdx;
            PWLayoutGridCell cell = row.getCell(i);
            if (cell.getReferCell() != null) {
                int rIdx = cell.getReferCell().getRow();
                int cIdx = cell.getReferCell().getCol();
                cell = outputGrid.getRow(rIdx).getCell(cIdx);
                PWLayoutGrid.resetCellContext(cell);
                cellAtRowIdx = rIdx;
            }
            int colWidth = 0;
            int rowHeight = 0;
            boolean isAdjustHeight = false;
            MergeBlockAcrossRow mbar = null;
            boolean isToExec = true;
            if (cell.isBeMerged()) {
                Object[] mergeInfos = grid.getMergeInfos(cellAtRowIdx, rowIdx, i);
                if (mergeInfos == null) {
                    outputRow.addCell(null);
                    mbar = PWLayoutGrid.searchFirstColMBAR(mbsAcrossThisRow, i);
                    if (mbar == null) continue;
                    isToExec = false;
                } else {
                    Dimension dim = (Dimension)mergeInfos[1];
                    colWidth = dim.width;
                    rowHeight = dim.height;
                    isAdjustHeight = (Boolean)mergeInfos[0];
                    mbar = (MergeBlockAcrossRow)mergeInfos[2];
                    if (mbar != null) {
                        mbsAcrossThisRow.add(mbar);
                    }
                }
            } else {
                colWidth = outputGrid.getOutputColumn(i).getWidth();
                rowHeight = row.getHeight();
                isAdjustHeight = row.isAdjustHeight();
            }
            PWLayoutGridCell outputCell = null;
            if (isToExec) {
                ExecuteContext cellExecuteContext = cell.getContext();
                cellExecuteContext.setOwner(grid.getContext().getOwner());
                cellExecuteContext.setContainerWidth(colWidth);
                cellExecuteContext.setContainerHeight(rowHeight);
                cellExecuteContext.setAdjustHeight(isAdjustHeight);
                cellExecuteContext.setMaxHeightToAdjust(maxHeightToAdjust);
                cellExecuteContext.passContextDataHelper(grid.getContext());
                cellExecuteContext.setOutputedParent(R1PrintEngine.createOutputedParent(outputGrid.getOutputedParent(), outputGrid));
                outputCell = (PWLayoutGridCell)cell.execute(helper);
                outputRow.addCell(outputCell);
                boolean bl = isChildrenPaginating = isChildrenPaginating || cell.getContext().isChildrenPaginating();
                if (isChildrenPaginating) {
                    mbsAcrossThisRow.remove(mbar);
                    mbar = null;
                }
                if (mbar != null) {
                    mbar.setHeightRemain(outputCell.getRectangle().height);
                }
            }
            if (mbar != null) {
                int maxHeight = row.isAdjustHeight() ? 0 : row.getHeight();
                realMaxHeight = realMaxHeight < maxHeight ? maxHeight : realMaxHeight;
                continue;
            }
            boolean isHeightToAccept = false;
            if (row.isAdjustHeight()) {
                if (outputCell.hasChildren()) {
                    for (IPrintWidget child : outputCell.getChildren()) {
                        if (child.isVFill() && !(child instanceof IAdjustHeightSupport)) continue;
                        isHeightToAccept = true;
                    }
                } else if (outputCell.isAdjustHeight()) {
                    isHeightToAccept = true;
                }
            } else {
                isHeightToAccept = true;
            }
            if (!isHeightToAccept || realMaxHeight >= outputCell.getRectangle().height) continue;
            realMaxHeight = outputCell.getRectangle().height;
        }
        row.getContext().setChildrenPaginating(isChildrenPaginating);
        if (realMaxHeight >= 0) {
            realMaxHeight = Math.min(realMaxHeight, maxHeightToAdjust);
            outputRow.setHeight(realMaxHeight);
            ArrayList colsInMergeBlock = new ArrayList();
            int c2 = outputRow.getCellCount();
            for (int i = 0; i < c2; ++i) {
                int delta;
                PWLayoutGridCell outputCell = outputRow.getCell(i);
                if (outputCell == null || colsInMergeBlock.contains(new Integer(i)) || (delta = realMaxHeight - outputCell.getRectangle().height) == 0) continue;
                outputCell.getRectangle().height = realMaxHeight;
                outputCell.recursionChildrenFill(false, 0, true, delta);
            }
        }
        mbsAcrossRow.addAll(mbsAcrossThisRow);
        helper.markOutputId(outputRow);
        helper.runScript(outputRow, 2);
        return outputRow;
    }

    private void hideRow(int fromRow, int toRow) {
        for (int i = fromRow; i <= toRow; ++i) {
            PWLayoutGridRow oriRow = this.getRow(i);
            int currentOutputIdx = this.getOutputRows().size();
            MergeHelper.adjustDeleteRow(this.getMergeBlocks(), currentOutputIdx, this, oriRow);
        }
    }

    private void hideTailRow(int fromRow) {
        this.hideRow(fromRow, this.getRowsCount() - 1);
    }

    private Object[] getMergeInfos(int cellAtRowIdx, int rowIdx, int colIdx) {
        boolean isHeightAdjust = false;
        for (MergeBlock mb : this.getMergeBlocks()) {
            if (mb.getLeft() != colIdx || mb.getTop() != cellAtRowIdx) continue;
            int h = 0;
            for (int i = rowIdx; i <= mb.getBottom(); ++i) {
                if (this.getRow(i).isAdjustHeight()) {
                    isHeightAdjust = true;
                }
                h += this.getRow(i).getHeight();
            }
            int w = 0;
            for (int i = mb.getLeft(); i <= mb.getRight(); ++i) {
                w += this.getColumn(i).getWidth();
            }
            MergeBlockAcrossRow mbar = null;
            if (mb.getTop() != mb.getBottom()) {
                mbar = new MergeBlockAcrossRow(mb);
            }
            return new Object[]{isHeightAdjust, new Dimension(w, h), mbar};
        }
        return null;
    }

    private void calculateMerge() {
        List mergeBlocks = this.getMergeBlocks();
        for (int i = mergeBlocks.size() - 1; i >= 0; --i) {
            MergeBlock mb = (MergeBlock)mergeBlocks.get(i);
            int blockHeight = 0;
            int blockWidth = 0;
            for (int h = mb.getTop(); h <= mb.getBottom(); ++h) {
                PWLayoutGridRow row = this.getOutputRow(h);
                blockHeight += row.getHeight();
                for (int w = mb.getLeft(); w <= mb.getRight(); ++w) {
                    if (h != mb.getTop()) continue;
                    blockWidth += this.getOutputColumn(w).getWidth();
                }
            }
            PWLayoutGridCell firstCell = this.getOutputRow(mb.getTop()).getCell(mb.getLeft());
            if (firstCell == null) continue;
            Rectangle rect = firstCell.getRectangle();
            int deltaWidth = blockWidth - rect.width;
            int deltaHeight = blockHeight - rect.height;
            boolean isToDealH = false;
            boolean isToDealV = false;
            if (deltaWidth != 0) {
                rect.width = blockWidth;
                isToDealH = true;
            }
            if (deltaHeight != 0) {
                rect.height = blockHeight;
                isToDealV = true;
            }
            if (!isToDealH && !isToDealV) continue;
            firstCell.recursionChildrenFill(isToDealH, deltaWidth, isToDealV, deltaHeight);
        }
    }

    @Override
    public void recursionChildrenFill(boolean isDealHorizontal, int deltaHorizontal, boolean isDealVertical, int deltaVertical) {
        List outputRows = this.getOutputRows();
        List outputCols = this.getOutputColumns();
        int rowsCount = outputRows.size();
        int colsCount = outputCols.size();
        int deltaEveryCol = (int)((double)((float)deltaHorizontal / (float)colsCount) + 0.5);
        int deltaEveryRow = (int)((double)((float)deltaVertical / (float)rowsCount) + 0.5);
        for (int i = 0; i < rowsCount; ++i) {
            int deltaV = deltaEveryRow;
            if (i == rowsCount - 1) {
                deltaV = deltaVertical - deltaEveryRow * (rowsCount - 1);
            }
            PWLayoutGridRow row = (PWLayoutGridRow)outputRows.get(i);
            if (isDealVertical) {
                row.setHeight(row.getHeight() + deltaV);
            }
            for (int j = 0; j < colsCount; ++j) {
                PWLayoutGridCell cell;
                int deltaH = deltaEveryCol;
                if (j == colsCount - 1) {
                    deltaH = deltaHorizontal - deltaEveryCol * (colsCount - 1);
                }
                if (i == 0 && isDealHorizontal) {
                    PWLayoutGridColumn col = (PWLayoutGridColumn)outputCols.get(j);
                    col.setWidth(col.getWidth() + deltaH);
                }
                if ((cell = row.getCell(j)) == null) continue;
                Rectangle rect = cell.getRectangle();
                if (isDealHorizontal) {
                    rect.width += deltaH;
                }
                if (isDealVertical) {
                    rect.height += deltaV;
                }
                cell.recursionChildrenFill(isDealHorizontal, deltaH, isDealVertical, deltaV);
            }
        }
    }

    private static List createCurrentRowMBAR(List mbsAcrossRow, int rowIdx) {
        ArrayList<MergeBlockAcrossRow> result = new ArrayList<MergeBlockAcrossRow>();
        for (int i = mbsAcrossRow.size() - 1; i >= 0; --i) {
            MergeBlockAcrossRow mbar = (MergeBlockAcrossRow)mbsAcrossRow.get(i);
            if (!mbar.isAcrossRow(rowIdx)) continue;
            result.add(mbar);
        }
        return result;
    }

    private static MergeBlockAcrossRow searchFirstColMBAR(List mbsAcrossThisRow, int colIdx) {
        for (int i = mbsAcrossThisRow.size() - 1; i >= 0; --i) {
            MergeBlockAcrossRow mbar = (MergeBlockAcrossRow)mbsAcrossThisRow.get(i);
            if (mbar.getFirstColIdx() != colIdx) continue;
            return mbar;
        }
        return null;
    }

    private void clearReferCell(int fromRow, int toRow) {
        for (int i = fromRow; i <= toRow; ++i) {
            PWLayoutGridRow row = this.getRow(i);
            int c = row.getCellCount();
            for (int j = 0; j < c; ++j) {
                row.getCell(j).setReferCell(null);
            }
        }
    }

    private void fixMbToDelayOutputRow(PWLayoutGridRow outputRow) {
        int c = outputRow.getCellCount();
        block0: for (int i = 0; i < c; ++i) {
            if (outputRow.getCell(i) != null) continue;
            int delayRowIdx = this.getOutputRows().size();
            for (MergeBlock mb : this.getMergeBlocks()) {
                if (mb.getLeft() != i || mb.getTop() >= delayRowIdx || delayRowIdx > mb.getBottom()) continue;
                for (int tempIdx = delayRowIdx - 1; tempIdx >= mb.getTop(); --tempIdx) {
                    PWLayoutGridCell mainCell = this.getOutputRow(tempIdx).getCell(mb.getLeft());
                    if (mainCell == null) continue;
                    outputRow.setCell(mainCell.copyOutput(), i);
                    continue block0;
                }
            }
        }
    }

    private static class MergeBlockAcrossRow {
        private int _fromDesignRowIdx;
        private int _toDesignRowIdx;
        private int _fromDesignColIdx;
        private int _toDesignColIdx;
        private int _heightRemain;
        private int _prepAcceptHeight;

        public MergeBlockAcrossRow(MergeBlock mb) {
            this._fromDesignRowIdx = mb.getTop();
            this._toDesignRowIdx = mb.getBottom();
            this._fromDesignColIdx = mb.getLeft();
            this._toDesignColIdx = mb.getRight();
        }

        public int getFirstRowIdx() {
            return this._fromDesignRowIdx;
        }

        public int getFirstColIdx() {
            return this._fromDesignColIdx;
        }

        public int getLastRowIdx() {
            return this._toDesignRowIdx;
        }

        public void setHeightRemain(int height) {
            this._heightRemain = height;
        }

        public int getHeightRemain() {
            return this._heightRemain;
        }

        public boolean isInside(int designRowIdx, int designColIdx) {
            return this._fromDesignRowIdx <= designRowIdx && designRowIdx <= this._toDesignRowIdx && this._fromDesignColIdx <= designColIdx && designColIdx <= this._toDesignColIdx;
        }

        public boolean isLastRow(int designRowIdx) {
            return this._toDesignRowIdx == designRowIdx;
        }

        public boolean isAcrossRow(int designRowIdx) {
            return this._fromDesignRowIdx <= designRowIdx && designRowIdx <= this._toDesignRowIdx;
        }

        public void markPrepAcceptHeight(int height) {
            this._prepAcceptHeight = height;
        }

        public int getPrepAcceptHeight() {
            return this._prepAcceptHeight;
        }

        public int acceptHeight(int height) {
            if (this._prepAcceptHeight != 0) {
                this._prepAcceptHeight = 0;
                this._heightRemain -= height;
                if (this._heightRemain < 0) {
                    int result = -this._heightRemain;
                    this._heightRemain = 0;
                    return result;
                }
                return 0;
            }
            return -1;
        }
    }
}

