/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.loop;

import com.kingdee.bos.ctrl.reportone.r1.print.engine.ExecuteContext;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.IWidgetExecuteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.R1PrintEngine;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintException;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.AbstractPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IAdjustHeightSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IDatasourceSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPaginationSupport;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.IPrintWidget;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.loop.DataTransposer;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.loop.PWLoopContainer;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.loop.TransposedDataHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.widget.loop.context.LoopAreaContext;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class PWLoopArea
extends AbstractPrintWidget
implements IAdjustHeightSupport,
IDatasourceSupport,
IPaginationSupport {
    public static final boolean Orientation_H = true;
    public static final boolean Orientation_V = false;
    private PWLoopContainer _container;
    private String _ds;
    private boolean _loopOrientation;
    private boolean _isAdjustHeight;
    private boolean _toUseOutWidth;
    private boolean _blankRowStrategy;
    private DataTransposer _transpose;
    private int _maxHeightToAdjust;
    private ArrayList _outputContainers;
    private int _maxRowIdx;
    private int _maxColIdx;

    @Override
    public IPrintWidget copy() {
        PWLoopArea outputArea = (PWLoopArea)super.copy();
        outputArea._container = (PWLoopContainer)this._container.copy();
        outputArea._ds = this._ds;
        outputArea._loopOrientation = this._loopOrientation;
        outputArea._isAdjustHeight = this._isAdjustHeight;
        outputArea._toUseOutWidth = this._toUseOutWidth;
        outputArea._blankRowStrategy = this._blankRowStrategy;
        return outputArea;
    }

    @Override
    public ExecuteContext getContext() {
        return this.getMyContext();
    }

    LoopAreaContext getMyContext() {
        if (this._executeContext == null) {
            this._executeContext = new LoopAreaContext(this.getDatasource());
        }
        return (LoopAreaContext)this._executeContext;
    }

    @Override
    protected void executing(IWidgetExecuteHelper helper, IPrintWidget outputWidget) throws R1PrintException {
        IWidgetExecuteHelper.IDataHelper dataHelper;
        PWLoopArea outputArea = (PWLoopArea)outputWidget;
        String ds = outputArea.getDatasource();
        if (this._transpose != null) {
            if (this.getMyContext().getDataCursorMemo() == -1) {
                dataHelper = this.createTansposedDataHelper(helper);
                this.getMyContext().setKeepDataHelper(dataHelper);
            } else {
                dataHelper = this.getMyContext().getKeepDataHelper();
            }
            this.getMyContext().setContextDataHelper(dataHelper, ds);
            this.getLoopContainer().getMyContext().setContextDataHelper(dataHelper, ds);
        }
        if ((dataHelper = this.getDataHelper(helper, ds)).isBOF(ds) && !dataHelper.isEOF(ds)) {
            dataHelper.next(ds);
        }
        if (this.getLoopOrientation()) {
            this.dealH(outputArea, helper);
        } else {
            this.dealV(outputArea, helper);
        }
    }

    private void dealH(PWLoopArea outputArea, IWidgetExecuteHelper helper) throws R1PrintException {
        boolean isOutputEnd;
        int addY;
        int areaWidth = outputArea.getRectangle().width;
        int areaHeight = outputArea.getRectangle().height;
        int ctnWidth = outputArea.getLoopContainer().getRectangle().width;
        int ctnHeight = outputArea.getLoopContainer().getRectangle().height;
        boolean isAdjustHeight = outputArea.isAdjustHeight();
        boolean isUsingMainDS = false;
        int heightCanUse = isAdjustHeight ? (this.getContext().isAdjustHeight() ? this.getContext().getMaxHeightToAdjust() : this.getContext().getContainerHeight()) - outputArea.getRectangle().y : areaHeight;
        String ds = outputArea.getDatasource();
        isUsingMainDS = ds.equals(this.getMainDs());
        IWidgetExecuteHelper.IDataHelper dataHelper = this.getDataHelper(helper, ds);
        int rowIdx = 0;
        int colIdx = 0;
        int addX = ctnWidth;
        int heightUsed = addY = ctnHeight;
        int widthUsed = addX;
        boolean loop = !dataHelper.isEOF(ds);
        boolean isBlankRow = false;
        boolean bl = isOutputEnd = !loop;
        while (loop) {
            PWLoopContainer executeContainer = this.executeContainer(helper, outputArea, isBlankRow, rowIdx, colIdx, addX, addY, ctnWidth, ctnHeight);
            boolean hasNext = dataHelper.hasNext(ds);
            if (outputArea.isBlankRowStrategy()) {
                isBlankRow = !hasNext;
            } else {
                loop = hasNext;
            }
            boolean bl2 = isOutputEnd = !hasNext;
            if (!isUsingMainDS && !dataHelper.isEOF(ds)) {
                dataHelper.next(ds);
            }
            if (executeContainer.isHide()) {
                if (!hasNext) continue;
                dataHelper.next(ds);
                continue;
            }
            if (widthUsed < addX) {
                widthUsed = addX;
            }
            ++colIdx;
            if ((addX += ctnWidth) > areaWidth) {
                if (isAdjustHeight && isOutputEnd) break;
                ++rowIdx;
                if ((addY += ctnHeight) > heightCanUse) {
                    isOutputEnd = !isAdjustHeight;
                    break;
                }
                addX = ctnWidth;
                colIdx = 0;
                heightUsed = addY;
            }
            if (!isUsingMainDS || dataHelper.isEOF(ds)) continue;
            dataHelper.next(ds);
        }
        if (isOutputEnd) {
            this.getMyContext().setDataCursorMemo(-1);
        } else {
            int cursor = dataHelper.getCurrentPositon(ds);
            this.getMyContext().setDataCursorMemo(cursor);
        }
        this.adjustWidth(outputArea, areaWidth, widthUsed);
        if (isAdjustHeight) {
            outputArea.getRectangle().height = heightUsed;
        }
    }

    private void dealV(PWLoopArea outputArea, IWidgetExecuteHelper helper) throws R1PrintException {
        boolean isOutputEnd;
        int addY;
        int outputRows;
        int areaWidth = outputArea.getRectangle().width;
        int areaHeight = outputArea.getRectangle().height;
        int ctnWidth = outputArea.getLoopContainer().getRectangle().width;
        int ctnHeight = outputArea.getLoopContainer().getRectangle().height;
        boolean isAdjustHeight = outputArea.isAdjustHeight();
        boolean isUsingMainDS = false;
        int heightCanUse = isAdjustHeight ? (this.getContext().isAdjustHeight() ? this.getContext().getMaxHeightToAdjust() : this.getContext().getContainerHeight()) - outputArea.getRectangle().y : areaHeight;
        String ds = outputArea.getDatasource();
        isUsingMainDS = ds.equals(this.getMainDs());
        IWidgetExecuteHelper.IDataHelper dataHelper = this.getDataHelper(helper, ds);
        int maxOutputRows = heightCanUse / ctnHeight;
        if (isAdjustHeight) {
            int memoDataCursor;
            int maxOutputCols = areaWidth / ctnWidth;
            int dataCount = dataHelper.getRowsCount(ds);
            int remainDataCount = dataCount - ((memoDataCursor = this.getMyContext().getDataCursorMemo()) < 0 ? 0 : memoDataCursor);
            int needRows = remainDataCount / maxOutputCols + (remainDataCount % maxOutputCols > 0 ? 1 : 0);
            outputRows = needRows > maxOutputRows ? maxOutputRows : needRows;
        } else {
            outputRows = maxOutputRows;
        }
        int rowIdx = 0;
        int colIdx = 0;
        int addX = ctnWidth;
        int heightUsed = addY = ctnHeight;
        int widthUsed = addX;
        boolean loop = !dataHelper.isEOF(ds);
        boolean isBlankRow = false;
        boolean bl = isOutputEnd = !loop;
        while (loop) {
            PWLoopContainer executeContainer = this.executeContainer(helper, outputArea, isBlankRow, rowIdx, colIdx, addX, addY, ctnWidth, ctnHeight);
            boolean hasNext = dataHelper.hasNext(ds);
            if (outputArea.isBlankRowStrategy()) {
                isBlankRow = !hasNext;
            } else {
                loop = hasNext;
            }
            boolean bl2 = isOutputEnd = !hasNext;
            if (!isUsingMainDS && hasNext) {
                dataHelper.next(ds);
            }
            if (executeContainer.isHide()) {
                if (!hasNext) continue;
                dataHelper.next(ds);
                continue;
            }
            if (heightUsed < addY) {
                heightUsed = addY;
            }
            addY += ctnHeight;
            if (++rowIdx >= outputRows) {
                if (isAdjustHeight && isOutputEnd) break;
                ++colIdx;
                if ((addX += ctnWidth) > areaWidth) {
                    isOutputEnd = !isAdjustHeight;
                    break;
                }
                addY = ctnHeight;
                rowIdx = 0;
                widthUsed = addX;
            }
            if (!isUsingMainDS || !hasNext) continue;
            dataHelper.next(ds);
        }
        if (isOutputEnd) {
            this.getMyContext().setDataCursorMemo(-1);
        } else {
            int cursor = dataHelper.getCurrentPositon(ds);
            this.getMyContext().setDataCursorMemo(cursor);
        }
        this.adjustWidth(outputArea, areaWidth, widthUsed);
        if (isAdjustHeight) {
            outputArea.getRectangle().height = heightUsed;
        }
    }

    private PWLoopContainer executeContainer(IWidgetExecuteHelper helper, PWLoopArea outputArea, boolean isBlankRow, int rowIdx, int colIdx, int addX, int addY, int ctnWidth, int ctnHeight) throws R1PrintException {
        this.getLoopContainer().setDatasource(outputArea.getDatasource());
        this.getLoopContainer().getMyContext().setBlankRow(isBlankRow);
        this.getLoopContainer().getMyContext().setOutputedParent(R1PrintEngine.createOutputedParent(outputArea.getOutputedParent(), outputArea));
        PWLoopContainer outputCtn = (PWLoopContainer)this.getLoopContainer().execute(helper);
        if (outputCtn.isPrintable()) {
            outputCtn.setRowIdx(rowIdx);
            outputCtn.setColIdx(colIdx);
            outputCtn.getRectangle().x = addX - ctnWidth;
            outputCtn.getRectangle().y = addY - ctnHeight;
            outputArea.getOutputContainers().add(outputCtn);
            outputArea.updateRowColCount(rowIdx, colIdx);
        }
        return outputCtn;
    }

    private void adjustWidth(PWLoopArea outputArea, int areaWidth, int widthUsed) {
        if (outputArea.isToUseOutWidth() && widthUsed < areaWidth) {
            int allDelta = areaWidth - widthUsed;
            int unitDelta = allDelta / outputArea.getOutputColsCount();
            int repairIdx = allDelta % outputArea.getOutputColsCount();
            for (PWLoopContainer outputCtn : outputArea.getOutputContainers()) {
                int idx;
                int xAdd = idx * unitDelta + ((idx = outputCtn.getColIdx()) < repairIdx ? idx : repairIdx);
                int delta = unitDelta + (idx < repairIdx ? 1 : 0);
                Rectangle rect = outputCtn.getRectangle();
                rect.x += xAdd;
                rect.width += delta;
                outputCtn.recursionChildrenFill(true, delta, false, 0);
            }
        }
    }

    private void updateRowColCount(int rowIdx, int colIdx) {
        if (rowIdx > this._maxRowIdx) {
            this._maxRowIdx = rowIdx;
        }
        if (colIdx > this._maxColIdx) {
            this._maxColIdx = colIdx;
        }
    }

    private IWidgetExecuteHelper.IDataHelper createTansposedDataHelper(IWidgetExecuteHelper helper) throws R1PrintDataException {
        if (this._transpose != null) {
            IRowSet rowSet = this._transpose.trans(helper.getDataHelper(), this.getDatasource());
            return new TransposedDataHelper(rowSet);
        }
        return null;
    }

    public int getOutputRowsCount() {
        return this._maxRowIdx + 1;
    }

    public int getOutputColsCount() {
        return this._maxColIdx + 1;
    }

    @Override
    public void setAdjustHeight(boolean isAdjustHeight) {
        this._isAdjustHeight = isAdjustHeight;
    }

    @Override
    public boolean isAdjustHeight() {
        return this._isAdjustHeight;
    }

    @Override
    public void setMaxHeightToAdjust(int maxHeight) {
        this._maxHeightToAdjust = maxHeight;
    }

    @Override
    public int getMaxHeightToAdjust() {
        return this._maxHeightToAdjust;
    }

    @Override
    public void setRemainContent(boolean isRemain) {
    }

    @Override
    public boolean isRemainContent() {
        return false;
    }

    @Override
    public void setDatasource(String ds) {
        this._ds = ds;
    }

    @Override
    public String getDatasource() {
        return this._ds;
    }

    public void setTranspose(DataTransposer transpose) {
        this._transpose = transpose;
    }

    public DataTransposer getTranspose() {
        return this._transpose;
    }

    public void setLoopContainer(PWLoopContainer ctn) {
        this._container = ctn;
    }

    public PWLoopContainer getLoopContainer() {
        return this._container;
    }

    public void setLoopOrientation(boolean orientation) {
        this._loopOrientation = orientation;
    }

    public boolean getLoopOrientation() {
        return this._loopOrientation;
    }

    public void setBlankRowStrategy(boolean isBlankRowStrategy) {
        this._blankRowStrategy = isBlankRowStrategy;
    }

    public boolean isBlankRowStrategy() {
        return this._blankRowStrategy;
    }

    public void setToUseOutWidth(boolean toUseOutWidth) {
        this._toUseOutWidth = toUseOutWidth;
    }

    public boolean isToUseOutWidth() {
        return this._toUseOutWidth;
    }

    public List getOutputContainers() {
        if (this._outputContainers == null) {
            this._outputContainers = new ArrayList();
        }
        return this._outputContainers;
    }

    @Override
    public boolean isOutputEnd() {
        if (this.isAdjustHeight()) {
            return this.getMyContext().getDataCursorMemo() == -1;
        }
        return true;
    }

    public void relive() {
        this.getMyContext().requestRelive();
    }

    public void secondBirth() {
        this.getMyContext().requestSecondBirth();
    }
}

