/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportframework;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.IObjectStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.execute.AbstractLocalReportExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;

public abstract class AbstractDataRptExecutor
extends AbstractLocalReportExecutor {
    private Object rs;
    private Connection bosConnectionWrapper;

    @Override
    public void execute(HashMap args) throws ReportException {
        IReportStorage sto = super.getReportStorage();
        Object object = null;
        if (sto instanceof IStreamStorage) {
            InputStream in = null;
            try {
                in = ((IStreamStorage)sto).getInputStream();
                object = CtrlUtil.Stream.readInputStream((InputStream)in);
            }
            catch (IOException ex) {
                throw ReportException.makeException("", ex);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (sto instanceof IStreamStorage) {
            object = ((IObjectStorage)sto).getInputObject();
        } else {
            throw new UnsupportedOperationException();
        }
        try {
            this.bosConnectionWrapper = BosUtil.getDBConnection();
            args.put("bosConnectionWrapper", this.bosConnectionWrapper);
            Object rs = super.getDataExecutor().execute(this.getDataCatetory(), object, args, null);
            args.remove("bosConnectionWrapper");
            this.setDataResult(rs);
        }
        catch (Exception ex) {
            throw ReportException.makeException(null, ex);
        }
    }

    protected void setDataResult(Object rs) {
        this.rs = rs;
    }

    protected Object getDataResult() {
        return this.rs;
    }

    protected abstract String getDataCatetory();

    @Override
    public void close() throws ReportException {
        this.rs = null;
        this.closeBosConnectionWrapper();
    }

    protected void closeBosConnectionWrapper() throws ReportException {
        if (this.bosConnectionWrapper != null) {
            try {
                this.bosConnectionWrapper.close();
            }
            catch (SQLException e) {
                throw ReportException.makeException(e);
            }
            finally {
                this.bosConnectionWrapper = null;
            }
        }
    }
}

