/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.AffairUpgradeFacadeFactory;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillInfo;
import com.kingdee.eas.hr.affair.EmployeePoolCollection;
import com.kingdee.eas.hr.affair.EmployeePoolFactory;
import com.kingdee.eas.hr.affair.EmployeePoolInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryCollection;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizCollection;
import com.kingdee.eas.hr.affair.HRAffairBizFactory;
import com.kingdee.eas.hr.affair.HRAffairBizInfo;
import com.kingdee.eas.hr.affair.IHRAffairBizBill;
import com.kingdee.eas.hr.affair.IHRAffairBizBillEntry;
import com.kingdee.eas.hr.affair.ResignBizBillEntryInfo;
import com.kingdee.eas.hr.affair.app.AbstractAffairBizCheckFacadeControllerBean;
import com.kingdee.eas.hr.affair.app.EmpEnrollHelper;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAppUtils;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.FluctuationInOutCollection;
import com.kingdee.eas.hr.emp.FluctuationInOutFactory;
import com.kingdee.eas.hr.emp.FluctuationInOutInfo;
import com.kingdee.eas.hr.emp.PersonLoanCollection;
import com.kingdee.eas.hr.emp.PersonLoanFactory;
import com.kingdee.eas.hr.emp.PersonLoanInfo;
import com.kingdee.eas.hr.emp.app.util.EmpPostRankUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.HRBizDefineTypeEnum;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AffairBizCheckFacadeControllerBean
extends AbstractAffairBizCheckFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.AffairBizCheckFacadeControllerBean");
    private static String strResoure = "com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource";
    private static final String empManageTypeId = "SGuJm3nXW0GshQfKRXenomWJ1dE=";
    public static final String PLURALITYADD_BOSTYPE = "B3F8AB50";
    public static final String PLURALITYDEL_BOSTYPE = "6422D4A6";

    @Override
    protected BatchProcessedResult _isPersonInAffairProcess(Context ctx, String personIDs, String billID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIDs)) {
            return null;
        }
        if (this.isCheckOldAffairBill(ctx)) {
            this.isPersonInOldAffair(ctx, personIDs, billID);
        }
        String currDate = this.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID ");
        oql.append("where person.id in ");
        oql.append(this.getIdsSql(personIDs));
        if (!StringUtils.isEmpty((String)billID)) {
            oql.append(" and billID <> '");
            oql.append(billID);
            oql.append("' ");
        }
        this.addNotCheckBosType(ctx, oql);
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance(ctx).getHRAffairBizCollection(oql.toString());
        if (col != null && col.size() > 0) {
            BatchProcessedResult result = new BatchProcessedResult();
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"not_allow_option", (Context)ctx);
                Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                message = MessageFormat.format(message, params);
                result.addinvalidInfo(message);
            }
            return result;
        }
        return null;
    }

    private void addNotCheckBosType(Context ctx, StringBuffer oql) throws EASBizException, BOSException {
        boolean flag = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_PLURALITY_CHECKOTHERBILL", null);
        if (!flag) {
            oql.append(" and billBOSType <> 'B3F8AB50' ");
        }
        oql.append(" and billBOSType <> '6422D4A6' ");
    }

    @Override
    protected BatchProcessedResult _isPersonInPool(Context ctx, String personIDs) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIDs)) {
            return null;
        }
        String oql = "select id,person.id,person.number where person.id in " + this.getIdsSql(personIDs) + "";
        EmployeePoolCollection col = EmployeePoolFactory.getLocalInstance(ctx).getEmployeePoolCollection(oql);
        BatchProcessedResult result = new BatchProcessedResult();
        for (int i = 0; i < col.size(); ++i) {
            EmployeePoolInfo employeePoolInfo = col.get(i);
            result.addinvalidInfo(ResourceBase.getString((String)strResoure, (String)"0_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()) + employeePoolInfo.getPerson().getNumber() + ResourceBase.getString((String)strResoure, (String)"3_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (col.size() > 0) {
            return result;
        }
        return null;
    }

    @Override
    protected BatchProcessedResult _checkExistPresentPersonLoan(Context ctx, String personIds) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIds)) {
            return null;
        }
        String oql = "select id,person.id,person.number where person.id in " + this.getIdsSql(personIds) + " and state='" + "1" + "'";
        PersonLoanCollection col = PersonLoanFactory.getLocalInstance((Context)ctx).getPersonLoanCollection(oql);
        BatchProcessedResult result = new BatchProcessedResult();
        for (int i = 0; i < col.size(); ++i) {
            PersonLoanInfo personloan = col.get(i);
            result.addinvalidInfo(ResourceBase.getString((String)strResoure, (String)"0_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()) + personloan.getPerson().getNumber() + ResourceBase.getString((String)strResoure, (String)"4_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (col.size() > 0) {
            return result;
        }
        return null;
    }

    @Override
    protected BatchProcessedResult _isPersonFlucOut(Context ctx, String personIDs, String billID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIDs)) {
            return null;
        }
        String oql = "select id,person.id,person.number where person.id in " + this.getIdsSql(personIDs) + " and completeState in (" + 0 + "," + 2 + ")and isLoanBill=0";
        FluctuationInOutCollection col = FluctuationInOutFactory.getLocalInstance((Context)ctx).getFluctuationInOutCollection(oql);
        BatchProcessedResult result = new BatchProcessedResult();
        for (int i = 0; i < col.size(); ++i) {
            FluctuationInOutInfo flucInOutInfo = col.get(i);
            result.addinvalidInfo(ResourceBase.getString((String)strResoure, (String)"0_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()) + flucInOutInfo.getPerson().getNumber() + ResourceBase.getString((String)strResoure, (String)"11_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (col.size() > 0) {
            return result;
        }
        return null;
    }

    @Override
    protected BatchProcessedResult _isPersonLoanOut(Context ctx, String personIDs, String billID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIDs)) {
            return null;
        }
        String oql = "select id,person.id,person.number where person.id in " + this.getIdsSql(personIDs) + " and completeState in (" + 0 + "," + 2 + ")and isLoanBill=1";
        FluctuationInOutCollection col = FluctuationInOutFactory.getLocalInstance((Context)ctx).getFluctuationInOutCollection(oql);
        BatchProcessedResult result = new BatchProcessedResult();
        for (int i = 0; i < col.size(); ++i) {
            FluctuationInOutInfo flucInOutInfo = col.get(i);
            result.addinvalidInfo(ResourceBase.getString((String)strResoure, (String)"0_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()) + flucInOutInfo.getPerson().getNumber() + ResourceBase.getString((String)strResoure, (String)"12_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (col.size() > 0) {
            return result;
        }
        return null;
    }

    @Override
    protected BatchProcessedResult _checkIDCardNoAndPassportNoInEnroll(Context ctx, String IDCardNo, String passportNo, String billID) throws BOSException, EASBizException {
        HRAffairBizBillEntryCollection coll;
        BOSObjectType type = null;
        type = StringUtils.isEmpty((String)billID) ? new EmpEnrollBizBillInfo().getBOSType() : BOSUuid.read((String)billID).getType();
        IHRAffairBizBillEntry iEnrollEntry = EmpEnrollHelper.getEntryLocalInstance(ctx, type);
        BatchProcessedResult result1 = new BatchProcessedResult();
        BatchProcessedResult result2 = new BatchProcessedResult();
        String oql = null;
        if (!StringUtils.isEmpty((String)IDCardNo)) {
            oql = this.getOqlByCardNoInEnroll(ctx, IDCardNo, billID);
            coll = iEnrollEntry.getHRAffairBizBillEntryCollection(oql.toString());
            result1 = this.getProcessedResult(ctx, coll, IDCardNo, ResourceBase.getString((String)strResoure, (String)"5_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (!StringUtils.isEmpty((String)passportNo)) {
            passportNo = passportNo.trim();
            oql = this.getOqlByPassportNoInEnroll(passportNo, billID);
            coll = iEnrollEntry.getHRAffairBizBillEntryCollection(oql.toString());
            result2 = this.getProcessedResult(ctx, coll, passportNo, ResourceBase.getString((String)strResoure, (String)"8_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        result1.addinvalidInfo(result2.getInvalidInfo());
        return result1;
    }

    @Override
    protected BatchProcessedResult _checkPersonNumberInEnroll(Context ctx, String personNumber, String billID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)billID)) {
            return null;
        }
        BOSObjectType type = BOSUuid.read((String)billID).getType();
        IHRAffairBizBillEntry iEnrollEntry = EmpEnrollHelper.getEntryLocalInstance(ctx, type);
        BatchProcessedResult result = new BatchProcessedResult();
        if (!StringUtils.isEmpty((String)personNumber)) {
            personNumber = personNumber.trim();
            StringBuffer oql = new StringBuffer("select bill.number,id ");
            oql.append(this.getDupOqlInBillEntry("empNumber", billID, new String[]{personNumber}));
            HRAffairBizBillEntryCollection coll = iEnrollEntry.getHRAffairBizBillEntryCollection(oql.toString());
            result = this.getProcessedResult(ctx, coll, personNumber, ResourceBase.getString((String)strResoure, (String)"9_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return result;
    }

    private String getDupOqlInBillEntry(String field, String billID, String[] values) {
        if (StringUtils.isEmpty((String)field) || values == null || values.length <= 0) {
            return null;
        }
        String currDate = this.getCurrentDate();
        StringBuffer oql = new StringBuffer("where (");
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                oql.append(" or ");
            }
            oql.append(field);
            oql.append(" = '");
            oql.append(values[i]);
            oql.append("'");
        }
        oql.append(") ");
        if (!StringUtils.isEmpty((String)billID)) {
            oql.append(" and bill.id <> '");
            oql.append(billID);
            oql.append("' ");
        }
        oql.append(" and (");
        oql.append(" bill.billState = ");
        oql.append(0);
        oql.append(" or bill.billState = ");
        oql.append(1);
        oql.append(" or bill.billState = ");
        oql.append(2);
        oql.append(" or (bill.billState = ");
        oql.append(3);
        oql.append(" and bizDate >= ");
        oql.append(currDate);
        oql.append(" ))");
        return oql.toString();
    }

    private String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }

    private String getIdsSql(String ids) {
        String[] idarrs = ids.split(",");
        StringBuffer idsSql = new StringBuffer();
        boolean isfirst = true;
        idsSql.append("(");
        for (int i = 0; i < idarrs.length; ++i) {
            if (StringUtils.isEmpty((String)idarrs[i])) continue;
            if (!isfirst) {
                idsSql.append(",");
            }
            isfirst = false;
            idsSql.append("'");
            idsSql.append(idarrs[i]);
            idsSql.append("'");
        }
        idsSql.append(")");
        return idsSql.toString();
    }

    private boolean isCheckOldAffairBill(Context ctx) throws BOSException, EASBizException {
        return false;
    }

    private void isPersonInOldAffair(Context ctx, String personID, String billID) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _isUpgradeToBiz(Context ctx) throws BOSException, EASBizException {
        return AffairUpgradeFacadeFactory.getLocalInstance(ctx).isUpgrade();
    }

    private String getOqlByCardNoInEnroll(Context ctx, String IDCardNo, String billID) throws BOSException, EASBizException {
        String idCardNumber = IDCardNo.trim();
        String _idCardNumber = "";
        boolean isCheckIDCard18To15 = com.kingdee.eas.base.core.hr.util.HRParamUtil.getParamOfHR((Context)ctx, (String)"IsCheckIDCardNO18To15", null);
        _idCardNumber = !isCheckIDCard18To15 ? idCardNumber : (idCardNumber.length() == 15 ? IDCardCommonUtil.IDCardNO15To18((String)idCardNumber) : IDCardCommonUtil.IDCardNO18To15((String)idCardNumber));
        StringBuffer oql = new StringBuffer("select bill.number,id ");
        oql.append(this.getDupOqlInBillEntry("IDCardNo", billID, new String[]{idCardNumber, _idCardNumber}));
        return oql.toString();
    }

    private String getOqlByPassportNoInEnroll(String passportNo, String billID) throws BOSException, EASBizException {
        passportNo = passportNo.trim();
        StringBuffer oql = new StringBuffer("select bill.number,id ");
        oql.append(this.getDupOqlInBillEntry("passportNo", billID, new String[]{passportNo}));
        return oql.toString();
    }

    private BatchProcessedResult getProcessedResult(Context ctx, HRAffairBizBillEntryCollection coll, String cardNo, String msg) {
        BatchProcessedResult result = new BatchProcessedResult();
        if (coll != null) {
            String billNumber = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                billNumber = ((HRAffairBizBillInfo)coll.get(i).get("bill")).getNumber();
                result.addinvalidInfo(msg + cardNo + ResourceBase.getString((String)strResoure, (String)"6_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()) + billNumber + ResourceBase.getString((String)strResoure, (String)"7_AffairBizCheckFacadeControllerBean", (Locale)ctx.getLocale()));
            }
        }
        return result;
    }

    @Override
    protected boolean _isPersonsInSameHrOrg(Context ctx, String personIDs, boolean isPrimary) throws BOSException, EASBizException {
        if (!personIDs.contains(",")) {
            return true;
        }
        int assginType = isPrimary ? 1 : 0;
        StringBuilder sql = new StringBuilder("select count(1) as COUNT from (").append(" select bu.FHrOrgUnitId  from T_HR_EmpHRORelationHis bu ").append(" left join T_HR_EmpOrgRelation eor on bu.FEmpOrgRelationID = eor.FID ").append(" where bu.Fpersonid in ").append(this.getIdsSql(personIDs)).append(" and bu.FState = ").append(1).append(" and eor.FAssignType = ").append(assginType).append(" and bu.FBizManageTypeID = '").append(empManageTypeId).append("'").append(" group by bu.FHrOrgUnitId ) hrOrg");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            int count;
            if (rs.next() && (count = rs.getInt("COUNT")) > 1) {
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        return true;
    }

    @Override
    protected BatchProcessedResult _isPersonInAffairProcessByPlurality(Context ctx, String personIDs, String billID, Map validMap) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIDs)) {
            return null;
        }
        if (this.isCheckOldAffairBill(ctx)) {
            this.isPersonInOldAffair(ctx, personIDs, billID);
        }
        String currDate = this.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID ");
        oql.append("where person.id in ");
        oql.append(this.getIdsSql(personIDs));
        if (!StringUtils.isEmpty((String)billID)) {
            oql.append(" and billID <> '");
            oql.append(billID);
            oql.append("' ");
        }
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance(ctx).getHRAffairBizCollection(oql.toString());
        if (col != null && col.size() > 0) {
            BatchProcessedResult result = new BatchProcessedResult();
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (this.checkPrurality(ctx, bosType, billInfo) || !this.checkEmpPostRank(ctx, bosType, validMap)) continue;
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"not_allow_option", (Context)ctx);
                Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                message = MessageFormat.format(message, params);
                result.addinvalidInfo(message);
            }
            return result;
        }
        return null;
    }

    @Override
    protected BatchProcessedResult _isPersonInAffairProcessByFlucIn(Context ctx, String personIDs, String billIDs, Map validMap) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIDs)) {
            return null;
        }
        if (this.isCheckOldAffairBill(ctx)) {
            this.isPersonInOldAffair(ctx, personIDs, billIDs);
        }
        String currDate = this.getCurrentDate();
        String flucOutBillIds = (String)validMap.get("uncheckedBillId");
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID ");
        oql.append("where person.id in ");
        oql.append(this.getIdsSql(personIDs));
        if (!StringUtils.isEmpty((String)billIDs)) {
            oql.append(" and billID <> '");
            oql.append(billIDs);
            oql.append("' ");
        }
        if (!StringUtils.isEmpty((String)flucOutBillIds)) {
            oql.append(" and billID not in ");
            oql.append(this.getIdsSql(flucOutBillIds));
        }
        this.addNotCheckBosType(ctx, oql);
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance(ctx).getHRAffairBizCollection(oql.toString());
        if (col != null && col.size() > 0) {
            BatchProcessedResult result = new BatchProcessedResult();
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (!this.checkEmpPostRank(ctx, bosType, validMap)) continue;
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"not_allow_option", (Context)ctx);
                Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                message = MessageFormat.format(message, params);
                result.addinvalidInfo(message);
            }
            return result;
        }
        return null;
    }

    @Override
    protected BatchProcessedResult _isPersonInAffairProcessByPostRank(Context ctx, String personIds, String billId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIds)) {
            return null;
        }
        if (this.isCheckOldAffairBill(ctx)) {
            this.isPersonInOldAffair(ctx, personIds, billId);
        }
        String currDate = this.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID ");
        oql.append("where person.id in ");
        oql.append(this.getIdsSql(personIds));
        if (!StringUtils.isEmpty((String)billId)) {
            oql.append(" and billID <> '");
            oql.append(billId);
            oql.append("' ");
        }
        this.addNotCheckBosType(ctx, oql);
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance(ctx).getHRAffairBizCollection(oql.toString());
        if (col != null && col.size() > 0) {
            BatchProcessedResult result = new BatchProcessedResult();
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                String personId = bizInfo.getPerson().getId().toString();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (!EmpPostRankUtil.isPostRankChange((Context)ctx, (String)exsitBillId, (String)personId)) continue;
                String message = ResourceBase.getString((String)strResoure, (String)"label98", (Locale)ctx.getLocale());
                Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                message = MessageFormat.format(message, params);
                result.addinvalidInfo(message);
            }
            return result;
        }
        return null;
    }

    @Override
    protected BatchProcessedResult _isPersonInAffairProcessByPostRankNotChange(Context ctx, String personIds, String billId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIds)) {
            return null;
        }
        if (this.isCheckOldAffairBill(ctx)) {
            this.isPersonInOldAffair(ctx, personIds, billId);
        }
        String currDate = this.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID ");
        oql.append("where person.id in ");
        oql.append(this.getIdsSql(personIds));
        if (!StringUtils.isEmpty((String)billId)) {
            oql.append(" and billID <> '");
            oql.append(billId);
            oql.append("' ");
        }
        this.addNotCheckBosType(ctx, oql);
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance(ctx).getHRAffairBizCollection(oql.toString());
        if (col != null && col.size() > 0) {
            BatchProcessedResult result = new BatchProcessedResult();
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if ("C4D946DE".equals(bosType)) continue;
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"not_allow_option", (Context)ctx);
                Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                message = MessageFormat.format(message, params);
                result.addinvalidInfo(message);
            }
            return result;
        }
        return null;
    }

    private boolean checkEmpPostRank(Context ctx, String bosType, Map validMap) {
        if (validMap == null) {
            return true;
        }
        boolean isCheckPostRank = (Boolean)validMap.get("isCheckPostRankFlag");
        return isCheckPostRank || !"C4D946DE".equals(bosType);
    }

    private boolean checkPrurality(Context ctx, String bosType, HRAffairBizBillInfo billInfo) {
        if (bosType.equals(PLURALITYADD_BOSTYPE) || bosType.equals(PLURALITYDEL_BOSTYPE)) {
            IObjectCollection entrys = (IObjectCollection)billInfo.get("entrys");
            HRAffairBizBillEntryInfo entry = (HRAffairBizBillEntryInfo)entrys.getObject(0);
            if (entry == null) {
                return false;
            }
            HRBizDefineInfo hrBizDefine = (HRBizDefineInfo)entry.get("hrBizDefine");
            if (hrBizDefine != null && entry.getHrBizDefine().getId() != null) {
                if (hrBizDefine.getBizDefineType() == null) {
                    hrBizDefine = HRBizDefineAppUtils.getHRBizDefineInfo((Context)ctx, (String)entry.getHrBizDefine().getId().toString());
                }
                if (HRBizDefineTypeEnum.PLURALITY.getValue() == hrBizDefine.getBizDefineType().getValue()) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected BatchProcessedResult _isPersonInAffairProcessByResign(Context ctx, String personIDs, String billID, Map validMap, IObjectValue info) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIDs)) {
            return null;
        }
        if (this.isCheckOldAffairBill(ctx)) {
            this.isPersonInOldAffair(ctx, personIDs, billID);
        }
        String currDate = this.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID,entryBizDate ");
        oql.append("where person.id in ");
        oql.append(this.getIdsSql(personIDs));
        if (!StringUtils.isEmpty((String)billID)) {
            oql.append(" and billID <> '");
            oql.append(billID);
            oql.append("' ");
        }
        this.addNotCheckBosType(ctx, oql);
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance(ctx).getHRAffairBizCollection(oql.toString());
        if (col != null && col.size() > 0) {
            BatchProcessedResult result = new BatchProcessedResult();
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            HRBillBaseInfo resignInfo = (HRBillBaseInfo)info;
            IObjectCollection entries = (IObjectCollection)resignInfo.get("entrys");
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (!this.checkEmpHireAndFluc(ctx, bosType, billInfo)) {
                    if (!this.checkEmpPostRank(ctx, bosType, validMap)) continue;
                    String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"not_allow_option", (Context)ctx);
                    Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                    message = MessageFormat.format(message, params);
                    result.addinvalidInfo(message);
                    continue;
                }
                if (!this.checkEmpPostRank(ctx, bosType, validMap)) continue;
                int entrysize = entries.size();
                for (int j = 0; j < entrysize; ++j) {
                    ResignBizBillEntryInfo entry = (ResignBizBillEntryInfo)entries.getObject(j);
                    PersonInfo person = (PersonInfo)entry.get("person");
                    if (person == null || person.getId() == null || !person.getId().toString().equals(bizInfo.getPerson().getId().toString()) || DateTimeUtils.dayBefore((Date)bizInfo.getEntryBizDate(), (Date)this.getEffectDate(entry))) continue;
                    String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"not_allow_option", (Context)ctx);
                    Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                    message = MessageFormat.format(message, params);
                    result.addinvalidInfo(message);
                }
            }
            return result;
        }
        return null;
    }

    public boolean checkEmpHireAndFluc(Context ctx, String bosType, HRAffairBizBillInfo billInfo) {
        if (bosType.equals("B65CCEF1") || bosType.equals("C0DAD00D")) {
            IObjectCollection entrys = (IObjectCollection)billInfo.get("entrys");
            HRAffairBizBillEntryInfo entry = (HRAffairBizBillEntryInfo)entrys.getObject(0);
            return entry != null;
        }
        return false;
    }

    protected Date getEffectDate(HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        if (null != entry.getDate("leftCompanyDate") && null != entry.getDate("bizDate") && DateTimeUtils.dayEquals((Date)entry.getDate("bizDate"), (Date)entry.getDate("leftCompanyDate")) && !entry.getBoolean("isSameDatePersonChange")) {
            return DateTimeUtils.truncateDate((Date)HRUtil.getAftereDate((Date)entry.getDate("bizDate")));
        }
        Date effectDate = entry.getDate("bizDate");
        if (effectDate != null) {
            effectDate = DateTimeUtils.truncateDate((Date)effectDate);
        }
        return effectDate;
    }

    @Override
    protected BatchProcessedResult _isPersonInAffairProcessWithResign(Context ctx, String personIDs, String billID, Map validMap, IObjectValue info) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIDs)) {
            return null;
        }
        if (this.isCheckOldAffairBill(ctx)) {
            this.isPersonInOldAffair(ctx, personIDs, billID);
        }
        String currDate = this.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID,entryBizDate ");
        oql.append("where person.id in ");
        oql.append(this.getIdsSql(personIDs));
        if (!StringUtils.isEmpty((String)billID)) {
            oql.append(" and billID <> '");
            oql.append(billID);
            oql.append("' ");
        }
        this.addNotCheckBosType(ctx, oql);
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance(ctx).getHRAffairBizCollection(oql.toString());
        if (col != null && col.size() > 0) {
            BatchProcessedResult result = new BatchProcessedResult();
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            HRBillBaseInfo billBaseInfo = (HRBillBaseInfo)info;
            IObjectCollection entries = (IObjectCollection)billBaseInfo.get("entrys");
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (!"CC58A617".equals(bosType)) {
                    if (!this.checkEmpPostRank(ctx, bosType, validMap)) continue;
                    String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"not_allow_option", (Context)ctx);
                    Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                    message = MessageFormat.format(message, params);
                    result.addinvalidInfo(message);
                    continue;
                }
                if (!this.checkEmpPostRank(ctx, bosType, validMap)) continue;
                int entrysize = entries.size();
                for (int j = 0; j < entrysize; ++j) {
                    HRBillBaseEntryInfo entry = (HRBillBaseEntryInfo)entries.getObject(j);
                    PersonInfo person = (PersonInfo)entry.get("person");
                    if (person == null || person.getId() == null || !person.getId().toString().equals(bizInfo.getPerson().getId().toString()) || DateTimeUtils.dayAfter((Date)bizInfo.getEntryBizDate(), (Date)this.getEffectDate(entry))) continue;
                    String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"not_allow_option", (Context)ctx);
                    Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                    message = MessageFormat.format(message, params);
                    result.addinvalidInfo(message);
                }
            }
            return result;
        }
        return null;
    }
}

