/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.app.AbstractAffairHistoryControllerBean;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AffairHistoryControllerBean
extends AbstractAffairHistoryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpCollectFacadeControllerBean");

    @Override
    protected IRowSet _getFluctuationInOutRows(Context ctx, Date beginDate, Date endDate, String longNumber, boolean isIncludeSubCUs, Map params) throws BOSException, EASBizException {
        return this.getDataRows(ctx, beginDate, endDate, longNumber, isIncludeSubCUs, params);
    }

    @Override
    protected IRowSet _getOtherInOutRows(Context ctx, Date beginDate, Date endDate, String longNumber, boolean isIncludeSubCUs) throws BOSException, EASBizException {
        return DbUtil.executeQuery((Context)ctx, (String)this.getOtherSql(ctx, longNumber, isIncludeSubCUs), (Object[])this.getParams(ctx, beginDate, endDate, longNumber));
    }

    private String getCULongNumber(Context ctx) {
        return ContextUtil.getCurrentCtrlUnit((Context)ctx).getLongNumber();
    }

    private String getCUId(Context ctx) {
        return ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
    }

    private Object[] getFluctuationParam(String fluctuationTypeId, Date beginDate, Date endDate) {
        Timestamp _beginDate = new Timestamp(beginDate.getTime());
        Timestamp _endDate = new Timestamp(endDate.getTime());
        return new Object[]{_beginDate, _endDate, fluctuationTypeId, _beginDate, _endDate, fluctuationTypeId};
    }

    private Object[] getOtherParam(int type, Date beginDate, Date endDate) {
        Timestamp _beginDate = new Timestamp(beginDate.getTime());
        Timestamp _endDate = new Timestamp(endDate.getTime());
        if (type != -1) {
            return new Object[]{_beginDate, _endDate, type, _beginDate, _endDate, type};
        }
        return new Object[]{_beginDate, _endDate, _beginDate, _endDate};
    }

    private void logParam(Object[] param) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < param.length; ++i) {
            sb.append(param[i]);
            sb.append("\n");
        }
        logger.debug((Object)sb.toString());
    }

    private String getOtherSqlByAffairType(boolean isTypeNull, String longNumber) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tSELECT ISNULL(SUM(FIN),0) AS FIN, ISNULL(SUM(FOUT),0) AS FOUT \n");
        sb.append("\t\tFROM  \n");
        sb.append("\t\t(SELECT ISNULL(CASE WHEN new_lnum || '!' LIKE '" + longNumber + "!%' AND \n");
        sb.append("\t\t      old_lnum || '!' LIKE '" + longNumber + "!%' THEN 0 WHEN new_lnum || '!' LIKE '" + longNumber + "!%' AND \n");
        sb.append("\t\t      old_lnum || '!' NOT LIKE '" + longNumber + "!%' THEN 1 END, 0) AS FIN , 0 AS FOUT \n");
        sb.append("\t\tFROM V_HR_AffairHistory \n");
        sb.append("\t\tWHERE (FAffairType <> 2) AND (FAffairType <> 1) AND (FAffairDate >= ?)  AND (FAffairDate <= ?) \n");
        if (isTypeNull) {
            sb.append("\t AND (FAffairType IS NULL)");
        } else {
            sb.append("\t AND (FAffairType = ?)");
        }
        sb.append("\t\tUNION ALL \n");
        sb.append("\t\tSELECT 0 AS FIN,  ISNULL(CASE WHEN old_lnum || '!' LIKE '" + longNumber + "!%' AND \n");
        sb.append("\t\t      new_lnum || '!' LIKE '" + longNumber + "!%' THEN 0 WHEN old_lnum || '!' LIKE '" + longNumber + "!%' AND  \n");
        sb.append("\t\t      new_lnum || '!' NOT LIKE '" + longNumber + "!%' THEN 1 END, 0) AS FOUT \n");
        sb.append("\t\tFROM V_HR_AffairHistory \n");
        sb.append("\t\tWHERE (FAffairType <> 2) AND (FAffairType <> 1) AND (FAffairDate >= ?)  AND (FAffairDate <= ?) \n");
        if (isTypeNull) {
            sb.append("\t AND (FAffairType IS NULL)");
        } else {
            sb.append("\t AND (FAffairType = ?)");
        }
        sb.append("\t\t) A \n");
        logger.debug((Object)sb.toString());
        return sb.toString();
    }

    private String getFluctuationSql(String longNumber) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tSELECT ISNULL(SUM(FIN),0) AS FIN, ISNULL(SUM(FOUT),0) AS FOUT \n");
        sb.append("\t\tFROM  \n");
        sb.append("\t\t(SELECT ISNULL(CASE WHEN new_lnum || '!' LIKE '" + longNumber + "!%' AND \n");
        sb.append("\t\t      old_lnum || '!' LIKE '" + longNumber + "!%' THEN 0 WHEN new_lnum || '!' LIKE '" + longNumber + "!%' AND \n");
        sb.append("\t\t      old_lnum || '!' NOT LIKE '" + longNumber + "!%' THEN 1 END, 0) AS FIN , 0 AS FOUT \n");
        sb.append("\t\tFROM V_HR_AffairHistory \n");
        sb.append("\t\tWHERE (FAffairType = 2) AND (FAffairDate >= ?)  AND (FAffairDate <= ?) AND (FFluctuationTypeID = ?) \n");
        sb.append("\t\tUNION ALL \n");
        sb.append("\t\tSELECT 0 AS FIN,  ISNULL(CASE WHEN old_lnum || '!' LIKE '" + longNumber + "!%' AND \n");
        sb.append("\t\t      new_lnum || '!' LIKE '" + longNumber + "!%' THEN 0 WHEN old_lnum || '!' LIKE '" + longNumber + "!%' AND  \n");
        sb.append("\t\t      new_lnum || '!' NOT LIKE '" + longNumber + "!%' THEN 1 END, 0) AS FOUT \n");
        sb.append("\t\tFROM V_HR_AffairHistory \n");
        sb.append("\t\tWHERE (FAffairType = 2) AND (FAffairDate >= ?)  AND (FAffairDate <= ?) AND (FFluctuationTypeID = ?) \n");
        sb.append("\t\t) A \n");
        logger.debug((Object)sb.toString());
        return sb.toString();
    }

    private ArrayList getFluctuationList(Context ctx, String longNumber, boolean isIncludeSubCUs, Date beginDate, Date endDate) throws BOSException {
        ArrayList list = new ArrayList();
        IRowSet rows = this.getFluctuationRows(ctx, longNumber, isIncludeSubCUs);
        String sql = null;
        IRowSet data = null;
        Object[] param = null;
        String longNum = null;
        String typeId = null;
        HashMap<String, Object> map = null;
        try {
            while (rows.next()) {
                longNum = rows.getString("FLongNumber");
                typeId = rows.getString("FTypeID");
                sql = this.getFluctuationSql(longNum);
                map = new HashMap<String, Object>();
                map.put("FLongNumber", longNum);
                map.put("FLevel", rows.getInt("FLevel"));
                map.put("FIsLeaf", rows.getBoolean("FIsLeaf"));
                map.put("FAdminOrgID", rows.getString("FAdminOrgID"));
                map.put("FOrgName", rows.getString("FOrgName"));
                map.put("FTypeID", rows.getString("FTypeID"));
                map.put("FTypeName", rows.getString("FTypeName"));
                map.put("FIndex", rows.getInt("FIndex"));
                param = this.getFluctuationParam(typeId, beginDate, endDate);
                this.logParam(param);
                data = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
                if (data.next()) {
                    map.put("FOUT", data.getInt("FOUT"));
                    map.put("FIN", data.getInt("FIN"));
                }
                list.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private ArrayList getOtherList(Context ctx, String longNumber, boolean isIncludeSubCUs, Date beginDate, Date endDate) throws BOSException {
        ArrayList list = new ArrayList();
        IRowSet rows = this.getOtherRows(ctx, longNumber, isIncludeSubCUs);
        String sqlTypeNotNull = this.getOtherSqlByAffairType(false, longNumber);
        logger.debug((Object)("sqlTypeNotNull : \n" + sqlTypeNotNull));
        String sqlTypeNull = this.getOtherSqlByAffairType(true, longNumber);
        logger.debug((Object)("sqlTypeNull : \n" + sqlTypeNull));
        IRowSet data = null;
        Object[] param = null;
        String longNum = "";
        int type = -1;
        HashMap<String, Object> map = null;
        try {
            while (rows.next()) {
                longNum = rows.getString("FLongNumber");
                sqlTypeNotNull = this.getOtherSqlByAffairType(false, longNum);
                sqlTypeNull = this.getOtherSqlByAffairType(true, longNum);
                type = rows.getInt("FAffairType");
                map = new HashMap<String, Object>();
                map.put("FLongNumber", longNum);
                map.put("FAdminOrgID", rows.getString("FAdminOrgID"));
                map.put("FOrgName", rows.getString("FOrgName"));
                map.put("FAffairType", type);
                map.put("FIndex", rows.getInt("FIndex"));
                param = this.getOtherParam(type, beginDate, endDate);
                this.logParam(param);
                data = DbUtil.executeQuery((Context)ctx, (String)(type == -1 ? sqlTypeNull : sqlTypeNotNull), (Object[])param);
                if (data.next()) {
                    map.put("FIN", data.getInt("FIN"));
                    map.put("FOUT", data.getInt("FOUT"));
                }
                list.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private IRowSet getOtherRows(Context ctx, String[] longNumbers) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT B.FLongNumber, B.FIndex, B.FAdminOrgID, B.FOrgName, H.FAffairType  \n");
        sb.append("   FROM (SELECT FLongNumber, FIndex, FLevel, FIsLeaf, FId AS FAdminOrgID, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FOrgName FROM T_ORG_Admin WHERE FLongNumber IN (");
        sb.append(this.getNumStrByArray(longNumbers));
        sb.append("))  \n");
        sb.append(" \t\tB, (SELECT DISTINCT ISNULL(FAffairType, -1) AS FAffairType FROM T_HR_AffairHistory WHERE FAffairType <> 1 and FAffairType <> 2) H \n");
        logger.debug((Object)sb.toString());
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    private IRowSet getOtherRows(Context ctx, String longNumber, boolean isIncludeSubCUs) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT B.FLongNumber, B.FIndex, B.FAdminOrgID, B.FOrgName, H.FAffairType  \n");
        sb.append("   FROM (SELECT FLongNumber, FIndex, FLevel, FIsLeaf, FId AS FAdminOrgID, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FOrgName FROM T_ORG_Admin WHERE FLongNumber || '!'  like ? AND FControlUnitID IN  \n");
        if (isIncludeSubCUs) {
            sb.append(" \t\t(SELECT FControlUnitID FROM T_Org_CtrlUnit Where FLongNumber || '!' like ?) \n");
        } else {
            sb.append(" \t\t(SELECT FControlUnitID FROM T_Org_CtrlUnit Where FLongNumber = ?)) \n");
        }
        sb.append(" \t\tB, (SELECT DISTINCT ISNULL(FAffairType, -1) AS FAffairType FROM T_HR_AffairHistory WHERE FAffairType <> 1 and FAffairType <> 2) H \n");
        sb.append("ORDER BY B.FLongNumber, B.FIndex \n");
        Object[] param = null;
        param = isIncludeSubCUs ? new Object[]{longNumber + "!%", this.getCULongNumberByLongNumber(ctx, longNumber) + "!%"} : new Object[]{longNumber + "!%", this.getCULongNumberByLongNumber(ctx, longNumber)};
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
    }

    private String getCULongNumberByLongNumber(Context ctx, String longNumber) throws BOSException {
        String value = longNumber;
        String sql = "SELECT FLongNumber FROM T_Org_CtrlUnit WHERE FID IN (SELECT FControlUnitID FROM T_ORG_ADMIN WHERE FLongNumber = ?)";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{longNumber});
        try {
            if (rows.next()) {
                value = rows.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return value;
    }

    private String getNumStrByArray(String[] longNumbers) {
        if (longNumbers.length == 0) {
            return "''";
        }
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < longNumbers.length; ++i) {
            if (i == 0) {
                sb.append("'");
                sb.append(longNumbers[i]);
                sb.append("'");
                continue;
            }
            sb.append(", '");
            sb.append(longNumbers[i]);
            sb.append("'");
        }
        return sb.toString();
    }

    private IRowSet getFlucRows(Context ctx, String[] longNumbers) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT B.FLongNumber, B.FLevel, B.FIsLeaf, B.FAdminOrgID, B.FOrgName,  \n");
        sb.append("\t              FT.FID AS FTypeID, FT.FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FTypeName, B.FIndex  \n");
        sb.append("        FROM (SELECT FLongNumber, FIndex, FLevel, FIsLeaf, FId AS FAdminOrgID, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FOrgName FROM T_ORG_Admin WHERE FLongNumber in (");
        sb.append(this.getNumStrByArray(longNumbers));
        sb.append(")) ");
        sb.append(" \t\tB, T_HR_BDFluctuationType FT \n");
        sb.append("        WHERE \n");
        sb.append("              (FT.FID IN ('00000000-0000-0000-0000-0000000000032AD8998F',  \n");
        sb.append("              '00000000-0000-0000-0000-0000000000042AD8998F',  \n");
        sb.append("              '00000000-0000-0000-0000-0000000000062AD8998F'))\n");
        sb.append("ORDER BY B.FLongNumber, B.FIndex \n");
        logger.debug((Object)sb.toString());
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    private IRowSet getFluctuationRows(Context ctx, String longNumber, boolean isIncludeSubCUs) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT B.FLongNumber, B.FLevel, B.FIsLeaf, B.FAdminOrgID, B.FOrgName,  \n");
        sb.append("\t              FT.FID AS FTypeID, FT.FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FTypeName, B.FIndex  \n");
        sb.append("        FROM (SELECT FLongNumber, FIndex, FLevel, FIsLeaf, FId AS FAdminOrgID, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FOrgName FROM T_ORG_Admin WHERE FLongNumber || '!' like ? AND FControlUnitID IN  \n");
        if (isIncludeSubCUs) {
            sb.append(" \t\t(SELECT FControlUnitID FROM T_Org_CtrlUnit Where FLongNumber || '!' like ?) \n");
        } else {
            sb.append(" \t\t(SELECT FControlUnitID FROM T_Org_CtrlUnit Where FLongNumber = ?)) \n");
        }
        sb.append(" \t\tB, T_HR_BDFluctuationType FT \n");
        sb.append("        WHERE \n");
        sb.append("              (FT.FID IN ('00000000-0000-0000-0000-0000000000032AD8998F',  \n");
        sb.append("              '00000000-0000-0000-0000-0000000000042AD8998F',  \n");
        sb.append("              '00000000-0000-0000-0000-0000000000062AD8998F'))\n");
        sb.append("ORDER BY B.FLongNumber, B.FIndex \n");
        logger.debug((Object)sb.toString());
        Object[] param = null;
        param = isIncludeSubCUs ? new Object[]{longNumber + "!%", this.getCULongNumberByLongNumber(ctx, longNumber) + "!%"} : new Object[]{longNumber + "!%", this.getCULongNumberByLongNumber(ctx, longNumber)};
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
    }

    private String getLangSuffix(Context ctx) {
        return "_" + ctx.getLocale().toString();
    }

    private String getOtherSql(Context ctx, String longNumber, boolean isIncludeSubCUs) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tSELECT X.FLongNumber, X.FAdminOrgID, X.FOrgName, ISNULL(B.FAffairType, -1)   \n");
        sb.append("\t      AS FAffairType, ISNULL(B.FIN, 0) AS FIN, ISNULL(B.FOUT, 0) AS FOUT  \n");
        sb.append("\tFROM (SELECT FLongNumber, FIndex,  FId AS FAdminOrgID, FName");
        sb.append(this.getLangSuffix(ctx));
        sb.append(" AS FOrgName  \n");
        sb.append("\t        FROM T_Org_Admin WHERE FControlUnitID IN \n");
        if (isIncludeSubCUs) {
            sb.append("\t\t\t(SELECT FControlUnitID FROM T_Org_CtrlUnit Where FLongNumber || '!' like ? || '!%')) \n");
        } else {
            sb.append("\t\t\t(SELECT FControlUnitID FROM T_Org_CtrlUnit Where FLongNumber = ?)) \n");
        }
        sb.append("\t\t\t\tX LEFT OUTER JOIN  \n");
        sb.append("          (SELECT FLONGNUMBER, SUM(FOUT) AS FOUT, SUM(FIN) AS FIN,  \n");
        sb.append("               FAffairType \n");
        sb.append("         FROM (SELECT S.FLongNumber, FAffairType, SUM(FOUT) AS FOUT, SUM(FIN)  \n");
        sb.append("                       AS FIN \n");
        sb.append("                 FROM (SELECT FLongNumber, FAffairType, 0 AS Fout,  \n");
        sb.append("\t                      ISNULL(CASE  \n");
        sb.append("\t\t\t\tWHEN new_lnum || '!' LIKE FLONGNUMBER || '!%' AND old_lnum || '!' LIKE FLONGNUMBER || '!%' THEN 0  \n");
        sb.append("\t\t\t\tWHEN new_lnum || '!' LIKE FLONGNUMBER || '!%' AND old_lnum || '!' NOT LIKE FLONGNUMBER || '!%' THEN 1  \n");
        sb.append("\t\t\t\tWHEN new_lnum || '!' LIKE FLONGNUMBER || '!%' AND old_lnum IS NULL THEN 1  \n");
        sb.append("\t\t\t\tEND, 0) AS FIN \n");
        sb.append("                         FROM (SELECT OldAdmin.FLongNumber AS Old_LNum,  \n");
        sb.append("                                       NewAdmin.FLongNumber AS New_LNum,  \n");
        sb.append("                                       Af.FAffairType, Af.FAffairDate,  \n");
        sb.append("                                       Af.FFluctuationTypeID \n");
        sb.append("                                 FROM T_HR_AffairHistory Af LEFT OUTER JOIN \n");
        sb.append("                                       T_ORG_Admin NewAdmin ON  \n");
        sb.append("                                       Af.FNewDeptID = NewAdmin.FID LEFT OUTER JOIN \n");
        sb.append("                                       T_ORG_Admin OldAdmin ON  \n");
        sb.append("                                       Af.FOldDeptID = OldAdmin.FID \n");
        sb.append("                                 WHERE FAffairDate >= ? AND  \n");
        sb.append("                                       FAffairDate <= ? AND FAffairType <> 2 AND FAffairType <> 1  \n");
        if (longNumber != null && longNumber.trim().length() > 0) {
            sb.append("\t\t\t\t\tAND (OldAdmin.FLongNumber || '!' like ? || '!%' or NewAdmin.FLongNumber || '!' like ? || '!%') \n");
        }
        sb.append("\t\t\t\t\t) Af, T_Org_Admin St \n");
        sb.append("                         WHERE Af.new_lnum IS NOT NULL) A, T_Org_Admin S \n");
        sb.append("                 WHERE S.FLongNumber || '!' LIKE A.FLongNumber || '!' \n");
        sb.append("                 GROUP BY S.FLongNumber, FAffairType \n");
        sb.append("                 UNION ALL \n");
        sb.append("                 SELECT S.FLongNumber, FAffairType, SUM(FOUT) AS FOUT, SUM(FIN)  \n");
        sb.append("                       AS FIN \n");
        sb.append("                 FROM (SELECT FLongNumber, FAffairType,  \n");
        sb.append("\t                      ISNULL(CASE  \n");
        sb.append("\t\t\t\tWHEN old_lnum || '!' LIKE FLONGNUMBER || '!%' AND new_lnum || '!' LIKE FLONGNUMBER || '!%' THEN 0  \n");
        sb.append("\t\t\t\tWHEN old_lnum || '!' LIKE FLONGNUMBER || '!%' AND new_lnum || '!' NOT LIKE FLONGNUMBER || '!%' THEN 1  \n");
        sb.append("\t\t\t\tWHEN old_lnum || '!' LIKE FLONGNUMBER || '!%' AND new_lnum IS NULL THEN 1  \n");
        sb.append("\t\t\t\tEND, 0) AS FOUT, 0 AS FIN \n");
        sb.append("                         FROM (SELECT OldAdmin.FLongNumber AS Old_LNum,  \n");
        sb.append("                                       NewAdmin.FLongNumber AS New_LNum,  \n");
        sb.append("                                       Af.FAffairType, Af.FAffairDate,  \n");
        sb.append("                                       Af.FFluctuationTypeID \n");
        sb.append("                                 FROM T_HR_AffairHistory Af LEFT OUTER JOIN \n");
        sb.append("                                       T_ORG_Admin NewAdmin ON  \n");
        sb.append("                                       Af.FNewDeptID = NewAdmin.FID LEFT OUTER JOIN \n");
        sb.append("                                       T_ORG_Admin OldAdmin ON  \n");
        sb.append("                                       Af.FOldDeptID = OldAdmin.FID \n");
        sb.append("                                 WHERE FAffairDate >= ? AND  \n");
        sb.append("                                       FAffairDate <= ? AND FAffairType <> 2 AND FAffairType <> 1  \n");
        if (longNumber != null && longNumber.trim().length() > 0) {
            sb.append("\t\t\t\t\tAND (OldAdmin.FLongNumber || '!' like ? || '!%' or NewAdmin.FLongNumber || '!' like ? || '!%') \n");
        }
        sb.append("\t\t\t\t\t) Af, T_Org_Admin St \n");
        sb.append("                         WHERE Af.new_lnum IS NOT NULL) A, T_Org_Admin S \n");
        sb.append("                 WHERE S.FLongNumber || '!' LIKE A.FLongNumber || '!' \n");
        sb.append("                 GROUP BY S.FLongNumber, FAffairType) A \n");
        sb.append("         GROUP BY FLONGNUMBER, FAffairType) B ON X.FLongNumber = B.FLongNumber \n");
        if (longNumber != null && longNumber.trim().length() > 0) {
            sb.append("\tWHERE (X.FLongNumber || '!' LIKE ? || '!%') \n");
        }
        sb.append("ORDER BY X.FLongNumber, X.FIndex \n");
        logger.debug((Object)"\n getOtherSql : begin \n");
        logger.debug((Object)sb.toString());
        logger.debug((Object)"\n getOtherSql : end \n");
        return sb.toString();
    }

    private Object[] getParams(Context ctx, Date beginDate, Date endDate, String longNumber) {
        Timestamp _beginDate = new Timestamp(beginDate.getTime());
        Timestamp _endDate = new Timestamp(endDate.getTime());
        Object[] param = null;
        param = longNumber != null && longNumber.trim().length() > 0 ? new Object[]{this.getCULongNumber(ctx), _beginDate, _endDate, longNumber, longNumber, _beginDate, _endDate, longNumber, longNumber, longNumber} : new Object[]{this.getCULongNumber(ctx), _beginDate, _endDate, _beginDate, _endDate};
        logger.debug((Object)"\n param begin :");
        for (int i = 0; i < param.length; ++i) {
            logger.debug((Object)("\n" + i + ":" + param[i]));
        }
        logger.debug((Object)"\n param end");
        return param;
    }

    @Override
    protected ArrayList _getFluctuationList(Context ctx, Date beginDate, Date endDate, String longNumber, boolean isIncludeSubCUs) throws BOSException, EASBizException {
        return this.getFluctuationList(ctx, longNumber, isIncludeSubCUs, beginDate, endDate);
    }

    @Override
    protected ArrayList _getOtherList(Context ctx, Date beginDate, Date endDate, String longNumber, boolean isIncludeSubCUs) throws BOSException, EASBizException {
        return this.getOtherList(ctx, longNumber, isIncludeSubCUs, beginDate, endDate);
    }

    @Override
    protected ArrayList _getFluctList(Context ctx, Date beginDate, Date endDate, String[] longNumbers) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        IRowSet rows = this.getFlucRows(ctx, longNumbers);
        String sql = null;
        IRowSet data = null;
        Object[] param = null;
        String longNum = null;
        String typeId = null;
        HashMap<String, Object> map = null;
        try {
            while (rows.next()) {
                longNum = rows.getString("FLongNumber");
                typeId = rows.getString("FTypeID");
                sql = this.getFluctuationSql(longNum);
                map = new HashMap<String, Object>();
                map.put("FLongNumber", longNum);
                map.put("FLevel", rows.getInt("FLevel"));
                map.put("FIsLeaf", rows.getBoolean("FIsLeaf"));
                map.put("FAdminOrgID", rows.getString("FAdminOrgID"));
                map.put("FOrgName", rows.getString("FOrgName"));
                map.put("FTypeID", rows.getString("FTypeID"));
                map.put("FTypeName", rows.getString("FTypeName"));
                map.put("FIndex", rows.getInt("FIndex"));
                param = this.getFluctuationParam(typeId, beginDate, endDate);
                this.logParam(param);
                data = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
                if (data.next()) {
                    map.put("FOUT", data.getInt("FOUT"));
                    map.put("FIN", data.getInt("FIN"));
                }
                list.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    @Override
    protected ArrayList _getOtherList(Context ctx, Date beginDate, Date endDate, String[] longNumbers) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        IRowSet rows = this.getOtherRows(ctx, longNumbers);
        String sqlTypeNotNull = null;
        String sqlTypeNull = null;
        IRowSet data = null;
        Object[] param = null;
        String longNum = "";
        int type = -1;
        HashMap<String, Object> map = null;
        try {
            while (rows.next()) {
                longNum = rows.getString("FLongNumber");
                sqlTypeNotNull = this.getOtherSqlByAffairType(false, longNum);
                logger.debug((Object)("sqlTypeNotNull : \n" + sqlTypeNotNull));
                sqlTypeNull = this.getOtherSqlByAffairType(true, longNum);
                logger.debug((Object)("sqlTypeNull : \n" + sqlTypeNull));
                type = rows.getInt("FAffairType");
                map = new HashMap<String, Object>();
                map.put("FLongNumber", longNum);
                map.put("FAdminOrgID", rows.getString("FAdminOrgID"));
                map.put("FOrgName", rows.getString("FOrgName"));
                map.put("FAffairType", type);
                map.put("FIndex", rows.getInt("FIndex"));
                param = this.getOtherParam(type, beginDate, endDate);
                this.logParam(param);
                data = DbUtil.executeQuery((Context)ctx, (String)(type == -1 ? sqlTypeNull : sqlTypeNotNull), (Object[])param);
                if (data.next()) {
                    map.put("FIN", data.getInt("FIN"));
                    map.put("FOUT", data.getInt("FOUT"));
                }
                list.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    protected IRowSet getDataRows(Context ctx, Date beginDate, Date endDate, String longNumber, boolean isIncludeSub, Map params) throws BOSException, EASBizException {
        int whereIndex;
        String evStr;
        StringBuffer sb = new StringBuffer();
        String tempTable = null;
        EntityViewInfo evInfo = (EntityViewInfo)params.get("EntityViewInfo");
        if (evInfo != null && (evStr = evInfo.toString()) != null && (whereIndex = evStr.indexOf("WHERE")) >= 0) {
            tempTable = this.createEmpFlowTempTable(ctx, params);
        }
        boolean isMultOrg = Boolean.valueOf(true).equals(params.get("isMultOrgs"));
        Object[] adminOrgs = (Object[])params.get("adminOrgs");
        if (isMultOrg) {
            longNumber = null;
        }
        sb.append("SELECT FLongNumber, FAffairType, fFluctuationTypeId , Count(*) AS count,  -1 AS TYPE  \n");
        sb.append("FROM   \n");
        sb.append("(SELECT B.FLongNumber,   \n");
        sb.append("ISNULL(Old_Lnum, '_') OLD_LNUM, ISNULL(New_Lnum, '_') NEW_LNUM, FAffairType, fFluctuationTypeId \n");
        sb.append("FROM v_hr_affairhistory   \n");
        sb.append("left outer JOIN T_ORG_ADMIN B ON CHARINDEX(b.flongnumber || '!', ISNULL(Old_Lnum, '_') || '!') = 1  \n");
        sb.append("WHERE CHARINDEX(b.flongnumber || '!', ISNULL(NEW_Lnum, '_') || '!') = 0  \n");
        sb.append("and FAffairDate >= ? and FAffairDate <= ?  \n");
        if (longNumber != null) {
            if (isIncludeSub) {
                sb.append("and B.FLongNumber like ?  \n");
            } else {
                sb.append("and B.FLongNumber = ?  \n");
            }
        }
        if (isMultOrg) {
            if (isIncludeSub) {
                sb.append("and ");
                sb.append(OrgStringUtil.getOrgsSqlIncludeChild((String)"B.FID", (String)"B.FLongNumber", (Object[])adminOrgs));
            } else {
                sb.append("and B.FID in ( " + OrgStringUtil.getOrgIdsSql((Object[])adminOrgs) + " ) \n");
            }
        }
        if (tempTable != null) {
            this.addTempTableFilter(tempTable, sb);
        }
        sb.append(") A \n");
        sb.append("group by FLongNumber, FAffairType,fFluctuationTypeId  \n");
        sb.append("union  \n");
        sb.append("SELECT FLongNumber, FAffairType,fFluctuationTypeId , Count(*) AS count,  1 AS TYPE  \n");
        sb.append("FROM   \n");
        sb.append("(SELECT B.FLongNumber,   \n");
        sb.append("ISNULL(Old_Lnum, '_') OLD_LNUM, ISNULL(New_Lnum, '_') NEW_LNUM, FAffairType, fFluctuationTypeId  \n");
        sb.append("FROM v_hr_affairhistory   \n");
        sb.append("left outer JOIN T_ORG_ADMIN B ON CHARINDEX(b.flongnumber || '!', ISNULL(NEW_Lnum, '_') || '!') = 1  \n");
        sb.append("WHERE CHARINDEX(b.flongnumber || '!', ISNULL(OLD_Lnum, '_') || '!') = 0  \n");
        sb.append("and FAffairDate >= ? and FAffairDate <= ?  \n");
        if (longNumber != null) {
            if (isIncludeSub) {
                sb.append("and B.FLongNumber like ?  \n");
            } else {
                sb.append("and B.FLongNumber = ?  \n");
            }
        }
        if (isMultOrg) {
            if (isIncludeSub) {
                sb.append("and ");
                sb.append(OrgStringUtil.getOrgsSqlIncludeChild((String)"B.FID", (String)"B.FLongNumber", (Object[])adminOrgs));
            } else {
                sb.append("and B.FID in ( " + OrgStringUtil.getOrgIdsSql((Object[])adminOrgs) + " ) \n");
            }
        }
        if (tempTable != null) {
            this.addTempTableFilter(tempTable, sb);
        }
        sb.append(") A \n");
        sb.append("group by FLongNumber, FAffairType,fFluctuationTypeId  \n");
        sb.append("order by FLongNumber, FAffairType,fFluctuationTypeId  \n");
        sb.append("  \n");
        logger.debug((Object)("getDataRows sql : \n" + sb.toString()));
        Timestamp _beginDate = new Timestamp(beginDate.getTime());
        Timestamp _endDate = new Timestamp(endDate.getTime());
        IRowSet rows = null;
        rows = longNumber != null ? (isIncludeSub ? DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{_beginDate, _endDate, longNumber + "%", _beginDate, _endDate, longNumber + "%"}) : DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{_beginDate, _endDate, longNumber, _beginDate, _endDate, longNumber})) : DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{_beginDate, _endDate, _beginDate, _endDate});
        return rows;
    }

    private String createEmpFlowTempTable(Context ctx, Map params) throws BOSException {
        String tempTable = null;
        Connection conn = null;
        PreparedStatement ps = null;
        Object sql = null;
        IMetaDataPK queryPK = (IMetaDataPK)params.get("QueryPK");
        EntityViewInfo evInfo = (EntityViewInfo)params.get("EntityViewInfo");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(evInfo);
        StringBuffer buf = new StringBuffer(" SELECT T.ID FROM (");
        String sqlQuery = queryExcu.getSQL();
        if (StringUtils.indexOfIgnoreCase((String)sqlQuery, (String)"ORDER BY") > 0) {
            sqlQuery = sqlQuery.substring(0, StringUtils.indexOfIgnoreCase((String)sqlQuery, (String)"ORDER BY"));
        }
        String tmpStr = sqlQuery.substring(sqlQuery.indexOf("FROM"), sqlQuery.length());
        String endSql = " SELECT \"PERSON\".FID \"ID\" " + tmpStr;
        String optSql = null;
        try {
            optSql = KSqlUtil.optimize((String)endSql);
        }
        catch (SqlTranslateException e1) {
            throw new BOSException((Throwable)e1);
        }
        buf.append(optSql);
        buf.append(") AS T");
        String createSql = "create table t_temp_tempempflow(fid varchar(44) not null)";
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createSql);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        String insertSql = "insert into " + tempTable + buf.toString();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(insertSql);
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return tempTable;
    }

    private void addTempTableFilter(String tempTable, StringBuffer sql) throws BOSException, EASBizException {
        if (tempTable != null && tempTable.length() > 0) {
            sql.append(" AND FPERSONID IN ( SELECT FID FROM ");
            sql.append(tempTable);
            sql.append(") ");
        }
    }
}

