/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.permission.ISecurity;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.SecurityCollection;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRoleOrgCollection;
import com.kingdee.eas.base.permission.UserRoleOrgInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.util.UserInfoHelper;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.ResignBackBizBillEntryInfo;
import com.kingdee.eas.hr.base.util.HrUserPermTranserHelper;
import com.kingdee.eas.hr.rec.util.DateUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.util.Date;
import java.util.Locale;

public class AffairUserHelper {
    public void opeateAutoCreateUser(Context ctx, ResignBackBizBillEntryInfo einfo, PersonInfo pInfo) throws EASBizException, BOSException {
        boolean isAutoUser = false;
        isAutoUser = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_Auto_User", null);
        if (isAutoUser) {
            this.autoCreateUser(ctx, pInfo, einfo);
        }
    }

    private void autoCreateUser(Context ctx, PersonInfo pInfo, ResignBackBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        UserInfo userInfo = null;
        boolean isNumberRepeat = false;
        if (pInfo != null) {
            String personId;
            String number = pInfo.getNumber();
            isNumberRepeat = this.isNumberExist(ctx, number, personId = pInfo.getId().toString());
            if (isNumberRepeat) {
                Date enrollDate = (Date)entryInfo.get("enrollDate");
                Date bizDate = (Date)entryInfo.get("bizDate");
                if (enrollDate == null) {
                    enrollDate = bizDate;
                }
                String enrollStr = DateUtil.format((Date)enrollDate, (String)"yyyyMMdd");
                String bizStr = DateUtil.format((Date)bizDate, (String)"yyyyMMdd");
                number = number + "_" + enrollStr + "_" + bizStr + DateUtil.format((Date)new Date(), (String)"HHmmss");
            }
            IUser userBean = UserFactory.getLocalInstance((Context)ctx);
            userInfo = this.getUserInfo(ctx, number, pInfo, entryInfo);
            String userId = this.getUserId(ctx, personId);
            if (userId != null) {
                userInfo.setId(BOSUuid.read((String)userId));
                HrUserPermTranserHelper.deleteAllTypeOrgRange((Context)ctx, (UserInfo)userInfo);
                this.deleteRole(ctx, userId, "T_PM_UserRoleOrg");
                this.deleteRole(ctx, userId, "T_PM_GrantUserRoleOrg");
                userInfo = this.addDefaultOrgRange(userInfo);
                HrUserPermTranserHelper.addOrgRangeOfNewUser((Context)ctx, (UserInfo)userInfo);
                HrUserPermTranserHelper.correctOrgSolution((Context)ctx, (UserInfo)userInfo);
                userBean.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userId)), (CoreBaseInfo)userInfo);
            } else {
                userInfo = this.addDefaultOrgRange(userInfo);
                userBean.addnew((CoreBaseInfo)userInfo);
            }
        }
        HrUserPermTranserHelper.addBizOrg((Context)ctx, userInfo);
        this.addDefaultRole(ctx, userInfo);
    }

    private UserInfo addDefaultOrgRange(UserInfo userInfo) {
        if (userInfo.getCU() == null) {
            return userInfo;
        }
        OrgRangeInfo orgRangeInfo = new OrgRangeInfo();
        orgRangeInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
        orgRangeInfo.setOrg(userInfo.getCU().castToFullOrgUnitInfo());
        userInfo.getOrgRange().add(orgRangeInfo);
        return userInfo;
    }

    private void addDefaultRole(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        String orgId = userInfo.getDefOrgUnit().getId().toString();
        String roleName = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.EnrollResource", (String)"24_LaborialStaff", (Locale)ctx.getLocale());
        RoleInfo roleInfo = new RoleInfo();
        String sql = "select id where Name = '" + roleName + "'";
        RoleCollection roleColl = RoleFactory.getLocalInstance((Context)ctx).getRoleCollection(sql);
        if (roleColl != null && roleColl.size() > 0) {
            roleInfo = roleColl.get(0);
            IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getLocalInstance((Context)ctx);
            UserRoleOrgInfo userRoleOrgInfo = new UserRoleOrgInfo();
            FullOrgUnitInfo fullOrgInfo = new FullOrgUnitInfo();
            fullOrgInfo.setId(BOSUuid.read((String)orgId));
            userRoleOrgInfo.setUser(userInfo);
            userRoleOrgInfo.setRole(roleInfo);
            userRoleOrgInfo.setOrg(fullOrgInfo);
            UserRoleOrgCollection userRoleOrgs = new UserRoleOrgCollection();
            userRoleOrgs.add(userRoleOrgInfo);
        }
    }

    private boolean isNumberExist(Context ctx, String number, String personId) throws EASBizException, BOSException {
        String oql;
        IUser userBean = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userColl = userBean.getUserCollection(oql = " select id where number ='" + number + "' and (person.id is null or person.id !='" + personId + "') ");
        return userColl != null && userColl.size() > 0;
    }

    private CtrlUnitInfo getHRCtrlUnit(Context ctx, FullOrgUnitInfo hrFullUnit) throws BOSException {
        CtrlUnitInfo ctrlUnitInfo = null;
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        if (hrFullUnit != null) {
            String hrId = hrFullUnit.getId().toString();
            String oql = "select id, cu.id where id='" + hrId + "'";
            FullOrgUnitCollection fullUnitColl = iFullOrgUnit.getFullOrgUnitCollection(oql);
            if (fullUnitColl != null && fullUnitColl.size() > 0) {
                ctrlUnitInfo = fullUnitColl.get(0).getCU();
            }
        }
        return ctrlUnitInfo;
    }

    private void deleteRole(Context ctx, String userId, String tableName) throws BOSException {
        String delSql = "delete from " + tableName + " where fuserid = '" + userId + "' ";
        DbUtil.execute((Context)ctx, (String)delSql);
    }

    private String getUserId(Context ctx, String personId) throws BOSException {
        UserInfo userInfo;
        String oql;
        IUser userBean = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userColl = userBean.getUserCollection(oql = " select id where person.id ='" + personId + "' ");
        if (userColl != null && userColl.size() > 0 && (userInfo = userColl.get(0)) != null) {
            return userInfo.getId().toString();
        }
        return null;
    }

    private UserInfo getUserInfo(Context ctx, String number, PersonInfo pInfo, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        UserInfo userInfo = UserInfoHelper.createNewDefaultUserInfo();
        userInfo.setNumber(number);
        userInfo.setName(pInfo.getName());
        userInfo.setPerson(pInfo);
        userInfo.setPassword(null);
        userInfo.setSecurity(this.getSecurity(ctx));
        FullOrgUnitInfo hrFullUnit = this.getHR(ctx, entryInfo.getAdminOrg());
        CtrlUnitInfo hrCtrlUnit = this.getHRCtrlUnit(ctx, hrFullUnit);
        userInfo.setCU(hrCtrlUnit);
        userInfo.setDefOrgUnit(hrFullUnit);
        userInfo.setAgentUser(false);
        userInfo.setLoginAuthorWay(LoginAuthorWayEnum.NORMAL);
        return userInfo;
    }

    private FullOrgUnitInfo getHR(Context ctx, AdminOrgUnitInfo adminOrg) throws BOSException {
        OrgUnitRelationInfo orgInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        if (adminOrg != null) {
            String oql;
            String adminOrgId = adminOrg.getId().toString();
            IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitRelationCollection orgRelationColl = iOrgRelation.getOrgUnitRelationCollection(oql = "select id, toUnit.id where fromUnit.id='" + adminOrgId + "' and typeRelation.fromType=0 and typeRelation.toType=16");
            if (orgRelationColl != null && orgRelationColl.size() > 0) {
                orgInfo = orgRelationColl.get(0);
            }
        }
        if (orgInfo != null) {
            fullOrgUnitInfo = orgInfo.getToUnit();
        }
        return fullOrgUnitInfo;
    }

    private SecurityInfo getSecurity(Context ctx) throws EASBizException, BOSException {
        SecurityInfo securityInfo = null;
        SecurityCollection securities = null;
        ISecurity iSecurity = SecurityFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SorterItemInfo sorterInfo = new SorterItemInfo();
        sorterInfo.setPropertyName("number");
        sorterInfo.setSortType(SortType.ASCEND);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(sorterInfo);
        view.setSorter(sorterColl);
        securities = iSecurity.getSecurityCollection(view);
        if (securities != null && securities.size() > 0) {
            securityInfo = securities.get(0);
        }
        return securityInfo;
    }
}

