/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.EmpTypeTransformParam;
import com.kingdee.eas.hr.affair.PositionChangeParam;
import com.kingdee.eas.hr.affair.app.IEmpTypeTransform;
import com.kingdee.eas.hr.affair.app.IPositionChange;
import com.kingdee.eas.hr.affair.app.PositionChange;
import com.kingdee.eas.hr.base.EmpInfoMultiPageInfo;
import com.kingdee.eas.hr.emp.EmployeeEmpTypeHistoryFactory;
import com.kingdee.eas.hr.emp.EmployeeEmpTypeHistoryInfo;

public class EmpTypeTransform
implements IEmpTypeTransform {
    @Override
    public void transform(Context ctx, EmpTypeTransformParam param) throws BOSException, EASBizException {
        if (param == null) {
            return;
        }
        this.updateEmpType(ctx, param);
        IPositionChange pc = this.getPositionChange();
        if (pc != null) {
            pc.change(ctx, param.getPcParam());
        }
    }

    protected void updateEmpType(Context ctx, EmpTypeTransformParam param) throws BOSException, EASBizException {
        if (param == null || param.getPerson() == null) {
            return;
        }
        if (!param.isEmpTypeChange()) {
            return;
        }
        PersonInfo person = param.getPerson();
        person.setEmployeeType(param.getTargetType());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("employeeType"));
        PersonFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)person, selector);
        EmployeeEmpTypeHistoryInfo empTypeHisInfo = this.getEmployeeTypeHistoryInfo(ctx, param);
        if (empTypeHisInfo != null) {
            EmployeeEmpTypeHistoryFactory.getLocalInstance((Context)ctx).addnew((EmpInfoMultiPageInfo)empTypeHisInfo);
        }
    }

    protected EmployeeEmpTypeHistoryInfo getEmployeeTypeHistoryInfo(Context ctx, EmpTypeTransformParam param) throws BOSException, EASBizException {
        if (param == null || param.getPerson() == null) {
            return null;
        }
        PositionChangeParam pcParam = param.getPcParam();
        if (pcParam == null) {
            return null;
        }
        EmployeeEmpTypeHistoryInfo historyInfo = new EmployeeEmpTypeHistoryInfo();
        historyInfo.setPosition(pcParam.getOldPosition());
        historyInfo.setAdminOrg(pcParam.getOldAdmin());
        historyInfo.setPerson(param.getPerson());
        historyInfo.setEmpType(param.getSrcType());
        historyInfo.setFlucDate(param.getBizDate());
        String empNumber = param.getPerson().getNumber();
        if (empNumber == null) {
            empNumber = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(param.getPerson().getId())).getNumber();
        }
        historyInfo.setEmployeeNumber(empNumber);
        return historyInfo;
    }

    protected IPositionChange getPositionChange() {
        return new PositionChange();
    }
}

