/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.affair.AffairUtilFacadeFactory;
import com.kingdee.eas.hr.affair.EnrollBillInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.app.AbstractEnrollBillEditUIHandler;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.DimissionReasonInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class EnrollBillEditUIHandler
extends AbstractEnrollBillEditUIHandler {
    public static final String ADDNEW = "ADDNEW";
    public static final String VIEW = "VIEW";
    public static final String EDIT = "EDIT";
    public static final String COPYADDNEW = "COPYADDNEW";
    public static final String EMPTYPE_RESIGN = "00000000-0000-0000-0000-000000000007A29E85B3";
    public static final String EMPTYPE_FIRE = "00000000-0000-0000-0000-000000000006A29E85B3";
    private static final String NUMBER = "number";
    private static final String IDCARDNUMBER = "idCardNumber";
    private static final String PASSPORTNUMBER = "passportNumber";

    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.getHROrgUnitCollection(request, context);
        this.getParamValueIgnoreGroupControl(context, "ENTRY001");
        if (null == request.getMainOrgType()) {
            return;
        }
        if (!VIEW.equals(request.getState())) {
            CodingRuleManageFacadeFactory.getLocalInstance((Context)context).getCodingRuleData((IObjectValue)new PersonInfo(), null);
        }
    }

    private void getHROrgUnitCollection(RequestContext request, Context context) throws BOSException {
        OrgType mainOrgType = request.getMainOrgType();
        OrgUnitInfo orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)context, (OrgType)mainOrgType);
        if (orgUnitInfo != null && orgUnitInfo instanceof HROrgUnitInfo) {
            HROrgUnitCollection hrOrgs = new HROrgUnitCollection();
            hrOrgs.add((HROrgUnitInfo)orgUnitInfo);
            if (hrOrgs != null && hrOrgs.size() > 0 && (hrOrgs.get(0).getCU() == null || hrOrgs.get(0).getCU().getNumber() == null)) {
                HashSet<String> hrOrgIDSet = new HashSet<String>();
                int size = hrOrgs.size();
                for (int i = 0; i < size; ++i) {
                    hrOrgIDSet.add(hrOrgs.get(i).getId().toString());
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", hrOrgIDSet, CompareType.INCLUDE));
                SelectorItemCollection selector = viewInfo.getSelector();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("cu.id"));
                selector.add(new SelectorItemInfo("cu.longnumber"));
                selector.add(new SelectorItemInfo("cu.number"));
                selector.add(new SelectorItemInfo("cu.name"));
                viewInfo.setFilter(filter);
                HROrgUnitFactory.getLocalInstance((Context)context).getHROrgUnitCollection(viewInfo);
            }
        }
    }

    @Override
    protected void _handleactionEnrollReg(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    public void _handleActionEdit(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.checkPermission(request, context);
        super._handleActionEdit(request, response, context);
    }

    protected void verifyInput(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.verifyInput(request, response, context);
        List idCardLs = (List)request.get("idCardLs");
        List passportLs = (List)request.get("passportLs");
        List isEnrollAgainLs = (List)request.get("isEnrollAgainLs");
        List existedPersonIdLs = (List)request.get("existedPersonIdLs");
        List enrollDateLs = (List)request.get("enrollDateLs");
        AffairUtilFacadeFactory.getLocalInstance(context).checkIdCardOrPassportNoDupInEnroll(idCardLs, passportLs, request.getId());
        ArrayList unReEnrollIdCardLs = new ArrayList();
        ArrayList unReEnrollPassportLs = new ArrayList();
        int size = idCardLs.size();
        for (int k = 0; k < size; ++k) {
            if (null != isEnrollAgainLs.get(k) && ((Boolean)isEnrollAgainLs.get(k)).booleanValue()) continue;
            unReEnrollIdCardLs.add(idCardLs.get(k));
            unReEnrollPassportLs.add(passportLs.get(k));
        }
        PersonCollection personColl = this.getPersonCollectionByStr(context, unReEnrollIdCardLs, unReEnrollPassportLs, null);
        int count = idCardLs.size();
        for (int i = 0; i < count; ++i) {
            String idCard = (String)idCardLs.get(i);
            String passport = (String)passportLs.get(i);
            if (isEnrollAgainLs.get(i) != null && ((Boolean)isEnrollAgainLs.get(i)).booleanValue()) continue;
            boolean isError = false;
            PersonInfo pInfo = this.getPersonByIdcardOrPassport(idCard, personColl, IDCARDNUMBER);
            if (this.isEnrollAgainError(IDCARDNUMBER, idCard, pInfo)) {
                isError = true;
            }
            if (this.isEnrollAgainError(PASSPORTNUMBER, passport, pInfo = this.getPersonByIdcardOrPassport(passport, personColl, PASSPORTNUMBER))) {
                isError = true;
            }
            if (!isError) continue;
            SysUtil.abort();
            continue;
        }
        PersonPositionFactory.getLocalInstance((Context)context).checkEnrollDate(isEnrollAgainLs, existedPersonIdLs, enrollDateLs);
    }

    private boolean isEnrollAgainError(String type, String value, PersonInfo pInfo) throws Exception {
        boolean isError = false;
        if (StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)value)) {
            return isError;
        }
        if (pInfo != null) {
            EmployeeTypeInfo pTypeInfo = pInfo.getEmployeeType();
            if (pTypeInfo.getId().toString().equals(EMPTYPE_RESIGN) || pTypeInfo.getId().toString().equals(EMPTYPE_FIRE)) {
                DimissionReasonInfo drInfo = (DimissionReasonInfo)pInfo.get("DimissionReasonInfo");
                if (drInfo == null || drInfo.isIsPermission()) {
                    if (type.equals(IDCARDNUMBER)) {
                        throw new HRAffairException(HRAffairException.IDCARDNUMBER_REASONTYPE);
                    }
                    throw new HRAffairException(HRAffairException.PASSPORTNUMBER_REASONTYPE);
                }
                throw new HRAffairException(HRAffairException.IDPASSNUMBER_REASONTYPE);
            }
            if (type.equals(IDCARDNUMBER)) {
                throw new HRAffairException(HRAffairException.IDCARDNUMBER_EMPLOYEETYPE);
            }
            throw new HRAffairException(HRAffairException.PASSPORTNUMBER_EMPLOYEETYPE);
        }
        return isError;
    }

    private PersonInfo getPersonByIdcardOrPassport(String str, PersonCollection personColl, String type) throws BaseException {
        PersonInfo pInfo = null;
        if (null == personColl) {
            return null;
        }
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        if (IDCARDNUMBER.equals(type)) {
            String _str = "";
            if (str.length() == 15) {
                _str = IDCardCommonUtil.IDCardNO15To18((String)str);
            } else if (str.length() == 18) {
                _str = IDCardCommonUtil.IDCardNO18To15((String)str);
            }
            int size = personColl.size();
            for (int j = 0; j < size; ++j) {
                if (null == personColl.get(j) || !str.equals(personColl.get(j).getIdCardNO()) && !_str.equals(personColl.get(j).getIdCardNO())) continue;
                pInfo = personColl.get(j);
            }
        }
        if (PASSPORTNUMBER.equals(type)) {
            int size = personColl.size();
            for (int j = 0; j < size; ++j) {
                if (null == personColl.get(j) || !str.equals(personColl.get(j).getPassportNO())) continue;
                pInfo = personColl.get(j);
            }
        }
        return pInfo;
    }

    private PersonCollection getPersonCollectionByStr(Context context, List idCardLs, List passportLs, List numberLs) throws BOSException, EASBizException {
        IPerson ip = PersonFactory.getLocalInstance((Context)context);
        return ip.getPersonCollectionByStrLs(idCardLs, passportLs, numberLs);
    }

    @Override
    protected void _handleActionSave(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.getPersonCollection(request, context);
        super._handleActionSave(request, response, context);
    }

    @Override
    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSubmit(request, response, context);
        this.appLogWriteAndUpdate(request, context);
    }

    private void getPersonCollection(RequestContext request, Context context) throws BOSException {
        IPerson ip = PersonFactory.getLocalInstance((Context)context);
        List idCardLs = (List)request.get("idCardLs");
        String type = "idCardNO";
        this.getPersonCollectionByType(ip, idCardLs, type);
        List passportLs = (List)request.get("passportLs");
        type = "passportNO";
        this.getPersonCollectionByType(ip, passportLs, type);
    }

    private void getPersonCollectionByType(IPerson ip, List idCardLs, String type) throws BOSException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        int size = idCardLs.size();
        for (int i = 0; i < size; ++i) {
            String str = (String)idCardLs.get(i);
            filter.getFilterItems().add(new FilterItemInfo(type, (Object)str));
            evi.setFilter(filter);
            ip.getPersonCollection(evi);
        }
    }

    public void _handCheckIdCardOrPassportNumber(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected IObjectValue createNewData() {
        EnrollBillInfo info = new EnrollBillInfo();
        info.setIsMultiEntry(true);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        if (this.nowClientDate != null) {
            info.setApplyDate(this.nowClientDate);
        }
        return info;
    }
}

