/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.affair.FireBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractFireBillEditUIHandler;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class FireBillEditUIHandler
extends AbstractFireBillEditUIHandler {
    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.getCtrlUnitInfo(request, context);
        this.getParamValueIgnoreGroupControl(context, "Dis001");
    }

    @Override
    protected void _handleActionSave(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSave(request, response, context);
    }

    protected void verifyInput(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.checkIsPersonInProcessForFireBill(request, context);
        super.verifyInput(request, response, context);
    }

    private void checkIsPersonInProcessForFireBill(RequestContext request, Context context) throws BOSException, EASBizException {
        PersonInfo pInfo = null;
        FireBillInfo billInfo = (FireBillInfo)request.getValue();
        if (null != billInfo && null != billInfo.getEntries()) {
            int size = billInfo.getEntries().size();
            for (int i = 0; i < size; ++i) {
                IObjectValue baseInfo;
                pInfo = billInfo.getEntries().get(i).getPerson();
                if (pInfo == null || (baseInfo = this.createNewData()) == null) continue;
                String id = "";
                if (null != request.getId()) {
                    id = request.getId().toString();
                }
                BOSObjectType entryBosType = null;
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                EntityObjectInfo entity = loader.getEntity(baseInfo.getBOSType());
                LinkPropertyInfo linkProperty = (LinkPropertyInfo)entity.getPropertyByName("entries");
                entryBosType = linkProperty.getRelationship().getSupplierObject().getType();
                this.checkIsPersonInProcess(request, context, baseInfo.getBOSType(), entryBosType, pInfo, id);
            }
        }
    }

    @Override
    protected IObjectValue createNewData() {
        FireBillInfo info = new FireBillInfo();
        info.setIsMultiEntry(true);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        return info;
    }

    @Override
    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSubmit(request, response, context);
        this.appLogWriteAndUpdate(request, context);
    }

    @Override
    protected void _handleactionAddPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionDelPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionAffairReg(RequestContext request, ResponseContext response, Context context) throws Exception {
    }
}

