/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.param.IPersonalNantionalPlan;
import com.kingdee.eas.base.param.PersonalNantionalPlanFactory;
import com.kingdee.eas.base.param.PersonalNantionalPlanInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.hr.affair.AffairAuditEffectFacadeFactory;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.AffairUnAuitAlreadyEffectFacadeFactory;
import com.kingdee.eas.hr.affair.HRAffairBillSuspendRecordCollection;
import com.kingdee.eas.hr.affair.HRAffairBillSuspendRecordFactory;
import com.kingdee.eas.hr.affair.HRAffairBillSuspendRecordInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizCollection;
import com.kingdee.eas.hr.affair.HRAffairBizFactory;
import com.kingdee.eas.hr.affair.HRAffairBizInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.IHRAffairBiz;
import com.kingdee.eas.hr.affair.IHRAffairBizBill;
import com.kingdee.eas.hr.affair.IHRAffairBizBillEntry;
import com.kingdee.eas.hr.affair.SuspendRecordStateEnum;
import com.kingdee.eas.hr.affair.app.AbstractHRAffairBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.HRAffairBillBizBean;
import com.kingdee.eas.hr.affair.app.HRAffairBizBillEntryValidateHelper;
import com.kingdee.eas.hr.affair.util.EmpSalaryAdjDataUtil;
import com.kingdee.eas.hr.affair.util.HRAffairBillProgressUtil;
import com.kingdee.eas.hr.affair.util.HolidayLimitUtil;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.BillEntryJobProcessCollection;
import com.kingdee.eas.hr.base.BillEntryJobProcessFactory;
import com.kingdee.eas.hr.base.BillEntryJobProcessInfo;
import com.kingdee.eas.hr.base.EmpAffairBizBillException;
import com.kingdee.eas.hr.base.EmpHRORelationHisFactory;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpSalaryAdjustmentCollection;
import com.kingdee.eas.hr.base.EmpSalaryAdjustmentFactory;
import com.kingdee.eas.hr.base.EmpSalaryAdjustmentInfo;
import com.kingdee.eas.hr.base.EmpSalaryItemDataCollection;
import com.kingdee.eas.hr.base.EmpSalaryItemDataFactory;
import com.kingdee.eas.hr.base.EmpSalaryItemDataInfo;
import com.kingdee.eas.hr.base.EmpSalaryItemDataPartCollection;
import com.kingdee.eas.hr.base.EmpSalaryItemDataPartDetailCollection;
import com.kingdee.eas.hr.base.EmpSalaryItemDataPartDetailInfo;
import com.kingdee.eas.hr.base.EmpSalaryItemDataPartFactory;
import com.kingdee.eas.hr.base.EmpSalaryItemDataPartInfo;
import com.kingdee.eas.hr.base.EmpSignFeeCollection;
import com.kingdee.eas.hr.base.EmpSignFeeDetailCollection;
import com.kingdee.eas.hr.base.EmpSignFeeDetailInfo;
import com.kingdee.eas.hr.base.EmpSignFeeFactory;
import com.kingdee.eas.hr.base.EmpSignFeeInfo;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.SalaryAdjustTypeInfo;
import com.kingdee.eas.hr.base.app.EmpPostExperienceHisHelper;
import com.kingdee.eas.hr.base.app.HRBillAppUtils;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.plan.SHRActionVerifyByPersonPlanTool;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.base.app.util.SHRBizBillAttachmentReverseUtils;
import com.kingdee.eas.hr.base.util.AffairBizExtendCustomerTool;
import com.kingdee.eas.hr.base.util.EmpEnrollUserPermHelper;
import com.kingdee.eas.hr.base.util.EmpLog;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.ReflectUtil;
import com.kingdee.eas.hr.emp.EmpPostRankException;
import com.kingdee.eas.hr.emp.LeaveQuitLimitEnum;
import com.kingdee.eas.hr.emp.SalaryItemInfo;
import com.kingdee.eas.hr.emp.app.util.RecEntryServiceUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpOrgRelationTool;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptPersonTool;
import com.kingdee.eas.hr.service.app.listener.DigestThreadUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtCollection;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.custom.TranslateLocalUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class HRAffairBizBillControllerBean
extends AbstractHRAffairBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.HRAffairBizBillControllerBean");

    protected IHRBillBizBean getBizBean() throws BOSException, EASBizException {
        Object bean = super.getBizBean();
        if (bean == null) {
            bean = new HRAffairBillBizBean();
        }
        return bean;
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.cleanInfo(model);
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        if (entries.size() == 0) {
            throw new HRAffairException(HRAffairException.NO_ENTRIES);
        }
        for (int i = 0; i < entries.size(); ++i) {
            HRAffairBizBillEntryInfo entry = (HRAffairBizBillEntryInfo)entries.getObject(i);
            EmpHRORelationHisInfo personBURelationInfo = this.getEmpHRORelationHisInfo(ctx, entry);
            this.setHrOrgUnitForEntry(ctx, model, entry, personBURelationInfo);
            this.setEmployerUnitForEntry(model, entry);
            this.setCompanyForEntry(ctx, entry);
            this.setBillUseDefault(ctx, model, entry, personBURelationInfo);
            this.bizTimeZoneTranferForEntry(ctx, entry);
        }
        super._addnew(ctx, pk, model);
    }

    private EmpHRORelationHisInfo getEmpHRORelationHisInfo(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        EmpHRORelationHisInfo buInfo = null;
        if (entry.getPerson() != null && entry.getPerson().getId() != null) {
            String personId = entry.getPerson().getId().toString();
            EmpPosOrgRelationInfo info = SHREmpOptEmpOrgRelationTool.getCurrntMainEmpOrgRelationInfo((Context)ctx, (String)personId);
            if (info != null && "P/OSDCPfQXqU0TB/LQoA6uZovtk=".equals(info.getAction().getId().toString())) {
                buInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo((Context)ctx, (String)personId);
                if (buInfo == null) {
                    if (EmpHRORelationHisFactory.getLocalInstance((Context)ctx).exists("where person.id = '" + personId + "' and isInner = 1")) {
                        throw new AffairActioniOperateException(AffairActioniOperateException.UPDATING_PERSON_BURELA);
                    }
                    throw new AffairActioniOperateException(AffairActioniOperateException.ERROR_PERSONINIT_NO_EMPHRO);
                }
            } else {
                buInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo((Context)ctx, (String)personId);
                if (buInfo == null) {
                    throw new AffairActioniOperateException(AffairActioniOperateException.UPDATING_PERSON_BURELA);
                }
            }
        }
        return buInfo;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.cleanInfo(model);
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        if (entries.size() == 0) {
            throw new HRAffairException(HRAffairException.NO_ENTRIES);
        }
        for (int i = 0; i < entries.size(); ++i) {
            HRAffairBizBillEntryInfo entry = (HRAffairBizBillEntryInfo)entries.getObject(i);
            EmpHRORelationHisInfo personBURelationInfo = this.getEmpHRORelationHisInfo(ctx, entry);
            this.setHrOrgUnitForEntry(ctx, model, entry, personBURelationInfo);
            this.setEmployerUnitForEntry(model, entry);
            this.setCompanyForEntry(ctx, entry);
            this.setBillUseDefault(ctx, model, entry, personBURelationInfo);
            this.bizTimeZoneTranferForEntry(ctx, entry);
            this.saveSalaryData(ctx, entry);
        }
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.cleanInfo(model);
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        if (entries.size() == 0) {
            throw new HRAffairException(HRAffairException.NO_ENTRIES);
        }
        for (int i = 0; i < entries.size(); ++i) {
            HRAffairBizBillEntryInfo entry = (HRAffairBizBillEntryInfo)entries.getObject(i);
            EmpHRORelationHisInfo personBURelationInfo = this.getEmpHRORelationHisInfo(ctx, entry);
            this.setHrOrgUnitForEntry(ctx, model, entry, personBURelationInfo);
            this.setEmployerUnitForEntry(model, entry);
            this.setCompanyForEntry(ctx, entry);
            this.setBillUseDefault(ctx, model, entry, personBURelationInfo);
            this.bizTimeZoneTranferForEntry(ctx, entry);
            this.saveSalaryData(ctx, entry);
        }
        super._update(ctx, pk, model);
    }

    public void saveSalaryData(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        String salaryData;
        if (entry.containsKey("salaryData") && !StringUtils.isEmpty((String)(salaryData = entry.getString("salaryData")))) {
            salaryData = salaryData.replaceAll("salaryData#", "");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HRAffairBizBillControllerBean.saveSalaryData : " + salaryData));
            }
            EmpSalaryItemDataInfo empSalaryItemDataInfo = (EmpSalaryItemDataInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)salaryData, EmpSalaryItemDataInfo.class);
            if (entry.getId() != null) {
                this.deleteSalaryItemData(ctx, entry.getId());
                empSalaryItemDataInfo.setEntryId(entry.getId().toString());
            } else {
                BOSUuid entryId = BOSUuid.create((BOSObjectType)entry.getBOSType());
                empSalaryItemDataInfo.setEntryId(entryId.toString());
                entry.setId(entryId);
            }
            empSalaryItemDataInfo.setPerson(entry.getPerson());
            if (empSalaryItemDataInfo.containsKey("empStandard")) {
                empSalaryItemDataInfo.setCmpStandard(empSalaryItemDataInfo.getString("empStandard"));
            }
            if (empSalaryItemDataInfo.containsKey("empStdValue")) {
                empSalaryItemDataInfo.setCmpStdValue(empSalaryItemDataInfo.getString("empStdValue"));
            }
            if (empSalaryItemDataInfo.getSalaryEffectDate() == null) {
                empSalaryItemDataInfo.setSalaryEffectDate(entry.getBizDate());
            }
            IObjectPK signPk = null;
            IObjectPK dataPk = null;
            boolean isHaveSign = false;
            if (empSalaryItemDataInfo.getSignFee() != null && empSalaryItemDataInfo.getSignFee().getEmpSignFeeDetail() != null && empSalaryItemDataInfo.getSignFee().getEmpSignFeeDetail().size() > 0) {
                signPk = EmpSignFeeFactory.getLocalInstance((Context)ctx).addnew(empSalaryItemDataInfo.getSignFee());
                isHaveSign = true;
            }
            if (isHaveSign || empSalaryItemDataInfo.getEmpSalaryItemPart() != null && empSalaryItemDataInfo.getEmpSalaryItemPart().size() > 0) {
                dataPk = EmpSalaryItemDataFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)empSalaryItemDataInfo);
            }
            if (signPk != null && dataPk != null) {
                String sql = "update t_hr_empsignfee set FEmpsalaryItemDataId = ? where fid = ?";
                Object[] params = new Object[]{dataPk.toString(), signPk.toString()};
                DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
            }
        }
    }

    protected void deleteSalaryItemData(Context ctx, BOSUuid entryId) throws BOSException, EASBizException {
        EmpSalaryItemDataCollection coll = EmpSalaryItemDataFactory.getLocalInstance((Context)ctx).getEmpSalaryItemDataCollection("select id where entryId = '" + entryId.toString() + "'");
        if (coll != null && coll.size() > 0) {
            HashSet<String> salaryItemDataIdSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                salaryItemDataIdSet.add(coll.get(i).getId().toString());
            }
            FilterInfo deletefilter = new FilterInfo();
            deletefilter.getFilterItems().add(new FilterItemInfo("empsalaryItemData", (Object)((Object)salaryItemDataIdSet).toString(), CompareType.INCLUDE));
            EmpSalaryItemDataPartFactory.getLocalInstance((Context)ctx).delete(deletefilter);
            EmpSignFeeFactory.getLocalInstance((Context)ctx).delete(deletefilter);
            deletefilter.getFilterItems().clear();
            deletefilter.getFilterItems().add(new FilterItemInfo("id", (Object)((Object)salaryItemDataIdSet).toString(), CompareType.INCLUDE));
            EmpSalaryItemDataFactory.getLocalInstance((Context)ctx).delete(deletefilter);
        }
    }

    private void bizTimeZoneTranferForEntry(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        String pattern = "yyyy-MM-dd HH:mm:ss";
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String oql = MessageFormat.format("where userid = ''{0}''", userId);
        IPersonalNantionalPlan iPersonalNantionalPlan = PersonalNantionalPlanFactory.getLocalInstance((Context)ctx);
        PersonalNantionalPlanInfo personalNantionalPlanInfo = null;
        Date biztime = null;
        java.sql.Date bizDate = entry.getDate("bizDate");
        try {
            if (iPersonalNantionalPlan.exists(oql)) {
                personalNantionalPlanInfo = iPersonalNantionalPlan.getPersonalNantionalPlanInfo(MessageFormat.format("select personalTimeZoneID.timeDiff,nationalplan.timeZoneID.timeDiff  {0}", oql));
                int currentTimeZone = 0;
                if (personalNantionalPlanInfo.getPersonalTimeZoneID() != null && personalNantionalPlanInfo.getPersonalTimeZoneID().getTimeDiff() != null) {
                    currentTimeZone = (int)personalNantionalPlanInfo.getPersonalTimeZoneID().getTimeDiff().getValue();
                }
                String currentTimeZoneStr = currentTimeZone > 0 ? "+" + currentTimeZone : "" + currentTimeZone;
                int currentTimeZoneTimeStamp = TimeZone.getTimeZone(MessageFormat.format("{0}{1}", "GMT", currentTimeZoneStr)).getRawOffset();
                int targetTimeZoneTimeStamp = TimeZone.getDefault().getRawOffset();
                Long targetTimeStamp = bizDate.getTime() - (long)currentTimeZoneTimeStamp + (long)targetTimeZoneTimeStamp;
                biztime = new Date(targetTimeStamp);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("*****bizDate*****" + bizDate + "*****currentTimeZoneTimeStamp*****" + currentTimeZoneTimeStamp + "targetTimeZoneTimeStamp*****" + targetTimeZoneTimeStamp + "*****targetTime*****" + biztime));
                }
            } else {
                biztime = DateTimeUtils.parseDate((String)DateTimeUtils.format((Date)bizDate, (String)pattern), (String)pattern);
            }
        }
        catch (ParseException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        entry.setBizTime(new Timestamp(biztime.getTime()));
    }

    private void cleanInfo(IObjectValue model) {
        HRAffairBizBillInfo info = (HRAffairBizBillInfo)model;
        if (info.getApplyDate() != null) {
            info.setApplyDate(DateTimeUtils.truncateDate((Date)info.getApplyDate()));
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.storefields(ctx, model);
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int i;
        this.storefields(ctx, model);
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        billInfo.setApproveType(ApproveTypeEnum.WORKFLOW);
        this.checkBeforeSubmit(ctx, model);
        IObjectPK pk = super._submit(ctx, model);
        this.checkAfterSubmit(ctx, model);
        IObjectCollection entries = (IObjectCollection)model.get(this.getEntryField());
        if (entries.size() == 0) {
            throw new HRAffairException(HRAffairException.NO_ENTRIES);
        }
        for (i = 0; i < entries.size(); ++i) {
            Date bizDate = this.getEmpPosBeginDate((HRAffairBizBillEntryInfo)entries.getObject(i));
            HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)entries.getObject(i);
            SHRActionVerifyByPersonPlanTool.recordAffairBizActionEmpPosChangeData((Context)ctx, (HRAffairBizBillEntryInfo)entryInfo, (Date)bizDate);
        }
        if (entries.size() == 1) {
            for (i = 0; i < entries.size(); ++i) {
                HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)entries.getObject(i);
                String enrtryID = entryInfo.getId().toString();
                String bosType = BOSUuid.read((String)enrtryID).getType().toString();
                if (bosType.equals("72314963") || bosType.equals("EE7E27FF")) continue;
                SHRBizBillAttachmentReverseUtils.saveBizBillAttachmentReverse((Context)ctx, (String)entryInfo.getId().toString());
            }
        }
        return pk;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.storefields(ctx, model);
        this.checkBeforeSubmit(ctx, model);
        super._submit(ctx, pk, model);
        this.checkAfterSubmit(ctx, model);
        IObjectCollection entries = (IObjectCollection)model.get(this.getEntryField());
        if (entries.size() == 0) {
            throw new HRAffairException(HRAffairException.NO_ENTRIES);
        }
        for (int i = 0; i < entries.size(); ++i) {
            Date bizDate = this.getEmpPosBeginDate((HRAffairBizBillEntryInfo)entries.getObject(i));
            HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)entries.getObject(i);
            SHRActionVerifyByPersonPlanTool.recordAffairBizActionEmpPosChangeData((Context)ctx, (HRAffairBizBillEntryInfo)entryInfo, (Date)bizDate);
        }
    }

    protected void checkAfterSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String entryField = this.getEntryField();
        IObjectCollection entries = (IObjectCollection)model.get(entryField);
        HRAffairBizBillEntryValidateHelper helper = new HRAffairBizBillEntryValidateHelper();
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        for (int i = 0; i < entries.size(); ++i) {
            Date bizDate = this.getEmpPosBeginDate((HRAffairBizBillEntryInfo)entries.getObject(i));
            HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)entries.getObject(i);
            this.refreshResignBillForExperience(ctx, entryInfo);
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            if (!DateTimeUtils.dayAfter((Date)bizDate, (Date)curDate) && !ApproveTypeEnum.WORKFLOW.equals((Object)billInfo.getApproveType())) continue;
            helper.validateFieldNotNull(ctx, entryInfo, bizDate);
        }
        SHRActionVerifyByPersonPlanTool.verifyHrAffairBizBilActionByPersonPlan((Context)ctx, (IObjectCollection)entries);
    }

    protected void storefields(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String entryField = this.getEntryField();
        IObjectCollection entries = (IObjectCollection)model.get(entryField);
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        Date nowDate = DateTimeUtils.truncateDate((Date)new Date());
        if (billInfo.getApplyDate() == null) {
            billInfo.setApplyDate(nowDate);
        }
        for (int i = 0; i < entries.size(); ++i) {
            HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)entries.getObject(i);
            if (entryInfo.getBizDate() == null) {
                entryInfo.setBizDate(nowDate);
            }
            this.storefieldsForEntry(ctx, billInfo, entryInfo);
        }
        this.storefieldsForBill(ctx, billInfo);
    }

    protected HRAffairBizBillEntryInfo storefieldsForEntry(Context ctx, HRAffairBizBillInfo billInfo, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        entryInfo.put(this.getBillField(), billInfo);
        PersonInfo personInfo = SHREmpOptPersonTool.getPersonDetailInfo((Context)ctx, (String)entryInfo.getPerson().getId().toString());
        EmpPostExperienceHisHelper.fillHistory((Context)ctx, (String)entryInfo.getPerson().getId().toString(), (Date)entryInfo.getBizDate(), (CoreBaseInfo)entryInfo);
        entryInfo.setPerson(personInfo);
        if (billInfo.getAdminOrg() == null) {
            billInfo.setAdminOrg(entryInfo.getAdminOrg());
        }
        return entryInfo;
    }

    protected HRAffairBizBillInfo storefieldsForBill(Context ctx, HRAffairBizBillInfo billInfo) throws EASBizException, BOSException {
        return billInfo;
    }

    protected void _auditEntryEffect(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        String entryField;
        if (billID == null) {
            return;
        }
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        IObjectCollection entries = (IObjectCollection)model.get(entryField = this.getEntryField());
        if (entries != null) {
            int entrySize = entries.size();
            if (entrySize > 1) {
                DigestThreadUtil.setIsSyncPause((Context)ctx, (boolean)true);
            }
            try {
                super._auditEntryEffect(ctx, billID);
            }
            catch (BOSException e) {
                if (entrySize > 1) {
                    DigestThreadUtil.setIsSyncPause((Context)ctx, (boolean)false);
                }
                throw e;
            }
            catch (EASBizException e) {
                if (entrySize > 1) {
                    DigestThreadUtil.setIsSyncPause((Context)ctx, (boolean)false);
                }
                throw e;
            }
            if (entrySize > 1) {
                DigestThreadUtil.setIsSyncPause((Context)ctx, (boolean)false);
            }
        }
    }

    protected Date getEffectDate(HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        if (null != entry.getDate("leftCompanyDate") && null != entry.getDate("bizDate") && DateTimeUtils.dayEquals((Date)entry.getDate("bizDate"), (Date)entry.getDate("leftCompanyDate")) && !entry.getBoolean("isSameDatePersonChange")) {
            return DateTimeUtils.truncateDate((Date)HRUtil.getAftereDate((Date)entry.getDate("bizDate")));
        }
        return super.getEffectDate(entry);
    }

    protected Date getEffectTime(HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        if (null != entry.getDate("leftCompanyDate") && null != entry.getDate("bizDate") && DateTimeUtils.dayEquals((Date)entry.getDate("bizDate"), (Date)entry.getDate("leftCompanyDate")) && !entry.getBoolean("isSameDatePersonChange")) {
            return HRUtil.getAftereDate((Date)entry.getDate("bizTime"));
        }
        return super.getEffectTime(entry);
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._entryEffect(ctx, entry);
        if (entry == null) {
            throw new AffairBizException(AffairBizException.ENRTY_IS_NULL);
        }
        this.refreshEmpPostExperience(ctx, entry);
        this.checkPersonIsResign(ctx, entry);
        this.checkEntryIsEffect(ctx, entry);
        HRAffairBizBillEntryInfo affairEntry = (HRAffairBizBillEntryInfo)entry;
        this._doWithPriorityThingEffect(ctx, affairEntry);
        this._doWithCommonRelationEffect(ctx, affairEntry);
        this._doWithSpecialFiledsEffect(ctx, affairEntry);
        this._doWithOtherChangeEffect(ctx, affairEntry);
        this.dowithSalaryItemData(ctx, affairEntry);
        this.reverseAttachment(ctx, affairEntry);
    }

    protected void dowithSalaryItemData(Context ctx, HRAffairBizBillEntryInfo affairEntry) throws BOSException, EASBizException {
        EmpSignFeeCollection signFeeCollection;
        EmpSalaryAdjustmentCollection salaryAdjustmentInfoList = new EmpSalaryAdjustmentCollection();
        EmpSalaryItemDataCollection coll = EmpSalaryItemDataFactory.getLocalInstance((Context)ctx).getEmpSalaryItemDataCollection("select id,salaryEffectDate where entryId = '" + affairEntry.getId().toString() + "'");
        if (coll == null || coll.size() == 0) {
            return;
        }
        EmpSalaryAdjustmentFactory.getLocalInstance((Context)ctx).delete("where affairId = '" + affairEntry.getId().toString() + "'");
        HashSet<String> salaryItemDataIdSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            salaryItemDataIdSet.add(coll.get(i).getId().toString());
        }
        Date effect = coll.get(0).getSalaryEffectDate() != null ? coll.get(0).getSalaryEffectDate() : affairEntry.getBizDate();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo selectfilter = new FilterInfo();
        selectfilter.getFilterItems().add(new FilterItemInfo("empsalaryItemData", (Object)((Object)salaryItemDataIdSet).toString(), CompareType.INCLUDE));
        view.setFilter(selectfilter);
        EmpSalaryItemDataPartCollection partCollection = EmpSalaryItemDataPartFactory.getLocalInstance((Context)ctx).getEmpSalaryItemDataPartCollection(view);
        if (partCollection != null && partCollection.size() > 0) {
            salaryAdjustmentInfoList.addCollection(this.assembleDataPartColl(ctx, affairEntry, partCollection, effect));
        }
        if ((signFeeCollection = EmpSignFeeFactory.getLocalInstance((Context)ctx).getEmpSignFeeCollection(view)) != null && signFeeCollection.size() > 0) {
            salaryAdjustmentInfoList.addCollection(this.assembleSignFeePartColl(ctx, affairEntry, signFeeCollection, effect));
        }
        if (salaryAdjustmentInfoList.size() > 0) {
            EmpSalaryAdjustmentFactory.getLocalInstance((Context)ctx).saveData(salaryAdjustmentInfoList);
        }
    }

    public EmpSalaryAdjustmentCollection assembleSignFeePartColl(Context ctx, HRAffairBizBillEntryInfo affairEntry, EmpSignFeeCollection signFeeCollection, Date effect) throws EASBizException, BOSException {
        EmpSalaryAdjustmentCollection salaryAdjustmentInfoList = new EmpSalaryAdjustmentCollection();
        EmpSignFeeInfo signFeeInfo = signFeeCollection.get(0);
        EmpSignFeeDetailCollection signFeeDetailCollection = signFeeInfo.getEmpSignFeeDetail();
        HRBizDefineInfo action = affairEntry.getHrBizDefine();
        SalaryAdjustTypeInfo info = this.getSalaryAdjustTypeByAction(ctx, action);
        SalaryItemInfo salaryItemInfo = new SalaryItemInfo();
        salaryItemInfo.setId(BOSUuid.read((String)"SrEAAADcDCbD25kv"));
        PersonInfo dataSourceCreator = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        Timestamp timestamp = null;
        timestamp = affairEntry.getBizDate() != null ? new Timestamp(affairEntry.getBizDate().getTime()) : new Timestamp(new Date().getTime());
        if (signFeeDetailCollection != null && signFeeDetailCollection.size() > 0) {
            for (int i = 0; i < signFeeDetailCollection.size(); ++i) {
                EmpSalaryAdjustmentInfo empSalaryAdjustmentInfo = new EmpSalaryAdjustmentInfo();
                EmpSignFeeDetailInfo signFeeDetailInfo = signFeeDetailCollection.get(i);
                empSalaryAdjustmentInfo.setSegment(signFeeDetailInfo.getIndex() + "");
                empSalaryAdjustmentInfo.setCurrency(signFeeInfo.getCurrency());
                empSalaryAdjustmentInfo.setPerson(affairEntry.getPerson());
                empSalaryAdjustmentInfo.setSalaryItem(salaryItemInfo);
                empSalaryAdjustmentInfo.setItemVal(signFeeDetailInfo.getAmount());
                empSalaryAdjustmentInfo.setEffect(effect);
                empSalaryAdjustmentInfo.setSalaryAdjustType(info);
                empSalaryAdjustmentInfo.setAffairId(affairEntry.getId().toString());
                empSalaryAdjustmentInfo.setDataSourceCreateTime(timestamp);
                empSalaryAdjustmentInfo.setDataSourceCreator(dataSourceCreator);
                String desc = signFeeDetailInfo.getDescription();
                String simple = TranslateLocalUtil.getSimplified((String)desc);
                empSalaryAdjustmentInfo.setDescription(simple, LocaleUtils.locale_l2);
                empSalaryAdjustmentInfo.setDescription(TranslateLocalUtil.getTraditional((String)simple), LocaleUtils.locale_l3);
                salaryAdjustmentInfoList.add(empSalaryAdjustmentInfo);
            }
        }
        return salaryAdjustmentInfoList;
    }

    public EmpSalaryAdjustmentCollection assembleDataPartColl(Context ctx, HRAffairBizBillEntryInfo affairEntry, EmpSalaryItemDataPartCollection partCollection, Date effect) throws EASBizException, BOSException {
        EmpSalaryAdjustmentCollection salaryAdjustmentInfoList = new EmpSalaryAdjustmentCollection();
        HRBizDefineInfo action = affairEntry.getHrBizDefine();
        SalaryAdjustTypeInfo info = this.getSalaryAdjustTypeByAction(ctx, action);
        PersonInfo dataSourceCreator = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        Timestamp timestamp = null;
        timestamp = affairEntry.getBizDate() != null ? new Timestamp(affairEntry.getBizDate().getTime()) : new Timestamp(new Date().getTime());
        for (int i = 0; i < partCollection.size(); ++i) {
            EmpSalaryItemDataPartInfo partInfo = partCollection.get(i);
            EmpSalaryItemDataPartDetailCollection partDetailCollection = partInfo.getEmpSalaryItemPartDataDetail();
            if (partDetailCollection == null || partDetailCollection.size() <= 0) continue;
            for (int j = 0; j < partDetailCollection.size(); ++j) {
                EmpSalaryItemDataPartDetailInfo detailInfo = partDetailCollection.get(j);
                EmpSalaryAdjustmentInfo empSalaryAdjustmentInfo = new EmpSalaryAdjustmentInfo();
                empSalaryAdjustmentInfo.setSalaryPoint(detailInfo.getPointId());
                empSalaryAdjustmentInfo.setFloatRate(detailInfo.getFloatRate());
                empSalaryAdjustmentInfo.setSalaryLevel(detailInfo.getLevelId());
                empSalaryAdjustmentInfo.setSalaryScope(detailInfo.getScopeId());
                empSalaryAdjustmentInfo.setCurrency(detailInfo.getCurrency());
                empSalaryAdjustmentInfo.setPerson(affairEntry.getPerson());
                empSalaryAdjustmentInfo.setSalaryItem(detailInfo.getSalaryItem());
                empSalaryAdjustmentInfo.setItemVal(detailInfo.getAmount());
                empSalaryAdjustmentInfo.setEffect(effect);
                empSalaryAdjustmentInfo.setSalaryAdjustType(info);
                empSalaryAdjustmentInfo.setAffairId(affairEntry.getId().toString());
                empSalaryAdjustmentInfo.setDataSourceCreateTime(timestamp);
                empSalaryAdjustmentInfo.setDataSourceCreator(dataSourceCreator);
                empSalaryAdjustmentInfo.setSalaryStandardId(detailInfo.getCmpItemId());
                empSalaryAdjustmentInfo.setDescription(detailInfo.getDescription());
                String desc = detailInfo.getDescription();
                String simple = TranslateLocalUtil.getSimplified((String)desc);
                empSalaryAdjustmentInfo.setDescription(simple, LocaleUtils.locale_l2);
                empSalaryAdjustmentInfo.setDescription(TranslateLocalUtil.getTraditional((String)simple), LocaleUtils.locale_l3);
                salaryAdjustmentInfoList.add(empSalaryAdjustmentInfo);
            }
        }
        return salaryAdjustmentInfoList;
    }

    protected SalaryAdjustTypeInfo getSalaryAdjustTypeByAction(Context ctx, HRBizDefineInfo hrBizDefineInfo) throws EASBizException, BOSException {
        SalaryAdjustTypeInfo salaryAdjustTypeInfo = new SalaryAdjustTypeInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDefineType"));
        hrBizDefineInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(hrBizDefineInfo.getId()), sic);
        HRBizDefineTypeEnum typeEnum = hrBizDefineInfo.getBizDefineType();
        if (typeEnum == null) {
            throw new EmpPostRankException(EmpPostRankException.ACTION_BIZTYPE_NULL);
        }
        String typeId = "";
        switch (typeEnum.getValue()) {
            case 1: 
            case 16: {
                typeId = "0M+dAbZdUvbgU8gEEazwoSCeof4=";
                break;
            }
            case 2: {
                typeId = "0M/DJ21aSTDgU8gEEazWFyCeof4=";
                break;
            }
            case 3: 
            case 10: {
                typeId = "0M+dAbZeUvbgU8gEEazwoSCeof4=";
                break;
            }
        }
        if (!StringUtils.isEmpty((String)typeId)) {
            salaryAdjustTypeInfo.setId(BOSUuid.read((String)typeId));
        }
        return salaryAdjustTypeInfo;
    }

    protected void _doWithPriorityThingEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
    }

    protected void _doWithCommonRelationEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        if (entry.getHrBizDefine() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.HRBIZDEFINENOTNULL);
        }
        AffairAuditEffectFacadeFactory.getLocalInstance(ctx).globaPropertyAudit(entry, this.getEmpPosBeginDate(entry));
    }

    protected void _doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
    }

    protected void _doWithOtherChangeEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        PersonInfo person = entry.getPerson();
        if (person == null || person.getId() == null) {
            return;
        }
        HRBizDefineInfo bizDefine = entry.getHrBizDefine();
        RecEntryServiceUtil.syncEmployeeStateChange((Context)ctx, (String)person.getId().toString(), (HRBizDefineInfo)bizDefine, (HRAffairBizBillEntryInfo)entry);
    }

    protected void processAlreadyEffectUnAuditEachEntry(Context ctx, HRBillBaseEntryInfo entry, Date effectDate) throws BOSException, EASBizException {
        this.unAuditEachEntryGlobaPropertyRecovery(ctx, (HRAffairBizBillEntryInfo)entry, effectDate);
        this._unAuditEachEntrySpecialPropertyRecovery(ctx, (HRAffairBizBillEntryInfo)entry);
    }

    @Override
    protected void _untiCheckBizBillEntry(Context ctx, String entryId) throws BOSException, EASBizException {
        String oql;
        IHRBillBaseEntry iHRBillBaseEntry = this.getEntryInterface(ctx);
        if (iHRBillBaseEntry.exists(oql = "where id = '" + entryId + "'")) {
            HRBillBaseEntryInfo entryInfo = iHRBillBaseEntry.getHRBillBaseEntryInfo(oql);
            this.processAlreadyEffectUnAuditEachEntry(ctx, entryInfo, null);
            EmpSalaryAdjDataUtil.delEmpSalaryAdjData(ctx, entryId);
        }
    }

    public void _unAuditEachEntrySpecialPropertyRecovery(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
    }

    public void unAuditEachEntryGlobaPropertyRecovery(Context ctx, HRAffairBizBillEntryInfo entry, Date effectDate) throws BOSException, EASBizException {
        AffairUnAuitAlreadyEffectFacadeFactory.getLocalInstance(ctx).grlobaPropertyUnAudit(entry);
    }

    protected Date getEmpPosBeginDate(HRBillBaseEntryInfo entry) throws EASBizException, BOSException {
        return this.getEffectDate(entry);
    }

    protected String getBillField() throws EASBizException, BOSException {
        String field = super.getBillField();
        if (StringUtils.isEmpty((String)field)) {
            field = "bill";
        }
        return field;
    }

    protected String getEntryField() throws EASBizException, BOSException {
        String entryField = super.getEntryField();
        if (StringUtils.isEmpty((String)entryField)) {
            entryField = "entrys";
        }
        return entryField;
    }

    protected String getEntryEffectDateField() throws EASBizException, BOSException {
        String field = super.getEntryEffectDateField();
        if (StringUtils.isEmpty((String)field)) {
            field = "bizDate";
        }
        return field;
    }

    protected String getEffectFunction(Context ctx) throws EASBizException, BOSException {
        String functionName = this.getEffectFunction();
        if (StringUtils.isEmpty((String)functionName)) {
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
            LinkPropertyInfo prop = (LinkPropertyInfo)entityInfo.getPropertyByNameRuntime(this.getEntryField());
            EntityObjectInfo clienEntityInfo = prop.getRelationship().getSupplierObject();
            functionName = clienEntityInfo.getName() + "EffectFunction";
        }
        return functionName;
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        EntityObjectInfo entityInfo;
        LinkPropertyInfo prop;
        EntityObjectInfo clienEntityInfo;
        String factory;
        IHRBillBaseEntry enFactroy = super.getEntryInterface(ctx);
        if (enFactroy == null && (factory = (clienEntityInfo = (prop = (LinkPropertyInfo)(entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType())).getPropertyByNameRuntime(this.getEntryField())).getRelationship().getSupplierObject()).getBusinessImplFactory()) != null) {
            enFactroy = (IHRBillBaseEntry)ReflectUtil.getLocalInstance((String)factory, (Context)ctx);
        }
        return enFactroy;
    }

    protected boolean isNeedRecorderUserPermission() {
        return false;
    }

    protected boolean isNeedDoWithUserPermission() {
        return false;
    }

    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        billInfo.setApproveType(ApproveTypeEnum.DIRECT);
        IObjectPK objectPK = super.save(ctx, model);
        this.initProgess(objectPK.toString(), model);
        this.checkBeforeSubmit(ctx, (IObjectValue)model);
        this.recordEmpPosChangeData(ctx, model);
        this.auditEntryEffect(ctx, BOSUuid.read((String)objectPK.toString()));
        return objectPK;
    }

    public void initProgess(String billId, CoreBaseInfo model) {
        HRAffairBillProgressUtil.initProgess(billId, model);
    }

    public void setProgressData(int curEntryNo, int entrysCount, String billId) {
        HRAffairBillProgressUtil.setProgressData(curEntryNo, entrysCount, billId);
    }

    private void recordEmpPosChangeData(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        String entryField = this.getEntryField();
        IObjectCollection entries = (IObjectCollection)model.get(entryField);
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        for (int i = 0; i < entries.size(); ++i) {
            Date bizDate = this.getEmpPosBeginDate((HRAffairBizBillEntryInfo)entries.getObject(i));
            if (!DateTimeUtils.dayBefore((Date)curDate, (Date)bizDate)) continue;
            HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)entries.getObject(i);
            SHRActionVerifyByPersonPlanTool.recordAffairBizActionEmpPosChangeData((Context)ctx, (HRAffairBizBillEntryInfo)entryInfo, (Date)bizDate);
            SHRActionVerifyByPersonPlanTool.refreshEmpPosChangeDataState((Context)ctx, (BOSUuid)billInfo.getId(), (HRBillStateEnum)HRBillStateEnum.AUDITED);
        }
    }

    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) || HRBillStateEnum.AUDITING.equals((Object)billState) || HRBillStateEnum.AUDITEND.equals((Object)billState)) {
                iHRBillBase.setSaved(BOSUuid.read((String)billId));
                SHRActionVerifyByPersonPlanTool.deleteEmpPosChangeData((Context)ctx, (BOSUuid)BOSUuid.read((String)billId));
                this.abortWorkFlow(ctx, billId);
                this.clearProcInstBizInfo(ctx, billInfo);
                SHRBizBillAttachmentReverseUtils.deleteBizBillAttachmentReverse((Context)ctx, (BOSUuid)BOSUuid.read((String)billId));
            } else {
                throw new AffairBizException(AffairBizException.BILLSTATECANTSUPPORT);
            }
        }
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAudited(ctx, billID);
        SHRActionVerifyByPersonPlanTool.refreshEmpPosChangeDataState((Context)ctx, (BOSUuid)billID, (HRBillStateEnum)HRBillStateEnum.AUDITED);
    }

    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditEnd(ctx, billID);
        SHRActionVerifyByPersonPlanTool.refreshEmpPosChangeDataState((Context)ctx, (BOSUuid)billID, (HRBillStateEnum)HRBillStateEnum.AUDITEND);
    }

    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditing(ctx, billID);
        SHRActionVerifyByPersonPlanTool.refreshEmpPosChangeDataState((Context)ctx, (BOSUuid)billID, (HRBillStateEnum)HRBillStateEnum.AUDITING);
    }

    protected void _setSubmited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setSubmited(ctx, billID);
    }

    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo billInfo = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            HRBillStateEnum billState = billInfo.getBillState();
            if (HRBillStateEnum.AUDITED.equals((Object)billState)) {
                iHRBillBase.passUnaudit(BOSUuid.read((String)billId));
                SHRActionVerifyByPersonPlanTool.deleteEmpPosChangeData((Context)ctx, (BOSUuid)BOSUuid.read((String)billId));
                AffairBizExtendCustomerTool.deleteCustomerExtendData((Context)ctx, (BOSUuid)BOSUuid.read((String)billId));
                SHRBizBillAttachmentReverseUtils.deleteBizBillAttachmentReverse((Context)ctx, (BOSUuid)BOSUuid.read((String)billId));
                this.delEmpSalaryAdjData(ctx, BOSUuid.read((String)billId));
            } else {
                throw new AffairBizException(AffairBizException.BILLSTATECANUNCHECK);
            }
        }
    }

    protected void delEmpSalaryAdjData(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)billID.getType());
        HRBillBaseInfo model = (HRBillBaseInfo)iCoreBillBase.getValue((IObjectPK)new ObjectUuidPK(billID));
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        HRBillBaseEntryInfo entry = null;
        HashSet<String> affairIdSet = new HashSet<String>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = (HRBillBaseEntryInfo)entries.getObject(i);
            affairIdSet.add(entry.getId().toString());
        }
        if (affairIdSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("affairId", affairIdSet, CompareType.INCLUDE));
            EmpSalaryAdjustmentFactory.getLocalInstance((Context)ctx).delete(filter);
        }
    }

    @Override
    protected void _abortBizBillEnd(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRAffairBizBill iHRBillBase = (IHRAffairBizBill)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            String sql = "select number,billState,entrys.id where id='" + billId + "'";
            HRAffairBizBillInfo billInfo = iHRBillBase.getHRAffairBizBillInfo(sql);
            IObjectCollection coll = (IObjectCollection)billInfo.get("entrys");
            HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)coll.getObject(0);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("billState"));
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            if (HRBillStateEnum.AUDITED == billInfo.getBillState()) {
                billInfo.setBillState(HRBillStateEnum.AUDITEND);
                iHRBillBase.updatePartial((CoreBaseInfo)billInfo, selector);
                String oql = "select billState,entryBizDate where entryID='" + entryInfo.getId() + "'";
                IHRAffairBiz iRAffairBiz = HRAffairBizFactory.getLocalInstance(ctx);
                HRAffairBizCollection affairBizColl = iRAffairBiz.getHRAffairBizCollection(oql.toString());
                if (affairBizColl.size() > 0) {
                    HRAffairBizInfo bizInfo = affairBizColl.get(0);
                    bizInfo.setBillState(HRBillStateEnum.AUDITEND);
                    iRAffairBiz.updatePartial(bizInfo, selector);
                    if (DateTimeUtils.dayBefore((Date)curDate, (Date)bizInfo.getEntryBizDate())) {
                        this.processUnEffectUnAudit(ctx, billId);
                    }
                }
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)this._getValue(ctx, pk);
        super._delete(ctx, pk);
        IObjectCollection coll = (IObjectCollection)billInfo.get("entrys");
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                HRAffairBizBillEntryInfo entry = (HRAffairBizBillEntryInfo)coll.getObject(i);
                this.deleteSalaryItemData(ctx, entry.getId());
            }
        }
    }

    protected void setEmployerUnitForEntry(IObjectValue model, HRAffairBizBillEntryInfo entry) {
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        HROrgUnitInfo hrUnitInfo = billInfo.getHrOrgUnit();
        entry.put("employerUnit", hrUnitInfo);
    }

    protected void setHrOrgUnitForEntry(Context ctx, IObjectValue model, HRAffairBizBillEntryInfo entry, EmpHRORelationHisInfo buRelationInfo) {
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        if (buRelationInfo != null && buRelationInfo.getHrOrgUnit() != null) {
            entry.setHrOrgUnit(buRelationInfo.getHrOrgUnit());
        } else if (entry.getHrOrgUnit() == null && billInfo.getHrOrgUnit() != null) {
            entry.setHrOrgUnit(billInfo.getHrOrgUnit());
        }
    }

    protected void setCompanyForEntry(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        if (entry.getCompany() == null && entry.getAdminOrg() != null && entry.getAdminOrg().getId() != null) {
            AdminOrgUnitInfo company = HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)entry.getAdminOrg());
            entry.setCompany(company);
        }
        if (entry.getOldCompany() == null && entry.getOldAdminOrg() != null && entry.getOldAdminOrg().getId() != null) {
            AdminOrgUnitInfo oldCompany = HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)entry.getOldAdminOrg());
            entry.setOldCompany(oldCompany);
        }
    }

    protected void setBillUseDefault(Context ctx, IObjectValue model, HRAffairBizBillEntryInfo entry, EmpHRORelationHisInfo buRelationInfo) throws BOSException, EASBizException {
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        billInfo.setUseDefault(buRelationInfo.isUseDefault());
        entry.setUseDefault(buRelationInfo.isUseDefault());
    }

    protected void reverseAttachment(Context ctx, HRAffairBizBillEntryInfo entry) throws EASBizException, BOSException {
        String entryField;
        HRAffairBizBillInfo hrAffairBizBillInfo = (HRAffairBizBillInfo)entry.get(this.getBillField());
        String billID = hrAffairBizBillInfo.getId().toString();
        if (StringUtils.isEmpty((String)billID)) {
            return;
        }
        String enrtryID = entry.getId().toString();
        String bosType = BOSUuid.read((String)enrtryID).getType().toString();
        if (bosType.equals("72314963") || bosType.equals("EE7E27FF")) {
            return;
        }
        String boID = "";
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        IObjectCollection entries = (IObjectCollection)model.get(entryField = this.getEntryField());
        if (entries.size() > 1) {
            return;
        }
        HRAffairBizBillEntryInfo hrAffairBizBillEntryInfo = (HRAffairBizBillEntryInfo)entries.getObject(0);
        Date bizDate = hrAffairBizBillEntryInfo.getBizDate();
        if (bizDate != null) {
            bizDate = DateTimeUtils.truncateDate((Date)bizDate);
        }
        if (bizDate != null && !SHRBizBillAttachmentReverseUtils.IsBizBillAttachmentReverse((Context)ctx, (String)enrtryID).booleanValue()) {
            return;
        }
        ISHRAttachmentExt attachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)billID));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SHRAttachmentExtCollection collection = attachmentExt.getSHRAttachmentExtCollection(entityViewInfo);
        if (collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                SHRAttachmentExtInfo shrAttachmentExtInfo = collection.get(i);
                String bunding = shrAttachmentExtInfo.getBunding();
                String[] split = bunding.split("#");
                String userId = split[0];
                SHRAttachmentExtInfo reverseAttachmentExtInfo = new SHRAttachmentExtInfo();
                reverseAttachmentExtInfo.setAttachment(shrAttachmentExtInfo.getAttachment());
                reverseAttachmentExtInfo.setPropertyName(shrAttachmentExtInfo.getPropertyName());
                reverseAttachmentExtInfo.setType(shrAttachmentExtInfo.getType());
                reverseAttachmentExtInfo.setState(AttachmentState.UNSAVE);
                if (bosType.equals("04BEFD73")) {
                    reverseAttachmentExtInfo.setBunding(userId + "#com.kingdee.eas.basedata.person.app.Person.form");
                } else {
                    reverseAttachmentExtInfo.setBunding(userId + "#com.kingdee.eas.hr.base.app.EmpPosOrgRelation.form");
                }
                reverseAttachmentExtInfo.setName(shrAttachmentExtInfo.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                reverseAttachmentExtInfo.setName(shrAttachmentExtInfo.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                reverseAttachmentExtInfo.setName(shrAttachmentExtInfo.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                reverseAttachmentExtInfo.setNumber(shrAttachmentExtInfo.getNumber());
                reverseAttachmentExtInfo.setDescription(shrAttachmentExtInfo.getDescription());
                reverseAttachmentExtInfo.setSimpleName(shrAttachmentExtInfo.getSimpleName());
                SHRAttachmentExtFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)reverseAttachmentExtInfo);
                EmpPosOrgRelationCollection empPosOrgRelationCollection = null;
                if (bosType.equals("04BEFD73")) {
                    if (entry.getPerson() == null) continue;
                    boID = entry.getPerson().getId().toString();
                    SHRAttachmentExtFactory.getLocalInstance((Context)ctx).updateAffterSaveForm(boID, userId + "#com.kingdee.eas.basedata.person.app.Person.form");
                    continue;
                }
                if (!bosType.equals("C3C63B6C")) {
                    String sql = "select * where flowInAffairID = '" + enrtryID + "'";
                    if (bosType.equals("929FE0E0") || bosType.equals("9F92C3DB")) {
                        sql = "select * where flowInAffairID = '" + enrtryID + "' and assignType = 0";
                    }
                    empPosOrgRelationCollection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(sql);
                } else {
                    empPosOrgRelationCollection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection("select * where flowOutAffairID = '" + enrtryID + "'");
                }
                if (empPosOrgRelationCollection == null || empPosOrgRelationCollection.size() <= 0) continue;
                for (int j = 0; j < empPosOrgRelationCollection.size(); ++j) {
                    EmpPosOrgRelationInfo empPosOrgRelationInfo = empPosOrgRelationCollection.get(0);
                    if (empPosOrgRelationInfo == null) continue;
                    boID = empPosOrgRelationInfo.getId().toString();
                    SHRAttachmentExtFactory.getLocalInstance((Context)ctx).updateAffterSaveForm(boID, userId + "#com.kingdee.eas.hr.base.app.EmpPosOrgRelation.form");
                }
            }
        }
        this.reverseAttachmentForBoAttch(ctx, entry, collection, billID);
    }

    protected void reverseAttachmentForBoAttch(Context ctx, HRAffairBizBillEntryInfo entry, SHRAttachmentExtCollection collection, String billID) throws EASBizException, BOSException {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String boID = "";
        IBoAttchAsso boAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        String enrtryID = entry.getId().toString();
        String bosType = BOSUuid.read((String)enrtryID).getType().toString();
        BoAttchAssoCollection boColl = this.getBoAttchAssoCol(boAttchAsso, billID);
        List<AttachmentInfo> list = this.getNoPropertyNameAttch(collection, boColl);
        if (!list.isEmpty()) {
            for (AttachmentInfo ai : list) {
                SHRAttachmentExtInfo reverseAttachmentExtInfo = new SHRAttachmentExtInfo();
                if (bosType.equals("04BEFD73")) {
                    reverseAttachmentExtInfo.setBunding(userId + "#com.kingdee.eas.basedata.person.app.Person.form");
                } else {
                    reverseAttachmentExtInfo.setBunding(userId + "#com.kingdee.eas.hr.base.app.EmpPosOrgRelation.form");
                }
                if (ai.getCreator() != null && ai.getCreator().getId() != null) {
                    userId = ai.getCreator().getId().toString();
                }
                reverseAttachmentExtInfo.setAttachment(ai);
                reverseAttachmentExtInfo.setPropertyName("null0");
                reverseAttachmentExtInfo.setType(AttachmentTypeEnum.FORM);
                reverseAttachmentExtInfo.setState(AttachmentState.UNSAVE);
                reverseAttachmentExtInfo.setName(ai.getName(LocaleUtils.locale_l1) + "." + ai.getSimpleName(), LocaleUtils.locale_l1);
                reverseAttachmentExtInfo.setName(ai.getName(LocaleUtils.locale_l2) + "." + ai.getSimpleName(), LocaleUtils.locale_l2);
                reverseAttachmentExtInfo.setName(ai.getName(LocaleUtils.locale_l3) + "." + ai.getSimpleName(), LocaleUtils.locale_l3);
                reverseAttachmentExtInfo.setDescription(ai.getDescription());
                reverseAttachmentExtInfo.setSimpleName(ai.getSimpleName());
                SHRAttachmentExtFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)reverseAttachmentExtInfo);
                EmpPosOrgRelationCollection empPosOrgRelationCollection = null;
                if (bosType.equals("04BEFD73")) {
                    if (entry.getPerson() == null) continue;
                    boID = entry.getPerson().getId().toString();
                    SHRAttachmentExtFactory.getLocalInstance((Context)ctx).updateAffterSaveForm(boID, userId + "#com.kingdee.eas.basedata.person.app.Person.form");
                    continue;
                }
                if (!bosType.equals("C3C63B6C")) {
                    String sql = "select * where flowInAffairID = '" + enrtryID + "'";
                    if (bosType.equals("929FE0E0") || bosType.equals("9F92C3DB")) {
                        sql = "select * where flowInAffairID = '" + enrtryID + "' and assignType = 0";
                    }
                    empPosOrgRelationCollection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(sql);
                } else {
                    empPosOrgRelationCollection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection("select * where flowOutAffairID = '" + enrtryID + "'");
                }
                if (empPosOrgRelationCollection == null || empPosOrgRelationCollection.size() <= 0) continue;
                for (int j = 0; j < empPosOrgRelationCollection.size(); ++j) {
                    EmpPosOrgRelationInfo empPosOrgRelationInfo = empPosOrgRelationCollection.get(0);
                    if (empPosOrgRelationInfo == null) continue;
                    boID = empPosOrgRelationInfo.getId().toString();
                    SHRAttachmentExtFactory.getLocalInstance((Context)ctx).updateAffterSaveForm(boID, userId + "#com.kingdee.eas.hr.base.app.EmpPosOrgRelation.form");
                }
            }
        }
    }

    public BoAttchAssoCollection getBoAttchAssoCol(IBoAttchAsso boAttchAsso, String boid) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boid", (Object)boid));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("attachment.size"));
        sic.add(new SelectorItemInfo("attachment.id"));
        sic.add(new SelectorItemInfo("attachment.name"));
        sic.add(new SelectorItemInfo("attachment.simplename"));
        sic.add(new SelectorItemInfo("attachment.description"));
        sic.add(new SelectorItemInfo("attachment.creator.name"));
        sic.add(new SelectorItemInfo("attachment.createTime"));
        entityViewInfo.setSelector(sic);
        return boAttchAsso.getBoAttchAssoCollection(entityViewInfo);
    }

    public List<AttachmentInfo> getNoPropertyNameAttch(SHRAttachmentExtCollection extColl, BoAttchAssoCollection boColl) {
        ArrayList<AttachmentInfo> list = new ArrayList<AttachmentInfo>();
        ArrayList<String> attchIds = new ArrayList<String>();
        if (extColl.size() == boColl.size()) {
            return list;
        }
        if (extColl.size() > 0) {
            for (int j = 0; j < extColl.size(); ++j) {
                AttachmentInfo attj = extColl.get(j).getAttachment();
                if (attj == null || attj.getId() == null) continue;
                attchIds.add(attj.getId().toString());
            }
        }
        if (boColl.size() > 0) {
            for (int i = 0; i < boColl.size(); ++i) {
                AttachmentInfo atti = boColl.get(i).getAttachment();
                if (atti == null || atti.getId() == null || attchIds.contains(atti.getId().toString())) continue;
                list.add(atti);
            }
        }
        return list;
    }

    protected void doForbidUser(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)entry;
        PersonInfo pInfo = entryInfo.getPerson();
        if (pInfo == null) {
            return;
        }
        EmployeeTypeInfo empType = entryInfo.getEmpType();
        if (empType != null) {
            empType = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(empType.getId()));
        }
        if (empType != null && empType.getUserState() != null && empType.getUserState().getValue() == 2) {
            EmpEnrollUserPermHelper.autoForbidUser((Context)ctx, (PersonInfo)pInfo);
            HRBillAppUtils.deleteUsers((Context)ctx, (String)pInfo.getId().toString());
        } else if (empType != null && empType.getUserState() != null && empType.getUserState().getValue() == 1) {
            EmpEnrollUserPermHelper.unForbidUser((Context)ctx, (PersonInfo)pInfo);
        }
    }

    protected void createUserBackGroundJob(Context ctx, IObjectValue ov, String jobKey) throws EASBizException, BOSException {
        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
        String funcName = this.getEffectFunction(ctx);
        if (!StringUtils.isEmpty((String)funcName)) {
            MetaDataPK functionPK = new MetaDataPK(funcName);
            FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
            OperationInfo operation = function.getOperation().get(1);
            HashMap<String, Object> jobContext = new HashMap<String, Object>();
            jobContext.put(jobKey, ov.get("id"));
            SecureRandom random = null;
            try {
                random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                throw new BOSException();
            }
            java.sql.Date forbidUserDate = ov.getDate("forbidUserDate");
            java.sql.Date bizDate = ov.getDate("bizDate");
            Date date = null;
            date = forbidUserDate != null ? forbidUserDate : bizDate;
            date = DateTimeUtils.addMinute((Date)date, (long)(60 + (random != null ? random.nextInt(60) : 0)));
            date = DateTimeUtils.addSecond((Date)date, (long)(random != null ? random.nextInt(60) : 0));
            String jobProcessDefID = service.createJobProcessDef(this.getUserBackProcessName(ctx, ov), function, operation, jobContext, this.getSchedule(date), ctx.getLocale());
            if (!StringUtils.isEmpty((String)jobProcessDefID)) {
                String sql = "update t_job_def set fproxyuserid = fcreateuserid where fjobdefid = '" + jobProcessDefID + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            BillEntryJobProcessInfo bejpInfo = new BillEntryJobProcessInfo();
            bejpInfo.setId(BOSUuid.create((String)"CC1195F2"));
            bejpInfo.setBillEntryId(ov.get("id").toString());
            bejpInfo.setJobProcessId(jobProcessDefID);
            BillEntryJobProcessFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)bejpInfo);
        }
    }

    private String getUserBackProcessName(Context ctx, IObjectValue ov) {
        BOSUuid id = (BOSUuid)ov.get("id");
        BOSObjectType type = id.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo eInfo = loader.getEntity(type);
        String alias = eInfo.getAlias();
        String backProcessName = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource", (String)"FORBIDUSER", (Context)ctx);
        return alias + backProcessName + "(" + id.toString() + ")";
    }

    protected Object processException(Exception e) {
        EmpLog.getLog().error((Object)e.getMessage(), (Throwable)e);
        return null;
    }

    public void setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        try {
            ServiceContext svcCtx = this.createServiceContext(new MetaDataPK("e22c89a7-53eb-45e1-9569-d0a862796bc0"), new Object[]{ctx, billID});
            this.invokeServiceBefore(svcCtx);
            if (!svcCtx.invokeBreak()) {
                this._setAudited(ctx, billID);
            }
            this.invokeServiceAfter(svcCtx);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            this.processException((Exception)((Object)ex));
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            this.processException((Exception)((Object)ex0));
            throw ex0;
        }
        catch (Exception ex1) {
            this.setRollbackOnly();
            this.processException(ex1);
            throw new BOSException(ex1.getMessage(), (Throwable)ex1);
        }
        finally {
            super.cleanUpServiceState();
        }
    }

    protected void checkEntryIsEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        if (entry == null || entry.getId() == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("flowInAffairID", (Object)entry.getId().toString()));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        entityViewInfo.setSelector(sic);
        CoreBaseCollection colls = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getCollection(entityViewInfo);
        if (colls != null && colls.size() > 0) {
            throw new EmpAffairBizBillException(EmpAffairBizBillException.BILLENTRY_EFFECT_EXCEPTION);
        }
    }

    protected void createBackGroundJob(Context ctx, IObjectValue ov, String jobKey) throws EASBizException, BOSException {
        super.createBackGroundJob(ctx, ov, jobKey);
        String enrtryID = ov.get("id").toString();
        String bosType = BOSUuid.read((String)enrtryID).getType().toString();
        if (bosType.equals("72314963") || bosType.equals("EE7E27FF")) {
            return;
        }
        SHRBizBillAttachmentReverseUtils.saveBizBillAttachmentReverse((Context)ctx, (String)enrtryID);
    }

    protected void dropJobProcess(Context ctx, String billEntryIdStr) throws EASBizException, BOSException {
        block8: {
            BillEntryJobProcessCollection bejpCol = BillEntryJobProcessFactory.getLocalInstance((Context)ctx).getBillEntryJobProcessCollection("where billEntryId in (" + billEntryIdStr + ")");
            StringBuffer jobProcessIdStr = new StringBuffer();
            int size = bejpCol.size();
            for (int i = 0; i < size; ++i) {
                BillEntryJobProcessInfo bejpInfo = bejpCol.get(i);
                jobProcessIdStr.append("'");
                jobProcessIdStr.append(bejpInfo.getJobProcessId());
                if (i == size - 1) {
                    jobProcessIdStr.append("'");
                    continue;
                }
                jobProcessIdStr.append("',");
            }
            if (jobProcessIdStr == null || jobProcessIdStr.length() == 0) {
                return;
            }
            IJobService jobService = JobServiceFactory.getLocalInstance((Context)ctx);
            String sql = "SELECT FID FROM T_JOB_Trigger WHERE FJobDefID in (" + jobProcessIdStr + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    rs.beforeFirst();
                    while (rs.next()) {
                        String triggerId = rs.getString(1);
                        jobService.disableTrigger(triggerId);
                    }
                    break block8;
                }
                throw new HRAffairException(HRAffairException.TRY_LATER_TIME);
            }
            catch (HRAffairException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void refreshEmpPostExperience(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    protected void refreshResignBillForExperience(Context ctx, HRBillBaseEntryInfo entryInfo) throws BOSException, EASBizException {
    }

    protected void checkPersonIsResign(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
    }

    protected void executeOther(Context ctx, HRBillBaseEntryInfo entry, Exception exception) throws BOSException {
        try {
            String realizeClassName = "com.kingdee.eas.hr.affair.app.HRAffairBizBillControllerBean";
            String realizeMethodName = "addHRAffairBillSuspendRecord";
            Class<?> cls = Class.forName(realizeClassName);
            Method method = cls.getMethod(realizeMethodName, Context.class, HRBillBaseEntryInfo.class, Exception.class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(cls.newInstance());
            txInvoker.invoke(method, new Object[]{ctx, entry, exception}, 3);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), e);
        }
    }

    public void addHRAffairBillSuspendRecord(Context ctx, HRBillBaseEntryInfo entry, Exception exception) {
        try {
            HRAffairBizBillEntryInfo affairEntry = (HRAffairBizBillEntryInfo)entry;
            PersonInfo personInfo = affairEntry.getPerson();
            String billField = this.getBillField();
            HRBillBaseInfo bill = (HRBillBaseInfo)affairEntry.get(billField);
            HRAffairBillSuspendRecordInfo hrAffairBillSuspendRecordInfo = new HRAffairBillSuspendRecordInfo();
            HRAffairBillSuspendRecordCollection hrAffairBillSuspendRecordCollection = HRAffairBillSuspendRecordFactory.getLocalInstance(ctx).getHRAffairBillSuspendRecordCollection("where billId ='" + bill.getId() + "' and entryId='" + affairEntry.getId() + "'");
            if (hrAffairBillSuspendRecordCollection.size() > 0) {
                hrAffairBillSuspendRecordInfo = hrAffairBillSuspendRecordCollection.get(0);
            }
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bill.getBOSType());
            hrAffairBillSuspendRecordInfo.setBizBillType(entityInfo.getAlias());
            hrAffairBillSuspendRecordInfo.setBosType(bill.getBOSType().toString());
            hrAffairBillSuspendRecordInfo.setNumber(bill.getNumber());
            hrAffairBillSuspendRecordInfo.setBillId(bill.getId());
            hrAffairBillSuspendRecordInfo.setEntryId(affairEntry.getId());
            if (personInfo == null) {
                hrAffairBillSuspendRecordInfo.setPersonName((String)affairEntry.get("empName"));
                hrAffairBillSuspendRecordInfo.setPersonNumber((String)affairEntry.get("empNumber"));
            } else {
                if (personInfo.getId() != null) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("name"));
                    selector.add(new SelectorItemInfo("number"));
                    personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personInfo.getId().toString()), selector);
                }
                hrAffairBillSuspendRecordInfo.setPersonName(personInfo.getName());
                hrAffairBillSuspendRecordInfo.setPersonNumber(personInfo.getNumber());
            }
            hrAffairBillSuspendRecordInfo.setBizDate(affairEntry.getBizDate());
            hrAffairBillSuspendRecordInfo.setIsDelete(false);
            hrAffairBillSuspendRecordInfo.setState(SuspendRecordStateEnum.NOT_EFFECT);
            String message = exception.getMessage() != null ? (exception.getMessage().length() > 1000 ? exception.getMessage().substring(0, 1000) : exception.getMessage()) : "";
            hrAffairBillSuspendRecordInfo.setReason(message);
            hrAffairBillSuspendRecordInfo.setStack(this.printStackToString(exception));
            HRAffairBillSuspendRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)hrAffairBillSuspendRecordInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String printStackToString(Exception e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        e.printStackTrace(ps);
        ps.flush();
        String stack = "";
        if (!StringUtils.isEmpty((String)out.toString())) {
            stack = out.toString().length() > 2000 ? out.toString().substring(0, 2000) : out.toString();
        }
        return stack;
    }

    protected void handlerBackQuitLimit(Context ctx, String billId, HRBillStateEnum billState) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)billId)) {
            IHRBillBase iHRBillBase = (IHRBillBase)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            HRBillBaseInfo model = iHRBillBase.getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId));
            String quitLimit = (String)HRParamUtil.getParamByKey((Context)ctx, null, (String)"SHR_Leave_QuitLimit");
            LeaveQuitLimitEnum paramLimit = LeaveQuitLimitEnum.effect;
            if (!StringUtils.isEmpty((String)quitLimit)) {
                paramLimit = LeaveQuitLimitEnum.getEnum((String)quitLimit);
            }
            if (LeaveQuitLimitEnum.effect.equals((Object)paramLimit)) {
                return;
            }
            if (HRBillStateEnum.SUBMITED.equals((Object)billState) && !LeaveQuitLimitEnum.submit.equals((Object)paramLimit)) {
                return;
            }
            IObjectCollection entries = (IObjectCollection)model.get("entrys");
            for (int i = 0; i < entries.size(); ++i) {
                HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)entries.getObject(i);
                this.handlerBackQuitLimitByEntry(ctx, entryInfo);
            }
        }
    }

    protected void handlerBackQuitLimitByEntryId(Context ctx, String entryId, HRBillStateEnum billState) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)entryId)) {
            IHRAffairBizBillEntry ihrAffairBizBillEntry = (IHRAffairBizBillEntry)MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)entryId).getType());
            HRAffairBizBillEntryInfo entryInfo = ihrAffairBizBillEntry.getHRAffairBizBillEntryInfo((IObjectPK)new ObjectUuidPK(entryId));
            String quitLimit = (String)HRParamUtil.getParamByKey((Context)ctx, null, (String)"SHR_Leave_QuitLimit");
            LeaveQuitLimitEnum paramLimit = LeaveQuitLimitEnum.effect;
            if (!StringUtils.isEmpty((String)quitLimit)) {
                paramLimit = LeaveQuitLimitEnum.getEnum((String)quitLimit);
            }
            if (LeaveQuitLimitEnum.effect.equals((Object)paramLimit) || HRBillStateEnum.SUBMITED.equals((Object)billState) && !LeaveQuitLimitEnum.submit.equals((Object)paramLimit)) {
                return;
            }
            this.handlerBackQuitLimitByEntry(ctx, entryInfo);
        }
    }

    protected void handlerQuitLimit(Context ctx, HRAffairBizBillInfo model, HRBillStateEnum billState) throws EASBizException, BOSException {
        String quitLimit = (String)HRParamUtil.getParamByKey((Context)ctx, null, (String)"SHR_Leave_QuitLimit");
        LeaveQuitLimitEnum paramLimit = LeaveQuitLimitEnum.effect;
        if (!StringUtils.isEmpty((String)quitLimit)) {
            paramLimit = LeaveQuitLimitEnum.getEnum((String)quitLimit);
        }
        if (LeaveQuitLimitEnum.effect.equals((Object)paramLimit)) {
            return;
        }
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        switch (billState.getValue()) {
            case 1: {
                if (!LeaveQuitLimitEnum.submit.equals((Object)paramLimit)) break;
                this.directQuitLimit(ctx, entries);
                break;
            }
            case 2: {
                if (!LeaveQuitLimitEnum.submit.equals((Object)paramLimit)) break;
                this.calculateQuitLimit(ctx, model);
                break;
            }
            case 3: {
                if (LeaveQuitLimitEnum.submit.equals((Object)paramLimit) && model.get("submitEffectFlag") == null) {
                    this.calculateQuitLimit(ctx, model);
                }
                if ((!LeaveQuitLimitEnum.submit.equals((Object)paramLimit) || model.get("submitEffectFlag") == null) && !LeaveQuitLimitEnum.audited.equals((Object)paramLimit)) break;
                this.directQuitLimit(ctx, entries);
            }
        }
    }

    protected void calculateQuitLimit(Context ctx, HRAffairBizBillInfo model) throws EASBizException, BOSException {
        IObjectCollection entries = (IObjectCollection)model.get("entrys");
        if (model.getId() == null || !this._exists(ctx, (IObjectPK)new ObjectUuidPK(model.getId()))) {
            this.directQuitLimit(ctx, entries);
            return;
        }
        HashMap<String, Object> oldpersonMap = new HashMap<String, Object>();
        HRAffairBizBillInfo oldModel = this.getHRAffairBizBillInfo(ctx, (IObjectPK)new ObjectUuidPK(model.getId()));
        IObjectCollection oldEntries = (IObjectCollection)oldModel.get("entrys");
        for (int i = 0; i < oldEntries.size(); ++i) {
            HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)oldEntries.getObject(i);
            oldpersonMap.put(entryInfo.getPerson().getId().toString(), entryInfo.get("leftCompanyDate"));
        }
        HashMap<String, Object> personMap = new HashMap<String, Object>();
        for (int i = 0; i < entries.size(); ++i) {
            HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)entries.getObject(i);
            personMap.put(entryInfo.getPerson().getId().toString(), entryInfo.get("leftCompanyDate"));
        }
        HashSet<Object> oldPersonIdSet = new HashSet();
        if (oldpersonMap.size() > 0) {
            oldPersonIdSet = new HashSet(oldpersonMap.keySet());
            oldPersonIdSet.addAll(oldpersonMap.keySet());
        }
        HashSet personIdSet = new HashSet();
        if (oldpersonMap.size() > 0) {
            personIdSet.addAll(oldpersonMap.keySet());
        }
        HashSet<Object> oldPersonIdSetCopy = new HashSet<Object>(oldPersonIdSet);
        HashSet personIdSetCopy = new HashSet(personIdSet);
        oldPersonIdSetCopy.removeAll(personIdSet);
        personIdSetCopy.removeAll(oldPersonIdSet);
        personIdSet.retainAll(oldPersonIdSet);
        HashMap<String, String> backParam = new HashMap<String, String>();
        for (Object personId : oldPersonIdSetCopy) {
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK((String)personId));
            backParam.put("personNumber", personInfo.getNumber());
            backParam.put("leftDate", DateTimeUtils.format((Date)((Date)oldpersonMap.get(personId)), (String)"yyyy-MM-dd"));
            HolidayLimitUtil.quitBackLimitService(ctx, backParam);
        }
        HashMap<String, String> quitParam = new HashMap<String, String>();
        for (String personId : personIdSetCopy) {
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            quitParam.put("personNumber", personInfo.getNumber());
            quitParam.put("leftDate", DateTimeUtils.format((Date)((Date)personMap.get(personId)), (String)"yyyy-MM-dd"));
            HolidayLimitUtil.quitLimitService(ctx, quitParam);
        }
        HashMap<String, String> backAndQuitParam = new HashMap<String, String>();
        for (String personId : personIdSet) {
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            backAndQuitParam.put("personNumber", personInfo.getNumber());
            if (!DateTimeUtils.dayEquals((Date)((Date)oldpersonMap.get(personId)), (Date)((Date)personMap.get(personId)))) {
                backAndQuitParam.put("leftDate", DateTimeUtils.format((Date)((Date)oldpersonMap.get(personId)), (String)"yyyy-MM-dd"));
                HolidayLimitUtil.quitBackLimitService(ctx, backAndQuitParam);
            }
            backAndQuitParam.put("leftDate", DateTimeUtils.format((Date)((Date)personMap.get(personId)), (String)"yyyy-MM-dd"));
            HolidayLimitUtil.quitLimitService(ctx, backAndQuitParam);
        }
    }

    protected void directQuitLimit(Context ctx, IObjectCollection entries) throws BOSException, EASBizException {
        HashMap<String, String> param = new HashMap<String, String>();
        for (int i = 0; i < entries.size(); ++i) {
            HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)entries.getObject(i);
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(entryInfo.getPerson().getId()));
            param.put("personNumber", personInfo.getNumber());
            param.put("leftDate", DateTimeUtils.format((Date)((Date)entryInfo.get("leftCompanyDate")), (String)"yyyy-MM-dd"));
            HolidayLimitUtil.quitLimitService(ctx, param);
        }
    }

    private void handlerBackQuitLimitByEntry(Context ctx, HRAffairBizBillEntryInfo entryInfo) throws BOSException, EASBizException {
        HashMap<String, String> backParam = new HashMap<String, String>();
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(entryInfo.getPerson().getId()));
        backParam.put("personNumber", personInfo.getNumber());
        backParam.put("leftDate", DateTimeUtils.format((Date)((Date)entryInfo.get("leftCompanyDate")), (String)"yyyy-MM-dd"));
        HolidayLimitUtil.quitBackLimitService(ctx, backParam);
    }
}

