/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.LoanBizBillEntryCollection;
import com.kingdee.eas.hr.affair.LoanBizBillEntryFactory;
import com.kingdee.eas.hr.affair.LoanBizBillEntryInfo;
import com.kingdee.eas.hr.affair.LoanBizBillFactory;
import com.kingdee.eas.hr.affair.LoanBizBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractLoanBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.LoanBillBizBean;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.emp.IPersonLoan;
import com.kingdee.eas.hr.emp.LoanStateEnum;
import com.kingdee.eas.hr.emp.PersonLoanCollection;
import com.kingdee.eas.hr.emp.PersonLoanFactory;
import com.kingdee.eas.hr.emp.PersonLoanInfo;
import com.kingdee.eas.hr.emp.PersonLoanOutBackState;
import com.kingdee.eas.hr.emp.app.util.FluctuationInOutUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptOrgnizationTool;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;

public class LoanBizBillControllerBean
extends AbstractLoanBizBillControllerBean {
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanBizBillInfo billInfo = (LoanBizBillInfo)model;
        return super._addnew(ctx, model);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanBizBillInfo billInfo = (LoanBizBillInfo)model;
        return super._submit(ctx, model);
    }

    @Override
    protected String getBillField() {
        return "bill";
    }

    @Override
    protected String getEntryField() {
        return "entrys";
    }

    @Override
    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.affair.app.LoanBizBillEffectFunction";
    }

    @Override
    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return LoanBizBillEntryFactory.getLocalInstance(ctx);
    }

    @Override
    protected IHRBillBizBean getBizBean() {
        return new LoanBillBizBean();
    }

    protected void _beforeEffectBeforeBackJob(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        this.lastCheck(ctx, entry);
        super._beforeEffectBeforeBackJob(ctx, entry);
    }

    protected void _beforeEffectOnNoJob(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        this.lastCheck(ctx, entry);
        super._beforeEffectOnNoJob(ctx, entry);
    }

    private void lastCheck(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        LoanBizBillEntryInfo einfo = (LoanBizBillEntryInfo)entry;
        if (einfo.getPosition() == null) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"35_LoanBizBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (einfo.getAdminOrg() == null) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"36_LoanBizBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    protected void _doWithPriorityThingEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithPriorityThingEffect(ctx, entry);
    }

    @Override
    protected void _doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithSpecialFiledsEffect(ctx, entry);
        LoanBizBillEntryInfo loanEntryInfo = (LoanBizBillEntryInfo)entry;
        FluctuationInOutUtil.updateFluctuationInOutData((Context)ctx, (HRAffairBizBillEntryInfo)entry);
        this.savePersonLoanInfo(ctx, loanEntryInfo);
    }

    @Override
    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._entryEffect(ctx, entry);
    }

    private void savePersonLoanInfo(Context ctx, LoanBizBillEntryInfo entryInfo) throws BOSException, EASBizException {
        LoanBizBillInfo billInfo = entryInfo.getBill();
        PersonInfo personInfo = entryInfo.getPerson();
        PersonLoanInfo personLoanInfo = AffairUtil.getPersonLoanInfo(ctx, personInfo);
        if (personLoanInfo != null) {
            PositionInfo position = AffairUtil.getPosition(ctx, entryInfo.getPosition());
            String positionStr = position.getName();
            AdminOrgUnitInfo adminOrg = AffairUtil.getAdmin(ctx, entryInfo.getAdminOrg());
            String adminOrgStr = adminOrg.getName();
            PersonInfo person = AffairUtil.getPerson(ctx, entryInfo.getPerson());
            String personStr = person.getName();
            String errorMsg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label17", (Context)ctx), personStr, adminOrgStr, positionStr);
            NumericExceptionSubItem EXCEPTION = new NumericExceptionSubItem("000", errorMsg);
            throw new HRCommonException(EXCEPTION);
        }
        personLoanInfo = new PersonLoanInfo();
        personLoanInfo.setOutPosition(entryInfo.getOldPosition());
        personLoanInfo.setOutAdmin(entryInfo.getOldAdminOrg());
        personLoanInfo.setOutJob(entryInfo.getOldJob());
        personLoanInfo.setInPosition(entryInfo.getPosition());
        personLoanInfo.setInAdmin(entryInfo.getAdminOrg());
        personLoanInfo.setInJob(entryInfo.getJob());
        personLoanInfo.setLoanEndDate(entryInfo.getLoanEndDate());
        personLoanInfo.setLoanDate(entryInfo.getBizDate());
        personLoanInfo.setLoanEffectDate(entryInfo.getLoanEffectDate());
        personLoanInfo.setLoanEntryId(entryInfo.getId().toString());
        personLoanInfo.setPerson(entryInfo.getPerson());
        personLoanInfo.setOutBillNumber(billInfo.getNumber());
        personLoanInfo.setPersonLoanState(PersonLoanOutBackState.loaning);
        personLoanInfo.setState(LoanStateEnum.present);
        personLoanInfo.setOutBillDesc(AffairUtil.getLoanDescription(ctx, personLoanInfo, entryInfo));
        personLoanInfo.setOutRemark(entryInfo.getDescription());
        personLoanInfo.setIsSingle(true);
        IObjectPK pk = PersonLoanFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)personLoanInfo);
        this.updateIsSingles(ctx, pk, entryInfo.getPerson().getId().toString());
    }

    public void updateIsSingles(Context ctx, IObjectPK pk, String personId) throws BOSException, EASBizException {
        PersonLoanCollection infoCollection = PersonLoanFactory.getLocalInstance((Context)ctx).getPersonLoanCollection("where person = '" + personId + "'");
        PersonLoanCollection updateCollection = new PersonLoanCollection();
        if (null != infoCollection) {
            for (int i = 0; i < infoCollection.size(); ++i) {
                if (null == infoCollection.get(i) || pk.toString().equals(infoCollection.get(i).getId().toString()) || !infoCollection.get(i).isIsSingle()) continue;
                infoCollection.get(i).setIsSingle(false);
                updateCollection.add(infoCollection.get(i));
            }
        }
        this.addAndUpdate(ctx, updateCollection);
    }

    private IObjectPK[] addAndUpdate(Context ctx, PersonLoanCollection degreeColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        for (int i = 0; i < degreeColl.size(); ++i) {
            if (degreeColl.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)degreeColl.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(degreeColl.get(i).getId()), (IObjectValue)degreeColl.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    protected String getPermItemNameDelete() {
        return "loan_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "loan_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "loan_Update";
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LoanBizBillInfo BillInfo = LoanBizBillFactory.getLocalInstance(ctx).getLoanBizBillInfo(pk);
        LoanBizBillEntryCollection billEntryCol = BillInfo.getEntrys();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    @Override
    public void _unAuditEachEntrySpecialPropertyRecovery(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        LoanBizBillEntryInfo entryInfo = (LoanBizBillEntryInfo)entry;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("loanEntryId", (Object)entryInfo.getId().toString()));
        IPersonLoan iPersonLoan = PersonLoanFactory.getLocalInstance((Context)ctx);
        if (iPersonLoan.exists(filterInfo)) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filterInfo);
            PersonLoanCollection coll = iPersonLoan.getPersonLoanCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                PersonLoanInfo pLoanInfo = coll.get(i);
                if (pLoanInfo.getBackEffectDate() == null || pLoanInfo.getState() != LoanStateEnum.history) continue;
                throw new HRAffairException(HRAffairException.PERSON_HAS_LOANBACK_CANT_UN_LOAN);
            }
            iPersonLoan.delete(filterInfo);
            this.updateNewIsSingles(ctx, coll);
        }
    }

    private void updateNewIsSingles(Context ctx, PersonLoanCollection coll) throws BOSException, EASBizException {
        if (null == coll) {
            return;
        }
        PersonLoanCollection updateCollection = new PersonLoanCollection();
        for (int i = 0; i < coll.size(); ++i) {
            PersonLoanCollection infoCollection = PersonLoanFactory.getLocalInstance((Context)ctx).getPersonLoanCollection("where person = '" + coll.get(i).getPerson().getId().toString() + "'");
            if (null == infoCollection) continue;
            for (int j = 0; j < infoCollection.size(); ++j) {
                if (null == infoCollection.get(j) || coll.get(i).getId().toString().equals(infoCollection.get(j).getId().toString()) || !infoCollection.get(j).isIsSingle()) continue;
                infoCollection.get(i).setIsSingle(false);
                updateCollection.add(infoCollection.get(i));
            }
        }
        this.addAndUpdate(ctx, updateCollection);
    }

    @Override
    protected boolean isNeedRecorderUserPermission() {
        return true;
    }

    @Override
    protected boolean isNeedDoWithUserPermission() {
        return true;
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
    }

    @Override
    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        IObjectPK objectPK = super._submitEffect(ctx, model);
        return objectPK;
    }

    @Override
    protected HRAffairBizBillEntryInfo storefieldsForEntry(Context ctx, HRAffairBizBillInfo billInfo, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        PositionInfo positionInfo;
        if (entryInfo.getAdminOrg() == null && (positionInfo = entryInfo.getPosition()) != null) {
            entryInfo.setAdminOrg(SHREmpOptOrgnizationTool.getAdminOrgUnitByPosition((Context)ctx, (String)positionInfo.getId().toString()));
        }
        super.storefieldsForEntry(ctx, billInfo, entryInfo);
        return entryInfo;
    }
}

