/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.LoanInBizBillEntryCollection;
import com.kingdee.eas.hr.affair.LoanInBizBillEntryFactory;
import com.kingdee.eas.hr.affair.LoanInBizBillEntryInfo;
import com.kingdee.eas.hr.affair.LoanInBizBillFactory;
import com.kingdee.eas.hr.affair.LoanInBizBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractLoanInBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.HrAffairFillEmptyBizDefineUtil;
import com.kingdee.eas.hr.affair.app.LoanInBillBizBean;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.util.AffairUnAuditAppUtils;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.CompleteStateEnum;
import com.kingdee.eas.hr.emp.FluctuationInOutCollection;
import com.kingdee.eas.hr.emp.FluctuationInOutFactory;
import com.kingdee.eas.hr.emp.FluctuationInOutInfo;
import com.kingdee.eas.hr.emp.IFluctuationInOut;
import com.kingdee.eas.hr.emp.IPersonLoan;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.LoanStateEnum;
import com.kingdee.eas.hr.emp.PersonLoanCollection;
import com.kingdee.eas.hr.emp.PersonLoanFactory;
import com.kingdee.eas.hr.emp.PersonLoanInfo;
import com.kingdee.eas.hr.emp.PersonLoanOutBackState;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.util.FluctuationInOutUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptOrgnizationTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.MessageFormat;
import java.util.Date;

public class LoanInBizBillControllerBean
extends AbstractLoanInBizBillControllerBean {
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanInBizBillInfo billInfo = (LoanInBizBillInfo)model;
        HrAffairFillEmptyBizDefineUtil.fillLoanInBizBillEntry(ctx, billInfo.getEntrys());
        return super._addnew(ctx, model);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanInBizBillInfo billInfo = (LoanInBizBillInfo)model;
        HrAffairFillEmptyBizDefineUtil.fillLoanInBizBillEntry(ctx, billInfo.getEntrys());
        LoanInBizBillEntryCollection entrys = billInfo.getEntrys();
        IObjectPK pk = super._submit(ctx, model);
        for (int i = 0; i < entrys.size(); ++i) {
            LoanInBizBillEntryInfo entry = entrys.get(i);
            String personId = entry.getPerson().getId().toString();
            FluctuationInOutInfo flucInOutInfo = FluctuationInOutUtil.getPersonFluctuationInOutInfo((Context)ctx, (String)personId);
            if (flucInOutInfo == null) continue;
            flucInOutInfo.setCompleteState(CompleteStateEnum.COMPLETING);
            flucInOutInfo.setInEntryId(entry.getId().toString());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("inEntryId"));
            sic.add(new SelectorItemInfo("completeState"));
            if (null == entry.getLoanEndDate()) {
                sic.add(new SelectorItemInfo("loanEndDate"));
                entry.setLoanEndDate(flucInOutInfo.getLoanEndDate());
            }
            FluctuationInOutFactory.getLocalInstance((Context)ctx).updatePartial(flucInOutInfo, sic);
        }
        return pk;
    }

    @Override
    protected String getBillField() {
        return "bill";
    }

    @Override
    protected String getEntryField() {
        return "entrys";
    }

    @Override
    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.affair.app.LoanInBizBillEffectFunction";
    }

    @Override
    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return LoanInBizBillEntryFactory.getLocalInstance(ctx);
    }

    @Override
    protected IHRBillBizBean getBizBean() {
        return new LoanInBillBizBean();
    }

    @Override
    protected void _doWithPriorityThingEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithPriorityThingEffect(ctx, entry);
        LoanInBizBillEntryInfo einfo = (LoanInBizBillEntryInfo)entry;
        IPersonPosition ipp = PersonPositionFactory.getLocalInstance((Context)ctx);
        PersonPositionInfo ppInfo = new PersonPositionInfo();
        ppInfo.put("person", (Object)einfo.getPerson());
        ppInfo.setJobGrade(einfo.getJobGrade());
        ppInfo.setJobGradeEndDate(einfo.getBizDate());
        String columnStrings = "jobGrade,jobGradeEndDate";
        AffairUnAuditAppUtils.updatePersonSinglePagePartial((ICoreBase)ipp, (CoreBaseInfo)ppInfo, (String)columnStrings);
    }

    @Override
    protected void _doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithSpecialFiledsEffect(ctx, entry);
        LoanInBizBillEntryInfo einfo = (LoanInBizBillEntryInfo)entry;
        this.savePersonLoanInfo(ctx, einfo);
        FluctuationInOutUtil.updateFluctuationInOutData((Context)ctx, (HRAffairBizBillEntryInfo)entry);
    }

    private void savePersonLoanInfo(Context ctx, LoanInBizBillEntryInfo entryInfo) throws BOSException, EASBizException {
        LoanInBizBillInfo billInfo = entryInfo.getBill();
        PersonInfo personInfo = entryInfo.getPerson();
        PersonLoanInfo personLoanInfo = AffairUtil.getPersonLoanInfo(ctx, personInfo);
        if (personLoanInfo != null) {
            PositionInfo position = AffairUtil.getPosition(ctx, entryInfo.getPosition());
            String positionStr = position.getName();
            AdminOrgUnitInfo adminOrg = AffairUtil.getAdmin(ctx, entryInfo.getAdminOrg());
            String adminOrgStr = adminOrg.getName();
            PersonInfo person = AffairUtil.getPerson(ctx, entryInfo.getPerson());
            String personStr = person.getName();
            String errorMsg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label17", (Context)ctx), personStr, adminOrgStr, positionStr);
            NumericExceptionSubItem EXCEPTION = new NumericExceptionSubItem("000", errorMsg);
            throw new HRCommonException(EXCEPTION);
        }
        personLoanInfo = new PersonLoanInfo();
        personLoanInfo.setOutPosition(entryInfo.getOldPosition());
        personLoanInfo.setOutAdmin(entryInfo.getOldAdminOrg());
        personLoanInfo.setOutJob(entryInfo.getOldJob());
        personLoanInfo.setInPosition(entryInfo.getPosition());
        personLoanInfo.setInAdmin(entryInfo.getAdminOrg());
        personLoanInfo.setInJob(entryInfo.getJob());
        personLoanInfo.setLoanEndDate(entryInfo.getLoanEndDate());
        personLoanInfo.setLoanDate(entryInfo.getBizDate());
        personLoanInfo.setLoanEffectDate(entryInfo.getLoanEffectDate());
        personLoanInfo.setLoanEntryId(entryInfo.getId().toString());
        personLoanInfo.setPerson(entryInfo.getPerson());
        personLoanInfo.setOutBillNumber(billInfo.getNumber());
        personLoanInfo.setPersonLoanState(PersonLoanOutBackState.loaning);
        personLoanInfo.setState(LoanStateEnum.present);
        personLoanInfo.setOutBillDesc(AffairUtil.getLoanDescription(ctx, personLoanInfo, entryInfo));
        personLoanInfo.setOutRemark(entryInfo.getDescription());
        personLoanInfo.setIsSingle(true);
        PersonLoanFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)personLoanInfo);
    }

    protected String getPermItemNameDelete() {
        return "loanIn_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "loanIn_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "loanIn_Update";
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LoanInBizBillInfo BillInfo = LoanInBizBillFactory.getLocalInstance(ctx).getLoanInBizBillInfo(pk);
        LoanInBizBillEntryCollection billEntryCol = BillInfo.getEntrys();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    @Override
    public void _unAuditEachEntrySpecialPropertyRecovery(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        LoanInBizBillEntryInfo entryInfo = (LoanInBizBillEntryInfo)entry;
        String entryId = entryInfo.getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("loanEntryId", (Object)entryId));
        IPersonLoan iPersonLoan = PersonLoanFactory.getLocalInstance((Context)ctx);
        if (iPersonLoan.exists(filterInfo)) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filterInfo);
            PersonLoanCollection coll = iPersonLoan.getPersonLoanCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                PersonLoanInfo pLoanInfo = coll.get(i);
                if (pLoanInfo.getBackEffectDate() == null || pLoanInfo.getState() != LoanStateEnum.history) continue;
                throw new HRAffairException(HRAffairException.PERSON_HAS_LOANBACK_CANT_UN_LOANIN);
            }
            iPersonLoan.delete(filterInfo);
        }
        FluctuationInOutInfo inOutInfo = FluctuationInOutUtil.getFluctuationInOutInfoByEntryId((Context)ctx, (String)entryId);
        inOutInfo.setCompleteState(CompleteStateEnum.NO_COMPLETE);
        inOutInfo.setInEntryId(null);
        inOutInfo.setNewPosition(null);
        inOutInfo.setNewLaborRelState(null);
        inOutInfo.setEmpID(null);
        inOutInfo.setEFFECT(null);
        FluctuationInOutFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(inOutInfo.getId().toString()), inOutInfo);
    }

    @Override
    protected boolean isNeedDoWithUserPermission() {
        return true;
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
        IFluctuationInOut iFluctuationInOut = FluctuationInOutFactory.getLocalInstance((Context)ctx);
        LoanInBizBillEntryCollection entry = LoanInBizBillEntryFactory.getLocalInstance(ctx).getLoanInBizBillEntryCollection("where bill = '" + billId + "'");
        if (null != entry && 0 < entry.size()) {
            FluctuationInOutCollection fInfo;
            String entryId = entry.get(0).getId().toString();
            String oql = "where inEntryId='" + entryId + "'";
            if (iFluctuationInOut.exists(oql) && null != (fInfo = iFluctuationInOut.getFluctuationInOutCollection(oql)) && fInfo.size() > 0) {
                for (int i = 0; i < fInfo.size(); ++i) {
                    fInfo.get(i).setEFFECT(null);
                    fInfo.get(i).setNewLaborRelState(null);
                    fInfo.get(i).setCompleteState(CompleteStateEnum.NO_COMPLETE);
                    fInfo.get(i).setEmpID(null);
                    FluctuationInOutFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(fInfo.get(i).getId().toString()), fInfo.get(i));
                }
            }
        }
    }

    @Override
    protected void _abortBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._abortBizBill(ctx, billId);
        LoanInBizBillInfo loanInInfo = LoanInBizBillFactory.getLocalInstance(ctx).getLoanInBizBillInfo((IObjectPK)new ObjectUuidPK(billId));
        LoanInBizBillEntryCollection loanInColl = loanInInfo.getEntrys();
        for (int i = 0; i < loanInColl.size(); ++i) {
            FluctuationInOutInfo flucInOutInfo = null;
            LoanInBizBillEntryInfo loanInEntry = loanInColl.get(i);
            String sql = "where person ='" + loanInEntry.getPerson().getId() + "' and completeState=2";
            FluctuationInOutCollection flucInOutColl = FluctuationInOutFactory.getLocalInstance((Context)ctx).getFluctuationInOutCollection(sql);
            if (flucInOutColl.size() > 0) {
                flucInOutInfo = flucInOutColl.get(0);
            }
            if (flucInOutInfo == null) continue;
            flucInOutInfo.setCompleteState(CompleteStateEnum.NO_COMPLETE);
            flucInOutInfo.setFlucInBill(null);
            flucInOutInfo.setNewPosition(null);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("completeState"));
            sic.add(new SelectorItemInfo("flucInBill"));
            sic.add(new SelectorItemInfo("newPosition"));
            FluctuationInOutFactory.getLocalInstance((Context)ctx).updatePartial(flucInOutInfo, sic);
        }
    }

    @Override
    protected void setHrOrgUnitForEntry(Context ctx, IObjectValue model, HRAffairBizBillEntryInfo entry, EmpHRORelationHisInfo buRelationInfo) {
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        if (entry.getHrOrgUnit() == null && billInfo.getHrOrgUnit() != null) {
            entry.setHrOrgUnit(billInfo.getHrOrgUnit());
        }
    }

    @Override
    protected void setBillUseDefault(Context ctx, IObjectValue model, HRAffairBizBillEntryInfo entry, EmpHRORelationHisInfo buRelationInfo) throws BOSException, EASBizException {
        HRAffairBizBillInfo billInfo = (HRAffairBizBillInfo)model;
        billInfo.setUseDefault(true);
        entry.setUseDefault(true);
    }

    @Override
    protected HRAffairBizBillEntryInfo storefieldsForEntry(Context ctx, HRAffairBizBillInfo billInfo, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        PositionInfo positionInfo;
        if (entryInfo.getAdminOrg() == null && (positionInfo = entryInfo.getPosition()) != null) {
            entryInfo.setAdminOrg(SHREmpOptOrgnizationTool.getAdminOrgUnitByPosition((Context)ctx, (String)positionInfo.getId().toString()));
        }
        super.storefieldsForEntry(ctx, billInfo, entryInfo);
        return entryInfo;
    }

    @Override
    protected void createBackGroundJob(Context ctx, IObjectValue entry, String jobKey) throws EASBizException, BOSException {
        super.createBackGroundJob(ctx, entry, jobKey);
        LoanInBizBillEntryInfo info = (LoanInBizBillEntryInfo)entry;
        Date endDate = info.getLoanEndDate();
        String personId = info.getPerson().getId().toString();
        StringBuffer sql = null;
        sql = endDate != null ? new StringBuffer("update T_HR_FluctuationInOut set FCompleteState = 2, FloanEndDate = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)endDate)).append(", FinEntryId = '").append(info.getId().toString() + "' where FPersonID = '").append(personId).append("'") : new StringBuffer("update T_HR_FluctuationInOut set FCompleteState = 2,  FinEntryId = '").append(info.getId().toString() + "' where FPersonID = '").append(personId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditEnd(ctx, billID);
        LoanInBizBillEntryCollection loanList = LoanInBizBillEntryFactory.getLocalInstance(ctx).getLoanInBizBillEntryCollection("where bill = '" + billID + "'");
        if (null != loanList && 0 < loanList.size()) {
            StringBuffer sql = new StringBuffer("update T_HR_FluctuationInOut set FCompleteState = 0, FloanEndDate = null where FinEntryId = '").append(loanList.get(0).getId().toString()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }
}

