/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizFactory;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.RiseBizBillEntryCollection;
import com.kingdee.eas.hr.affair.RiseBizBillEntryFactory;
import com.kingdee.eas.hr.affair.RiseBizBillEntryInfo;
import com.kingdee.eas.hr.affair.RiseBizBillFactory;
import com.kingdee.eas.hr.affair.RiseBizBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractRiseBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.RiseBillBizBean;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogFactory;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogInfo;
import com.kingdee.eas.hr.base.IHRAffairActionTransactionLog;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmpPostRankFactory;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.hr.emp.EmpPostRankOptFacadeFactory;
import com.kingdee.eas.hr.emp.app.util.EmpPostRankUtil;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.ws.ca.utils.StringUtils;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class RiseBizBillControllerBean
extends AbstractRiseBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.RiseBizBillControllerBean");

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.affair.app.RiseBizBillEffectFunction";
    }

    @Override
    protected void _doWithCommonRelationEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithCommonRelationEffect(ctx, entry);
    }

    @Override
    protected IHRBillBizBean getBizBean() {
        return new RiseBillBizBean();
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        super.checkBeforeSubmit(ctx, model);
        RiseBizBillInfo info = (RiseBizBillInfo)model;
        RiseBizBillEntryCollection eColl = info.getEntrys();
        RiseBizBillEntryInfo eInfo = null;
        for (int i = 0; i < eColl.size(); ++i) {
            String[] errorParam = new String[1];
            eInfo = eColl.get(i);
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(eInfo.getPerson().getId()));
            if (eInfo.getJobGrade() == null && eInfo.getJobLevel() == null) {
                throw new HRAffairException(HRAffairException.JOBGRADE_LEVEL_CANT_NULL, new String[]{personInfo.getName()});
            }
            if (!this.isJobLevelAndJobGradNotChange(eInfo)) continue;
            throw new HRAffairException(HRAffairException.JOBGRADE_LEVEL_NO_CHANGE, new String[]{personInfo.getName()});
        }
    }

    private boolean isJobLevelAndJobGradNotChange(RiseBizBillEntryInfo eInfo) {
        return !(!HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)eInfo.getOldJobGrade(), (CoreBaseInfo)eInfo.getJobGrade()) && eInfo.getJobGrade() != null || !HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)eInfo.getOldJobLevel(), (CoreBaseInfo)eInfo.getJobLevel()) && eInfo.getJobLevel() != null);
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
        this.recoveryEmpPostRank(ctx, billId);
    }

    @Override
    protected void _unAuditEntry(Context ctx, String entryId) throws BOSException, EASBizException {
        try {
            EmpPostRankInfo postRankInfo = EmpPostRankFactory.getLocalInstance((Context)ctx).getEmpPostRankInfo((IObjectPK)new ObjectUuidPK(entryId));
            RiseBizBillInfo riseBizBillInfo = EmpPostRankUtil.getRiseBizBillInfoByPostRankInfo((Context)ctx, (EmpPostRankInfo)postRankInfo);
            String billId = riseBizBillInfo.getId().toString();
            RiseBizBillEntryCollection entrys = riseBizBillInfo.getEntrys();
            if (entrys.size() > 1) {
                IHRAffairActionTransactionLog iHRAffairActionTransactionLog = HRAffairActionTransactionLogFactory.getLocalInstance((Context)ctx);
                String hrAATLString = postRankInfo.getFlowInAffairID();
                HRAffairActionTransactionLogInfo hrAffairActionTransactionLogInfo = iHRAffairActionTransactionLog.getHRAffairActionTransactionLogInfo((IObjectPK)new ObjectUuidPK(hrAATLString));
                String entryInfoId = hrAffairActionTransactionLogInfo.getAffairEntryID();
                RiseBizBillEntryFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(entryInfoId));
                iHRAffairActionTransactionLog.delete((IObjectPK)new ObjectUuidPK(hrAATLString));
                HRAffairBizFactory.getLocalInstance(ctx).delete(" where entryId='" + entryInfoId + "'");
                EmpPostRankOptFacadeFactory.getLocalInstance((Context)ctx).deleteNewestEmpPostRank((IObjectPK)new ObjectUuidPK(entryId));
            } else {
                this._untiCheckBizBill(ctx, billId);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        super._unAuditEntry(ctx, entryId);
    }

    private void recoveryEmpPostRank(Context ctx, String billId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        RiseBizBillInfo billInfo = RiseBizBillFactory.getLocalInstance(ctx).getRiseBizBillInfo((IObjectPK)new ObjectUuidPK(billId));
        RiseBizBillEntryCollection entrys = billInfo.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            String personId;
            EmpPostRankInfo rankInfo;
            RiseBizBillEntryInfo entry = entrys.get(i);
            Date now = new Date();
            Date bizDate = entry.getBizDate();
            if (entry.getPerson() == null || entry.getPerson().getId() == null || !now.after(bizDate) || (rankInfo = EmpPostRankUtil.getEmpPostRankByBillId((Context)ctx, (String)(personId = entry.getPerson().getId().toString()), (String)entry.getId().toString())) == null) continue;
            EmpPostRankOptFacadeFactory.getLocalInstance((Context)ctx).deleteNewestEmpPostRank((IObjectPK)new ObjectUuidPK(rankInfo.getId()));
        }
    }

    @Override
    protected HRAffairBizBillEntryInfo storefieldsForEntry(Context ctx, HRAffairBizBillInfo hrBillInfo, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        RiseBizBillInfo billInfo = (RiseBizBillInfo)hrBillInfo;
        entryInfo.put("bill", billInfo);
        String clearJobGrade = (String)billInfo.get("isClearJobGrade");
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(entryInfo.getPerson().getId()));
        if ((entryInfo.getJobLevel() == null || entryInfo.getJobLevel() != null && entryInfo.getJobLevel().getId() == null) && (entryInfo.getJobGrade() == null || entryInfo.getJobGrade() != null && entryInfo.getJobGrade().getId() == null)) {
            throw new HRAffairException(HRAffairException.JOBGRADE_LEVEL_CANT_NULL, new String[]{personInfo.getName()});
        }
        JobGradeInfo jobGradeInfo = entryInfo.getJobGrade();
        JobLevelInfo jobLevelInfo = entryInfo.getJobLevel();
        super.storefieldsForEntry(ctx, billInfo, entryInfo);
        entryInfo.setJobGrade(jobGradeInfo);
        entryInfo.setJobLevel(jobLevelInfo);
        if (this.isJobLevelAndJobGradNotChange((RiseBizBillEntryInfo)entryInfo)) {
            throw new HRAffairException(HRAffairException.JOBGRADE_LEVEL_NO_CHANGE, new String[]{personInfo.getName()});
        }
        this.checkJobGradeLevelRange(ctx, (RiseBizBillEntryInfo)entryInfo);
        this.setJobSystemInfo(ctx, (RiseBizBillEntryInfo)entryInfo);
        return entryInfo;
    }

    private void setJobSystemInfo(Context ctx, RiseBizBillEntryInfo entryInfo) throws BOSException, EASBizException {
        if (entryInfo.getJobGrade() != null && entryInfo.getJobGrade().getId() != null && entryInfo.getJobGradeModule() == null) {
            JobGradeInfo jobGradeInfo = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(entryInfo.getJobGrade().getId()));
            entryInfo.setJobGradeModule(jobGradeInfo.getJobGradeModule());
        }
        if (entryInfo.getJobLevel() != null && entryInfo.getJobLevel().getId() != null && entryInfo.getJobLevelProject() == null) {
            JobLevelInfo jobLevelInfo = JobLevelFactory.getLocalInstance((Context)ctx).getJobLevelInfo((IObjectPK)new ObjectUuidPK(entryInfo.getJobLevel().getId()));
            entryInfo.setJobLevelProject(jobLevelInfo.getJobLevelProject());
        }
    }

    private void checkJobGradeLevelRange(Context ctx, RiseBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        boolean isRelatePositionJobRange = HRParamUtil.isRelatePositionJobRange((Context)ctx);
        if (!isRelatePositionJobRange && entryInfo.getJobLevel() != null && entryInfo.getJobGrade() != null && entryInfo.getJobLevel().getId() != null && entryInfo.getJobGrade().getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("lowestJobGrade.index"));
            sic.add(new SelectorItemInfo("jobGrade.index"));
            sic.add(new SelectorItemInfo("jobLevelProject.jobGradeModule.id"));
            JobLevelInfo jlInfo = JobLevelFactory.getLocalInstance((Context)ctx).getJobLevelInfo((IObjectPK)new ObjectUuidPK(entryInfo.getJobLevel().getId()), sic);
            JobGradeInfo jgInfo = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(entryInfo.getJobGrade().getId()));
            int index = jgInfo.getIndex();
            if (!(jlInfo.getJobLevelProject() == null || jlInfo.getJobLevelProject().getJobGradeModule() == null || jlInfo.getJobLevelProject().getJobGradeModule().getId() == null || HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)jgInfo.getJobGradeModule(), (CoreBaseInfo)jgInfo.getJobGradeModule()) && jlInfo.getLowestJobGrade() != null && index >= jlInfo.getLowestJobGrade().getIndex() && jlInfo.getJobGrade() != null && index <= jlInfo.getJobGrade().getIndex())) {
                throw new HRAffairException(HRAffairException.JOBGREADE_MUST_IN_MODULE);
            }
        }
    }
}

