/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairUtilFacadeFactory;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.IAffairUtilFacade;
import com.kingdee.eas.hr.affair.IHRAffairBizBillEntry;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonLoanCollection;
import com.kingdee.eas.hr.emp.PersonLoanFactory;
import com.kingdee.eas.hr.emp.PersonLoanInfo;
import com.kingdee.eas.hr.emp.PersonLoanOutBackState;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AffairUtil {
    public static String clientName = null;

    public static String getCurrentClientName() throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)clientName)) {
            IAffairUtilFacade iAffairUtilFacade = AffairUtilFacadeFactory.getRemoteInstance();
            clientName = iAffairUtilFacade.getCurrentClientName();
        }
        return clientName;
    }

    public static String getCurrentClientName(Context ctx) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)clientName)) {
            IAffairUtilFacade iAffairUtilFacade = AffairUtilFacadeFactory.getLocalInstance(ctx);
            clientName = iAffairUtilFacade.getCurrentClientName();
        }
        return clientName;
    }

    public static String getParamForClient(String paramNumber, HROrgUnitInfo hrInfo) throws EASBizException, BOSException {
        String val = "";
        IParamControl iParam = null;
        String HRO_ID = null;
        iParam = ParamControlFactory.getRemoteInstance();
        if (hrInfo != null && hrInfo.getId() != null) {
            HRO_ID = hrInfo.getId().toString();
            val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID), paramNumber);
        }
        return val;
    }

    public static String getParamForServer(Context ctx, String paramNumber) throws EASBizException, BOSException {
        String val = "";
        IParamControl iParam = null;
        String HRO_ID = null;
        iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        HROrgUnitInfo hrOrgUnitInfo = HRSchemeUtils.getServerHROrgUnitInfo((Context)ctx);
        if (hrOrgUnitInfo != null && hrOrgUnitInfo.getId() != null) {
            HRO_ID = hrOrgUnitInfo.getId().toString();
            val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID), paramNumber);
        }
        return val;
    }

    public static JobGradeInfo getJobGradeByPosition(String positionId, HROrgUnitInfo hrInfo) throws Exception {
        PositionInfo positionInfo;
        JobGradeInfo jobgrade = null;
        if ("true".equals(AffairUtil.getParamForClient("AutoGetJob", hrInfo)) && (positionInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)positionId)))) != null && positionInfo.getJob() != null) {
            JobLevelInfo joblevel;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("job.id", (Object)positionInfo.getJob().getId(), CompareType.EQUALS));
            view.setFilter(filter);
            CoreBaseCollection col = JobLevelFactory.getRemoteInstance().getCollection(view);
            if (col.size() == 1 && (joblevel = (JobLevelInfo)col.get(0)).getJobGrade() != null) {
                jobgrade = (JobGradeInfo)JobGradeFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(joblevel.getJobGrade().getId()));
            }
        }
        return jobgrade;
    }

    public static JobGradeInfo getJobLevelByPosition(String positionId, HROrgUnitInfo hrInfo) throws Exception {
        PositionInfo positionInfo;
        JobGradeInfo jobgrade = null;
        if ("true".equals(AffairUtil.getParamForClient("AutoGetJob", hrInfo)) && (positionInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)positionId)))) != null && positionInfo.getJob() != null) {
            JobLevelInfo joblevel;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("job.id", (Object)positionInfo.getJob().getId(), CompareType.EQUALS));
            view.setFilter(filter);
            CoreBaseCollection col = JobLevelFactory.getRemoteInstance().getCollection(view);
            if (col.size() == 1 && (joblevel = (JobLevelInfo)col.get(0)).getJobGrade() != null) {
                jobgrade = (JobGradeInfo)JobGradeFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(joblevel.getJobGrade().getId()));
            }
        }
        return jobgrade;
    }

    public static JobInfo getJobInfoByPosition(String positionId) throws Exception {
        JobInfo jobInfo = null;
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("job.id"));
        sel.add(new SelectorItemInfo("job.name"));
        sel.add(new SelectorItemInfo("job.number"));
        PositionInfo positionInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)positionId)), sel);
        if (positionInfo != null && positionInfo.getJob() != null) {
            jobInfo = positionInfo.getJob();
        }
        return jobInfo;
    }

    public static JobLevelInfo getJoLevelByJob(String jobId) throws Exception {
        JobLevelInfo joblevel = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("job.id", (Object)jobId, CompareType.EQUALS));
        view.setFilter(filter);
        CoreBaseCollection col = JobLevelFactory.getRemoteInstance().getCollection(view);
        if (col.size() == 1) {
            joblevel = (JobLevelInfo)col.get(0);
        }
        return joblevel;
    }

    public static JobGradeInfo getJobGradeByJobLevel(String joblevelId) throws Exception {
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("jobGrade.id"));
        sel.add(new SelectorItemInfo("jobGrade.name"));
        sel.add(new SelectorItemInfo("jobGrade.number"));
        JobLevelInfo jobLevel = (JobLevelInfo)JobLevelFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(joblevelId), sel);
        JobGradeInfo jobGrade = null;
        if (jobLevel != null) {
            jobGrade = jobLevel.getJobGrade();
        }
        return jobGrade;
    }

    public static JobGradeInfo getJobGradeByJobLevel(JobLevelInfo joblevel) throws Exception {
        JobGradeInfo jobgradeInfo = null;
        if (joblevel != null && joblevel.getId() != null) {
            jobgradeInfo = AffairUtil.getJobGradeByJobLevel(joblevel.getId().toString());
        }
        return jobgradeInfo;
    }

    public static JobLevelInfo getJobLevelByGradeAndJob(String jobGradeId, String jobId) throws Exception {
        JobLevelInfo jobLevel = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("job.id", (Object)jobId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("jobGrade.id", (Object)jobGradeId, CompareType.EQUALS));
        view.setFilter(filter);
        CoreBaseCollection col = JobLevelFactory.getRemoteInstance().getCollection(view);
        if (col.size() == 1) {
            jobLevel = (JobLevelInfo)col.get(0);
        }
        return jobLevel;
    }

    public static JobLevelInfo getJobLevelByGradeAndPosition(String jobGradeId, String positionId) throws Exception {
        JobLevelInfo jobLevel = null;
        JobInfo jobInfo = AffairUtil.getJobInfoByPosition(positionId);
        if (jobInfo != null && jobInfo.getId() != null) {
            jobLevel = AffairUtil.getJobLevelByGradeAndJob(jobGradeId, jobInfo.getId().toString());
        }
        return jobLevel;
    }

    public static JobLevelInfo getJobLevelByGradeAndPosition(JobGradeInfo jobGrade, PositionInfo position) throws Exception {
        JobLevelInfo jobLevel = null;
        if (jobGrade != null && jobGrade.getId() != null && position != null && position.getId() != null) {
            jobLevel = AffairUtil.getJobLevelByGradeAndPosition(jobGrade.getId().toString(), position.getId().toString());
        }
        return jobLevel;
    }

    public static boolean isObjectEquelsByPkValue(CoreBaseInfo ainfo, CoreBaseInfo binfo) {
        if (ainfo != null && binfo != null) {
            return ainfo.getId().equals((Object)binfo.getId());
        }
        return ainfo == binfo;
    }

    public static HRBizDefineInfo getHRBizDefineInfo(String hrBizDefineID) {
        HRBizDefineInfo defineInfo = new HRBizDefineInfo();
        defineInfo.setId(BOSUuid.read((String)hrBizDefineID));
        return defineInfo;
    }

    @Deprecated
    public static void updateAffairEntryJobGradeInfo(Context ctx, IHRAffairBizBillEntry localInterface, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        PersonInfo personInfo = entryInfo.getPerson();
        if (personInfo == null) {
            return;
        }
        IPersonPosition ipp = PersonPositionFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personInfo.getId().toString()));
        viewInfo.setFilter(filter);
        PersonPositionCollection collection = ipp.getPersonPositionCollection(viewInfo);
        if (collection == null || collection.size() == 0) {
            return;
        }
        PersonPositionInfo ppInfo = collection.get(0);
        if (ppInfo.getJobGrade() != null) {
            entryInfo.setJobGrade(ppInfo.getJobGrade());
            SelectorItemCollection selectItemColl = new SelectorItemCollection();
            selectItemColl.add(new SelectorItemInfo("jobGrade"));
            localInterface.updatePartial((CoreBaseInfo)entryInfo, selectItemColl);
        }
    }

    public static void setColumnDateFormat(KDTable kdTable, String[] columns) {
        int len = columns.length;
        for (int i = 0; i < len; ++i) {
            AffairUtil.setColumnDateFormat(kdTable, columns[i]);
        }
    }

    public static void setColumnDateFormat(KDTable kdTable, String column) {
        String dtFormat = CtrlFormatUtilities.getDateFormatString();
        kdTable.getColumn(column).getStyleAttributes().setNumberFormat(dtFormat);
    }

    public static PersonLoanInfo getPersonLoanInfo(Context ctx, PersonInfo personInfo) throws BOSException {
        PersonLoanInfo personLoanInfo = null;
        boolean isLoanBackEffect = true;
        PersonLoanCollection personLoanColl = AffairUtil.getPersonLoanCollection(ctx, personInfo);
        if (personLoanColl.isEmpty()) {
            return null;
        }
        for (int i = 0; i < personLoanColl.size(); ++i) {
            personLoanInfo = personLoanColl.get(i);
            if (personLoanInfo.getBackEffectDate() != null) continue;
            isLoanBackEffect = false;
            break;
        }
        if (!isLoanBackEffect) {
            return personLoanInfo;
        }
        return null;
    }

    public static PersonLoanCollection getPersonLoanCollection(Context ctx, PersonInfo personInfo) throws BOSException {
        String personId = personInfo.getId().toString();
        String oql = "where person = '" + personId + "' ";
        PersonLoanCollection personLoanColl = PersonLoanFactory.getLocalInstance((Context)ctx).getPersonLoanCollection(oql);
        return personLoanColl;
    }

    public static String getLoanDescription(Context ctx, PersonLoanInfo personLoanInfo, HRAffairBizBillEntryInfo entryEntry) throws BOSException, EASBizException {
        StringBuffer bufferStr = null;
        StringBuffer bufferStrBack = null;
        Date loanDate = personLoanInfo.getLoanDate();
        Date loanEndDate = personLoanInfo.getLoanEndDate();
        Date loanBackDate = personLoanInfo.getBackEffectDate();
        PersonLoanOutBackState personLoanState = personLoanInfo.getPersonLoanState();
        AdminOrgUnitInfo outAdmin = personLoanInfo.getOutAdmin();
        AdminOrgUnitInfo inAdmin = personLoanInfo.getInAdmin();
        PositionInfo outPosition = personLoanInfo.getOutPosition();
        PositionInfo inPosition = personLoanInfo.getInPosition();
        outAdmin = AffairUtil.getAdmin(ctx, outAdmin);
        inAdmin = AffairUtil.getAdmin(ctx, inAdmin);
        outPosition = AffairUtil.getPosition(ctx, outPosition);
        inPosition = AffairUtil.getPosition(ctx, inPosition);
        bufferStr = new StringBuffer();
        bufferStr.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label27", (Context)ctx), AffairUtil.translateDateToStr(loanDate), outAdmin.getName(), outPosition.getName(), inAdmin.getName(), inPosition.getName(), AffairUtil.translateDateToStr(loanEndDate)));
        if (personLoanState == PersonLoanOutBackState.getEnum((int)2)) {
            bufferStrBack = new StringBuffer();
            HRBizDefineInfo hrBizDefineInfo = entryEntry.getHrBizDefine();
            if ("SHR33".equals((hrBizDefineInfo = AffairUtil.getHRBizDefineInfo(ctx, hrBizDefineInfo)).getNumber())) {
                String positionId = entryEntry.getPosition().getId().toString();
                PositionInfo positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(positionId));
                String adminOrgId = positionInfo.getAdminOrgUnit().getId().toString();
                String updateSql = "update T_HR_PERSONLOAN set FBackPositionID = '" + positionId + "',FBackAdminID = '" + adminOrgId + "' where fid ='" + personLoanInfo.getId().toString() + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
                AdminOrgUnitInfo backAdmin = positionInfo.getAdminOrgUnit();
                PositionInfo backPosition = positionInfo;
                backAdmin = AffairUtil.getAdmin(ctx, backAdmin);
                backPosition = AffairUtil.getPosition(ctx, backPosition);
                bufferStrBack.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label28", (Context)ctx), AffairUtil.translateDateToStr(loanBackDate), inAdmin.getName(), inPosition.getName(), backAdmin.getName(), backPosition.getName()));
            } else {
                AdminOrgUnitInfo backAdmin = AffairUtil.getAdmin(ctx, entryEntry.getOldAdminOrg());
                PositionInfo backPosition = AffairUtil.getPosition(ctx, entryEntry.getOldPosition());
                bufferStrBack.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label28", (Context)ctx), AffairUtil.translateDateToStr(loanBackDate), inAdmin.getName(), inPosition.getName(), backAdmin.getName(), backPosition.getName()));
            }
            return bufferStrBack.toString();
        }
        return bufferStr.toString();
    }

    public static PersonInfo getPerson(Context ctx, PersonInfo person) throws BOSException {
        PersonInfo personInfo = null;
        String id = person.getId().toString();
        try {
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return personInfo;
    }

    public static AdminOrgUnitInfo getAdmin(Context ctx, AdminOrgUnitInfo admin) throws BOSException {
        AdminOrgUnitInfo adminOrg = null;
        String id = admin.getId().toString();
        try {
            adminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return adminOrg;
    }

    public static PositionInfo getPosition(Context ctx, PositionInfo pos) throws BOSException {
        PositionInfo position = null;
        String id = pos.getId().toString();
        try {
            position = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return position;
    }

    public static String translateDateToStr(Date date) {
        String s = "";
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            s = dateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return s;
    }

    public static HRBizDefineInfo getHRBizDefineInfo(Context ctx, HRBizDefineInfo hrBizDefineInfo) {
        String id = hrBizDefineInfo.getId().toString();
        try {
            hrBizDefineInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        return hrBizDefineInfo;
    }
}

