/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillInfo;
import com.kingdee.eas.hr.affair.EmpHireBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpHireBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpHireBizBillInfo;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryCollection;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryInfo;
import com.kingdee.eas.hr.affair.FluctuationBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.IHRAffairBizBill;
import com.kingdee.eas.hr.affair.LoanBackBizBillInfo;
import com.kingdee.eas.hr.affair.LoanBizBillInfo;
import com.kingdee.eas.hr.affair.LoanInBizBillInfo;
import com.kingdee.eas.hr.affair.LoanOutBizBillInfo;
import com.kingdee.eas.hr.affair.ReinviteBizBillEntryCollection;
import com.kingdee.eas.hr.affair.ReinviteBizBillEntryInfo;
import com.kingdee.eas.hr.affair.ReinviteBizBillInfo;
import com.kingdee.eas.hr.affair.ReinviteFireBizBillEntryCollection;
import com.kingdee.eas.hr.affair.ReinviteFireBizBillEntryInfo;
import com.kingdee.eas.hr.affair.ReinviteFireBizBillInfo;
import com.kingdee.eas.hr.affair.ResignBizBillEntryCollection;
import com.kingdee.eas.hr.affair.ResignBizBillEntryInfo;
import com.kingdee.eas.hr.affair.ResignBizBillInfo;
import com.kingdee.eas.hr.affair.RetireBizBillEntryCollection;
import com.kingdee.eas.hr.affair.RetireBizBillEntryInfo;
import com.kingdee.eas.hr.affair.RetireBizBillInfo;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.PersonChangeInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PersonChangeConvertToBizBillUtil {
    private static Logger logger = Logger.getLogger(PersonChangeConvertToBizBillUtil.class);

    public static void batchOperateEmployeeChange(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        PersonChangeInfo changeInfo = (PersonChangeInfo)model;
        String actionDefId = changeInfo.getActionDef().getId().toString();
        HRBizDefineInfo defInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(actionDefId));
        HRAffairBizBillInfo affairBillInfo = PersonChangeConvertToBizBillUtil.getAffairBizBillInfo(ctx, changeInfo, defInfo);
        IHRAffairBizBill iHRAffairBizBill = (IHRAffairBizBill)PersonChangeConvertToBizBillUtil.getIHRAffairBizBillByBillInfo(ctx, affairBillInfo);
        iHRAffairBizBill.submitEffect((CoreBaseInfo)affairBillInfo);
    }

    private static HRAffairBizBillInfo getAffairBizBillInfo(Context ctx, PersonChangeInfo changeInfo, HRBizDefineInfo defInfo) throws EASBizException, BOSException {
        HRAffairBizBillInfo affairBillInfo = null;
        String isUpdateJobgrade = ParamManager.getParamValueIgnoreGroupControl(null, (String)"IS_JOBGRADE_AUTO", null, (boolean)true);
        if (defInfo.getBizDefineType() == HRBizDefineTypeEnum.EMPHIRE) {
            EmpHireBizBillInfo billInfo = new EmpHireBizBillInfo();
            billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
            EmpHireBizBillEntryInfo entryInfo = new EmpHireBizBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            entryInfo.setBill(billInfo);
            EmpHireBizBillEntryCollection coll = new EmpHireBizBillEntryCollection();
            coll.add(entryInfo);
            billInfo.put("entrys", (Object)coll);
            affairBillInfo = PersonChangeConvertToBizBillUtil.fillAffairBizbillEntry(ctx, billInfo, changeInfo);
            HRUtilExtend.fillJobGradeInfoForAffairBizBillEntryInfo((HRAffairBizBillEntryInfo)entryInfo, (String)isUpdateJobgrade);
        } else if (defInfo.getBizDefineType() == HRBizDefineTypeEnum.ENROLL) {
            EmpEnrollBizBillInfo billInfo = new EmpEnrollBizBillInfo();
            billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
            EmpEnrollBizBillEntryInfo entryInfo = new EmpEnrollBizBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            entryInfo.setBill(billInfo);
            EmpEnrollBizBillEntryCollection coll = new EmpEnrollBizBillEntryCollection();
            coll.add(entryInfo);
            billInfo.put("entrys", (Object)coll);
            affairBillInfo = PersonChangeConvertToBizBillUtil.fillAffairBizbillEntry(ctx, billInfo, changeInfo);
            HRUtilExtend.fillJobGradeInfoForAffairBizBillEntryInfo((HRAffairBizBillEntryInfo)entryInfo, (String)isUpdateJobgrade);
        } else if (defInfo.getBizDefineType() == HRBizDefineTypeEnum.FLUCTUACTION) {
            FluctuationBizBillInfo billInfo = new FluctuationBizBillInfo();
            billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
            FluctuationBizBillEntryInfo entryInfo = new FluctuationBizBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            entryInfo.setBill(billInfo);
            FluctuationBizBillEntryCollection coll = new FluctuationBizBillEntryCollection();
            coll.add(entryInfo);
            billInfo.put("entrys", (Object)coll);
            affairBillInfo = PersonChangeConvertToBizBillUtil.fillAffairBizbillEntry(ctx, billInfo, changeInfo);
            HRUtilExtend.fillJobGradeInfoForAffairBizBillEntryInfo((HRAffairBizBillEntryInfo)entryInfo, (String)isUpdateJobgrade);
        } else if (defInfo.getBizDefineType() == HRBizDefineTypeEnum.RESIGN) {
            ResignBizBillInfo billInfo = new ResignBizBillInfo();
            billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
            ResignBizBillEntryInfo entryInfo = new ResignBizBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            ResignBizBillEntryCollection coll = new ResignBizBillEntryCollection();
            coll.add(entryInfo);
            billInfo.put("entrys", (Object)coll);
            affairBillInfo = PersonChangeConvertToBizBillUtil.fillAffairBizbillEntry(ctx, billInfo, changeInfo);
        } else if (defInfo.getBizDefineType() == HRBizDefineTypeEnum.RETIRE) {
            RetireBizBillInfo billInfo = new RetireBizBillInfo();
            billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
            RetireBizBillEntryInfo entryInfo = new RetireBizBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            RetireBizBillEntryCollection coll = new RetireBizBillEntryCollection();
            coll.add(entryInfo);
            billInfo.put("entrys", (Object)coll);
            affairBillInfo = PersonChangeConvertToBizBillUtil.fillAffairBizbillEntry(ctx, billInfo, changeInfo);
        } else if (defInfo.getBizDefineType() == HRBizDefineTypeEnum.REINVITE) {
            ReinviteBizBillInfo billInfo = new ReinviteBizBillInfo();
            billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
            ReinviteBizBillEntryInfo entryInfo = new ReinviteBizBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            ReinviteBizBillEntryCollection coll = new ReinviteBizBillEntryCollection();
            coll.add(entryInfo);
            billInfo.put("entrys", (Object)coll);
            affairBillInfo = PersonChangeConvertToBizBillUtil.fillAffairBizbillEntry(ctx, billInfo, changeInfo);
            HRUtilExtend.fillJobGradeInfoForAffairBizBillEntryInfo((HRAffairBizBillEntryInfo)entryInfo, (String)isUpdateJobgrade);
        } else if (defInfo.getBizDefineType() == HRBizDefineTypeEnum.REINVITEFIRE) {
            ReinviteFireBizBillInfo billInfo = new ReinviteFireBizBillInfo();
            billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
            ReinviteFireBizBillEntryInfo entryInfo = new ReinviteFireBizBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            ReinviteFireBizBillEntryCollection coll = new ReinviteFireBizBillEntryCollection();
            coll.add(entryInfo);
            billInfo.put("entrys", (Object)coll);
            affairBillInfo = PersonChangeConvertToBizBillUtil.fillAffairBizbillEntry(ctx, billInfo, changeInfo);
        }
        PersonChangeConvertToBizBillUtil.setAffairBizBillField(ctx, affairBillInfo);
        PersonChangeConvertToBizBillUtil.setAffairBizbillNumber(ctx, affairBillInfo);
        return affairBillInfo;
    }

    public static void setAffairBizBillField(Context ctx, HRAffairBizBillInfo billInfo) throws EASBizException, BOSException {
        PersonInfo personInfo = new PersonInfo();
        personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (personInfo == null) {
            throw new AffairBizException(AffairBizException.CURRENTUSEROFPERSONISNULL);
        }
        PersonPositionInfo ppInfo = new PersonPositionInfo();
        ppInfo = PersonChangeConvertToBizBillUtil.getAdminOrgUnit(ctx, personInfo.getId().toString());
        if (ppInfo == null || ppInfo.getPersonDep() == null) {
            throw new AffairBizException(AffairBizException.CURRENTUSEROFPERSONDEPORPOSISNULL);
        }
        billInfo.setAdminOrg(ppInfo.getPersonDep());
        billInfo.setBillState(HRBillStateEnum.AUDITED);
        billInfo.setApplier(personInfo);
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        billInfo.setApplyDate(curDate);
        billInfo.setBizDate(curDate);
    }

    public static void setAffairBizbillNumber(Context ctx, HRAffairBizBillInfo billInfo) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        HROrgUnitInfo hro = billInfo.getHrOrgUnit();
        if (hro != null && hro.getId().toString() != null && iCodingRuleManager.isExist((IObjectValue)billInfo, hro.getId().toString())) {
            String number = iCodingRuleManager.getNumber((IObjectValue)billInfo, hro.getId().toString());
            billInfo.put("number", number);
        } else {
            GregorianCalendar cal = new GregorianCalendar();
            SimpleDateFormat sFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String curTime = sFormat.format(cal.getTime());
            SecureRandom random = null;
            try {
                random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                throw new BOSException();
            }
            String number = curTime + (random != null ? random.nextInt(100) : 0);
            billInfo.put("number", number);
        }
    }

    public static HRAffairBizBillInfo fillAffairBizbillEntry(Context ctx, HRAffairBizBillInfo billInfo, PersonChangeInfo changeInfo) throws BOSException {
        IObjectCollection entries = (IObjectCollection)billInfo.get("entrys");
        HRAffairBizBillEntryInfo entryInfo = null;
        String personId = changeInfo.getPerson().getId().toString();
        EmpHRORelationHisInfo buInfo = null;
        if (personId != null) {
            buInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo((Context)ctx, (String)personId);
            billInfo.setHrOrgUnit(changeInfo.getHrOrgUnit());
            billInfo.setUseDefault(buInfo.isUseDefault());
        }
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (HRAffairBizBillEntryInfo)entries.getObject(i);
            HashSet<String> propSet = new HashSet<String>();
            entryInfo.setOldAdminOrg(changeInfo.getOldAdmin());
            propSet.add("oldadmin");
            entryInfo.setOldPosition(changeInfo.getOldPosition());
            propSet.add("oldposition");
            entryInfo.setOldEmpType(changeInfo.getOldLaborRelState());
            propSet.add("oldlaborrelstate");
            entryInfo.setAdminOrg(changeInfo.getNewAdmin());
            propSet.add("newadmin");
            entryInfo.setPosition(changeInfo.getNewPosition());
            propSet.add("newposition");
            entryInfo.setEmpType(changeInfo.getNewLaborRelState());
            propSet.add("newlaborrelstate");
            entryInfo.setBizDate(changeInfo.getEFFDT());
            propSet.add("effdt");
            entryInfo.setHrOrgUnit(changeInfo.getHrOrgUnit());
            propSet.add("hrOrgUnit");
            if (personId != null && buInfo != null) {
                entryInfo.setUseDefault(buInfo.isUseDefault());
            }
            Enumeration enums = changeInfo.keys();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                if (propSet.contains(key)) continue;
                entryInfo.put(key, changeInfo.get(key));
            }
        }
        return billInfo;
    }

    public static PersonPositionInfo getAdminOrgUnit(Context ctx, String personID) throws BOSException {
        if (personID == null) {
            return null;
        }
        PersonPositionInfo personPositionInfo = null;
        StringBuffer oqlb = new StringBuffer();
        oqlb.append("select ");
        oqlb.append("id,");
        oqlb.append("enterDate,");
        oqlb.append("leftDate,");
        oqlb.append("formalDate,");
        oqlb.append("jobGrade.id,");
        oqlb.append("tryoutMonth,");
        oqlb.append("jobGrade.name,");
        oqlb.append("personDep.id,");
        oqlb.append("personDep.name,");
        oqlb.append("personDep.number,");
        oqlb.append("personDep.displayName,");
        oqlb.append("primaryPosition.id,");
        oqlb.append("primaryPosition.name,");
        oqlb.append("primaryPosition.number,");
        oqlb.append("primaryPosition.job.id,");
        oqlb.append("primaryPosition.job.name");
        oqlb.append(" where person.id='");
        oqlb.append(personID);
        oqlb.append("'");
        PersonPositionCollection c = null;
        c = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(oqlb.toString());
        if (c != null && c.size() > 0) {
            personPositionInfo = c.get(0);
        }
        return personPositionInfo;
    }

    public static IBOSObject getIHRAffairBizBillEntryByBillInfo(Context ctx, HRAffairBizBillInfo billInfo) throws BOSException {
        IBOSObject iCoreBase = null;
        if (billInfo instanceof EmpHireBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.EmpHireBizBillEntry"));
        } else if (billInfo instanceof ResignBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.ResignBizBillEntry"));
        } else if (billInfo instanceof EmpEnrollBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.EmpEnrollBizBillEntry"));
        } else if (billInfo instanceof FluctuationBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.FluctuationBizBillEntry"));
        } else if (billInfo instanceof ReinviteBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.ReinviteBizBillEntry"));
        } else if (billInfo instanceof RetireBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.RetireBizBillEntry"));
        } else if (billInfo instanceof ReinviteFireBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.ReinviteFireBizBillEntry"));
        }
        return iCoreBase;
    }

    public static IBOSObject getIHRAffairBizBillByBillInfo(Context ctx, HRAffairBizBillInfo billInfo) throws BOSException {
        IBOSObject iCoreBase = null;
        if (billInfo instanceof EmpHireBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.EmpHireBizBill"));
        } else if (billInfo instanceof ResignBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.ResignBizBill"));
        } else if (billInfo instanceof EmpEnrollBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.EmpEnrollBizBill"));
        } else if (billInfo instanceof FluctuationBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.FluctuationBizBill"));
        } else if (billInfo instanceof ReinviteBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.ReinviteBizBill"));
        } else if (billInfo instanceof RetireBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.RetireBizBill"));
        } else if (billInfo instanceof ReinviteFireBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.ReinviteFireBizBill"));
        } else if (billInfo instanceof LoanBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.LoanBizBill"));
        } else if (billInfo instanceof LoanOutBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.LoanOutBizBill"));
        } else if (billInfo instanceof LoanInBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.LoanInBizBill"));
        } else if (billInfo instanceof LoanBackBizBillInfo) {
            iCoreBase = BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.affair.app.LoanBackBizBill"));
        }
        return iCoreBase;
    }

    public static IBOSObject getIHRAffairBizBillEntryByBizDefineType(Context ctx, HRBizDefineTypeEnum enumbType) throws BOSException {
        HRAffairBizBillInfo billInfo = PersonChangeConvertToBizBillUtil.getInstanceByHRBizDefineTypeEnum(enumbType);
        return PersonChangeConvertToBizBillUtil.getIHRAffairBizBillEntryByBillInfo(ctx, billInfo);
    }

    private static HRAffairBizBillInfo getInstanceByHRBizDefineTypeEnum(HRBizDefineTypeEnum enumbType) {
        HRAffairBizBillInfo billInfo = null;
        if (enumbType == HRBizDefineTypeEnum.ENROLL) {
            billInfo = new EmpEnrollBizBillInfo();
        } else if (enumbType == HRBizDefineTypeEnum.EMPHIRE) {
            billInfo = new EmpHireBizBillInfo();
        } else if (enumbType == HRBizDefineTypeEnum.FLUCTUACTION || enumbType == HRBizDefineTypeEnum.LOAN) {
            billInfo = new FluctuationBizBillInfo();
        } else if (enumbType == HRBizDefineTypeEnum.RESIGN) {
            billInfo = new ResignBizBillInfo();
        } else if (enumbType == HRBizDefineTypeEnum.RETIRE) {
            billInfo = new RetireBizBillInfo();
        } else if (enumbType == HRBizDefineTypeEnum.REINVITE) {
            billInfo = new ReinviteBizBillInfo();
        } else if (enumbType == HRBizDefineTypeEnum.REINVITEFIRE) {
            billInfo = new ReinviteFireBizBillInfo();
        }
        return billInfo;
    }

    public static IBOSObject getIHRAffairBizBillByBizDefineType(Context ctx, HRBizDefineTypeEnum enumbType) throws BOSException {
        HRAffairBizBillInfo billInfo = PersonChangeConvertToBizBillUtil.getInstanceByHRBizDefineTypeEnum(enumbType);
        return PersonChangeConvertToBizBillUtil.getIHRAffairBizBillByBillInfo(ctx, billInfo);
    }
}

