/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.DynQuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.CommonFilterGroupInfo;
import com.kingdee.eas.hr.base.CommonFilterQueryFieldInfo;
import com.kingdee.eas.hr.base.CommonFilterSchemeException;
import com.kingdee.eas.hr.base.CommonFilterSchemeFactory;
import com.kingdee.eas.hr.base.CommonFilterSchemeInfo;
import com.kingdee.eas.hr.base.CommonFilterSchemeStatusEnum;
import com.kingdee.eas.hr.base.client.AbstractCommonFilterSchemeXEditUI;
import com.kingdee.eas.hr.base.client.CommonFilterGroupXEditUI;
import com.kingdee.eas.hr.base.client.CommonFilterQueryFiledChoseListUI;
import com.kingdee.eas.hr.base.client.CommonFilterUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class CommonFilterSchemeXEditUI
extends AbstractCommonFilterSchemeXEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CommonFilterSchemeXEditUI.class);
    public static final String CONTEXT_EDITDATA = "CONTEXT_EDITDATA";
    protected static final Color NO_EXIST_COLOR = new Color(208, 208, 208);
    private Map groupMap = new HashMap();
    private Map fieldMap = new HashMap();
    private String oldGroupFieldCode = null;
    private Map queryFieldMap = null;

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.editPageGroupPanel.setBounds(this.pageGroupPanel.getBounds());
        this.add((Component)this.editPageGroupPanel, null);
        this.pageGroupPanel.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblGroupPage.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (512 == e.getModifiersEx() && e.getKeyCode() == 73) {
                    try {
                        CommonFilterSchemeXEditUI.this.keyImportPage_actionPerformed(e);
                    }
                    catch (Exception e1) {
                        CommonFilterSchemeXEditUI.this.handleException(e1);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.groupMap.size() > 0) {
            this.editData.put("groupMap", this.groupMap);
        }
        if (this.fieldMap.size() > 0) {
            this.editData.put("fieldMap", this.fieldMap);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.fieldMap.size() <= 0 || this.groupMap.size() <= 0) {
            throw new CommonFilterSchemeException(CommonFilterSchemeException.GROUP_FIELD_NOT_BLANK);
        }
        if (this.editData.getDynQuerySolution() != null && StringUtils.isEmpty((String)this.editData.getDynQuerySolution().getNumber())) {
            throw new CommonFilterSchemeException(CommonFilterSchemeException.DYN_NOT_EXISTS);
        }
    }

    @Override
    public void loadFields() {
        this.queryFieldMap = null;
        super.loadFields();
        DynQuerySolutionInfo dynQuerySolution = this.editData.getDynQuerySolution();
        if (dynQuerySolution != null) {
            this.dynaQueryNumber.setText(dynQuerySolution.getNumber());
            this.dynaQueryName.setText(dynQuerySolution.getName());
        } else {
            String nodynastr = EASResource.getString((String)"com.kingdee.eas.hr.base.CommonFilterSchemeResource", (String)"None_dynaQuery");
            this.dynaQueryNumber.setText(nodynastr);
            this.dynaQueryName.setText(nodynastr);
        }
        if (this.editData.getDynQuerySolution() != null && StringUtils.isEmpty((String)this.editData.getDynQuerySolution().getNumber())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.CommonFilterSchemeResource", (String)"DynaQueryNotExists"));
        }
        if (this.editData.containsKey("groupMap")) {
            this.groupMap = (Map)this.editData.get("groupMap");
        }
        if (this.editData.containsKey("fieldMap")) {
            this.fieldMap = (Map)this.editData.get("fieldMap");
        }
        try {
            this.oldGroupFieldCode = this.getGroupFileCode();
            this.loadQueryFieldMap(this.editData);
            this.loadGroup();
            this.tblGroup.getSelectManager().select(0, 0);
            this.loadField();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private String getGroupFileCode() {
        StringBuffer groupFieldCode = new StringBuffer();
        Map fieldMap = CommonFilterUtil.getSortedMap(this.fieldMap, "index");
        for (Map.Entry entry : fieldMap.entrySet()) {
            CommonFilterQueryFieldInfo field = (CommonFilterQueryFieldInfo)entry.getValue();
            groupFieldCode.append("$$$");
            groupFieldCode.append(field.getIndex());
            groupFieldCode.append("$$$");
            groupFieldCode.append(field.getNumber());
            groupFieldCode.append("$$$");
            groupFieldCode.append(field.getName());
        }
        Map groupMap = CommonFilterUtil.getSortedMap(this.groupMap, "index");
        for (Map.Entry entry : groupMap.entrySet()) {
            CommonFilterGroupInfo group = (CommonFilterGroupInfo)entry.getValue();
            groupFieldCode.append("$$$");
            groupFieldCode.append(group.getIndex());
            groupFieldCode.append("$$$");
            groupFieldCode.append(group.getName());
        }
        return groupFieldCode.toString();
    }

    public boolean isModify() {
        if (OprtState.VIEW.equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            return false;
        }
        if (!this.getGroupFileCode().equals(this.oldGroupFieldCode)) {
            return true;
        }
        return super.isModify();
    }

    private void updateFieldMapByQueryFieldMap() {
        for (Map.Entry entry : this.fieldMap.entrySet()) {
            CommonFilterQueryFieldInfo field = (CommonFilterQueryFieldInfo)entry.getValue();
            if (this.queryFieldMap == null || !this.queryFieldMap.containsKey(field.getNumber())) continue;
            DataObject data = (DataObject)this.queryFieldMap.get(field.getNumber());
            if (field.getName().equals(data.getName())) continue;
            field.setName(data.getName());
            field.put("NameChanged!", "");
        }
    }

    private void loadQueryFieldMap(CommonFilterSchemeInfo info) {
        String dynQueryId = null;
        if (info.getDynQuerySolution() != null) {
            dynQueryId = info.getDynQuerySolution().getId().toString();
        }
        this.queryFieldMap = CommonFilterUtil.getQueryFilterFieldsMap(info.getQuery(), dynQueryId);
        this.updateFieldMapByQueryFieldMap();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CommonFilterSchemeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        CommonFilterSchemeInfo objectValue = new CommonFilterSchemeInfo();
        if (this.getUIContext().containsKey(CONTEXT_EDITDATA)) {
            objectValue = (CommonFilterSchemeInfo)this.getUIContext().get(CONTEXT_EDITDATA);
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setStatus(CommonFilterSchemeStatusEnum.disabled);
        return objectValue;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.groupContainer.addButton((JButton)this.btnAddNewGroup);
        this.groupContainer.addButton((JButton)this.btnEditGroup);
        this.groupContainer.addButton((JButton)this.btnDeleteGroup);
        this.btnSubmitGroupIndex.setVisible(false);
        this.groupPageContainer.addButton((JButton)this.btnImportPage);
        this.groupPageContainer.addButton((JButton)this.btnDeletePage);
        this.btnSubmitPageIndex.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.actionEdit.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionCopy.setVisible(false);
        this.initUserTable(this.tblGroup);
        this.initUserTable(this.tblGroupPage);
    }

    private void initUserTable(KDTable tblMain) {
        tblMain.checkParsed();
        tblMain.getStyleAttributes().setLocked(true);
        tblMain.getSelectManager().setSelectMode(10);
    }

    @Override
    protected void tblGroup_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblGroup_tableClicked(e);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.btnEditGroup_actionPerformed(null);
        }
    }

    @Override
    protected void editPageGroupSplitPanel_propertyChange(PropertyChangeEvent e) throws Exception {
        super.editPageGroupSplitPanel_propertyChange(e);
        if ("dividerLocation".equals(e.getPropertyName())) {
            this.editPageGroupSplitPanel.setDividerLocation(250);
        }
    }

    @Override
    protected void btnAddNewGroup_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddNewGroup_actionPerformed(e);
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        UIContext uiContext = new UIContext((Object)ownerWindow);
        IUIWindow curDialog = null;
        uiContext.put((Object)"CONTEXT_GROUPMAP", (Object)this.groupMap);
        uiContext.put((Object)"CONTEXT_UITITLE", (Object)this.getResourceStr("GroupEditTitle"));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        curDialog = uiFactory.create(CommonFilterGroupXEditUI.class.getName(), (Map)uiContext);
        curDialog.show();
        CommonFilterGroupXEditUI ui = (CommonFilterGroupXEditUI)curDialog.getUIObject();
        CommonFilterGroupInfo commonFilterGroupInfo = ui.getCommonFilterGroupInfo();
        if (commonFilterGroupInfo != null) {
            if (!this.groupMap.containsKey(commonFilterGroupInfo.getName())) {
                commonFilterGroupInfo.setIndex(this.groupMap.size());
                commonFilterGroupInfo.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
                commonFilterGroupInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                commonFilterGroupInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                this.groupMap.put(commonFilterGroupInfo.getName(), commonFilterGroupInfo);
            }
            this.loadGroup();
        }
    }

    private void selectIfNeed(KDTable tblMain) {
        if (KDTableUtil.getSelectedRow((KDTable)tblMain) == null && tblMain.getRowCount() > 0) {
            tblMain.getSelectManager().select(0, 0);
        }
    }

    @Override
    protected void tblGroup_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblGroup_tableSelectChanged(e);
        this.loadField();
    }

    @Override
    protected void btnEditGroup_actionPerformed(ActionEvent e) throws Exception {
        super.btnEditGroup_actionPerformed(e);
        this.checkSelected(this.tblGroup);
        CommonFilterGroupInfo groupInfo = (CommonFilterGroupInfo)this.getSelectedIdValues(this.tblGroup, "group").get(0);
        String groupName = groupInfo.getName();
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        UIContext uiContext = new UIContext((Object)ownerWindow);
        uiContext.put((Object)CONTEXT_EDITDATA, this.getSelectedIdValues(this.tblGroup, "group").get(0));
        uiContext.put((Object)"CONTEXT_GROUPMAP", (Object)this.groupMap);
        IUIWindow curDialog = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            curDialog = uiFactory.create(CommonFilterGroupXEditUI.class.getName(), (Map)uiContext);
            curDialog.show();
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
        CommonFilterGroupXEditUI ui = (CommonFilterGroupXEditUI)curDialog.getUIObject();
        CommonFilterGroupInfo commonFilterGroupInfo = ui.getCommonFilterGroupInfo();
        if (commonFilterGroupInfo != null) {
            this.groupMap.remove(groupName);
            this.groupMap.put(commonFilterGroupInfo.getName(), commonFilterGroupInfo);
            Map sortedMap = CommonFilterUtil.getSortedMap(this.fieldMap, "index");
            Iterator iterator = sortedMap.entrySet().iterator();
            this.tblGroupPage.removeRows();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                CommonFilterQueryFieldInfo field = (CommonFilterQueryFieldInfo)entry.getValue();
                if (!groupName.equals(field.getCommonFilterGroup().getName())) continue;
                field.getCommonFilterGroup().setName(commonFilterGroupInfo.getName());
            }
            this.loadGroup();
        }
    }

    @Override
    protected void btnDeletePage_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeletePage_actionPerformed(e);
        if (!this.beforeRemoveSelectedRow(this.tblGroupPage)) {
            return;
        }
        List values = this.getSelectedIdValues(this.tblGroupPage, "field");
        for (int i = 0; i < values.size(); ++i) {
            CommonFilterQueryFieldInfo fieldInfo = (CommonFilterQueryFieldInfo)values.get(i);
            this.fieldMap.remove(fieldInfo.getNumber());
        }
        this.loadField();
    }

    @Override
    protected void btnImportPage_actionPerformed(ActionEvent e) throws Exception {
        super.btnImportPage_actionPerformed(e);
        this.checkSelected(this.tblGroup);
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        UIContext uiContext = new UIContext((Object)ownerWindow);
        uiContext.put((Object)CONTEXT_EDITDATA, (Object)this.editData);
        IUIWindow curDialog = null;
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        curDialog = uiFactory.create(CommonFilterQueryFiledChoseListUI.class.getName(), (Map)uiContext);
        curDialog.show();
        CommonFilterQueryFiledChoseListUI ui = (CommonFilterQueryFiledChoseListUI)curDialog.getUIObject();
        if (ui.isOk()) {
            List fieldList = ui.getFieldList();
            this.importFiled(fieldList);
        }
    }

    private void importFiled(List fieldList) throws Exception {
        for (int i = 0; i < fieldList.size(); ++i) {
            DataObject field = (DataObject)fieldList.get(i);
            CommonFilterQueryFieldInfo info = new CommonFilterQueryFieldInfo();
            info.setNumber(field.getValue());
            info.setName(field.getName());
            info.setCommonFilterGroup((CommonFilterGroupInfo)this.getSelectedIdValues(this.tblGroup, "group").get(0));
            info.setIndex(this.fieldMap.size());
            info.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
            if (!this.fieldMap.containsKey(info.getNumber())) {
                this.fieldMap.put(info.getNumber(), info);
                continue;
            }
            logger.info((Object)(info.getNumber() + info.getName()));
        }
        this.loadField();
    }

    protected void keyImportPage_actionPerformed(KeyEvent e) throws Exception {
        UIContext uicontext = new UIContext((Object)this);
        uicontext.put((Object)"CONTEXT_FIELDLABLE", (Object)this.getResourceStr("FieldCollections"));
        uicontext.put((Object)"CONTEXT_MAX_LENGTH", (Object)1000);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CommonFilterGroupXEditUI.class.getName(), (Map)uicontext, null, null);
        window.show();
        CommonFilterGroupXEditUI ui = (CommonFilterGroupXEditUI)window.getUIObject();
        if (ui.getCommonFilterGroupInfo() != null) {
            String fieldstr = ui.getCommonFilterGroupInfo().getName();
            HashMap<String, DataObject> queryFieldNameMap = new HashMap<String, DataObject>();
            for (Map.Entry entry : this.queryFieldMap.entrySet()) {
                DataObject da = (DataObject)entry.getValue();
                queryFieldNameMap.put(da.getName(), da);
            }
            String[] fields = fieldstr.split(",");
            ArrayList<DataObject> fieldList = new ArrayList<DataObject>();
            for (int i = 0; i < fields.length; ++i) {
                DataObject da = (DataObject)this.queryFieldMap.get(fields[i]);
                if (da == null) {
                    da = (DataObject)queryFieldNameMap.get(fields[i]);
                }
                if (da != null) {
                    fieldList.add(da);
                    continue;
                }
                logger.error((Object)("fast import not find:" + fields[i]));
            }
            this.importFiled(fieldList);
        }
    }

    private void loadField() throws Exception {
        CommonFilterGroupInfo info;
        this.tblGroupPage.removeRows();
        CommonFilterUtil.reFreshMapIndex(this.fieldMap);
        List groups = this.getSelectedIdValues(this.tblGroup, "group");
        if (groups != null && groups.size() > 0 && (info = (CommonFilterGroupInfo)groups.get(0)) != null) {
            Map sortedMap = CommonFilterUtil.getSortedMap(this.fieldMap, "index");
            for (Map.Entry entry : sortedMap.entrySet()) {
                CommonFilterQueryFieldInfo field = (CommonFilterQueryFieldInfo)entry.getValue();
                if (!info.getName().equals(field.getCommonFilterGroup().getName())) continue;
                IRow row = this.tblGroupPage.addRow();
                row.getCell("field").setValue((Object)field);
                if (this.queryFieldMap != null && !this.queryFieldMap.containsKey(field.getNumber())) {
                    row.getStyleAttributes().setBackground(NO_EXIST_COLOR);
                }
                if (!field.containsKey("NameChanged!")) continue;
                row.getStyleAttributes().setBackground(new Color(208, 208, 108));
            }
        }
        this.selectIfNeed(this.tblGroupPage);
    }

    private void loadGroup() throws Exception {
        CommonFilterUtil.reFreshMapIndex(this.groupMap);
        Map sortedMap = CommonFilterUtil.getSortedMap(this.groupMap, "index");
        Iterator iterator = sortedMap.entrySet().iterator();
        this.tblGroup.removeRows();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            IRow row = this.tblGroup.addRow();
            CommonFilterGroupInfo group = (CommonFilterGroupInfo)entry.getValue();
            row.getCell("group").setValue((Object)group);
        }
        this.selectIfNeed(this.tblGroup);
    }

    private void storeGroup() throws Exception {
        this.groupMap.clear();
        for (int i = 0; i < this.tblGroup.getRowCount(); ++i) {
            CommonFilterGroupInfo info = (CommonFilterGroupInfo)this.tblGroup.getRow(i).getCell("group").getValue();
            info.setIndex(i);
            this.groupMap.put(info.getName(), info);
        }
    }

    private void storeField() throws Exception {
        CommonFilterQueryFieldInfo info;
        int i;
        for (i = 0; i < this.tblGroupPage.getRowCount(); ++i) {
            info = (CommonFilterQueryFieldInfo)this.tblGroupPage.getRow(i).getCell("field").getValue();
            this.fieldMap.remove(info.getNumber());
        }
        CommonFilterUtil.reFreshMapIndex(this.fieldMap);
        for (i = 0; i < this.tblGroupPage.getRowCount(); ++i) {
            info = (CommonFilterQueryFieldInfo)this.tblGroupPage.getRow(i).getCell("field").getValue();
            info.setIndex(this.fieldMap.size());
            this.fieldMap.put(info.getNumber(), info);
        }
    }

    @Override
    protected void btnDeleteGroup_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteGroup_actionPerformed(e);
        if (!this.beforeRemoveSelectedRow(this.tblGroup)) {
            return;
        }
        List values = this.getSelectedIdValues(this.tblGroup, "group");
        for (int i = 0; i < values.size(); ++i) {
            CommonFilterGroupInfo commonFilterGroupInfo = (CommonFilterGroupInfo)values.get(i);
            this.groupMap.remove(commonFilterGroupInfo.getName());
            Iterator iterator = this.fieldMap.entrySet().iterator();
            ArrayList<String> fieldList = new ArrayList<String>();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                CommonFilterQueryFieldInfo field = (CommonFilterQueryFieldInfo)entry.getValue();
                if (!commonFilterGroupInfo.getName().equals(field.getCommonFilterGroup().getName())) continue;
                fieldList.add(field.getNumber());
            }
            for (int k = 0; k < fieldList.size(); ++k) {
                this.fieldMap.remove(fieldList.get(k));
            }
        }
        this.loadGroup();
        if (this.groupMap.size() == 0) {
            this.loadField();
        }
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnDown_actionPerformed(e);
        this.checkSelected(this.tblGroupPage);
        HRUtil.moveTableRowToDown(this.tblGroupPage);
        this.storeField();
    }

    @Override
    protected void btnDown2_actionPerformed(ActionEvent e) throws Exception {
        super.btnDown2_actionPerformed(e);
        this.checkSelected(this.tblGroup);
        HRUtil.moveTableRowToDown(this.tblGroup);
        this.storeGroup();
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        super.btnTop_actionPerformed(e);
        this.checkSelected(this.tblGroupPage);
        HRUtil.moveTableRowToTop(this.tblGroupPage);
        this.storeField();
    }

    @Override
    protected void btnTop2_actionPerformed(ActionEvent e) throws Exception {
        super.btnTop2_actionPerformed(e);
        this.checkSelected(this.tblGroup);
        HRUtil.moveTableRowToTop(this.tblGroup);
        this.storeGroup();
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnUp_actionPerformed(e);
        this.checkSelected(this.tblGroupPage);
        HRUtil.moveTableRowToUp(this.tblGroupPage);
        this.storeField();
    }

    @Override
    protected void btnUp2_actionPerformed(ActionEvent e) throws Exception {
        super.btnUp2_actionPerformed(e);
        this.checkSelected(this.tblGroup);
        HRUtil.moveTableRowToUp(this.tblGroup);
        this.storeGroup();
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        super.btnBottom_actionPerformed(e);
        this.checkSelected(this.tblGroupPage);
        HRUtil.moveTableRowToBottom(this.tblGroupPage);
        this.storeField();
    }

    @Override
    protected void btnBottom2_actionPerformed(ActionEvent e) throws Exception {
        super.btnBottom2_actionPerformed(e);
        this.checkSelected(this.tblGroup);
        HRUtil.moveTableRowToBottom(this.tblGroup);
        this.storeGroup();
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.btnAddNewGroup.setEnabled(false);
        this.btnImportPage.setEnabled(false);
        this.btnDeleteGroup.setEnabled(false);
        this.btnDeletePage.setEnabled(false);
        this.btnEditGroup.setEnabled(false);
    }

    private boolean beforeRemoveSelectedRow(KDTable tblMain) {
        this.checkSelected(tblMain);
        return this.confirmRemove();
    }

    private void checkSelected(KDTable tblMain) {
        if (tblMain.getRowCount() == 0 || tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private List getSelectedIdValues(KDTable tblMain, String colName) throws Exception {
        if (tblMain.getRowCount() < 1) {
            return null;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)tblMain);
        ArrayList<Object> ids = new ArrayList<Object>(selectRows.length);
        int length = selectRows.length;
        for (int i = 0; i < length; ++i) {
            ids.add(tblMain.getRow(selectRows[i]).getCell(colName).getValue());
        }
        return ids;
    }

    private void putSelectedIdValue(KDTable tblMain, String colName, Object value) throws Exception {
        if (tblMain.getRowCount() < 1) {
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)tblMain);
        if (selectRows.length > 0 && selectRows[0] >= 0) {
            tblMain.getRow(selectRows[0]).getCell(colName).setValue(value);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("ui"));
        sic.add(new SelectorItemInfo("query"));
        return sic;
    }

    private String getFixedLenStr(int num) {
        String numstr = "" + num;
        for (int i = 0; i < 5 - numstr.length(); ++i) {
            numstr = "0" + numstr;
        }
        return numstr;
    }

    private String getResourceStr(String key) {
        return EASResource.getString((String)"com.kingdee.eas.hr.base.CommonFilterSchemeResource", (String)key);
    }
}

