/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.hr.base.client.AbstractEntityColumnSelectUI;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EntityColumnSelectUI
extends AbstractEntityColumnSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(EntityColumnSelectUI.class);
    public boolean isCanceled = true;
    private boolean isSingle = true;
    private PropertyInfo[] returnData = null;
    HashSet alreadySelected = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.columnTable.getSelectManager().setSelectMode(2);
        this.columnTable.checkParsed();
        String entityName = (String)this.getUIContext().get("entityName");
        if (StringUtils.isEmpty((String)entityName)) {
            return;
        }
        this.alreadySelected = (HashSet)this.getUIContext().get("alreadySelected");
        if (this.alreadySelected == null) {
            this.alreadySelected = new HashSet();
        }
        if (this.getUIContext().get("isSingle") != null) {
            this.isSingle = (Boolean)this.getUIContext().get("isSingle");
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(entityName));
        this.loadEntityToTable(entity);
    }

    private void loadEntityToTable(EntityObjectInfo entity) {
        PropertyCollection propertyColl = entity.getInheritedProperties();
        this.columnTable.removeRows();
        PropertyInfo prop = null;
        IRow row = null;
        for (int i = 0; i < propertyColl.size(); ++i) {
            prop = propertyColl.get(i);
            if (prop.getMappingField() == null || this.alreadySelected.contains(prop.getName().toUpperCase())) continue;
            row = this.columnTable.addRow();
            row.setUserObject((Object)prop);
            row.getCell("properties").setValue((Object)prop.getName());
            row.getCell("alias").setValue((Object)prop.getAlias());
            row.getCell("type").setValue((Object)prop.getMappingField().getTypeName());
        }
    }

    @Override
    public void confirmAction_actionPerformed(ActionEvent e) throws Exception {
        super.confirmAction_actionPerformed(e);
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.columnTable);
        if (rowID.length > 0) {
            if (this.isSingle) {
                PropertyInfo prop = (PropertyInfo)this.columnTable.getRow(rowID[0]).getUserObject();
                this.returnData = new PropertyInfo[]{prop};
            } else {
                this.returnData = new PropertyInfo[rowID.length];
                for (int i = 0; i < rowID.length; ++i) {
                    this.returnData[i] = (PropertyInfo)this.columnTable.getRow(rowID[i]).getUserObject();
                }
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label164"));
            return;
        }
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    @Override
    public void cancleAction_actionPerformed(ActionEvent e) throws Exception {
        super.cancleAction_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public boolean isCancle() {
        return this.isCanceled;
    }

    public Object getData() {
        return this.returnData;
    }
}

