/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgContextManager;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.client.HRCoreUIObject;
import com.kingdee.eas.hr.base.client.HRCustomerQueryPanelUI;
import com.kingdee.eas.hr.base.client.IHRPanelListener;
import com.kingdee.eas.hr.base.client.IListUIBiz;
import com.kingdee.eas.hr.base.client.PlugInUIDecorator;
import com.kingdee.eas.hr.base.client.PlugInUIParam;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HRListUIObject
extends HRCoreUIObject {
    private IMetaDataPK mainQueryPK = null;
    protected IListUIBiz listBiz = null;

    public HRListUIObject(CoreUI ui, Map uiContext, IMetaDataPK mainQueryPK, PlugInUIDecorator plugIn, PlugInUIParam plugInParam, IListUIBiz biz) {
        super(ui, uiContext, plugIn, plugInParam, biz);
        this.listBiz = biz;
        this.mainQueryPK = mainQueryPK;
    }

    public boolean isAllowDefaultSolutionNull() {
        if (this.uiContext.get(OrgType.HRO) != null) {
            HROrgUnitInfo hrOrgUnitInfo = (HROrgUnitInfo)this.uiContext.get(OrgType.HRO);
            try {
                hrOrgUnitInfo = HROrgContextManagerFacadeFactory.getRemoteInstance().getLegalityHROrg(hrOrgUnitInfo, MetaDataTypeList.BASEQUERY, this.mainQueryPK);
                return hrOrgUnitInfo != null;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return false;
    }

    public CommonQueryDialog initCommonQueryDialog(CommonQueryDialog dialog, OrgContextManager orgContextManager, IHRPanelListener[] panels) {
        if (dialog == null) {
            return dialog;
        }
        if (orgContextManager != null && orgContextManager.getOwner() != null && orgContextManager.getOwner() instanceof HRCustomerQueryPanelUI) {
            List ps;
            HRCustomerQueryPanelUI mainPanel = (HRCustomerQueryPanelUI)orgContextManager.getOwner();
            mainPanel.setMetaDataPKForPemmission(this.mainQueryPK);
            IHRPanelListener[] lisPanels = this.getListenerPanels(panels);
            if (lisPanels != null) {
                for (int i = 0; i < lisPanels.length; ++i) {
                    mainPanel.addListenerPanel(lisPanels[i]);
                }
            }
            if ((ps = mainPanel.getListenerPanels()) != null) {
                for (Object panel : ps) {
                    if (!(panel instanceof CustomerQueryPanel)) continue;
                    dialog.addUserPanel((KDPanel)((CustomerQueryPanel)panel));
                }
            }
        }
        return dialog;
    }

    public void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        if (this.biz != null) {
            this.listBiz.handleQueryDialog(dialog);
        }
        if (this.plugIn != null) {
            this.plugIn.handleQueryDialog(dialog);
        }
    }

    private IHRPanelListener[] getListenerPanels(IHRPanelListener[] panels) {
        if (this.biz != null) {
            try {
                panels = this.mergeListener(this.listBiz.getListenerPanel(), panels);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.plugIn != null) {
            try {
                panels = this.mergeListener(this.plugIn.getListenerPanel(), panels);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return panels;
    }

    protected IHRPanelListener[] mergeListener(IHRPanelListener[] lis1, IHRPanelListener[] lis2) {
        if (lis1 == null && lis2 == null) {
            return null;
        }
        if (lis1 != null && lis2 != null) {
            int i;
            ArrayList<IHRPanelListener> list = new ArrayList<IHRPanelListener>();
            for (i = 0; i < lis1.length; ++i) {
                list.add(lis1[i]);
            }
            for (i = 0; i < lis2.length; ++i) {
                list.add(lis2[i]);
            }
            if (list != null) {
                IHRPanelListener[] result = new IHRPanelListener[list.size()];
                int size = list.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    result[i2] = (IHRPanelListener)list.get(i2);
                }
                return result;
            }
        }
        if (lis1 != null) {
            return lis1;
        }
        if (lis2 != null) {
            return lis2;
        }
        return null;
    }

    public FilterInfo getDefaultFilterForQuery(FilterInfo fi) {
        FilterInfo filter = null;
        try {
            filter = this.biz != null ? this.listBiz.getDefaultFilterForQuery() : fi;
            if (this.plugIn != null) {
                filter = this.plugIn.getDefaultFilterForQuery(filter);
            }
            if (filter == null) {
                filter = new FilterInfo();
            }
            if (fi != null && filter != null) {
                filter.mergeFilter(fi, "and");
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return filter;
    }

    public IMultiOrgSupport getMainCustomerQueryPanel() {
        if (this.biz != null) {
            try {
                if (this.listBiz.getMainCustomerQueryPanel() != null) {
                    return this.listBiz.getMainCustomerQueryPanel();
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return null;
    }

    public void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)OrgType.HRO, this.uiContext.get(OrgType.HRO));
        if (this.biz != null) {
            this.listBiz.prepareUIContext(uiContext, e);
        }
        if (this.plugIn != null) {
            this.plugIn.prepareUIContext(uiContext, e);
        }
    }
}

