/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.hr.base.client.GroupLayout;
import com.kingdee.eas.hr.base.client.GroupModel;
import com.kingdee.eas.hr.base.client.KDGroupContainer;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class KDGroupPane
extends KDPanel {
    private List groupModelList = null;
    private KDPanel pNorth = new KDPanel();
    private KDPanel pCenter = new KDPanel();
    private KDPanel pSouth = new KDPanel();
    private ArrayList groupList = new ArrayList();
    private KDGroupContainer activeGroup = null;
    transient ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            KDWorkButton bttTitle = (KDWorkButton)e.getSource();
            KDGroupPane.this.expandGroup((KDGroupContainer)((Object)bttTitle.getParent()));
        }
    };
    transient ListSelectionListener lsl = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            try {
                if (!e.getValueIsAdjusting()) {
                    KDGroupPane.this.memberClick();
                }
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Throwable)e1);
                SysUtil.abort();
            }
        }
    };

    public KDGroupPane(List gmList) {
        this.initComponents();
        this.groupModelList = gmList;
        if (this.groupModelList == null) {
            this.createDefaultGroup();
        } else {
            this.createGroupFromModel();
        }
    }

    protected void memberClick() throws Exception {
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.pNorth, "North");
        this.add((Component)this.pCenter, "Center");
        this.add((Component)this.pSouth, "South");
        this.pNorth.setLayout((LayoutManager)new GroupLayout());
        this.pCenter.setLayout((LayoutManager)new BorderLayout());
        this.pSouth.setLayout((LayoutManager)new GroupLayout());
    }

    private void createGroupFromModel() {
        GroupModel model = null;
        int size = this.groupModelList.size();
        for (int i = 0; i < size; ++i) {
            model = (GroupModel)this.groupModelList.get(i);
            this.insertGroup(i, model.title);
            if (model.itemsList == null) continue;
            int length = model.itemsList.size();
            for (int j = 0; j < length; ++j) {
                this.addMember(i, model.itemsList.get(j));
            }
            this.getGroup(i).setMemberGap(0, 0);
            this.getGroup(i).getMemberContainer().addListSelectionListener(this.lsl);
        }
        this.expandGroup(0);
    }

    private void createDefaultGroup() {
        Color[] bg = new Color[]{Color.black, Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.white};
        for (int i = 1; i <= bg.length; ++i) {
            this.insertGroup(i - 1, "Group " + i, bg[i - 1]);
            Color mc = new Color(255 - bg[i - 1].getRed(), 255 - bg[i - 1].getGreen(), 255 - bg[i - 1].getBlue());
            for (int j = 1; j <= 5; ++j) {
                KDWorkButton bttMember = new KDWorkButton("Member " + j + " of " + i);
                this.addMember(i - 1, (Component)bttMember);
                bttMember.setPreferredSize(new Dimension(1, 40));
                bttMember.setOpaque(false);
                bttMember.setForeground(mc);
            }
            this.getGroup(i - 1).setMemberGap(20, 5);
            this.getGroup(i - 1).getTitleButton().setForeground(bg[i - 1]);
        }
        this.expandGroup(0);
    }

    public KDGroupPane(String[] groupNames) {
        this.initComponents();
        this.addGroup(groupNames);
    }

    public void expandGroup(String name) {
        for (int i = this.getGroupCount() - 1; i >= 0; --i) {
            if (!this.getGroupName(i).equals(name)) continue;
            this.expandGroup(i);
        }
    }

    public void expandGroup(int index) {
        this.expandGroup(this.getGroup(index));
    }

    public void expandDefaultGroup() {
        if (this.activeGroup != null) {
            this.activeGroup.getMemberContainer().setSelectedIndex(-1);
        }
        this.expandGroup(this.getGroup(0));
        this.activeGroup.getMemberContainer().setSelectedIndex(0);
    }

    public KDGroupContainer getDefaultGroup() {
        return this.getGroup(0);
    }

    protected void expandGroup(KDGroupContainer group) {
        this.pNorth.removeAll();
        this.pCenter.removeAll();
        this.pSouth.removeAll();
        boolean hasAddCenter = false;
        for (int i = 0; i < this.groupList.size(); ++i) {
            Component c = (Component)this.groupList.get(i);
            if (hasAddCenter) {
                this.pSouth.add(c);
                continue;
            }
            if (c == group) {
                this.pCenter.add(c, (Object)"Center");
                hasAddCenter = true;
                continue;
            }
            this.pNorth.add(c);
        }
        if (this.activeGroup != null) {
            this.activeGroup.collapse();
        }
        this.activeGroup = group;
        this.activeGroup.expand();
        this.pNorth.doLayout();
        this.pCenter.doLayout();
        this.pSouth.doLayout();
        this.doLayout();
    }

    public void collapseGroup(String name) {
        for (int i = this.getGroupCount() - 1; i >= 0; --i) {
            if (!this.getGroupName(i).equals(name)) continue;
            this.collapseGroup(i);
        }
    }

    public void collapseGroup(int index) {
        this.collapseGroup(this.getGroup(index));
    }

    protected void collapseGroup(KDGroupContainer group) {
        if (group == this.activeGroup) {
            this.activeGroup.collapse();
            this.activeGroup = null;
        }
    }

    public void addGroup(String name) {
        this.insertGroup(this.getGroupCount(), name);
    }

    public void addGroup(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.addGroup(names[i]);
        }
    }

    public void insertGroup(int index, String name, Color bg) {
        if (index < 0 || index > this.groupList.size()) {
            throw new ArrayIndexOutOfBoundsException("index:" + index + " >count:" + this.groupList.size());
        }
        int countNorth = this.pNorth.getComponentCount();
        int countCenter = this.pCenter.getComponentCount();
        int countSouth = this.pSouth.getComponentCount();
        KDGroupContainer group = index <= countNorth ? this.insertGroup(this.pNorth, index, name, bg) : (index <= countNorth + countCenter ? this.insertGroup(this.pCenter, index - countNorth, name, bg) : (index <= countNorth + countCenter + countSouth ? this.insertGroup(this.pSouth, index - countNorth - countCenter, name, bg) : this.insertGroup(this.pSouth, countSouth, name, bg)));
        group.getTitleButton().addActionListener(this.al);
        this.groupList.add(index, group);
    }

    public void insertGroup(int index, String name) {
        this.insertGroup(index, name, UIManager.getColor("Desktop.background"));
    }

    private KDGroupContainer insertGroup(KDPanel p, int index, String name, Color bg) {
        KDGroupContainer group = new KDGroupContainer(name, bg);
        p.add((Component)((Object)group));
        return group;
    }

    public void removeGroup(int index) {
        KDGroupContainer c = (KDGroupContainer)((Object)this.groupList.get(index));
        this.groupList.remove(index);
        c.getParent().remove((Component)((Object)c));
        c.getTitleButton().removeActionListener(this.al);
        this.pNorth.doLayout();
        this.pCenter.doLayout();
        this.pSouth.doLayout();
        this.doLayout();
    }

    public void removeGroup(String name) {
        for (int i = this.getGroupCount() - 1; i >= 0; --i) {
            if (!this.getGroupName(i).equals(name)) continue;
            this.removeGroup(i);
        }
    }

    public void setGroupName(int index, String name) {
        this.getGroup(index).setName(name);
    }

    public String getGroupName(int groupIndex) {
        return this.getGroup(groupIndex).getName();
    }

    public String[] getGroupNames() {
        String[] sResult = new String[this.getGroupCount()];
        for (int i = 0; i < this.getGroupCount(); ++i) {
            sResult[i] = this.getGroupName(i);
        }
        return sResult;
    }

    public int getGroupCount() {
        return this.groupList.size();
    }

    public void addMember(int groupIndex, Component member) {
        this.getGroup(groupIndex).addMember(this.getGroup(groupIndex).getMemberCount(), member);
    }

    public void addMember(int groupIndex, Object member) {
        this.getGroup(groupIndex).addMember(this.getGroup(groupIndex).getMemberCount(), member);
    }

    public void insertMember(int groupIndex, int memberIndex, Component member) {
        this.getGroup(groupIndex).addMember(memberIndex, member);
    }

    public void removeMember(int groupIndex, int memberIndex) {
        this.getGroup(groupIndex).removeMember(memberIndex);
    }

    public Component getMember(int groupIndex, int memberIndex) {
        return this.getGroup(groupIndex).getMember(memberIndex);
    }

    public Component[] getMembers(int groupIndex) {
        return this.getGroup(groupIndex).getMembers();
    }

    public int getMemberCount(int groupIndex) {
        return this.getGroup(groupIndex).getMemberCount();
    }

    public KDGroupContainer getActiveGroup() {
        return this.activeGroup;
    }

    public KDGroupContainer getGroup(int index) {
        return (KDGroupContainer)((Object)this.groupList.get(index));
    }

    public KDGroupContainer getGroup(String name) {
        KDGroupContainer kdGroup = null;
        int size = this.groupList.size();
        for (int i = 0; i < size; ++i) {
            kdGroup = (KDGroupContainer)((Object)this.groupList.get(i));
            if (!kdGroup.getTitleButton().getText().equalsIgnoreCase(name)) continue;
            return kdGroup;
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            CtrlUIEnv.setKingdeeLAF();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setTitle("JGroupPanel Demo");
        frame.getContentPane().setLayout(new BorderLayout());
        ArrayList<GroupModel> list = new ArrayList<GroupModel>();
        GroupModel model = new GroupModel();
        ArrayList<String> itemList = new ArrayList<String>();
        model.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"73_KDGroupPane"));
        itemList.add(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"74_KDGroupPane"));
        itemList.add(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"75_KDGroupPane"));
        itemList.add(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"76_KDGroupPane"));
        model.setItemsList(itemList);
        list.add(model);
        model = new GroupModel();
        itemList = new ArrayList();
        model.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"77_KDGroupPane"));
        itemList.add(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"78_KDGroupPane"));
        itemList.add(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"79_KDGroupPane"));
        itemList.add(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"80_KDGroupPane"));
        model.setItemsList(itemList);
        list.add(model);
        model = new GroupModel();
        model.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"81_KDGroupPane"));
        list.add(model);
        KDGroupPane p = new KDGroupPane(list);
        frame.getContentPane().add((Component)((Object)p), "Center");
        frame.setSize(150, 600);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(d.width - frame.getSize().width - 10, 10);
        frame.setVisible(true);
    }
}

