/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.hr.client.f7.IF7ParamFromUI;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.client.AbstractOrgChartSwitchUI;
import com.kingdee.eas.hr.base.client.HRF7CommonRegister;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.IOrgChartTreeBuilder;
import com.kingdee.eas.hr.base.client.f7.DefaultF7PramFromUI;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class OrgChartSwitchUI
extends AbstractOrgChartSwitchUI {
    private boolean isCanceled = true;
    private KDLabel previewLab;
    private IOrgChartTreeBuilder chartBuilder = null;
    private AdminOrgUnitInfo adminInfo = null;
    private int level = 1;

    protected IF7ParamFromUI getF7ParamFromUI() {
        return new DefaultF7PramFromUI((CoreUIObject)this, this.getMainOrgContext(), OrgType.HRO, false);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.HRO;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        IHRF7CommonRegister register = HRF7CommonRegister.getInstance(this.getF7ParamFromUI());
        register.registerAdminByOrgRangePromptBox(this.prmtAdmin);
        this.prmtAdmin.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                OrgChartSwitchUI.this.initOrgLevel((AdminOrgUnitInfo)e.getData());
            }
        });
        this.previewLab = new KDLabel();
        this.kDSplitPane1.add((Component)this.previewLab, (Object)"right");
        this.kDSplitPane1.setDividerLocation(150);
        this.kDSplitPane1.setEnabled(false);
        this.kDTable1.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    OrgChartSwitchUI.this.kDTable1_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    OrgChartSwitchUI.this.handUIException(exc);
                }
            }
        });
        this.kDTable1.checkParsed();
        StringBuffer sql = new StringBuffer("SELECT FName_");
        sql.append(SysContext.getSysContext().getLocale());
        sql.append(" AS FName,FPluginClassName,FDescription_");
        sql.append(SysContext.getSysContext().getLocale());
        sql.append(" AS FDesc FROM T_HR_OrgChartPlugin ");
        try {
            IRowSet rows = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            if (rows == null) {
                return;
            }
            IRow row = null;
            while (rows.next()) {
                row = this.kDTable1.addRow();
                row.getCell(0).setValue((Object)rows.getString("FPluginClassName"));
                row.getCell(1).setValue((Object)rows.getString("FName"));
                row.getCell(2).setValue((Object)rows.getString("FDesc"));
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
    }

    protected void kDTable1_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex = KDTableUtil.getSelectedRow((KDTable)this.kDTable1);
        String className = this.kDTable1.getRow(rowIndex).getCell(0).getValue().toString();
        Class<?> classObj = Class.forName(className);
        this.chartBuilder = (IOrgChartTreeBuilder)classObj.newInstance();
        Dimension size = new Dimension(this.kDSplitPane1.getWidth() - 150, this.kDSplitPane1.getHeight());
        BufferedImage bf = new BufferedImage(size.width, size.height, 2);
        Graphics2D g = (Graphics2D)bf.getGraphics();
        this.chartBuilder.paintDemo(g, size);
        this.previewLab.setIcon((Icon)new ImageIcon(bf));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTable1.getStyleAttributes().setLocked(true);
        this.kDTable1.getSelectManager().select(0, 1);
    }

    private void initOrgLevel(AdminOrgUnitInfo adminInfo) {
        this.cboLevel.removeAllItems();
        if (adminInfo == null) {
            return;
        }
        int level = 1;
        try {
            level = HRUtil.getAdminOrgLevelCount(adminInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        for (int i = 1; i <= level; ++i) {
            this.cboLevel.addItem((Object)i);
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        this.setCanceled(false);
        this.getUIWindow().close();
    }

    @Override
    protected void btnQuit_actionPerformed(ActionEvent e) throws Exception {
        super.btnQuit_actionPerformed(e);
        this.setCanceled(true);
        this.getUIWindow().close();
    }

    public void setChartBuilder(IOrgChartTreeBuilder chartBuilder) {
        this.chartBuilder = chartBuilder;
    }

    public IOrgChartTreeBuilder getChartBuilder() {
        if (this.chartBuilder != null && this.getAdminInfo() != null) {
            this.chartBuilder.setAdminInfo(this.getAdminInfo());
            this.chartBuilder.setLevel(this.getLevel());
        }
        return this.chartBuilder;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        if (this.cboLevel.getSelectedIndex() > -1) {
            return this.cboLevel.getSelectedIndex() + 1;
        }
        return 0;
    }

    public void setAdminInfo(AdminOrgUnitInfo adminInfo) {
        this.adminInfo = adminInfo;
    }

    public AdminOrgUnitInfo getAdminInfo() {
        return (AdminOrgUnitInfo)this.prmtAdmin.getData();
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

