/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SHRAdminActivatedCollection;
import com.kingdee.eas.hr.base.SHRAdminActivatedFactory;
import com.kingdee.eas.hr.base.client.AbstractSHRAdminInitUI;
import com.kingdee.eas.hr.base.client.util.ActivatedAdminResultPolo;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class SHRAdminInitUI
extends AbstractSHRAdminInitUI {
    private static final Logger logger = CoreUIObject.getLogger(SHRAdminInitUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        List adminInfoList = (List)this.getUIContext().get("AdminInfoList");
        if (adminInfoList != null) {
            if (adminInfoList.size() > 1) {
                this.shrCHK.setVisible(false);
                this.shrCHK.setSelected(false);
            } else {
                this.shrCHK.setVisible(true);
                this.shrCHK.setSelected(true);
            }
        }
    }

    @Override
    public void actionInitSure_actionPerformed(ActionEvent e) throws Exception {
        AdminOrgUnitInfo info;
        java.util.Date effectDate = new java.util.Date();
        HashSet<String> idSet = new HashSet<String>();
        boolean isContains = this.shrCHK.isSelected();
        effectDate = this.shrDP.getTimestamp();
        ArrayList<ActivatedAdminResultPolo> failList = new ArrayList<ActivatedAdminResultPolo>();
        ActivatedAdminResultPolo polo = new ActivatedAdminResultPolo();
        List adminInfoList = (List)this.getUIContext().get("AdminInfoList");
        int sucessCount = 0;
        if (adminInfoList == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label95"));
        }
        if (isContains) {
            info = (AdminOrgUnitInfo)adminInfoList.get(0);
            AdminOrgUnitCollection adminOrgColl = this.getSubAdminCollection(info);
            for (int k = 0; k < adminOrgColl.size(); ++k) {
                AdminOrgUnitInfo tempInfo = adminOrgColl.get(k);
                polo = this.activatedAdmin(effectDate, tempInfo, true);
                polo.setOrgName(tempInfo.getName());
                polo.setOrgNum(tempInfo.getNumber());
                if (polo.isActivated()) {
                    ++sucessCount;
                    idSet.add(tempInfo.getId().toString());
                    continue;
                }
                failList.add(polo);
            }
        } else {
            for (int i = 0; i < adminInfoList.size(); ++i) {
                info = (AdminOrgUnitInfo)adminInfoList.get(i);
                polo = this.activatedAdmin(effectDate, info, false);
                polo.setOrgName(info.getName());
                polo.setOrgNum(info.getNumber());
                if (polo.isActivated()) {
                    ++sucessCount;
                    idSet.add(info.getId().toString());
                    continue;
                }
                failList.add(polo);
            }
        }
        SHRAdminActivatedFactory.getRemoteInstance().activatedSHRAdmin(idSet, effectDate);
        if (failList.size() > 0) {
            StringBuffer infoString = new StringBuffer();
            StringBuffer errString = new StringBuffer();
            infoString.append("1. ");
            infoString.append(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label159"));
            infoString.append(sucessCount);
            infoString.append("\r\n");
            infoString.append("\r\n");
            infoString.append("2. ");
            infoString.append(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label160"));
            infoString.append(failList.size());
            for (int n = 0; n < failList.size(); ++n) {
                ActivatedAdminResultPolo failResult = (ActivatedAdminResultPolo)failList.get(n);
                errString.append(failResult.getOrgName());
                errString.append("\uff08");
                errString.append(failResult.getOrgNum());
                errString.append("\uff09");
                errString.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label161"), failResult.getResultMsg()));
                errString.append("\r\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)infoString.toString(), (String)errString.toString(), (int)1);
        } else {
            this.btnSure.setEnabled(false);
            this.shrCHK.setEnabled(false);
            this.getUIWindow().close();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label92"));
        }
    }

    private String checkHasType(AdminOrgUnitInfo info) throws EASBizException, BOSException {
        String msg = null;
        if (info.getUnitLayerType() == null) {
            msg = EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label93");
            return msg;
        }
        OrgUnitLayerTypeInfo orgUnitLayerTypeInfo = OrgUnitLayerTypeFactory.getRemoteInstance().getOrgUnitLayerTypeInfo((IObjectPK)new ObjectUuidPK(info.getUnitLayerType().getId()));
        if (orgUnitLayerTypeInfo.getAdminAffiliationType() == null) {
            msg = EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label93");
            return msg;
        }
        AdminOrgUnitInfo parentAdmin = info.getParent();
        if (parentAdmin != null && parentAdmin.getId() != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("unitLayerType.adminAffiliationType.id"));
            parentAdmin = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentAdmin.getId()), selector);
            String affiliationTypeID = orgUnitLayerTypeInfo.getAdminAffiliationType().getId().toString();
            String parentAffiliationTypeID = null;
            if ("US3TP3eIJgbgU0A+qMDqhoRbQ4A=".equals(affiliationTypeID) && !"US3TP3eIJgbgU0A+qMDqhoRbQ4A=".equals(parentAffiliationTypeID = parentAdmin.getUnitLayerType().getAdminAffiliationType().getId().toString())) {
                msg = EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label96");
            }
        }
        return msg;
    }

    private AdminOrgUnitCollection getSubAdminCollection(AdminOrgUnitInfo info) throws BOSException {
        AdminOrgUnitCollection col = new AdminOrgUnitCollection();
        StringBuffer sb = new StringBuffer();
        sb.append(" select id ,longnumber , number ,name,unitLayerType,parent ").append(" where longnumber like '").append(info.getLongNumber()).append("!%'").append(" or longnumber='").append(info.getLongNumber()).append("' order by longnumber");
        col = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(sb.toString());
        return col;
    }

    private List getParentAdminList(List adminInfoList) {
        String longNumber = "";
        Object compareLongNumber = null;
        Object lightNumber = null;
        ArrayList<AdminOrgUnitInfo> newList = new ArrayList<AdminOrgUnitInfo>();
        boolean isSon = true;
        for (int i = adminInfoList.size(); i > 0; --i) {
            isSon = true;
            AdminOrgUnitInfo info = (AdminOrgUnitInfo)adminInfoList.get(i - 1);
            if (newList == null || newList.size() == 0) {
                newList.add(info);
                continue;
            }
            for (int j = newList.size(); j > 0; --j) {
                AdminOrgUnitInfo newInfo = (AdminOrgUnitInfo)newList.get(j - 1);
                if (info.getLongNumber().startsWith(newInfo.getLongNumber())) {
                    isSon = true;
                    break;
                }
                if (newInfo.getLongNumber().startsWith(info.getLongNumber())) {
                    newList.remove(newInfo);
                    newList.add(info);
                    isSon = true;
                    break;
                }
                isSon = false;
            }
            if (isSon) continue;
            newList.add(info);
        }
        return newList;
    }

    private ActivatedAdminResultPolo activatedAdmin(java.util.Date effectDate, AdminOrgUnitInfo info, boolean isContainSubOrg) throws BOSException, EASBizException {
        ActivatedAdminResultPolo polo = new ActivatedAdminResultPolo();
        if (info == null) {
            polo.setActivated(false);
            return polo;
        }
        StringBuffer existsSql = new StringBuffer();
        existsSql.append("select * ").append(" where adminOrgUnit='").append(info.getId().toString()).append("'");
        SHRAdminActivatedCollection col = SHRAdminActivatedFactory.getRemoteInstance().getSHRAdminActivatedCollection(existsSql.toString());
        if (col.size() > 0) {
            polo.setActivated(false);
            polo.setResultMsg(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label84"));
        } else {
            String msg = this.checkHasType(info);
            if (msg != null) {
                polo.setActivated(false);
                polo.setResultMsg(msg);
            } else {
                String response = "";
                response = SHRAdminActivatedFactory.getRemoteInstance().checkAdminActivated(effectDate, info, isContainSubOrg);
                String[] arr = response.split("@");
                if ("true".equals(arr[0])) {
                    polo.setActivated(true);
                } else {
                    polo.setActivated(false);
                    polo.setResultMsg(arr[1]);
                }
            }
        }
        return polo;
    }

    @Override
    public void actionUpdateDate_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpdateDate_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setDefaultAdminStartSHRDate();
    }

    private void setDefaultAdminStartSHRDate() {
        AdminOrgUnitInfo info = null;
        java.util.Date effectDate = null;
        List adminInfoList = (List)this.getUIContext().get("AdminInfoList");
        if (adminInfoList == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label95"));
        } else {
            try {
                info = (AdminOrgUnitInfo)adminInfoList.get(0);
                AdminOrgUnitInfo parentInfoStarted = this.getParentAdminInfoStarted(info);
                if (parentInfoStarted != null) {
                    effectDate = this.getAdminFirstEffectDate(parentInfoStarted);
                }
                if (effectDate == null) {
                    effectDate = DateTimeUtils.parseDate((String)"1900-01-01", (String)"yyyy-MM-dd");
                }
                this.shrDP.setValue((Object)effectDate);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    effectDate = DateTimeUtils.parseDate((String)"1900-01-01", (String)"yyyy-MM-dd");
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
                this.shrDP.setValue((Object)effectDate);
            }
        }
    }

    private AdminOrgUnitInfo getParentAdminInfoStarted(AdminOrgUnitInfo info) throws BOSException {
        String oql = "select id ,name,parent,parent.effdt,parent.isStartSHR,effdt,isStartSHR where id='" + info.getId().toString() + "'";
        AdminOrgUnitCollection adminOrgUnitCollection = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(oql);
        if (adminOrgUnitCollection.size() <= 0) {
            return null;
        }
        info = adminOrgUnitCollection.get(0);
        AdminOrgUnitInfo parentInfo = info.getParent();
        if (parentInfo.isIsStartSHR()) {
            return parentInfo;
        }
        return this.getParentAdminInfoStarted(parentInfo);
    }

    public java.util.Date getAdminFirstEffectDate(AdminOrgUnitInfo adminOrgUnitInfo) throws BOSException, SQLException {
        String oql = "select fid ,feffdt from t_org_adminhis where fhistoryRelateID='" + adminOrgUnitInfo.getId().toString() + "' order by feffdt";
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)oql.toString());
        IRowSet rowSet = null;
        rowSet = iSQL.executeSQL();
        if (rowSet != null && rowSet.next()) {
            Date date = rowSet.getDate(2);
            return date;
        }
        return null;
    }
}

