/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.base.ITechPostType;
import com.kingdee.eas.hr.base.ITechnicalPost;
import com.kingdee.eas.hr.base.TechPostTypeCollection;
import com.kingdee.eas.hr.base.TechPostTypeFactory;
import com.kingdee.eas.hr.base.TechnicalPostCollection;
import com.kingdee.eas.hr.base.TechnicalPostFactory;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.client.AbstractTechPostDistributeUI;
import com.kingdee.eas.hr.base.client.HROListUI;
import com.kingdee.eas.hr.base.util.TreeUtil;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TechPostDistributeUI
extends AbstractTechPostDistributeUI {
    private static final Logger logger = CoreUIObject.getLogger(TechPostDistributeUI.class);
    private KDTreeNode rightRoot = null;
    private boolean isFirst = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.createTechPostTree(this.treeLeft);
        this.initRightTree();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void initRightTree() {
        ((KingdeeTreeModel)this.treeRight.getModel()).setRoot(null);
    }

    void createTechPostTree(KDTree kdTree) throws BOSException {
        KDTreeNode root = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.TECHNICALPOST_TYPE"));
        TechPostTypeCollection cols = this.getTechPostTypeCollection();
        Map tpMap = this.getTechPostCollection(cols);
        for (int i = 0; i < cols.size(); ++i) {
            KDTreeNode node = new KDTreeNode((Object)cols.get(i));
            List tpList = (List)tpMap.get(cols.get(i).getId().toString());
            if (tpList != null) {
                int sum = tpList.size();
                for (int j = 0; j < sum; ++j) {
                    KDTreeNode tpNode = new KDTreeNode(tpList.get(j));
                    node.add((MutableTreeNode)tpNode);
                }
            }
            root.add((MutableTreeNode)node);
        }
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        kdTree.setModel((TreeModel)model);
        KDTreeNode rootNode = (KDTreeNode)((KingdeeTreeModel)kdTree.getModel()).getRoot();
        if (rootNode.getChildCount() > 0) {
            kdTree.setSelectionNode((DefaultKingdeeTreeNode)((KDTreeNode)rootNode.getChildAt(0)));
        } else {
            kdTree.setSelectionNode((DefaultKingdeeTreeNode)rootNode);
        }
    }

    private Map getTechPostCollection(TechPostTypeCollection cols) throws BOSException {
        ArrayList<String> tpTypeList = new ArrayList<String>();
        HashMap tpMap = new HashMap();
        for (int i = 0; i < cols.size(); ++i) {
            tpTypeList.add(cols.get(i).getId().toString());
        }
        if (tpTypeList.size() == 0) {
            return tpMap;
        }
        String oql = "select *, category.* where category.id in" + BenefitUtils.getStrFromList(tpTypeList);
        ITechnicalPost iTechnicalPost = TechnicalPostFactory.getRemoteInstance();
        TechnicalPostCollection techCols = iTechnicalPost.getTechnicalPostCollection(oql);
        String tpTypeId = null;
        List<TechnicalPostInfo> tpList = null;
        int size = techCols.size();
        for (int i = 0; i < size; ++i) {
            tpTypeId = techCols.get(i).getCategory().getId().toString();
            if (tpMap.get(tpTypeId) == null) {
                tpList = new ArrayList<TechnicalPostInfo>();
                tpList.add(techCols.get(i));
                tpMap.put(tpTypeId, tpList);
                continue;
            }
            tpList = (List)tpMap.get(tpTypeId);
            tpList.add(techCols.get(i));
            tpMap.put(tpTypeId, tpList);
        }
        return tpMap;
    }

    TechPostTypeCollection getTechPostTypeCollection() throws BOSException {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isStandard", (Object)0, CompareType.EQUALS));
        filter.setMaskString("(#0 or #1 or #2 ) and #3");
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        ITechPostType iType = TechPostTypeFactory.getRemoteInstance();
        TechPostTypeCollection techCols = iType.getTechPostTypeCollection(env);
        return techCols;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(HROListUI.class.getName(), (Map)uiContext, null);
        curDialog.show();
        HROListUI nowHROui = (HROListUI)curDialog.getUIObject();
        if (!nowHROui.isCanceled()) {
            List hroList = nowHROui.getLstSelectHROrgUnit();
            IRow iRow = null;
            FullOrgUnitInfo orgInfo = null;
            int size = hroList.size();
            for (int i = 0; i < size; ++i) {
                orgInfo = (FullOrgUnitInfo)hroList.get(i);
                iRow = this.tblMain.addRow();
                iRow.getCell("id").setValue((Object)orgInfo.getId().toString());
                iRow.getCell("name").setValue((Object)orgInfo.getName());
                iRow.getCell("number").setValue((Object)orgInfo.getNumber());
            }
        }
    }

    @Override
    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        super.btnDel_actionPerformed(e);
        BenefitUtils.deleteBlock((KDTable)this.tblMain);
    }

    @Override
    protected void btnLeft_actionPerformed(ActionEvent e) throws Exception {
        super.btnLeft_actionPerformed(e);
        TreePath[] treePaths = this.treeRight.getSelectionPaths();
        if (treePaths != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                if (((KDTreeNode)treePaths[i].getLastPathComponent()).getUserObject() instanceof String) {
                    this.initRightTree();
                    return;
                }
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
            }
            TreeUtil.removeNodes(this.treeRight, treeNodes);
        }
    }

    @Override
    protected void btnRight_actionPerformed(ActionEvent e) throws Exception {
        super.btnRight_actionPerformed(e);
        TreePath[] treePaths = this.treeLeft.getSelectionPaths();
        if (treePaths != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                if (((KDTreeNode)treePaths[i].getLastPathComponent()).getUserObject() instanceof String) {
                    this.createTechPostTree(this.treeRight);
                    return;
                }
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
            }
            Set extendedNodes = TreeUtil.getExpendedNodes(this.treeLeft);
            TreeUtil.addNodes(this.treeRight, treeNodes, extendedNodes);
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }
}

