/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.base.ITechPostType;
import com.kingdee.eas.hr.base.ITechnicalPost;
import com.kingdee.eas.hr.base.TechPostTypeCollection;
import com.kingdee.eas.hr.base.TechPostTypeFactory;
import com.kingdee.eas.hr.base.TechnicalPostCollection;
import com.kingdee.eas.hr.base.TechnicalPostFactory;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.client.AbstractTechPostListUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class TechPostListUI
extends AbstractTechPostListUI {
    private static final Logger logger = CoreUIObject.getLogger(TechPostListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTechPostTree(this.treeMain);
    }

    private void initTechPostTree(KDTree kdTree) throws BOSException {
        KDTreeNode root = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.TECHNICALPOST_TYPE"));
        TechPostTypeCollection cols = this.getTechPostTypeCollection();
        Map tpMap = this.getTechPostCollection(cols);
        for (int i = 0; i < cols.size(); ++i) {
            KDTreeNode node = new KDTreeNode((Object)cols.get(i));
            List tpList = (List)tpMap.get(cols.get(i).getId().toString());
            if (tpList != null) {
                int sum = tpList.size();
                for (int j = 0; j < sum; ++j) {
                    KDTreeNode tpNode = new KDTreeNode(tpList.get(j));
                    node.add((MutableTreeNode)tpNode);
                }
            }
            root.add((MutableTreeNode)node);
        }
        KingdeeTreeModel model = new KingdeeTreeModel((TreeNode)root);
        kdTree.setShowCheckBox(true);
        kdTree.setModel((TreeModel)model);
        KDTreeNode rootNode = (KDTreeNode)((KingdeeTreeModel)kdTree.getModel()).getRoot();
        if (rootNode.getChildCount() > 0) {
            kdTree.setSelectionNode((DefaultKingdeeTreeNode)((KDTreeNode)rootNode.getChildAt(0)));
        } else {
            kdTree.setSelectionNode((DefaultKingdeeTreeNode)rootNode);
        }
    }

    private Map getTechPostCollection(TechPostTypeCollection cols) throws BOSException {
        ArrayList<String> tpTypeList = new ArrayList<String>();
        HashMap tpMap = new HashMap();
        for (int i = 0; i < cols.size(); ++i) {
            tpTypeList.add(cols.get(i).getId().toString());
        }
        if (tpTypeList.size() == 0) {
            return tpMap;
        }
        String oql = "select *, category.* where category.id in" + BenefitUtils.getStrFromList(tpTypeList);
        ITechnicalPost iTechnicalPost = TechnicalPostFactory.getRemoteInstance();
        TechnicalPostCollection techCols = iTechnicalPost.getTechnicalPostCollection(oql);
        String tpTypeId = null;
        List<TechnicalPostInfo> tpList = null;
        int size = techCols.size();
        for (int i = 0; i < size; ++i) {
            tpTypeId = techCols.get(i).getCategory().getId().toString();
            if (tpMap.get(tpTypeId) == null) {
                tpList = new ArrayList<TechnicalPostInfo>();
                tpList.add(techCols.get(i));
                tpMap.put(tpTypeId, tpList);
                continue;
            }
            tpList = (List)tpMap.get(tpTypeId);
            tpList.add(techCols.get(i));
            tpMap.put(tpTypeId, tpList);
        }
        return tpMap;
    }

    TechPostTypeCollection getTechPostTypeCollection() throws BOSException {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isStandard", (Object)0, CompareType.EQUALS));
        filter.setMaskString("(#0 or #1 or #2 ) and #3");
        EntityViewInfo env = new EntityViewInfo();
        env.setFilter(filter);
        ITechPostType iType = TechPostTypeFactory.getRemoteInstance();
        TechPostTypeCollection techCols = iType.getTechPostTypeCollection(env);
        return techCols;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }
}

