/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client.f7;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.eas.base.core.hr.client.f7.F7ParamOnRegister;
import com.kingdee.eas.base.core.hr.client.f7.IF7ParamFromUI;
import com.kingdee.eas.base.core.hr.client.f7.IF7Support;
import com.kingdee.eas.hr.base.F7ConfigCollection;
import com.kingdee.eas.hr.base.F7ConfigDetailCollection;
import com.kingdee.eas.hr.base.F7ConfigDetailInfo;
import com.kingdee.eas.hr.base.F7ConfigFactory;
import com.kingdee.eas.hr.base.F7ConfigInfo;
import com.kingdee.eas.hr.base.F7ScopeEnum;
import com.kingdee.eas.hr.base.client.f7.F7Property;
import com.kingdee.util.StringUtils;
import java.util.HashMap;

public class F7ConfigManager {
    private static HashMap configs = new HashMap();

    public void apply(IF7Support f7) throws Exception {
        int seq;
        String uiName;
        if (f7 == null) {
            return;
        }
        F7ParamOnRegister regParam = f7.getF7ParamOnRegister();
        IF7ParamFromUI uiParam = f7.getF7ParamFromUI();
        if (regParam == null || uiParam == null) {
            return;
        }
        String f7Name = regParam.getF7Name();
        F7ConfigInfo config = this.getConfig(f7Name, uiName = uiParam.getUI().getMetaDataPK().getFullName(), seq = regParam.getSeq());
        if (config == null) {
            return;
        }
        F7ConfigDetailCollection dc = config.getDetail();
        F7ConfigDetailInfo dInfo = null;
        if (dc != null) {
            int size = dc.size();
            for (int i = 0; i < size; ++i) {
                dInfo = dc.get(i);
                this.applyProperty(new F7Property(dInfo), f7);
            }
        }
    }

    public F7ConfigInfo getConfig(String f7, String ui, int seq) throws Exception {
        F7ConfigInfo config = null;
        if (StringUtils.isEmpty((String)f7) || StringUtils.isEmpty((String)ui)) {
            return config;
        }
        String key = f7 + ui + seq;
        if (configs.containsKey(key)) {
            config = (F7ConfigInfo)configs.get(key);
        }
        String oql = "select id,seq,f7.id,f7.number,ui.id,ui.name,detail.* where f7.number = '" + f7 + "' and ui.name = '" + ui + "' and seq = " + seq;
        F7ConfigCollection cc = F7ConfigFactory.getRemoteInstance().getF7ConfigCollection(oql);
        if (cc != null && cc.size() > 0) {
            config = cc.get(0);
        }
        configs.put(key, config);
        return config;
    }

    protected void applyProperty(F7Property prop, IF7Support f7) {
        if (prop == null || f7 == null) {
            return;
        }
        String name = prop.getName();
        Object value = prop.getValue();
        if (value == null) {
            return;
        }
        F7ParamOnRegister regParam = f7.getF7ParamOnRegister();
        IF7ParamFromUI uiParam = f7.getF7ParamFromUI();
        KDBizPromptBox prmtBox = null;
        if (regParam != null && regParam.getPromptBox() instanceof KDBizPromptBox) {
            prmtBox = (KDBizPromptBox)regParam.getPromptBox();
        }
        if ("SCOPE".equals(name)) {
            f7.setScope((F7ScopeEnum)value, uiParam);
        } else if ("DISPLAYFORMART".equals(name)) {
            if (prmtBox != null) {
                prmtBox.setDisplayFormat((String)value);
                if (regParam.getColumn() != null) {
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat((String)value));
                    regParam.getColumn().setRenderer((IBasicRender)avr);
                }
            }
        } else if ("EDITFORMAT".equals(name)) {
            if (prmtBox != null) {
                prmtBox.setEditFormat((String)value);
            }
        } else if ("COMMITFORMAT".equals(name) && prmtBox != null) {
            prmtBox.setCommitFormat((String)value);
        }
    }
}

