/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.PersonCheckException;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class EmpEnrollUserPermHelper {
    public static final String USERNUMBER = "userNumber";
    public static final String ISADDUSER = "isAddUser";

    public static void autoCreateUser(Context ctx, PersonInfo pInfo, boolean isIsEnrollAgain, Date enrollDate, AdminOrgUnitInfo adminOrg) throws EASBizException, BOSException {
        boolean isAutoUser = HRParamUtil.getParamOfHR(ctx, "IS_Auto_User", null);
        if (!isAutoUser || pInfo == null) {
            return;
        }
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("personId", pInfo.getId().toString());
            param.put("orgUnitId", adminOrg.getId().toString());
            IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = (UserInfo)osfServiceFacade.processService("generatetUserByAddPerson", param);
        }
        catch (UserException e) {
            e.printStackTrace();
            if (UserException.NUMBER_REPEAT.getCode().toString().equals(e.getSubCode().toString())) {
                throw new EmployeeException(EmployeeException.USER_IS_EXIST);
            }
            throw new BOSException((Throwable)e);
        }
    }

    public static void autoCreateUser(Context ctx, PersonInfo pInfo, String userNumber, boolean isIsEnrollAgain, Date enrollDate, AdminOrgUnitInfo adminOrg) throws EASBizException, BOSException {
        boolean isAutoUser;
        if (pInfo == null) {
            return;
        }
        if (pInfo.get(ISADDUSER) == null ? !(isAutoUser = HRParamUtil.getParamOfHR(ctx, "IS_Auto_User", null)) : "0".equals((String)pInfo.get(ISADDUSER))) {
            return;
        }
        String unumberCell = "";
        String unumberMail = "";
        try {
            StringBuilder sql = new StringBuilder(" SELECT FID,FNUMBER FROM T_PM_User WHERE UPPER(FCell) =  UPPER(N'").append(pInfo.getCell()).append("')");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next()) {
                unumberCell = rowSet.getString("FNUMBER");
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = new StringBuilder(" SELECT FID,FNUMBER FROM T_PM_User WHERE UPPER(FEMail) = UPPER(N'").append(pInfo.getEmail()).append("')")).toString())).next()) {
                unumberMail = rowSet.getString("FNUMBER");
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            throw new BOSException((Throwable)e1);
        }
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("personId", pInfo.getId().toString());
            param.put("orgUnitId", adminOrg.getId().toString());
            param.put(USERNUMBER, userNumber);
            IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = (UserInfo)osfServiceFacade.processService("generatetUserByAddPerson", param);
        }
        catch (UserException e) {
            e.printStackTrace();
            if (UserException.NUMBER_REPEAT.getCode().toString().equals(e.getSubCode().toString())) {
                throw new EmployeeException(EmployeeException.USER_IS_EXIST);
            }
            if (UserException.CELL_REPEAT.getCode().toString().equals(e.getSubCode().toString())) {
                throw new PersonCheckException(PersonCheckException.USER_CELL_REPEAT, new Object[]{unumberCell});
            }
            if (UserException.EMAIL_REPEAT.getCode().toString().equals(e.getSubCode().toString())) {
                throw new PersonCheckException(PersonCheckException.USER_MAIL_REPEAT, new Object[]{unumberMail});
            }
            throw new BOSException((Throwable)e);
        }
    }

    public static void autoForbidUser(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException {
        String oql;
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        if (!iUser.exists(oql = "where person.id='" + personInfo.getId() + "'")) {
            return;
        }
        UserCollection userColl = iUser.getUserCollection(oql);
        ObjectUuidPK[] userPKs = new ObjectUuidPK[userColl.size()];
        int size = userColl.size();
        for (int i = 0; i < size; ++i) {
            userPKs[i] = new ObjectUuidPK(userColl.get(i).getId().toString());
        }
        iUser.forbidUsers((IObjectPK[])userPKs, true);
    }

    public static void unForbidUser(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException {
        String oql;
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        if (!iUser.exists(oql = "where person.id='" + personInfo.getId() + "'")) {
            return;
        }
        UserCollection userColl = iUser.getUserCollection(oql);
        ObjectUuidPK[] userPKs = new ObjectUuidPK[userColl.size()];
        int size = userColl.size();
        for (int i = 0; i < size; ++i) {
            userPKs[i] = new ObjectUuidPK(userColl.get(i).getId().toString());
        }
        iUser.forbidUsers((IObjectPK[])userPKs, false);
    }

    public static void autoCallBackUser(Context ctx, PersonInfo personInfo, AdminOrgUnitInfo adminInfo) throws BOSException, EASBizException {
        if (personInfo != null && personInfo.getId() != null) {
            ArrayList<String> list = new ArrayList<String>();
            UserCollection userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select id,isDelete where person.id='" + personInfo.getId().toString() + "'");
            if (userCollection.size() > 0) {
                int size = userCollection.size();
                for (int i = 0; i < size; ++i) {
                    UserInfo userInfo = userCollection.get(i);
                    if (userInfo == null || !userInfo.isIsDelete()) continue;
                    list.add(userCollection.get(i).getId().toString());
                }
                if (list.size() > 0) {
                    UserFactory.getLocalInstance((Context)ctx).callBackUser(list);
                }
            } else {
                EmpEnrollUserPermHelper.autoCreateUser(ctx, personInfo, false, null, adminInfo);
            }
        }
    }

    public static String getUserNumber(Context ctx, String number, String personId, int seq) throws EASBizException, BOSException {
        boolean isNumberRepeat;
        String newNumber = number;
        if (seq > 0) {
            newNumber = number + seq;
        }
        if (!(isNumberRepeat = EmpEnrollUserPermHelper.isNumberExist(ctx, newNumber, personId))) {
            return newNumber;
        }
        return EmpEnrollUserPermHelper.getUserNumber(ctx, number, personId, ++seq);
    }

    public static boolean isNumberExist(Context ctx, String number, String personId) throws EASBizException, BOSException {
        String sql = "select fid from t_pm_user where (fpersonid is null or fpersonid <> ?) and fnumber =?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{personId, number});
        return rs.size() > 0;
    }

    public static void updateUserNumber(Context ctx, PersonInfo personInfo, AdminOrgUnitInfo adminInfo) throws EASBizException, BOSException {
        boolean flag = HRParamUtil.getParamOfHR(ctx, "AUTO_UPDATE_USERNUMBER", null);
        if (flag) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("personId", personInfo.getId().toString());
            param.put("orgUnitId", adminInfo.getId().toString());
            IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = (UserInfo)osfServiceFacade.processService("generatetUserByAddPerson", param);
        }
    }
}

