/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.ClassLocationEnum;
import com.kingdee.eas.hr.base.PlugInException;
import com.kingdee.util.StringUtils;

public class PlugInManagerUtil {
    public static EntityViewInfo getPlugInConfigViewInfo(String applyClass, ClassLocationEnum location) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("plugInClass"));
        selector.add(new SelectorItemInfo("loadOrder"));
        selector.add(new SelectorItemInfo("enable"));
        selector.add(new SelectorItemInfo("applyClass.id"));
        selector.add(new SelectorItemInfo("applyClass.name"));
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)applyClass)) {
            filter.getFilterItems().add(new FilterItemInfo("applyClass.name", (Object)applyClass));
        }
        if (location != null) {
            filter.getFilterItems().add(new FilterItemInfo("applyClass.location", (Object)location.getValue()));
        }
        filter.getFilterItems().add(new FilterItemInfo("enable", (Object)Boolean.TRUE));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("applyClass.id"));
        view.getSorter().add(new SorterItemInfo("loadOrder"));
        return view;
    }

    public static void verifyPlugInClass(String plugInClass, Class plugInInterface) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)plugInClass) && plugInInterface != null) {
            Class<?> pClass = null;
            try {
                pClass = Class.forName(plugInClass);
            }
            catch (ClassNotFoundException e) {
                throw new PlugInException(PlugInException.NOT_EXIST, new Object[]{plugInClass});
            }
            Class<?> tClass = null;
            tClass = pClass;
            boolean isRealize = false;
            Class<?>[] interfaces = null;
            while (tClass != null) {
                interfaces = tClass.getInterfaces();
                if (interfaces != null) {
                    for (int i = 0; i < interfaces.length; ++i) {
                        if (!plugInInterface.equals(interfaces[i])) continue;
                        isRealize = true;
                        break;
                    }
                }
                if (isRealize) break;
                tClass = pClass.getSuperclass();
            }
            if (!isRealize) {
                throw new PlugInException(PlugInException.INTERFACE_NOT_REALIZED, new Object[]{plugInClass, plugInInterface});
            }
            try {
                pClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new PlugInException(PlugInException.INSTANCE_ERROR, new Object[]{plugInClass});
            }
            catch (IllegalAccessException e) {
                throw new PlugInException(PlugInException.INSTANCE_ERROR, new Object[]{plugInClass});
            }
        }
    }
}

