/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.EmployeeOtherContractInfoFacadeFactory;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.IHRContractInfo;
import com.kingdee.eas.hr.contract.IPersonContractPageInfo;
import com.kingdee.eas.hr.contract.PersonContractPageInfoFactory;
import com.kingdee.eas.hr.contract.PersonContractPageInfoInfo;
import com.kingdee.eas.hr.contract.PersonContractState;
import com.kingdee.eas.hr.contract.app.AbstractHRContractInfoFacadeControllerBean;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.emp.ContractLimitTypeEnum;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRContractInfoFacadeControllerBean
extends AbstractHRContractInfoFacadeControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(HRContractInfoFacadeControllerBean.class);

    @Override
    protected void _fixedHRContractInfo(Context ctx) throws BOSException, EASBizException {
        int dbType = HRUtilExtend.getDbType((Context)ctx);
        String contractLimitEndDateSql = null;
        String contractLimitToDateSql = null;
        String contractLimitEndDateRealSql = null;
        String curDateSql = null;
        String dialectSql = null;
        if (DbType.isOracle((int)dbType)) {
            dialectSql = "/*dialect*/";
            contractLimitEndDateSql = "round((TO_DATE(TO_CHAR(FEndDate,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS') - TO_DATE(TO_CHAR(FEffectDate,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS'))/365,1)";
            contractLimitToDateSql = "round((TO_DATE(TO_CHAR(FToDate,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS') - TO_DATE(TO_CHAR(FEffectDate,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS'))/365,1)";
            contractLimitEndDateRealSql = "round((TO_DATE(TO_CHAR(FEndDateReal,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS') - TO_DATE(TO_CHAR(FEffectDate,'YYYY-MM-DD HH24:MI:SS'),'YYYY-MM-DD HH24:MI:SS'))/365,1)";
            curDateSql = "TRUNC(sysdate)";
        } else {
            dialectSql = "";
            contractLimitEndDateSql = "round(DateDiff(FEffectDate,FEndDate)/31536000.0,1)";
            contractLimitToDateSql = "round(DateDiff(FEffectDate,FToDate)/31536000.0,1)";
            contractLimitEndDateRealSql = "round(DateDiff(FEffectDate,FEndDateReal)/31536000.0,1)";
            curDateSql = "curDate()";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_EmployeeContract set fstate=1 where (FContractLimitType='1' or FContractLimitType='3')").append(" and fState=0 and fEffectDate<=CURDATE() and ((FEndDateReal is not null and FEndDateReal>CURDATE()) or (FEndDateReal is null and ( FEndDate is null or FEndDate>CURDATE())))").append(" and (fRecordDate is not null and fRecordDate<=CURDATE())");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_HRContractInfo set fstate=1 where (FContractLimitType='1' or FContractLimitType='3')").append(" and fState=0 and fEffectDate<=CURDATE() and ((FEndDateReal is not null and FEndDateReal>CURDATE()) or (FEndDateReal is null and ( FEndDate is null or FEndDate>CURDATE())))").append(" and (fRecordDate is not null and fRecordDate<=CURDATE())").append(" and (fBillId is null or (fBillId is not null and fBillState = 3))");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeContract set fstate=1 where FContractLimitType='2'").append(" and fState=0 and fEffectDate<=CURDATE() and (fRecordDate is not null and fRecordDate<=CURDATE())");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_HRContractInfo set fstate=1 where FContractLimitType='2'").append(" and fState=0 and fEffectDate<=CURDATE() and (fRecordDate is not null and fRecordDate<=CURDATE())").append("  and (fBillId is null or (fBillId is not null and fBillState = 3))");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeContract set fstate=4 ").append(" where fstate in (1,2,3) and (FToDate is null and FEndDateReal is not null and FEndDateReal<CURDATE())");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_HRContractInfo set fstate=4 ").append(" where fstate in (1,2,3) and (FToDate is null and FEndDateReal is not null and FEndDateReal<CURDATE()) and (FBillState in (3) or FBillState is null)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer(dialectSql);
        sql.append("update T_HR_EmployeeContract set fstate=4, FEndDateReal=FEndDate, FContractLimitAutoReal=").append(contractLimitEndDateSql).append(" where (FContractLimitType='1' or FContractLimitType='3')").append(" and fstate in (1,2,3) and FEndDateReal is null and FEndDate<").append(curDateSql);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer(dialectSql);
        sql.append("update T_HR_HRContractInfo set fstate=4, FEndDateReal=FEndDate, FContractLimitAutoReal=").append(contractLimitEndDateSql).append(" where (FContractLimitType='1' or FContractLimitType='3')").append(" and fstate in (1,2,3) and FEndDateReal is null and FEndDate<").append(curDateSql).append(" and (FBillState in (3) or FBillState is null)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer(dialectSql);
        sql.append("update T_HR_EmployeeContract set fstate=5, FEndDateReal=FToDate, FContractLimitAutoReal=").append(contractLimitToDateSql).append(" where ").append(" fstate in (1,2,3) and (FToDate is not null and FToDate<").append(curDateSql).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer(dialectSql);
        sql.append("update T_HR_HRContractInfo set fstate=5, FEndDateReal=FToDate, FContractLimitAutoReal=").append(contractLimitToDateSql).append(" where ").append(" fstate in (1,2,3) and (FToDate is not null and FToDate<").append(curDateSql).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_HRContractInfo contract set fState=4, FEndDateReal=DATEADD(-3600*24,(select newCon.FEffectDate from T_HR_EmployeeContract newCon where newCon.FSOURCECONTRACTID = contract.FEmployeeContractID)) where FEmployeeContractID in (").append(" select sourceContract.fid from T_HR_EmployeeContract newContract inner join T_HR_EmployeeContract sourceContract on sourceContract.fid=newContract.FSourceContractID").append(" where sourceContract.FNewState=3 and sourceContract.fState=1 and newContract.FEffectDate<=curDate()").append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeContract contract set fState=4, FEndDateReal=DATEADD(-3600*24,(select newCon.FEffectDate from T_HR_EmployeeContract newCon where newCon.FSOURCECONTRACTID = contract.Fid)) where fid in (").append(" select sourceContract.fid from T_HR_EmployeeContract newContract inner join T_HR_EmployeeContract sourceContract on sourceContract.fid=newContract.FSourceContractID").append(" where sourceContract.FNewState=3 and sourceContract.fState=1 and newContract.FEffectDate<=curDate()").append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_hr_employeecontract set fNewState=1 where fNewState=0 and fState=1");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_HRContractInfo set fNewState=1 where fNewState=0 and fState=1");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_hr_employeecontract set fNewState=fstate where fNewState in (0,1) and fState in (4,5)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_HRContractInfo set fNewState=fstate where fNewState in (0,1) and fState in (4,5)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_hr_employeecontract contract set fstate=4, FEndDateReal=DATEADD(-3600*24,(select newContract.FEffectDate from T_HR_EmployeeContract newContract where newContract.FSOURCECONTRACTID = contract.Fid)) ").append("where FNewState=2 and FState=1 and fid in (").append("select newContract.FSOURCECONTRACTID from T_HR_EmployeeContract newContract where contract.fid = newContract.FSourceContractID and newContract.FEffectDate<=curDate()").append(") and fEnddate>=curDate()");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_HRContractInfo contract set fstate=4, FEndDateReal=DATEADD(-3600*24,(select newContract.FEffectDate from T_HR_EmployeeContract newContract where newContract.FSOURCECONTRACTID = contract.FEmployeeContractID)) ").append("where FNewState=2 and FState=1 and FEmployeeContractID in (").append("select newContract.FSOURCECONTRACTID from T_HR_EmployeeContract newContract where contract.fid = newContract.FSourceContractID and newContract.FEffectDate<=curDate()").append(") and FEndDate>=curDate()");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer(dialectSql);
        sql.append("update t_hr_employeecontract contract set FContractLimitAutoReal=").append(contractLimitEndDateRealSql).append(" where FNewState in (2,3) and FState=4 and fid in (").append("select newContract.FSOURCECONTRACTID from T_HR_EmployeeContract newContract where contract.fid = newContract.FSourceContractID and newContract.FEffectDate<=").append(curDateSql).append(") and FEndDateReal is null and FEndDate>=").append(curDateSql);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer(dialectSql);
        sql.append("update T_HR_HRContractInfo contract set FContractLimitAutoReal=").append(contractLimitEndDateRealSql).append(" where FNewState in (2,3) and FState=4 and FEmployeeContractID in (").append("select newContract.FSOURCECONTRACTID from T_HR_EmployeeContract newContract where contract.fid = newContract.FSourceContractID and newContract.FEffectDate<=").append(curDateSql).append(") and FEndDateReal is null and FEndDate>=").append(curDateSql);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.updatePersonContractPageInfo(ctx);
        EmployeeOtherContractInfoFacadeFactory.getLocalInstance(ctx).fixedOtherContractInfo();
    }

    private void updatePersonContractPageInfo(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_HR_ContractPageInfo where fpersonid in(").append("select fpersonid from T_HR_ContractPageInfo where fpersonid is not null group by fpersonid having count(FEmployeeContractID)>1").append("\t)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("select pageInfo.fid,pageInfo.FEmployeeContractID ,pageInfo.fpersonid from T_HR_ContractPageInfo pageInfo").append(" left join T_HR_EmployeeContract empCon on pageInfo.FEmployeeContractID=empCon.fid").append("  where empCon.FState in (4,5) and pageInfo.FPersonID in ").append(" \t(select empCon.FEmployeeID from T_HR_EmployeeContract empCon inner join T_HR_ContractTemplet contractTemplet on empCon.FContractTempletID = contractTemplet.fid").append("  \t\tinner join T_HR_ContractType contractType on contractTemplet.FContractTypeID = contractType.fid").append(" \t\twhere contractType.fIsLaborContract = 1 and empCon.FState in (1, 2) and empCon.FEffectDate <= CURDATE() and empCon.FEMPLOYEEID is not null )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String personId = rs.getString("fpersonid");
                sql = new StringBuffer();
                sql.append("select top 1 empCon.FID from T_HR_EmployeeContract empCon ").append("  inner join T_HR_ContractTemplet contractTemplet on empCon.FContractTempletID = contractTemplet.fid").append("  inner join T_HR_ContractType contractType on contractTemplet.FContractTypeID = contractType.fid").append("  where contractType.fIsLaborContract = 1 and empCon.FState in (1, 2) and empCon.FEffectDate<=CURDATE() ").append(" and ((FEndDateReal is not null and FEndDateReal>=CURDATE()) or (FEndDateReal is null and ( FEndDate is null or FEndDate>CURDATE())) or (FEndDate is null and FContractLimitType='2'))").append("  and empCon.FEmployeeID='").append(personId).append("' order by empCon.FEffectDate desc");
                IRowSet newRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!newRs.next()) continue;
                sql = new StringBuffer();
                sql.append("update T_HR_ContractPageInfo set FEmployeeContractID='").append(newRs.getString("FID")).append("'").append(" where fpersonid='").append(personId).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        sql = new StringBuffer();
        sql.append("select fid from t_bd_person where fid not in (select fpersonid from T_HR_ContractPageInfo where fpersonid is not null ) ").append(" and fid in ").append(" \t(select empCon.FEmployeeID from T_HR_EmployeeContract empCon inner join T_HR_ContractTemplet contractTemplet on empCon.FContractTempletID = contractTemplet.fid").append("  \t\tinner join T_HR_ContractType contractType on contractTemplet.FContractTypeID = contractType.fid").append(" \t\twhere contractType.fIsLaborContract = 1 and empCon.FState in (1, 2) and empCon.FEffectDate <= CURDATE() and empCon.FEMPLOYEEID is not null )");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            IPersonContractPageInfo iPersonContractPageInfo = PersonContractPageInfoFactory.getLocalInstance(ctx);
            while (rs.next()) {
                String personId = rs.getString("fid");
                sql = new StringBuffer();
                sql.append("select top 1 empCon.FID,empCon.FEmployeeID from T_HR_EmployeeContract empCon ").append("  inner join T_HR_ContractTemplet contractTemplet on empCon.FContractTempletID = contractTemplet.fid").append("  inner join T_HR_ContractType contractType on contractTemplet.FContractTypeID = contractType.fid").append("  where contractType.fIsLaborContract = 1 and empCon.FState in (1, 2) and empCon.FEffectDate<=CURDATE() and ((FEndDateReal is not null and FEndDateReal>=CURDATE()) or (FEndDateReal is null and (FEndDate is null or FEndDate>=CURDATE())))").append("  and empCon.FEmployeeID='").append(personId).append("' order by empCon.FEffectDate desc");
                IRowSet newRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!newRs.next()) continue;
                PersonContractPageInfoInfo pageInfo = new PersonContractPageInfoInfo();
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)newRs.getString("FEmployeeID")));
                pageInfo.setPerson(personInfo);
                EmployeeContractInfo contractInfo = new EmployeeContractInfo();
                contractInfo.setId(BOSUuid.read((String)newRs.getString("FID")));
                pageInfo.setEmployeeContract(contractInfo);
                pageInfo.setHasSignContract(PersonContractState.hasSign);
                iPersonContractPageInfo.addnew(pageInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeContract set FVIP=1 where fid in (select FEmployeeContractID from T_HR_ContractPageInfo where fpersonid is not null)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update T_HR_EmployeeContract set FVIP=0 where fid not in (select FEmployeeContractID from T_HR_ContractPageInfo where FEmployeeContractID is not null)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update  t_hr_employeecontract set FISNEWESTCONTRACT =0 where FEMPLOYEEID is not null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update  t_hr_employeecontract set FISNEWESTCONTRACT =1 where FID in (").append(" select empContract.FID ").append(" from t_hr_employeecontract empContract").append(" inner join (select FEMPLOYEEID, max(feffectDate) feffectDate").append(" from t_hr_employeecontract").append(" where fid in").append(" (select empContract.fid").append("  from t_hr_employeecontract empContract").append(" inner join T_HR_ContractTemplet conTemp on empContract.FCONTRACTTEMPLETID = conTemp.FID").append(" inner join T_HR_ContractType contractType on conTemp.FContractTypeID = contractType.FID").append(" where contractType.FISLABORCONTRACT = 1)").append("  group by FEMPLOYEEID) as newContract").append("  on empContract.FEMPLOYEEID = newContract.FEMPLOYEEID and empContract.feffectDate = newContract.feffectDate").append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("select femployeeid,max(FCREATETIME) FCREATETIME from T_HR_EmployeeContract ").append(" where fid in ").append(" (select empContract.fid ").append(" from t_hr_employeecontract empContract ").append(" inner join T_HR_ContractTemplet conTemp on empContract.FCONTRACTTEMPLETID = conTemp.FID ").append(" inner join T_HR_ContractType contractType on conTemp.FContractTypeID = contractType.FID ").append(" where contractType.FISLABORCONTRACT = 1) ").append(" and FIsNewestContract=1 ").append(" group by femployeeid having count(fid)>1 ");
        IRowSet mulRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            while (mulRs.next()) {
                String employeeId = mulRs.getString("femployeeid");
                String effectDate = "{ts'" + sFormat.format(mulRs.getTimestamp("FCREATETIME").getTime()) + "'}";
                String updateSql = "update T_HR_EmployeeContract set FIsNewestContract=0 where femployeeid='" + employeeId + "' and FCREATETIME!=" + effectDate;
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _renewContract(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        EmployeeContractInfo sourceContract = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(contractInfo.getSourceContract().getId()));
        String personId = contractInfo.getEmployee().getId().toString();
        if ("true".equals(contractInfo.get("contractInitImport"))) {
            if (contractInfo.getId() == null) {
                ContractUtils.checkPersonHasMutiLaborEmployeeContract(ctx, personId);
            }
        } else if (contractInfo.get("contractInitImport") == null) {
            ContractUtils.checkPersonHasMutiLaborEmployeeContract(ctx, personId);
            EmployeeContractInfo personCurContractInfo = ContractUtils.getPersonLaborEmployeeContractInfo(ctx, personId);
            if (personCurContractInfo == null) {
                throw new ContractException(ContractException.PERSON_HAS_NO_CONTRACT);
            }
            if (personCurContractInfo.getState() != EmployeeContractState.END && personCurContractInfo.getState() != EmployeeContractState.FREE && personCurContractInfo.getContractLimitType() == ContractLimitTypeEnum.NO_FIXED_LIMIT) {
                throw new ContractException(ContractException.PERSONHASNOTFIXEDTIMECONTRACT);
            }
            ContractUtils.checkContractChangeOrRenewException(ctx, personId, sourceContract, "CONTRACT_OPT_RENEW");
            Date endDate = ContractUtils.getContractEndDateField(sourceContract);
            if (endDate != null) {
                Date renewDate = HRUtil.getAftereDate((Date)endDate);
                if (DateTimeUtils.dayAfter((Date)contractInfo.getEffectDate(), (Date)renewDate)) {
                    String personParm = ContractUtils.getPersonInfo(ctx, personId);
                    throw new ContractException(ContractException.RENEWDATE_TOO_LATE, new Object[]{personParm});
                }
            }
            HashMap<Object, Object> personMap = new HashMap<Object, Object>();
            if (ContractUtils.checkIsEnrollAgainPersonWhenRenewAction(ctx, contractInfo.getSourceContract().getId().toString(), personMap)) {
                throw new ContractException(ContractException.ENROLL_AGAIN_CANT_RENEW, new Object[]{personMap.get("number") + "_" + personMap.get("name")});
            }
            ContractUtils.checkSourceContractTimeIsCrossing(ctx, contractInfo, sourceContract);
            ContractUtils.checkContractInBillByHRContractInfo(ctx, contractInfo.getSourceContract().getId().toString(), null);
            contractInfo.setSourceContract(sourceContract);
            contractInfo.setContinuousSignedCount(sourceContract.getContinuousSignedCount() + 1);
        }
        if (contractInfo.get("notNeedGenerateObjectNumber") == null || !"true".equals(contractInfo.get("notNeedGenerateObjectNumber").toString())) {
            contractInfo.put("notNeedGenerateObjectNumber", (Object)false);
        }
        contractInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        contractInfo.setCreateTime(this.getCurTimestamp());
        this.updateSourceContractState(ctx, contractInfo, EmployeeContractState.RESUME, EmployeeContractNewStateEnum.RESUMED);
        this.updateHRContractInfoState(ctx, contractInfo, EmployeeContractState.RESUME, EmployeeContractNewStateEnum.RESUMED);
        EmployeeContractFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)contractInfo);
        this.updateRenewSourceContractDate(ctx, contractInfo, EmployeeContractState.RESUME, EmployeeContractNewStateEnum.RESUMED);
    }

    private void updateSourceContractState(Context ctx, EmployeeContractInfo contractInfo, EmployeeContractState state, EmployeeContractNewStateEnum newState) throws BOSException, EASBizException {
        EmployeeContractInfo sourceContract = contractInfo.getSourceContract();
        SelectorItemCollection selector = new SelectorItemCollection();
        if (DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)this.getCurDate()) || DateTimeUtils.dayEquals((Date)contractInfo.getEffectDate(), (Date)this.getCurDate())) {
            sourceContract.setState(EmployeeContractState.END);
            selector.add(new SelectorItemInfo("state"));
        } else {
            EmployeeContractState ContractStateEnum = this.getHRContractInfoState(ctx, sourceContract);
            sourceContract.setState(ContractStateEnum);
        }
        sourceContract.setNewState(newState);
        selector.add(new SelectorItemInfo("newState"));
        EmployeeContractFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)sourceContract, selector);
    }

    private EmployeeContractState getHRContractInfoState(Context ctx, EmployeeContractInfo sourceContract) throws EASBizException, BOSException {
        BOSUuid empContractID = sourceContract.getId();
        int state = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmpContractStateValue(empContractID.toString());
        return EmployeeContractState.getEnum((int)state);
    }

    private void updateHRContractInfoState(Context ctx, EmployeeContractInfo contractInfo, EmployeeContractState state, EmployeeContractNewStateEnum newState) throws EASBizException, BOSException {
        HRContractInfoInfo sourceHRContractInfo = ContractUtils.getIHRContractInfoByContractInfo(ctx, contractInfo.getSourceContract());
        SelectorItemCollection selector = new SelectorItemCollection();
        if (sourceHRContractInfo != null) {
            Date curDate = DateTimeUtils.truncateDate((Date)new Date());
            if (DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)contractInfo.getEffectDate(), (Date)curDate)) {
                sourceHRContractInfo.setState(EmployeeContractState.END);
                selector.add(new SelectorItemInfo("state"));
            }
            sourceHRContractInfo.setNewState(newState);
            selector.add(new SelectorItemInfo("newState"));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(sourceHRContractInfo, selector);
        }
    }

    private void updateRenewSourceContractDate(Context ctx, EmployeeContractInfo contractInfo, EmployeeContractState state, EmployeeContractNewStateEnum newState) throws BOSException, EASBizException {
        Date curDate = this.getCurDate();
        if (EmployeeContractNewStateEnum.RESUMED.equals((Object)newState) && (DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)contractInfo.getEffectDate(), (Date)curDate))) {
            HRContractInfoInfo sourceHRContractInfo = ContractUtils.getIHRContractInfoByContractInfo(ctx, contractInfo.getSourceContract());
            EmployeeContractInfo sourceContract = contractInfo.getSourceContract();
            SelectorItemCollection selector = new SelectorItemCollection();
            if (sourceContract.getEndDate() != null && !DateTimeUtils.dayBefore((Date)sourceContract.getEndDate(), (Date)contractInfo.getEffectDate())) {
                sourceContract.setEndDateReal(HRUtil.getBeforeDate((Date)contractInfo.getEffectDate()));
                selector.add(new SelectorItemInfo("endDateReal"));
                sourceContract.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceContract.getEffectDate(), sourceContract.getEndDateReal()));
                selector.add(new SelectorItemInfo("contractLimitAutoReal"));
                EmployeeContractFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)sourceContract, selector);
            }
            if (sourceHRContractInfo != null) {
                selector = new SelectorItemCollection();
                if (sourceHRContractInfo.getEndDate() != null && !DateTimeUtils.dayBefore((Date)sourceHRContractInfo.getEndDate(), (Date)contractInfo.getEffectDate())) {
                    sourceHRContractInfo.setEndDateReal(HRUtil.getBeforeDate((Date)contractInfo.getEffectDate()));
                    sourceHRContractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceContract.getEffectDate(), sourceHRContractInfo.getEndDateReal()));
                    selector.add(new SelectorItemInfo("contractLimitAutoReal"));
                    selector.add(new SelectorItemInfo("endDateReal"));
                }
                HRContractInfoFactory.getLocalInstance(ctx).updatePartial(sourceHRContractInfo, selector);
            }
        }
    }

    @Override
    protected void _changeContract(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        if (contractInfo.get("notNeedGenerateObjectNumber") == null || !"true".equals(contractInfo.get("notNeedGenerateObjectNumber").toString())) {
            contractInfo.put("notNeedGenerateObjectNumber", (Object)false);
        }
        EmployeeContractInfo sourceContract = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(contractInfo.getSourceContract().getId()));
        contractInfo.setSourceContract(sourceContract);
        String personId = contractInfo.getEmployee().getId().toString();
        ContractUtils.checkPersonHasMutiLaborEmployeeContract(ctx, personId);
        contractInfo.setIsContinuousSigned(sourceContract.isIsContinuousSigned());
        if (contractInfo.get("contractInitImport") == null) {
            if (DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)sourceContract.getEffectDate())) {
                throw new ContractException(ContractException.CHANGEDATE_BEFORE_EFFECTDATE);
            }
            ContractUtils.checkContractChangeOrRenewException(ctx, personId, sourceContract, "CONTRACT_OPT_CHANGE");
            contractInfo.setContinuousSignedCount(sourceContract.getContinuousSignedCount());
            ContractUtils.checkContractInBillByHRContractInfo(ctx, contractInfo.getSourceContract().getId().toString(), null);
        }
        contractInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        contractInfo.setCreateTime(this.getCurTimestamp());
        this.updateSourceContractState(ctx, contractInfo, EmployeeContractState.CHANGE, EmployeeContractNewStateEnum.CHANGED);
        this.updateHRContractInfoState(ctx, contractInfo, EmployeeContractState.CHANGE, EmployeeContractNewStateEnum.CHANGED);
        EmployeeContractFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)contractInfo);
        this.updateChangeSourceContractDate(ctx, contractInfo, EmployeeContractState.CHANGE, EmployeeContractNewStateEnum.CHANGED);
    }

    private void updateChangeSourceContractDate(Context ctx, EmployeeContractInfo contractInfo, EmployeeContractState state, EmployeeContractNewStateEnum newState) throws BOSException, EASBizException {
        Date curDate = this.getCurDate();
        if (EmployeeContractNewStateEnum.CHANGED.equals((Object)newState) && (DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)contractInfo.getEffectDate(), (Date)curDate))) {
            HRContractInfoInfo sourceHRContractInfo = ContractUtils.getIHRContractInfoByContractInfo(ctx, contractInfo.getSourceContract());
            EmployeeContractInfo sourceContract = contractInfo.getSourceContract();
            SelectorItemCollection selector = new SelectorItemCollection();
            if (DateTimeUtils.dayEquals((Date)contractInfo.getEffectDate(), (Date)sourceContract.getEffectDate())) {
                sourceContract.setEndDateReal(sourceContract.getEffectDate());
                sourceHRContractInfo.setEndDateReal(sourceHRContractInfo.getEffectDate());
                selector.add(new SelectorItemInfo("endDateReal"));
                sourceContract.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceContract.getEffectDate(), sourceContract.getEndDateReal()));
                sourceHRContractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceHRContractInfo.getEffectDate(), sourceHRContractInfo.getEndDateReal()));
                selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            } else if ((DateTimeUtils.dayBefore((Date)contractInfo.getEffectDate(), (Date)curDate) || DateTimeUtils.dayEquals((Date)contractInfo.getEffectDate(), (Date)curDate)) && (sourceHRContractInfo.getEndDate() == null || sourceHRContractInfo.getEndDate() != null && !DateTimeUtils.dayBefore((Date)sourceContract.getEndDate(), (Date)contractInfo.getEffectDate()))) {
                Date endDateReal = HRUtil.getBeforeDate((Date)contractInfo.getEffectDate());
                sourceContract.setEndDateReal(endDateReal);
                sourceHRContractInfo.setEndDateReal(endDateReal);
                selector.add(new SelectorItemInfo("endDateReal"));
                sourceContract.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceContract.getEffectDate(), sourceContract.getEndDateReal()));
                sourceHRContractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(sourceHRContractInfo.getEffectDate(), sourceHRContractInfo.getEndDateReal()));
                selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            }
            EmployeeContractFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)sourceContract, selector);
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(sourceHRContractInfo, selector);
        }
    }

    @Override
    protected void _endContract(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        ContractUtils.checkContractEndException(ctx, contractInfo, null);
        String personId = contractInfo.getEmployee().getId().toString();
        ContractUtils.checkPersonHasMutiLaborEmployeeContract(ctx, personId);
        ContractUtils.checkContractInBillByHRContractInfo(ctx, contractInfo.getId().toString(), null);
        this.updateEndContractInfo(ctx, contractInfo);
        HRContractInfoInfo hRContractInfo = ContractUtils.getIHRContractInfoByContractInfo(ctx, contractInfo);
        if (hRContractInfo != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            if (contractInfo.getEndDateReal() != null && DateTimeUtils.dayBefore((Date)contractInfo.getEndDateReal(), (Date)this.getCurDate())) {
                hRContractInfo.setState(EmployeeContractState.END);
                selector.add(new SelectorItemInfo("state"));
            }
            hRContractInfo.setEndDateReal(contractInfo.getEndDateReal());
            hRContractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            hRContractInfo.setReason(contractInfo.getReason());
            hRContractInfo.setDescription(contractInfo.getDescription());
            hRContractInfo.setContractLimitAutoReal(contractInfo.getContractLimitAutoReal());
            selector.add(new SelectorItemInfo("newState"));
            selector.add(new SelectorItemInfo("endDateReal"));
            selector.add(new SelectorItemInfo("reason"));
            selector.add(new SelectorItemInfo("description"));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
        }
        String curDate = HRUtil.getCurrentDate();
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_HR_EmployeeContract SET FNewState=4 where FEffectDate>").append(curDate).append(" and FEmployeeID='").append(contractInfo.getEmployee().getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_HR_HRContractInfo SET FNewState=4 where FEffectDate>").append(curDate).append(" and FEmployeeID='").append(contractInfo.getEmployee().getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _freeContract(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        ContractUtils.checkContractFreeException(ctx, contractInfo, null);
        String personId = contractInfo.getEmployee().getId().toString();
        ContractUtils.checkPersonHasMutiLaborEmployeeContract(ctx, personId);
        ContractUtils.checkContractInBillByHRContractInfo(ctx, contractInfo.getId().toString(), null);
        this.updateFreeContractInfo(ctx, contractInfo);
        HRContractInfoInfo hRContractInfo = ContractUtils.getIHRContractInfoByContractInfo(ctx, contractInfo);
        if (hRContractInfo != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            if (contractInfo.getFreeDate() != null && (DateTimeUtils.dayBefore((Date)contractInfo.getFreeDate(), (Date)this.getCurDate()) || DateTimeUtils.dayEquals((Date)contractInfo.getFreeDate(), (Date)this.getCurDate()))) {
                hRContractInfo.setState(EmployeeContractState.FREE);
                selector.add(new SelectorItemInfo("state"));
                hRContractInfo.setEndDateReal(contractInfo.getFreeDate());
                selector.add(new SelectorItemInfo("endDateReal"));
                hRContractInfo.setContractLimitAutoReal(contractInfo.getContractLimitAutoReal());
                selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            }
            hRContractInfo.setFreeDate(contractInfo.getFreeDate());
            hRContractInfo.setNewState(EmployeeContractNewStateEnum.FREED);
            hRContractInfo.setReason(contractInfo.getReason());
            hRContractInfo.setDescription(contractInfo.getDescription());
            selector.add(new SelectorItemInfo("newState"));
            selector.add(new SelectorItemInfo("freeDate"));
            selector.add(new SelectorItemInfo("reason"));
            selector.add(new SelectorItemInfo("description"));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(hRContractInfo, selector);
        }
        String curDate = HRUtil.getCurrentDate();
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_HR_EmployeeContract SET FNewState=5 where FEffectDate>").append(curDate).append(" and FEmployeeID='").append(contractInfo.getEmployee().getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_HR_HRContractInfo SET FNewState=5 where FEffectDate>").append(curDate).append(" and FEmployeeID='").append(contractInfo.getEmployee().getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateFreeContractInfo(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        if (contractInfo.containsKey("freeDate")) {
            selector.add(new SelectorItemInfo("freeDate"));
            if (contractInfo.getFreeDate() != null && (DateTimeUtils.dayBefore((Date)contractInfo.getFreeDate(), (Date)this.getCurDate()) || DateTimeUtils.dayEquals((Date)contractInfo.getFreeDate(), (Date)this.getCurDate()))) {
                contractInfo.setState(EmployeeContractState.FREE);
                selector.add(new SelectorItemInfo("state"));
                contractInfo.setEndDateReal(contractInfo.getFreeDate());
                selector.add(new SelectorItemInfo("endDateReal"));
                contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(contractInfo.getEffectDate(), contractInfo.getFreeDate()));
                selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            }
            contractInfo.setNewState(EmployeeContractNewStateEnum.FREED);
            selector.add(new SelectorItemInfo("newState"));
        }
        if (contractInfo.containsKey("appraisal")) {
            selector.add(new SelectorItemInfo("appraisal"));
        }
        if (contractInfo.containsKey("appraDate")) {
            selector.add(new SelectorItemInfo("appraDate"));
        }
        if (contractInfo.containsKey("penalty")) {
            selector.add(new SelectorItemInfo("penalty"));
        }
        if (contractInfo.containsKey("compensation")) {
            selector.add(new SelectorItemInfo("compensation"));
        }
        EmployeeContractInfo oldContractInfo = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(contractInfo.getId().toString()));
        if (contractInfo.containsKey("reason")) {
            if (!StringUtils.isEmpty((String)oldContractInfo.getReason())) {
                String reason = oldContractInfo.getReason() + "\n" + contractInfo.getReason();
                contractInfo.setReason(reason);
            }
            selector.add(new SelectorItemInfo("reason"));
        }
        if (contractInfo.containsKey("description")) {
            selector.add(new SelectorItemInfo("description"));
        }
        EmployeeContractFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)contractInfo, selector);
    }

    protected void updateEndContractInfo(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        if (contractInfo.containsKey("endDateReal")) {
            selector.add(new SelectorItemInfo("endDateReal"));
            contractInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(contractInfo.getEffectDate(), contractInfo.getEndDateReal()));
            selector.add(new SelectorItemInfo("contractLimitAutoReal"));
            if (contractInfo.getEndDateReal() != null && DateTimeUtils.dayBefore((Date)contractInfo.getEndDateReal(), (Date)this.getCurDate())) {
                contractInfo.setState(EmployeeContractState.END);
                selector.add(new SelectorItemInfo("state"));
            }
            contractInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            selector.add(new SelectorItemInfo("newState"));
        }
        if (contractInfo.containsKey("appraisal")) {
            selector.add(new SelectorItemInfo("appraisal"));
        }
        if (contractInfo.containsKey("appraDate")) {
            selector.add(new SelectorItemInfo("appraDate"));
        }
        if (contractInfo.containsKey("penalty")) {
            selector.add(new SelectorItemInfo("penalty"));
        }
        if (contractInfo.containsKey("compensation")) {
            selector.add(new SelectorItemInfo("compensation"));
        }
        EmployeeContractInfo oldContractInfo = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(contractInfo.getId().toString()));
        if (contractInfo.containsKey("reason")) {
            if (!StringUtils.isEmpty((String)oldContractInfo.getReason())) {
                String reason = oldContractInfo.getReason() + "\n" + contractInfo.getReason();
                contractInfo.setReason(reason);
            }
            selector.add(new SelectorItemInfo("reason"));
        }
        if (contractInfo.containsKey("description")) {
            selector.add(new SelectorItemInfo("description"));
        }
        EmployeeContractFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)contractInfo, selector);
    }

    protected Timestamp getCurTimestamp() {
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        Timestamp curTime = new Timestamp(curDate.getTime());
        return curTime;
    }

    protected Date getCurDate() {
        return DateTimeUtils.truncateDate((Date)new Date());
    }

    @Override
    protected void _newContract(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        String personId = contractInfo.getEmployee().getId().toString();
        if (!"true".equals(contractInfo.get("contractInitImport"))) {
            ContractUtils.checkPersonHasMutiLaborEmployeeContract(ctx, personId);
        }
        contractInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        contractInfo.setCreateTime(this.getCurTimestamp());
        IObjectPK pk = EmployeeContractFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)contractInfo);
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        String oql = "select id where employeeContract.id='" + pk.toString() + "'";
        HRContractInfoCollection coll = iHRContractInfo.getHRContractInfoCollection(oql);
        if (coll.size() > 0) {
            HRContractInfoInfo info = coll.get(0);
            info.setBillState(HRBillStateEnum.AUDITED);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("billState"));
            iHRContractInfo.updatePartial(info, selectors);
        }
    }
}

