/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.DataBaseCustomInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.client.PlugInUIParam;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.contract.ContractBillMiddleFactory;
import com.kingdee.eas.hr.contract.ContractBizException;
import com.kingdee.eas.hr.contract.ContractChangeBizBill;
import com.kingdee.eas.hr.contract.ContractEndBizBill;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.contract.ContractFreeBizBill;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillInfo;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillEntryCollection;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.ContractPreSignBizBillInfo;
import com.kingdee.eas.hr.contract.ContractRenewBizBill;
import com.kingdee.eas.hr.contract.ContractSignBizBillEntryFactory;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.EmpEleContractDelLogFactory;
import com.kingdee.eas.hr.contract.EmpEleContractDelLogInfo;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordCollection;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordFactory;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordCollection;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordFactory;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.HRContractInfoCollection;
import com.kingdee.eas.hr.contract.HRContractInfoFactory;
import com.kingdee.eas.hr.contract.HRContractInfoInfo;
import com.kingdee.eas.hr.contract.IContractBillMiddle;
import com.kingdee.eas.hr.contract.IEmpEleContractSignRecord;
import com.kingdee.eas.hr.contract.IEmpOtherEleContractSignRecord;
import com.kingdee.eas.hr.contract.IHRContractInfo;
import com.kingdee.eas.hr.contract.IPersonContractPageInfo;
import com.kingdee.eas.hr.contract.PersonContractPageInfoCollection;
import com.kingdee.eas.hr.contract.PersonContractPageInfoFactory;
import com.kingdee.eas.hr.contract.PersonContractPageInfoInfo;
import com.kingdee.eas.hr.contract.PersonContractState;
import com.kingdee.eas.hr.contract.util.HRContractInfoUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicOtherContractUtilsEx;
import com.kingdee.eas.hr.emp.ContractClassifyEnum;
import com.kingdee.eas.hr.emp.ContractLimitTypeEnum;
import com.kingdee.eas.hr.emp.ContractTempletCollection;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeCollection;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeContractNewStateEnum;
import com.kingdee.eas.hr.emp.EmployeeContractState;
import com.kingdee.eas.hr.emp.EmployeeOtherContractCollection;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.hr.emp.IContractTemplet;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.IEmployeeOtherContract;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.BillTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BaseItemParam;
import com.kingdee.shr.base.syssetting.api.service.SHRBaseItemApi;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.preentry.PreEntryPersonCollection;
import com.kingdee.shr.preentry.PreEntryPersonFactory;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JPopupMenu;

public class ContractUtils {
    public static final Color MUSTINPUT_BGCOLOR = new Color(252, 251, 223);
    public static final Date DATETIME = new Date(1199116800000L);
    public static final BigDecimal ZERO = new BigDecimal("0");
    public static final String NotNeedGenerateObjectNumber = "notNeedGenerateObjectNumber";
    public static final String IsFromImportContract = "IsFromImportContract";
    public static final String CONTRACT_TEMPLET_ENTITYNAME = "com.kingdee.eas.hr.emp.app.ContractTemplet";
    public static final String CONTRACTFIELD_ENTRYINDEX = "entryIndex";
    public static final String CONTRACT_RES_CLASSNAME = "com.kingdee.eas.hr.contract.ContractResource";
    public static final String CONTRACT_OPT_SIGN = "CONTRACT_OPT_SIGN";
    public static final String CONTRACT_OPT_RENEW = "CONTRACT_OPT_RENEW";
    public static final String CONTRACT_OPT_CHANGE = "CONTRACT_OPT_CHANGE";
    public static final String CONTRACT_OPT_END = "CONTRACT_OPT_END";
    public static final String CONTRACT_OPT_FREE = "CONTRACT_OPT_FREE";
    public static final String CONTRACT_OPT_PRE_SIGN = "CONTRACT_OPT_PRE_SIGN";
    public static final String CONTRACT_OPT_E_SIGN = "CONTRACT_OPT_E_SIGN";
    public static final String CONTRACT_ENTRYTYPE_RES_CLASSNAME = "com.kingdee.eas.hr.contract.ContractEntryTypeResource";
    public static final String PROBATION = "probation";

    public static void continuousSignedCount(PlugInUIParam ctx, IRow activeRow) throws BOSException, EASBizException {
        String oqlStr;
        IPersonPosition ppBean;
        PersonPositionInfo positionInfo;
        CharSequence message;
        PersonInfo personInfo = (PersonInfo)activeRow.getCell("person").getValue();
        ContractTypeInfo contractType = (ContractTypeInfo)activeRow.getCell("contractType").getValue();
        ContractLimitTypeEnum limitType = (ContractLimitTypeEnum)activeRow.getCell("contractLimitType").getValue();
        Date bizDate = (Date)activeRow.getCell("bizDate").getValue();
        IEmployeeContract iEmpCon = EmployeeContractFactory.getRemoteInstance();
        if (personInfo == null || bizDate == null || contractType == null || limitType == null) {
            return;
        }
        if (!contractType.isIsLaborContract()) {
            return;
        }
        if (!ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)limitType)) {
            return;
        }
        if (bizDate.before(DATETIME)) {
            return;
        }
        StringBuffer oql = new StringBuffer();
        oql.append("SELECT contractNo, effectDate, endDate, endDateReal, toUnit, employee.id, ");
        oql.append("isContinuousSigned, continuousSignedCount, ");
        oql.append("contractTemplet.id, contractTemplet.contractType.id, ");
        oql.append("contractTemplet.contractType.isLaborContract ");
        oql.append("WHERE contractTemplet.contractType.isLaborContract = 1 and employee.id = '");
        oql.append(personInfo.getId().toString());
        oql.append("' ");
        BOSUuid id = ((HRBillBaseInfo)ctx.getEditData()).getId();
        if (id != null) {
            oql.append("AND id <> '" + id.toString() + "' ");
        }
        oql.append("ORDER BY effectDate DESC");
        EmployeeContractCollection coll = iEmpCon.getEmployeeContractCollection(oql.toString());
        if (coll.size() > 0) {
            EmployeeContractInfo contractInfo = coll.get(0);
            int count = contractInfo.getContinuousSignedCount();
            boolean isContinuSign = (Boolean)activeRow.getCell("isContinuousSigned").getValue();
            if (isContinuSign) {
                if (activeRow.getCell("changeReason") != null) {
                    activeRow.getCell("continuousSignedCount").setValue((Object)new Integer(count));
                } else {
                    activeRow.getCell("continuousSignedCount").setValue((Object)new Integer(count + 1));
                }
            }
            if (contractInfo.isIsContinuousSigned() && count >= 2) {
                message = new StringBuffer();
                String str = EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEE_CONTRACT_MORE_THAN_TWO");
                str = MessageFormat.format(str, personInfo.getNumber(), personInfo.getName());
                ((StringBuffer)message).append(str);
                int len = coll.size();
                for (int j = 0; j < len; ++j) {
                    contractInfo = coll.get(j);
                    if (!contractInfo.getContractTemplet().getContractType().isIsLaborContract()) continue;
                    ((StringBuffer)message).append("\n" + contractInfo.getContractNo() + " ");
                    ((StringBuffer)message).append(contractInfo.getEffectDate() + " ");
                    Date endDate = ContractUtils.getContractEndDateField(contractInfo);
                    if (endDate != null) {
                        ((StringBuffer)message).append(endDate + " ");
                    }
                    ((StringBuffer)message).append(contractInfo.getToUnit() + ";");
                }
                String info = EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.CONTRACT_MORE_THAN_TWICE");
                MsgBox.showDetailAndOK((Component)ctx.getUI(), (String)info, (String)((StringBuffer)message).toString(), (int)1);
            }
        }
        if ((double)(positionInfo = (ppBean = PersonPositionFactory.getRemoteInstance()).getPersonPositionInfo(oqlStr = "SELECT id, joinGroupYears WHERE person.id = '" + personInfo.getId() + "'")).getJoinGroupYears() >= 10.0) {
            message = EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.EMPLOYEE_JOIN_GROUP_YEARS_MORE_THAN_TEN");
            MsgBox.showInfo((String)message);
        }
    }

    public static void checkContractIsInOther(Context ctx, EmployeeContractInfo ecInfo, String fromPage, int rowIndex) throws BOSException, EASBizException {
        String billNumber = null;
        String hroId = null;
        HROrgUnitInfo hrOrgUnitInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        String personParm = ContractUtils.getPersonInfo(ctx, ecInfo.getEmployee().getId().toString());
        if (hrOrgUnitInfo != null) {
            IRowSet rs;
            StringBuffer sql;
            hroId = hrOrgUnitInfo.getId().toString();
            if (!fromPage.endsWith(ContractRenewBizBill.class.getName())) {
                sql = new StringBuffer("select cb.FNumber, cb.FID from T_HR_ContractRenewBizBillEntry ce ");
                sql.append("inner join T_HR_ContractRenewBizBill cb on ce.FBillID = cb.FID where ce.FSourceContractId = (");
                sql.append("select fid from T_HR_EmployeeContract where FContractNo = '");
                sql.append(ecInfo.getContractNo());
                sql.append("') and (cb.FBillState in (0, 1, 2) or (cb.FBillState = 3 and ce.FBizDate >= ");
                sql.append(HRUtil.getCurrentDate());
                sql.append("))");
                if (sql.length() > 0) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        if (rs.next()) {
                            billNumber = rs.getString(1);
                            throw new ContractException(ContractException.CONTRACT_ISRENEW, new Object[]{personParm, billNumber});
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            if (!fromPage.equals(ContractChangeBizBill.class.getName())) {
                sql = new StringBuffer("select cb.FNumber, cb.FID from T_HR_ContractChangeBillEntry ce ");
                sql.append("inner join T_HR_ContractChangeBizBill cb on ce.FBillID = cb.FID where ce.FSourceContractId = (");
                sql.append("select fid from T_HR_EmployeeContract where FContractNo = '");
                sql.append(ecInfo.getContractNo());
                sql.append("') and (cb.FBillState in (0, 1, 2) or (cb.FBillState = 3 and ce.FBizDate >= ");
                sql.append(HRUtil.getCurrentDate());
                sql.append("))");
                if (sql.length() > 0) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        if (rs.next()) {
                            billNumber = rs.getString(1);
                            throw new ContractException(ContractException.CONTRACT_ISUSED, new Object[]{personParm, billNumber});
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            if (!fromPage.equals(ContractEndBizBill.class.getName())) {
                sql = new StringBuffer("select cb.FNumber, cb.FID from T_HR_ContractEndBizBillEntry ce ");
                sql.append("inner join T_HR_ContractEndBizBill cb on ce.FBillID = cb.FID where ce.FContractNo = '");
                sql.append(ecInfo.getContractNo());
                sql.append("' and (cb.FBillState in (0, 1, 2) or (cb.FBillState = 3 and ce.FBizDate >= CURDATE()");
                sql.append("))");
                if (sql.length() > 0) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        if (rs.next()) {
                            billNumber = rs.getString(1);
                            throw new ContractException(ContractException.CONTRACT_ISEND, new Object[]{personParm, billNumber});
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            if (!fromPage.equals(ContractFreeBizBill.class.getName())) {
                sql = new StringBuffer("select cb.FNumber, cb.FID from T_HR_ContractFreeBizBillEntry ce ");
                sql.append("inner join T_HR_ContractFreeBizBill cb on ce.FBillID = cb.FID where ce.FContractNo = '");
                sql.append(ecInfo.getContractNo());
                sql.append("' and (cb.FBillState in (0, 1, 2) or (cb.FBillState = 3 and ce.FBizDate >= CURDATE()");
                sql.append("))");
                if (sql.length() > 0) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        if (rs.next()) {
                            billNumber = rs.getString(1);
                            throw new ContractException(ContractException.CONTRACT_ISFREE, new Object[]{personParm, billNumber});
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        }
    }

    public static void removeLintMenu(KDTable table, KDTMenuManager tm) {
        Component[] obj = tm.getMenu().getComponents();
        Component comp3 = null;
        Component comp2 = null;
        for (Component comp3 : obj) {
            if (comp3.getName() == null || !comp3.getName().equals("menuPublishReport")) continue;
            Component[] menus = ((KDMenu)comp3).getMenuComponents();
            for (int t = 0; t < menus.length; ++t) {
                comp2 = menus[t];
                if (comp3.getName() == null) continue;
                if (comp2.getName().equals("separatorRpt")) {
                    ((JPopupMenu.Separator)comp2).setVisible(false);
                }
                if (!comp2.getName().equals("menuItemToLinkForRpt")) continue;
                ((KDMenuItem)comp2).setVisible(false);
            }
        }
    }

    public static String getDateFormatStr() {
        return "yyyy-mm-dd";
    }

    public static void expandColumnWidth(KDTable kdt, double base, String[] columns) {
        if (columns == null || columns.length < 1) {
            return;
        }
        IColumn column = null;
        int j = columns.length;
        for (int i = 0; i < j; ++i) {
            column = kdt.getColumn(columns[i]);
            if (column == null) continue;
            column.setWidth((int)((double)column.getWidth() * base));
        }
    }

    public static boolean IsLaborContract(Context ctx, ContractTempletInfo ContractTempletInfo2) throws EASBizException, BOSException {
        IContractTemplet iContractTemplet = null;
        iContractTemplet = ctx == null ? ContractTempletFactory.getRemoteInstance() : ContractTempletFactory.getLocalInstance((Context)ctx);
        ContractTempletInfo templateInfo = iContractTemplet.getContractTempletInfo("select contractType.isLaborContract where id='" + ContractTempletInfo2.getId() + "'");
        if (templateInfo.getContractType() != null) {
            return templateInfo.getContractType().isIsLaborContract();
        }
        return false;
    }

    public static void syncLaborContractToPersonContractPageInfo(Context ctx, String personId, String contractId) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select id where contractTemplet.contractType.isLaborContract=1 ").append(" and id='").append(contractId).append("'");
        boolean isLaborContract = EmployeeContractFactory.getLocalInstance((Context)ctx).exists(sql.toString());
        if (isLaborContract) {
            ContractUtils.refreshEmployeeContractPageInfo(ctx, personId);
        }
    }

    public static void syncContractToHRContractInfo(Context ctx, String personId, String contractId) throws EASBizException, BOSException {
        EmployeeContractInfo employeeContractInfo = ContractUtils.getEmployeeContractInfo(ctx, contractId);
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("employeeContract.id", (Object)employeeContractInfo.getId().toString()));
        viewInfo.setFilter(filter);
        HRContractInfoCollection hrInfoColl = iHRContractInfo.getHRContractInfoCollection(viewInfo);
        HRContractInfoInfo contractInfo = new HRContractInfoInfo();
        if (hrInfoColl.size() == 0) {
            EntityViewInfo viewInfo1 = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("employee.id", (Object)personId));
            filter1.getFilterItems().add(new FilterItemInfo("contractNo", (Object)employeeContractInfo.getContractNo()));
            viewInfo1.setFilter(filter1);
            hrInfoColl = iHRContractInfo.getHRContractInfoCollection(viewInfo1);
        }
        if (hrInfoColl.size() > 0) {
            contractInfo = hrInfoColl.get(0);
        }
        if (StringUtils.isEmpty((String)employeeContractInfo.getEntryID())) {
            contractInfo.setBillState(HRBillStateEnum.AUDITED);
        }
        contractInfo.put("toUnit", employeeContractInfo.getToUnit());
        contractInfo.setDelegatePerson(employeeContractInfo.getDelegatePerson());
        contractInfo.put("state", employeeContractInfo.getState());
        contractInfo.put("newState", employeeContractInfo.getNewState());
        contractInfo.put("effectDate", employeeContractInfo.getEffectDate());
        contractInfo.put("entryBizDate", employeeContractInfo.getEffectDate());
        contractInfo.put("recordDate", employeeContractInfo.getRecordDate());
        contractInfo.put("contractLimitAuto", employeeContractInfo.getContractLimitAuto());
        contractInfo.put("endDateReal", employeeContractInfo.getEndDateReal());
        contractInfo.put("contractLimitAutoReal", employeeContractInfo.getContractLimitAutoReal());
        contractInfo.setEmployeeContract(employeeContractInfo);
        contractInfo.setEmployee(employeeContractInfo.getEmployee());
        ContractUtils.setHRContractInfoInfo(ctx, (CoreBaseInfo)employeeContractInfo, contractInfo);
        iHRContractInfo.submit(contractInfo);
    }

    public static void setHRContractInfoInfo(Context ctx, CoreBaseInfo entryInfo, HRContractInfoInfo contractInfo) throws EASBizException, BOSException {
        contractInfo.put("contractNo", entryInfo.get("contractNo"));
        contractInfo.put("contractTemplet", entryInfo.get("contractTemplet"));
        boolean isLaborContract = ContractUtils.IsLaborContract(ctx, (ContractTempletInfo)entryInfo.get("contractTemplet"));
        contractInfo.put("isLaborContract", isLaborContract);
        contractInfo.put("endDate", entryInfo.get("endDate"));
        contractInfo.put("freeDate", entryInfo.get("freeDate"));
        contractInfo.put("description", entryInfo.get("description"));
        contractInfo.put("contSerLimit", entryInfo.get("contractServerLimit"));
        contractInfo.put("contractLimitType", entryInfo.get("contractLimitType"));
        contractInfo.put("isContinuousSigned", entryInfo.get("isContinuousSigned"));
        contractInfo.put("continuousSignedCount", entryInfo.get("continuousSignedCount"));
    }

    public static EmployeeContractInfo getEmployeeContractInfo(Context ctx, String contractId) throws EASBizException, BOSException {
        Date endDate;
        EmployeeContractInfo empContractInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)contractId));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = ContractUtils.getSelectorCollection();
        viewInfo.setSelector(selector);
        EmployeeContractCollection employeeContractCollection = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(viewInfo);
        if (employeeContractCollection != null && employeeContractCollection.size() > 0) {
            empContractInfo = employeeContractCollection.get(0);
        }
        if (empContractInfo != null && (endDate = ContractUtils.getContractEndDateField(empContractInfo)) != null) {
            Date renewBeginDate = DateTimeUtils.addDay((Date)endDate, (long)1L);
            empContractInfo.put("createTime", (Object)renewBeginDate);
        }
        return empContractInfo;
    }

    public static EmployeeContractInfo getEmployeeContractInfoByNo(Context ctx, String contractNo, String hrOrgId) throws EASBizException, BOSException {
        Date endDate;
        EmployeeContractInfo empContractInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("contractNo", (Object)contractNo));
        if (!StringUtils.isEmpty((String)hrOrgId)) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgId));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = ContractUtils.getSelectorCollection();
        viewInfo.setSelector(selector);
        EmployeeContractCollection employeeContractCollection = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(viewInfo);
        if (employeeContractCollection != null && employeeContractCollection.size() > 0) {
            empContractInfo = employeeContractCollection.get(0);
        }
        if (empContractInfo != null && (endDate = ContractUtils.getContractEndDateField(empContractInfo)) != null) {
            Date renewBeginDate = DateTimeUtils.addDay((Date)endDate, (long)1L);
            empContractInfo.put("createTime", (Object)renewBeginDate);
        }
        return empContractInfo;
    }

    public static SelectorItemCollection getSelectorCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("contractNo"));
        selector.add(new SelectorItemInfo("contractTemplet.name"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.name"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.isLaborContract"));
        selector.add(new SelectorItemInfo("contractTemplet.contractType.isRenewWarn"));
        selector.add(new SelectorItemInfo("employee.name"));
        selector.add(new SelectorItemInfo("employee.number"));
        selector.add(new SelectorItemInfo("recordDate"));
        selector.add(new SelectorItemInfo("effectDate"));
        selector.add(new SelectorItemInfo("freeDate"));
        selector.add(new SelectorItemInfo("endDate"));
        selector.add(new SelectorItemInfo("endDateReal"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("toUnit"));
        selector.add(new SelectorItemInfo("delegatePerson"));
        selector.add(new SelectorItemInfo("toUnitAddress"));
        selector.add(new SelectorItemInfo("employee.idCardNO"));
        selector.add(new SelectorItemInfo("empAddress"));
        selector.add(new SelectorItemInfo("employee.passportNO"));
        selector.add(new SelectorItemInfo("ContractLimit.name"));
        selector.add(new SelectorItemInfo("ContSerLimit.name"));
        selector.add(new SelectorItemInfo("vip"));
        selector.add(new SelectorItemInfo("testBeginDate"));
        selector.add(new SelectorItemInfo("testEndDate"));
        selector.add(new SelectorItemInfo("newState"));
        selector.add(new SelectorItemInfo("contractLimitType"));
        selector.add(new SelectorItemInfo("thirdDelegatePerson"));
        selector.add(new SelectorItemInfo("thirdUnitName"));
        selector.add(new SelectorItemInfo("thirdUnitAddress"));
        selector.add(new SelectorItemInfo("contractLimitAuto"));
        selector.add(new SelectorItemInfo("contractLimitAutoReal"));
        selector.add(new SelectorItemInfo("penalty"));
        selector.add(new SelectorItemInfo("compensation"));
        selector.add(new SelectorItemInfo("appraisal"));
        selector.add(new SelectorItemInfo("appraDate"));
        selector.add(new SelectorItemInfo("isInAdmin"));
        selector.add(new SelectorItemInfo("contractSourceState"));
        selector.add(new SelectorItemInfo("isContinuousSigned"));
        selector.add(new SelectorItemInfo("continuousSignedCount"));
        selector.add(new SelectorItemInfo("sourceContract.contractNo"));
        selector.add(new SelectorItemInfo("sourceContract.id"));
        selector.add(new SelectorItemInfo("sourceContract.effectDate"));
        selector.add(new SelectorItemInfo("sourceContract.endDate"));
        selector.add(new SelectorItemInfo("sourceContract.endDateReal"));
        selector.add(new SelectorItemInfo("sourceContract.freeDate"));
        selector.add(new SelectorItemInfo("isChanged"));
        selector.add(new SelectorItemInfo("isWorkflow"));
        selector.add(new SelectorItemInfo("entryID"));
        selector.add(new SelectorItemInfo("createTime"));
        selector.add(new SelectorItemInfo("isNewestContract"));
        selector.add(new SelectorItemInfo("positionString"));
        selector.add(new SelectorItemInfo("contractAgreedSalary"));
        selector.add(new SelectorItemInfo("labContractFirstParty.name"));
        selector.add(new SelectorItemInfo("hrOrgUnit.name"));
        selector.add(new SelectorItemInfo("signStatus"));
        return selector;
    }

    public static void syncBillStateToHRContractInfo(Context ctx, BOSUuid billID, HRBillStateEnum billState) throws BOSException, EASBizException {
        IHRContractInfo iHRContractInfo = HRContractInfoFactory.getLocalInstance(ctx);
        String oql = "select * where billID='" + billID + "'";
        HRContractInfoCollection coll = iHRContractInfo.getHRContractInfoCollection(oql);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            HRContractInfoInfo info = coll.get(i);
            info.setBillState(billState);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("billState"));
            iHRContractInfo.updatePartial(info, selector);
        }
    }

    public static boolean isLaborContract(Context ctx, String template) throws BOSException {
        String oql;
        boolean isLabor = false;
        IContractTemplet iContractTemplet = ctx == null ? ContractTempletFactory.getRemoteInstance() : ContractTempletFactory.getLocalInstance((Context)ctx);
        ContractTempletCollection coll = iContractTemplet.getContractTempletCollection(oql = "select contractType.isLaborContract where number='" + template + "' or id='" + template + "'");
        if (coll.size() > 0) {
            isLabor = coll.get(0).getContractType().isIsLaborContract();
        }
        return isLabor;
    }

    /*
     * Unable to fully structure code
     */
    public static Map checkContractTimeIsCrossing(Context ctx, HRContractInfoInfo contractInfo, Set excludeContractNo, boolean isRenewOpt) throws BOSException, EASBizException {
        sql = new StringBuffer();
        resultMap = new HashMap<String, Object>();
        if (contractInfo.getEffectDate() == null) {
            return resultMap;
        }
        effectDate = DateTimeUtils.truncateDate((Date)contractInfo.getEffectDate());
        sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        effdtString = "{ts'" + sFormat.format(effectDate.getTime()) + "'}";
        rs = null;
        if (contractInfo.getContractLimitType() == ContractLimitTypeEnum.FIXED_LIMIT || contractInfo.getContractLimitType() == ContractLimitTypeEnum.COMPLETE_WORK_TYPE && ContractUtils.getContractEndDateField(contractInfo) != null) {
            endString = "{ts'" + sFormat.format(ContractUtils.getContractEndDateField(contractInfo).getTime()) + "'}";
            sql.append("select fid,FContractNo,FEmployeeContractID,FBillID,FEntryId,FBillState,FBillBOSType from T_HR_HRContractInfo where FIsLaborContract=1 and FState in (0,1,2,4) and FNewState<>3");
            if (contractInfo.getEmployee() != null && !StringUtils.isEmpty((String)contractInfo.getEmployee().getId().toString())) {
                sql.append(" and FEmployeeID='").append(contractInfo.getEmployee().getId()).append("'");
            } else {
                sql.append(" and FPreEntryPersonId ='").append(contractInfo.getPreEntryPerson().getId()).append("'");
            }
            if (contractInfo.getBillID() != null) {
                sql.append(" and (FBillID<>'").append(contractInfo.getBillID()).append("' or FBillID is null) ");
            }
            if (excludeContractNo != null && excludeContractNo.size() > 0) {
                sql.append(" and FContractNo not in ").append(ContractUtils.getStrFromSet(excludeContractNo)).append(" ");
            }
            if (contractInfo.getEmployeeContract() != null && contractInfo.getEmployeeContract().getId() != null) {
                sql.append(" and FEmployeeContractId <> '").append(contractInfo.getEmployeeContract().getId().toString()).append("' ");
            }
            sql.append(" and (FBillState<>4 or FBillState is null) and FIsDisplay=1").append(" and (").append("  \t\t(FEffectDate>=").append(effdtString).append("  \t\tand FEffectDate<=").append(endString).append(")").append("   or (FEffectDate<=").append(effdtString).append("       and ((FEndDateReal is not null and FEndDateReal>=").append(effdtString).append(") or (FEndDateReal is null and (FEndDate is null or (FEndDate is not null and FEndDate>=").append(effdtString).append(")))))").append(" )").append(" and fToDate is null");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                count = 0;
                if (rs.next()) {
                    resultMap.put("contractNO", rs.getString("FContractNo"));
                    resultMap.put("contractId", rs.getString("FEmployeeContractID"));
                    resultMap.put("billBOSType", rs.getString("FBillBOSType"));
                    resultMap.put("billID", rs.getString("FBillID"));
                    resultMap.put("entryId", rs.getString("FEntryId"));
                    resultMap.put("billState", rs.getInt("FBillState"));
                    ++count;
                }
                while (rs.next()) {
                    ++count;
                }
                if (count <= 0) ** GOTO lbl102
                resultMap.put("count", count);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        } else if (contractInfo.getContractLimitType() == ContractLimitTypeEnum.NO_FIXED_LIMIT || contractInfo.getContractLimitType() == ContractLimitTypeEnum.COMPLETE_WORK_TYPE && ContractUtils.getContractEndDateField(contractInfo) == null) {
            sql.append("select fid,FContractNo,FEmployeeContractID,FBillID,FEntryId,FBillState,FBillBOSType from T_HR_HRContractInfo where FIsLaborContract=1 and FState in (0,1,2,4)  and FNewState<>3");
            if (contractInfo.getEmployee() != null && !StringUtils.isEmpty((String)contractInfo.getEmployee().getId().toString())) {
                sql.append(" and FEmployeeID='").append(contractInfo.getEmployee().getId()).append("'");
            } else {
                sql.append(" and FPreEntryPersonId ='").append(contractInfo.getPreEntryPerson().getId()).append("'");
            }
            if (contractInfo.getBillID() != null) {
                sql.append(" and (FBillID<>'").append(contractInfo.getBillID()).append("' or FBillID is null) ");
            }
            if (excludeContractNo != null && excludeContractNo.size() > 0) {
                sql.append(" and FContractNo not in ").append(ContractUtils.getStrFromSet(excludeContractNo)).append(" ");
            }
            if (contractInfo.getEmployeeContract() != null && contractInfo.getEmployeeContract().getId() != null) {
                sql.append(" and FEmployeeContractId <> '").append(contractInfo.getEmployeeContract().getId().toString()).append("' ");
            }
            sql.append(" and (FBillState<>4 or FBillState is null) and FIsDisplay=1").append(" and ((FEndDateReal is not null and FEndDateReal>=").append(effdtString).append(" ) or (FEndDateReal is null and (FEndDate is null or (FEndDate is not null and FEndDate>=").append(effdtString).append("))))").append(" and fToDate is null");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                count = 0;
                if (rs.next()) {
                    resultMap.put("contractNO", rs.getString("FContractNo"));
                    resultMap.put("contractId", rs.getString("FEmployeeContractID"));
                    resultMap.put("billBOSType", rs.getString("FBillBOSType"));
                    resultMap.put("billID", rs.getString("FBillID"));
                    resultMap.put("entryId", rs.getString("FEntryId"));
                    resultMap.put("billState", rs.getInt("FBillState"));
                    ++count;
                }
                while (rs.next()) {
                    ++count;
                }
                if (count > 0) {
                    resultMap.put("count", count);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
lbl102:
        // 5 sources

        if (isRenewOpt && !resultMap.isEmpty() && contractInfo.getSourceContract() != null && (Integer)resultMap.get("count") == 1 && resultMap.get("contractId") != null && ((String)resultMap.get("contractId")).equals(contractInfo.getSourceContract().getId().toString())) {
            hroInfo = (HROrgUnitInfo)contractInfo.get("hrOrgUnit");
            v0 = hroId = hroInfo == null ? null : hroInfo.getId().toString();
            if (HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_ALLOW_CONTRACT_CROSSING", (String)hroId)) {
                sourceContract = contractInfo.getSourceContract();
                nowDate = new Date();
                if (sourceContract.getEffectDate() == null || sourceContract.getState() == null) {
                    sourceContract = ContractUtils.getEmployeeContractInfo(ctx, sourceContract.getId().toString());
                }
                srcConEndDate = ContractUtils.getContractEndDateField(sourceContract);
                if (!DateTimeUtils.dayAfter((Date)sourceContract.getEffectDate(), (Date)nowDate) && DateTimeUtils.dayBefore((Date)sourceContract.getEffectDate(), (Date)contractInfo.getEffectDate()) && srcConEndDate != null && !DateTimeUtils.dayBefore((Date)srcConEndDate, (Date)nowDate) && !DateTimeUtils.dayBefore((Date)srcConEndDate, (Date)contractInfo.getEffectDate()) && (contractInfo.getEndDate() == null || contractInfo.getEndDate() != null && DateTimeUtils.dayAfter((Date)contractInfo.getEndDate(), (Date)srcConEndDate))) {
                    resultMap.clear();
                }
            }
        }
        if (resultMap.isEmpty()) {
            sql = new StringBuffer();
            if (contractInfo.getContractLimitType() == ContractLimitTypeEnum.FIXED_LIMIT || contractInfo.getContractLimitType() == ContractLimitTypeEnum.COMPLETE_WORK_TYPE && ContractUtils.getContractEndDateField(contractInfo) != null) {
                endString = "{ts'" + sFormat.format(contractInfo.getEndDate().getTime()) + "'}";
                sql.append("select * from T_HR_HRContractInfo where FIsLaborContract=1 and FState in (5)");
                if (contractInfo.getEmployee() != null && !StringUtils.isEmpty((String)contractInfo.getEmployee().getId().toString())) {
                    sql.append(" and FEmployeeID='").append(contractInfo.getEmployee().getId()).append("'");
                } else {
                    sql.append(" and FPreEntryPersonId ='").append(contractInfo.getPreEntryPerson().getId()).append("'");
                }
                if (contractInfo.getBillID() != null) {
                    sql.append(" and (FBillID<>'").append(contractInfo.getBillID()).append("' or FBillID is null) ");
                }
                if (excludeContractNo != null && excludeContractNo.size() > 0) {
                    sql.append(" and FContractNo not in ").append(ContractUtils.getStrFromSet(excludeContractNo)).append(" ");
                }
                if (contractInfo.getEmployeeContract() != null && contractInfo.getEmployeeContract().getId() != null) {
                    sql.append(" and FEmployeeContractId <> '").append(contractInfo.getEmployeeContract().getId().toString()).append("' ");
                }
                sql.append(" and (FBillState<>4 or FBillState is null)  and FIsDisplay=1").append(" and (").append("  \t\t(FEffectDate>=").append(effdtString).append("  \t\tand FEffectDate<=").append(endString).append(")").append("   or (FEffectDate<=").append(effdtString).append("       and (FToDate is null or (FToDate is not null and FToDate>=").append(effdtString).append(")))").append(" )");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    if (!rs.next()) ** GOTO lbl189
                    resultMap.put("contractNO", rs.getString("FContractNo"));
                    resultMap.put("contractId", rs.getString("FEmployeeContractID"));
                    resultMap.put("billBOSType", rs.getString("FBillBOSType"));
                    resultMap.put("billID", rs.getString("FBillID"));
                    resultMap.put("entryId", rs.getString("FEntryId"));
                    resultMap.put("billState", rs.getInt("FBillState"));
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            } else if (contractInfo.getContractLimitType() == ContractLimitTypeEnum.NO_FIXED_LIMIT || contractInfo.getContractLimitType() == ContractLimitTypeEnum.COMPLETE_WORK_TYPE && ContractUtils.getContractEndDateField(contractInfo) == null) {
                sql.append("select * from T_HR_HRContractInfo where FIsLaborContract=1 and FState in (5)");
                if (contractInfo.getEmployee() != null && !StringUtils.isEmpty((String)contractInfo.getEmployee().getId().toString())) {
                    sql.append(" and FEmployeeID='").append(contractInfo.getEmployee().getId()).append("'");
                } else {
                    sql.append(" and FPreEntryPersonId ='").append(contractInfo.getPreEntryPerson().getId()).append("'");
                }
                if (contractInfo.getBillID() != null) {
                    sql.append(" and (FBillID<>'").append(contractInfo.getBillID()).append("' or FBillID is null) ");
                }
                if (excludeContractNo != null && excludeContractNo.size() > 0) {
                    sql.append(" and FContractNo not in ").append(ContractUtils.getStrFromSet(excludeContractNo)).append(" ");
                }
                sql.append(" and (FBillState<>4 or FBillState is null)  and FIsDisplay=1").append(" and (FToDate is null or (FToDate is not null and FToDate>=").append(effdtString).append("))");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    if (rs.next()) {
                        resultMap.put("contractNO", rs.getString("FContractNo"));
                        resultMap.put("contractId", rs.getString("FEmployeeContractID"));
                        resultMap.put("billBOSType", rs.getString("FBillBOSType"));
                        resultMap.put("billID", rs.getString("FBillID"));
                        resultMap.put("entryId", rs.getString("FEntryId"));
                        resultMap.put("billState", rs.getInt("FBillState"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
lbl189:
        // 7 sources

        if (!resultMap.isEmpty()) {
            personId = contractInfo.getEmployee() == null ? contractInfo.getPreEntryPerson().getId().toString() : contractInfo.getEmployee().getId().toString();
            personParm = ContractUtils.getPersonInfo(ctx, personId);
            billBOSType = (String)resultMap.get("billBOSType");
            if (!(StringUtils.isEmpty((String)billBOSType) || (billState = (Integer)resultMap.get("billState")) == null || 3 == billState && resultMap.get("contractId") != null)) {
                billTypeAlias = null;
                if ("502B7D81".equals(billBOSType)) {
                    entryId = (String)resultMap.get("entryId");
                    if (!StringUtils.isEmpty((String)entryId)) {
                        selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("contractTemplet.isElectronicSign"));
                        entryInfo = ContractSignBizBillEntryFactory.getLocalInstance(ctx).getContractSignBizBillEntryInfo((IObjectPK)new ObjectUuidPK(entryId), selector);
                        billTypeAlias = entryInfo.getContractTemplet() != null && entryInfo.getContractTemplet().isIsElectronicSign() ? ResourceBase.getString((String)"com.kingdee.eas.hr.contract.ContractResource", (String)"CONTRACT_OPT_E_SIGN", (Locale)ctx.getLocale()) : ResourceBase.getString((String)"com.kingdee.eas.hr.contract.ContractResource", (String)"CONTRACT_OPT_SIGN", (Locale)ctx.getLocale());
                    } else {
                        billTypeAlias = ResourceBase.getString((String)"com.kingdee.eas.hr.contract.ContractResource", (String)"CONTRACT_OPT_SIGN", (Locale)ctx.getLocale());
                    }
                } else if ("2A2632A9".equals(billBOSType)) {
                    billTypeAlias = ResourceBase.getString((String)"com.kingdee.eas.hr.contract.ContractResource", (String)"CONTRACT_OPT_RENEW", (Locale)ctx.getLocale());
                } else if ("056FBF2E".equals(billBOSType)) {
                    billTypeAlias = ResourceBase.getString((String)"com.kingdee.eas.hr.contract.ContractResource", (String)"CONTRACT_OPT_CHANGE", (Locale)ctx.getLocale());
                } else if ("9F4ECBD6".equals(billBOSType)) {
                    billTypeAlias = ResourceBase.getString((String)"com.kingdee.eas.hr.contract.ContractResource", (String)"CONTRACT_OPT_PRE_SIGN", (Locale)ctx.getLocale());
                }
                if (billTypeAlias != null) {
                    throw new ContractException(ContractException.SAME_WITH_CONBILL, new Object[]{personParm, billTypeAlias, resultMap.get("contractNO")});
                }
            }
            throw new ContractException(ContractException.SAME_WITH_EMPCON, new Object[]{personParm, resultMap.get("contractNO")});
        }
        return resultMap;
    }

    public static void deleteLaborContractInfo(Context ctx, String personId, String contractId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_HR_HRContractInfo where FEmployeeContractID='").append(contractId).append("' and FIsLaborContract=1");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        ContractUtils.refreshEmployeeContractPageInfo(ctx, personId);
    }

    public static String refreshEmployeeContractPageInfo(Context ctx, String personId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 empContract.fid from T_HR_EmployeeContract empContract ").append(" inner join T_HR_ContractTemplet contractTemplet on contractTemplet.fid = empContract.FContractTempletID").append(" inner join T_HR_ContractType contractType  on contractTemplet.FContractTypeID = contractType.fid ").append("\twhere contractType.FIsLaborContract=1 and FEmployeeID='").append(personId).append("'").append(" \tand empContract.FEffectDate<=CURDATE() and empContract.FState in (1, 2, 4, 5) order by empContract.FState asc, empContract.FEffectDate desc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                EmployeeContractInfo contractInfo = new EmployeeContractInfo();
                String laborContractId = rs.getString(1);
                contractInfo.setId(BOSUuid.read((String)laborContractId));
                sql = new StringBuffer();
                sql.append("select * where person.id='").append(personId).append("'");
                IPersonContractPageInfo iPersonContractPageInfo = PersonContractPageInfoFactory.getLocalInstance(ctx);
                PersonContractPageInfoCollection pageInfoColl = iPersonContractPageInfo.getPersonContractPageInfoCollection(sql.toString());
                PersonContractPageInfoInfo pageInfo = null;
                if (pageInfoColl.size() > 0) {
                    pageInfo = pageInfoColl.get(0);
                    pageInfo.setEmployeeContract(contractInfo);
                    pageInfo.setIsNeedSignContract(true);
                    pageInfo.setHasSignContract(PersonContractState.hasSign);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("isNeedSignContract"));
                    selector.add(new SelectorItemInfo("hasSignContract"));
                    selector.add(new SelectorItemInfo("employeeContract"));
                    iPersonContractPageInfo.updatePartial(pageInfo, selector);
                } else {
                    pageInfo = new PersonContractPageInfoInfo();
                    pageInfo.setId(BOSUuid.create((BOSObjectType)pageInfo.getBOSType()));
                    PersonInfo personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)personId));
                    pageInfo.setPerson(personInfo);
                    pageInfo.setEmployeeContract(contractInfo);
                    pageInfo.setIsNeedSignContract(true);
                    pageInfo.setHasSignContract(PersonContractState.hasSign);
                    iPersonContractPageInfo.addnew(pageInfo);
                }
                return laborContractId;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String getStrFromSet(Set set) {
        if (set == null || set != null && set.size() == 0) {
            return "('')";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Iterator ite = set.iterator();
        while (ite.hasNext()) {
            sb.append("'");
            sb.append(ite.next().toString());
            sb.append("',");
        }
        String vals = sb.substring(0, sb.lastIndexOf(",")) + ")";
        return vals;
    }

    public static boolean isHaveChild(Context ctx, String contractId) throws BOSException {
        boolean isHaveChild = false;
        StringBuffer oql = new StringBuffer(" select id ");
        oql.append(" where  sourcecontract='").append(contractId).append("'");
        EmployeeContractCollection eContCol = new EmployeeContractCollection();
        eContCol = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(oql.toString());
        if (eContCol.size() > 0) {
            isHaveChild = true;
        }
        return isHaveChild;
    }

    public static EmployeeContractCollection getPersonAllLaborEmployeeContractInfo(Context ctx, String personId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select empCon.FID,empCon.FContractLimitType,empCon.FState,empCon.FEffectDate from T_HR_EmployeeContract empCon ").append("  inner join T_HR_ContractTemplet contractTemplet on empCon.FContractTempletID = contractTemplet.fid").append("  inner join T_HR_ContractType contractType on contractTemplet.FContractTypeID = contractType.fid").append("  where contractType.fIsLaborContract = 1 and empCon.FState in (0,1)").append("  and empCon.FEmployeeID='").append(personId).append("' order by empCon.FEffectDate desc");
        IRowSet newRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        EmployeeContractInfo contractInfo = null;
        EmployeeContractCollection collection = new EmployeeContractCollection();
        try {
            while (newRs.next()) {
                contractInfo = new EmployeeContractInfo();
                contractInfo.setId(BOSUuid.read((String)newRs.getString(1)));
                contractInfo.setContractLimitType(ContractLimitTypeEnum.getEnum((String)newRs.getString("FContractLimitType")));
                contractInfo.setState(EmployeeContractState.getEnum((String)newRs.getString("FState")));
                contractInfo.setEffectDate((Date)newRs.getDate("FEffectDate"));
                collection.add(contractInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return collection;
    }

    public static EmployeeContractInfo getPersonNewestContract(Context ctx, String personId) {
        try {
            EmployeeContractCollection coll = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection("where employee.id = '" + personId + "' and isNewestContract = 1");
            if (coll.size() > 0) {
                return coll.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static EmployeeOtherContractCollection getPersonAllLaborEmployeeOtherContractInfo(Context ctx, String personId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select empCon.FID,empCon.FContractLimitType,empCon.FState,empCon.FEffectDate from T_HR_EmployeeOtherContract empCon ").append("  inner join T_HR_ContractTemplet contractTemplet on empCon.FContractTempletID = contractTemplet.fid").append("  inner join T_HR_ContractType contractType on contractTemplet.FContractTypeID = contractType.fid").append("  where contractType.fIsLaborContract = 0 and empCon.FState in (0,1)").append("  and empCon.FEmployeeID='").append(personId).append("' order by empCon.FEffectDate desc");
        IRowSet newRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        EmployeeOtherContractInfo contractInfo = null;
        EmployeeOtherContractCollection collection = new EmployeeOtherContractCollection();
        try {
            while (newRs.next()) {
                contractInfo = new EmployeeOtherContractInfo();
                contractInfo.setId(BOSUuid.read((String)newRs.getString(1)));
                contractInfo.setContractLimitType(ContractLimitTypeEnum.getEnum((String)newRs.getString("FContractLimitType")));
                contractInfo.setState(EmployeeContractState.getEnum((String)newRs.getString("FState")));
                contractInfo.setEffectDate((Date)newRs.getDate("FEffectDate"));
                collection.add(contractInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return collection;
    }

    public static void checkPersonHasMutiLaborEmployeeContract(Context ctx, String personId) throws BOSException, ContractException {
        EmployeeContractCollection collection = ContractUtils.getPersonAllLaborEmployeeContractInfo(ctx, personId);
        if (collection != null && collection.size() >= 2) {
            throw new ContractException(ContractException.PERSON_HAS_MULTI_CONTRACT);
        }
    }

    public static void checkPersonHasFutureContract(Context ctx, String personId) throws BOSException, EASBizException {
        String dateStr = DateTimeUtils.format((Date)new Date());
        if (EmployeeContractFactory.getLocalInstance((Context)ctx).exists("where employee.id = '" + personId + "' and contractTemplet.contractType.isLaborContract=1 and effectDate>'" + dateStr + "'")) {
            String personParm = ContractUtils.getPersonInfo(ctx, personId);
            throw new ContractException(ContractException.PERSON_HAS_FUTURE_CONTRACT, new Object[]{personParm});
        }
    }

    public static void checkPreEntryPersonHasFutureContract(Context ctx, String entryPersonId) throws BOSException, EASBizException {
        String dateStr = DateTimeUtils.format((Date)new Date());
        if (EmployeeContractFactory.getLocalInstance((Context)ctx).exists("where preEntryPerson.id = '" + entryPersonId + "' and contractTemplet.contractType.isLaborContract=1 and effectDate>'" + dateStr + "'")) {
            String personParm = ContractUtils.getPersonInfo(ctx, entryPersonId);
            throw new ContractException(ContractException.PERSON_HAS_FUTURE_CONTRACT, new Object[]{personParm});
        }
    }

    public static EmployeeContractCollection getPersonAllLaborEmployeeContractInfoCanBeResumed(Context ctx, String personId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select empCon.FID,empCon.FContractLimitType,empCon.FState,empCon.FEffectDate from T_HR_EmployeeContract empCon ").append("  inner join T_HR_ContractTemplet contractTemplet on empCon.FContractTempletID = contractTemplet.fid").append("  inner join T_HR_ContractType contractType on contractTemplet.FContractTypeID = contractType.fid").append("  where contractType.fIsLaborContract = 1 and empCon.FState in (0,1,4)").append("  and empCon.FEmployeeID='").append(personId).append("' order by empCon.FEffectDate desc");
        IRowSet newRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        EmployeeContractInfo contractInfo = null;
        EmployeeContractCollection collection = new EmployeeContractCollection();
        try {
            while (newRs.next()) {
                contractInfo = new EmployeeContractInfo();
                contractInfo.setId(BOSUuid.read((String)newRs.getString(1)));
                contractInfo.setContractLimitType(ContractLimitTypeEnum.getEnum((String)newRs.getString("FContractLimitType")));
                contractInfo.setState(EmployeeContractState.getEnum((String)newRs.getString("FState")));
                contractInfo.setEffectDate((Date)newRs.getDate("FEffectDate"));
                collection.add(contractInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return collection;
    }

    public static EmployeeContractInfo getPersonLaborEmployeeContractInfo(Context ctx, String personId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 empCon.FID,empCon.FContractLimitType,empCon.FState,FContinuousSignedCount,empCon.FEffectDate,empCon.FEndDate,empCon.FEndDateReal,empCon.FToDate,empCon.FNewState from T_HR_EmployeeContract empCon ").append("  inner join T_HR_ContractTemplet contractTemplet on empCon.FContractTempletID = contractTemplet.fid").append("  inner join T_HR_ContractType contractType on contractTemplet.FContractTypeID = contractType.fid").append("  where contractType.fIsLaborContract = 1 and empCon.FNewState in (0,1,4,5) and empCon.FEffectDate<=CURDATE()").append("  and empCon.FEmployeeID='").append(personId).append("' order by empCon.FEffectDate desc");
        IRowSet newRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        EmployeeContractInfo contractInfo = null;
        try {
            if (newRs.next()) {
                contractInfo = new EmployeeContractInfo();
                contractInfo.setId(BOSUuid.read((String)newRs.getString(1)));
                contractInfo.setContractLimitType(ContractLimitTypeEnum.getEnum((String)newRs.getString("FContractLimitType")));
                contractInfo.setState(EmployeeContractState.getEnum((int)newRs.getInt("FState")));
                contractInfo.setContinuousSignedCount(newRs.getInt("FContinuousSignedCount"));
                contractInfo.setEffectDate((Date)newRs.getDate("FEffectDate"));
                contractInfo.setEndDate((Date)newRs.getDate("FEndDate"));
                contractInfo.setEndDateReal((Date)newRs.getDate("FEndDateReal"));
                contractInfo.setFreeDate((Date)newRs.getDate("FToDate"));
                contractInfo.setNewState(EmployeeContractNewStateEnum.getEnum((int)newRs.getInt("FNewState")));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return contractInfo;
    }

    public static HRContractInfoInfo getIHRContractInfoByContractInfo(Context ctx, EmployeeContractInfo contractInfo) throws BOSException {
        String oql = "select * where employeeContract.id='" + contractInfo.getId() + "'";
        HRContractInfoCollection infoColl = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection(oql);
        HRContractInfoInfo info = null;
        if (infoColl.size() > 0) {
            info = infoColl.get(0);
        }
        return info;
    }

    public static String getPersonLaborEmployeeContractSQL(Context ctx, Set personIdSet) {
        String personIds = HRUtil.getStrFromSet((Set)personIdSet);
        StringBuffer sql = new StringBuffer();
        sql.append("select empContract.fid from T_HR_EmployeeContract empContract ").append(" inner join (").append(" select empCon.FEmployeeID,max(empCon.FEffectDate) FEffectDate from T_HR_EmployeeContract empCon  ").append(" inner join T_HR_ContractTemplet contractTemplet on empCon.FContractTempletID = contractTemplet.fid ").append(" inner join T_HR_ContractType contractType on contractTemplet.FContractTypeID = contractType.fid ").append("  where contractType.fIsLaborContract = 1  ").append("  and empCon.FEmployeeID in ").append(personIds).append("  group by  empCon.FEmployeeID) maxEffdtCon ").append("  on maxEffdtCon.FEmployeeID=empContract.FEmployeeID and empContract.FEffectDate=maxEffdtCon.FEffectDate ").append(" and empContract.FEmployeeID in ").append(personIds).append("  and empContract.fvip=1 ");
        return sql.toString();
    }

    public static CoreBaseInfo getDynValueClass(Context ctx, String entityFullName) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo eoInfo = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)entityFullName));
        String valueClassName = eoInfo.getObjectValueClass();
        CoreBaseInfo info = null;
        try {
            Class<?> c = Class.forName(valueClassName);
            Constructor<?> cst = c.getConstructor(null);
            info = (CoreBaseInfo)cst.newInstance(null);
            if (info instanceof DataBaseCustomInfo) {
                ((DataBaseCustomInfo)info).setBOSType(eoInfo.getType());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    public static void endPersonContract(Context ctx, String personId, Date endDate) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personId)) {
            return;
        }
        EmployeeContractCollection ecColl = ContractUtils.getPersonAllLaborEmployeeContractInfo(ctx, personId);
        IEmployeeContract iECF = EmployeeContractFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("endDateReal"));
        selector.add(new SelectorItemInfo("contractLimitAutoReal"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("newState"));
        for (int i = 0; i < ecColl.size(); ++i) {
            EmployeeContractInfo ecInfo = ecColl.get(i);
            ecInfo.setEndDateReal(endDate);
            ecInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(ecInfo.getEffectDate(), endDate));
            ecInfo.setState(EmployeeContractState.END);
            ecInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            iECF.updatePartial((CoreBaseInfo)ecInfo, selector);
            String curDate = HRUtil.getCurrentDate();
            StringBuffer sql = new StringBuffer();
            sql.append(" delete from T_HR_EmployeeContract where FEffectDate>").append(curDate).append(" and FEmployeeID='").append(personId).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql = new StringBuffer();
            sql.append(" delete from T_HR_HRContractInfo where FEffectDate>").append(curDate).append(" and FEmployeeID='").append(personId).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        ContractUtils.updateHRContractInfo(ctx, personId, endDate);
    }

    public static void endPersonOtherContract(Context ctx, String personId, Date endDate) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personId)) {
            return;
        }
        EmployeeOtherContractCollection ecColl = ContractUtils.getPersonAllLaborEmployeeOtherContractInfo(ctx, personId);
        IEmployeeOtherContract iECF = EmployeeOtherContractFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("endDateReal"));
        selector.add(new SelectorItemInfo("contractLimitAutoReal"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("newState"));
        for (int i = 0; i < ecColl.size(); ++i) {
            EmployeeOtherContractInfo ecInfo = ecColl.get(i);
            ecInfo.setEndDateReal(endDate);
            ecInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(ecInfo.getEffectDate(), endDate));
            ecInfo.setState(EmployeeContractState.END);
            ecInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            iECF.updatePartial((CoreBaseInfo)ecInfo, selector);
        }
        String curDate = HRUtil.getCurrentDate();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_HR_EmployeeOtherContract where FEffectDate>").append(curDate).append(" and FEmployeeID='").append(personId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static void updateHRContractInfo(Context ctx, String personId, Date endDate) throws EASBizException, BOSException {
        HRContractInfoCollection ciColl = HRContractInfoUtils.getCurrentHRContractCollectionByPerson(ctx, personId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("newState"));
        selector.add(new SelectorItemInfo("endDateReal"));
        selector.add(new SelectorItemInfo("contractLimitAutoReal"));
        for (int i = 0; i < ciColl.size(); ++i) {
            HRContractInfoInfo ciInfo = ciColl.get(i);
            ciInfo.setState(EmployeeContractState.END);
            ciInfo.setNewState(EmployeeContractNewStateEnum.ENDED);
            ciInfo.setEndDateReal(endDate);
            ciInfo.setContractLimitAutoReal(ContractUtils.calContractLimit(ciInfo.getEffectDate(), endDate));
            HRContractInfoFactory.getLocalInstance(ctx).updatePartial(ciInfo, selector);
        }
    }

    public static void getBillApprovePersonData(List<Map<String, Object>> recordList) {
        if (!recordList.isEmpty() && recordList != null) {
            Map<String, Set<String>> assginMap = ContractUtils.setAssginApprovePersonMap(recordList);
            for (Map<String, Object> mapRecord : recordList) {
                String billId = (String)mapRecord.get("id");
                if (assginMap.get(billId) == null) continue;
                Set<String> personNameSet = assginMap.get(billId);
                ((HashMap)mapRecord).put("description", ContractUtils.convertSetToString(personNameSet));
            }
        }
    }

    public static Map<String, Set<String>> setAssginApprovePersonMap(List<Map<String, Object>> recordList) {
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, Set<String>> assginMap = new HashMap<String, Set<String>>();
        for (Map<String, Object> mapRecord : recordList) {
            String billId = (String)mapRecord.get("id");
            ids.add(billId);
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bizObjID"));
        sic.add(new SelectorItemInfo("performerUName"));
        sic.add(new SelectorItemInfo("personEmpName"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bizObjID", ids, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        try {
            AssignCollection assginCol = AssignFactory.getRemoteInstance().getCollection(entityViewInfo);
            if (!assginCol.isEmpty() && assginCol.size() > 0) {
                int assginSize = assginCol.size();
                for (int i = 0; i < assginSize; ++i) {
                    Set<String> personNameSet;
                    AssignInfo assginInfo = assginCol.get(i);
                    String billId = assginInfo.getBizObjID();
                    String personName = assginInfo.getPersonEmpName();
                    if (assginMap.get(billId) != null) {
                        personNameSet = (Set)assginMap.get(billId);
                        personNameSet.add(personName);
                        assginMap.put(billId, personNameSet);
                        continue;
                    }
                    personNameSet = new HashSet();
                    personNameSet.add(personName);
                    assginMap.put(billId, personNameSet);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return assginMap;
    }

    public static String convertSetToString(Set<String> personNameSet) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = personNameSet.iterator();
        while (it.hasNext()) {
            sb.append("" + it.next() + "");
            sb.append(",");
        }
        sb = sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    public static void checkProbation(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        if ("true".equals(contractInfo.getString("contractInitImport"))) {
            return;
        }
        Date curDate = new Date();
        if (contractInfo.getEndDateReal() != null && DateTimeUtils.dayBefore((Date)contractInfo.getEndDateReal(), (Date)curDate) || contractInfo.getEndDate() != null && DateTimeUtils.dayBefore((Date)contractInfo.getEndDate(), (Date)curDate)) {
            return;
        }
        if (contractInfo.getSourceContract() == null) {
            String hroId;
            HROrgUnitInfo hroInfo = contractInfo.getHrOrgUnit();
            String string = hroId = hroInfo == null ? null : hroInfo.getId().toString();
            if (!HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_CONTRACT_CHECK_PROBATION", (String)hroId)) {
                return;
            }
            int probation = 0;
            if (contractInfo.containsKey(PROBATION)) {
                probation = contractInfo.getInt(PROBATION);
            } else if (contractInfo.getEmployee() != null) {
                EmpLaborRelationCollection empLaborColl = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationCollection("where person.id = '" + contractInfo.getEmployee().getId().toString() + "'");
                if (empLaborColl.size() > 0 && empLaborColl.get(0).getTryoutMonth() > 0) {
                    probation = empLaborColl.get(0).getTryoutMonth();
                }
            } else {
                return;
            }
            if (probation > 0) {
                String personId = contractInfo.getEmployee() == null ? contractInfo.getPreEntryPerson().getId().toString() : contractInfo.getEmployee().getId().toString();
                String personParm = ContractUtils.getPersonInfo(ctx, personId);
                if (contractInfo.getContractLimitType() == ContractLimitTypeEnum.FIXED_LIMIT) {
                    Date beginDate = contractInfo.getEffectDate();
                    Date endDate = HRUtil.getAftereDate((Date)contractInfo.getEndDate());
                    int contractLimit = (DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)beginDate)) * 12 + (DateTimeUtils.getMonth((Date)endDate) - DateTimeUtils.getMonth((Date)beginDate)) - (DateTimeUtils.getDay((Date)endDate) < DateTimeUtils.getDay((Date)beginDate) ? 1 : 0);
                    if (contractLimit < 3 && probation > 0) {
                        throw new ContractException(ContractException.PROBATION_SHOULD_BE_NULL, new Object[]{personParm});
                    }
                    if (contractLimit < 12 && contractLimit >= 3 && probation > 1) {
                        throw new ContractException(ContractException.PROBATION_MORE_THAN_ONE_MONTH, new Object[]{personParm});
                    }
                    if (contractLimit >= 12 && contractLimit < 36 && probation > 2) {
                        throw new ContractException(ContractException.PROBATION_MORE_THAN_TWO_MONTH, new Object[]{personParm});
                    }
                    if (contractLimit >= 36 && probation > 6) {
                        throw new ContractException(ContractException.PROBATION_MORE_THAN_SIX_MONTH_FIX, new Object[]{personParm});
                    }
                } else if (contractInfo.getContractLimitType() == ContractLimitTypeEnum.NO_FIXED_LIMIT && probation > 6) {
                    throw new ContractException(ContractException.PROBATION_MORE_THAN_SIX_MONTH_NO_FIX, new Object[]{personParm});
                }
            }
        }
    }

    public static BigDecimal calContractLimit(Date effectDate, Date endDate) {
        if (effectDate == null || endDate == null) {
            return null;
        }
        BigDecimal calTime = new BigDecimal(DateTimeUtils.dateDiff((Date)effectDate, (Date)endDate));
        calTime = calTime.setScale(1, 4);
        calTime = calTime.divide(BigDecimal.valueOf(3.1536E10), 4);
        return calTime;
    }

    public static void checkContractEndOrFreeException(Context ctx, EmployeeContractInfo sourceContract, String opt) throws EASBizException, BOSException {
        Date nowDate = new Date();
        String errorState = null;
        if (sourceContract == null) {
            throw new ContractException(ContractException.PERSONNOTSIGNCONTRACT_OLD);
        }
        String personParm = sourceContract.getEmployee().getNumber() + "_" + sourceContract.getEmployee().getName();
        if (DateTimeUtils.dayAfter((Date)sourceContract.getEffectDate(), (Date)nowDate)) {
            throw new ContractException(ContractException.SRC_CONTRACT_NOT_EFFECT, new Object[]{personParm});
        }
        if (sourceContract.getState() == EmployeeContractState.FREE || sourceContract.getState() == EmployeeContractState.END) {
            errorState = sourceContract.getState().getAlias();
        } else if (sourceContract.getNewState() == EmployeeContractNewStateEnum.CHANGED || sourceContract.getNewState() == EmployeeContractNewStateEnum.RESUMED) {
            errorState = sourceContract.getNewState().getAlias();
        } else if (sourceContract.getEndDateReal() != null || sourceContract.getNewState() == EmployeeContractNewStateEnum.ENDED) {
            errorState = EmployeeContractNewStateEnum.ENDED.getAlias();
        } else if (sourceContract.getFreeDate() != null || sourceContract.getNewState() == EmployeeContractNewStateEnum.FREED) {
            errorState = EmployeeContractNewStateEnum.FREED.getAlias();
        }
        if (errorState != null) {
            throw new ContractException(ContractException.CONTRACT_CANNOT_OPT, new Object[]{personParm, errorState, SHRServerResource.getString((String)CONTRACT_RES_CLASSNAME, (String)opt, (Locale)ctx.getLocale())});
        }
    }

    public static void checkContractEndException(Context ctx, EmployeeContractInfo contract, EmployeeContractInfo oldContract) throws EASBizException, BOSException {
        if (oldContract == null) {
            oldContract = contract != null && contract.getId() != null ? ContractUtils.getEmployeeContractInfo(ctx, contract.getId().toString()) : ContractUtils.getEmployeeContractInfoByNo(ctx, contract.getContractNo(), contract.getHrOrgUnit().getId().toString());
        }
        ContractUtils.checkContractEndOrFreeException(ctx, oldContract, CONTRACT_OPT_END);
        Date oldContractEndDate = oldContract.getEndDate();
        String personParm = oldContract.getEmployee().getNumber() + "_" + oldContract.getEmployee().getName();
        if (oldContractEndDate != null && DateTimeUtils.dayAfter((Date)contract.getEndDateReal(), (Date)oldContractEndDate)) {
            throw new ContractException(ContractException.ENDDATE_AFTER_OLDENDDATE, new Object[]{personParm});
        }
        if (DateTimeUtils.dayBefore((Date)contract.getEndDateReal(), (Date)oldContract.getEffectDate())) {
            throw new ContractException(ContractException.EFFECTDATE_AFTER_ENDDATE, new Object[]{personParm});
        }
    }

    public static void checkContractFreeException(Context ctx, EmployeeContractInfo contract, EmployeeContractInfo oldContract) throws EASBizException, BOSException {
        Integer entryIndex = (Integer)contract.get(CONTRACTFIELD_ENTRYINDEX);
        if (entryIndex == null) {
            entryIndex = 0;
        }
        if (oldContract == null) {
            oldContract = contract != null && contract.getId() != null ? ContractUtils.getEmployeeContractInfo(ctx, contract.getId().toString()) : ContractUtils.getEmployeeContractInfoByNo(ctx, contract.getContractNo(), contract.getHrOrgUnit().getId().toString());
        }
        ContractUtils.checkContractEndOrFreeException(ctx, oldContract, CONTRACT_OPT_FREE);
        Date oldContractEndDate = ContractUtils.getContractEndDateField(oldContract);
        String personParm = oldContract.getEmployee().getNumber() + "_" + oldContract.getEmployee().getName();
        if (oldContractEndDate != null && DateTimeUtils.dayAfter((Date)contract.getFreeDate(), (Date)oldContractEndDate)) {
            throw new ContractException(ContractException.FREEDATE_AFTER_ENDDATE, new Object[]{personParm});
        }
        if (oldContract.getEffectDate() != null && DateTimeUtils.dayBefore((Date)contract.getFreeDate(), (Date)oldContract.getEffectDate())) {
            throw new ContractException(ContractException.EFFECTDATE_AFTER_FREEDATE, new Object[]{personParm});
        }
    }

    public static void checkContractChangeOrRenewException(Context ctx, String personId, EmployeeContractInfo sourceContract, String opt) throws EASBizException, BOSException {
        Date nowDate = new Date();
        String personParm = ContractUtils.getPersonInfo(ctx, personId);
        if (sourceContract == null) {
            throw new ContractException(ContractException.PERSONNOTSIGNCONTRACT, new Object[]{personParm});
        }
        if (DateTimeUtils.dayAfter((Date)sourceContract.getEffectDate(), (Date)nowDate)) {
            throw new ContractException(ContractException.SRC_CONTRACT_NOT_EFFECT, new Object[]{personParm});
        }
        Date endDateReal = sourceContract.getEndDateReal();
        Date freeDate = sourceContract.getFreeDate();
        String errorState = null;
        if (sourceContract.getNewState() == EmployeeContractNewStateEnum.CHANGED || sourceContract.getNewState() == EmployeeContractNewStateEnum.RESUMED) {
            errorState = sourceContract.getNewState().getAlias();
        } else if (freeDate != null || sourceContract.getNewState() == EmployeeContractNewStateEnum.FREED) {
            errorState = EmployeeContractNewStateEnum.FREED.getAlias();
        } else if ((endDateReal != null && !DateTimeUtils.dayBefore((Date)endDateReal, (Date)nowDate) || endDateReal == null && sourceContract.getNewState() == EmployeeContractNewStateEnum.ENDED) && CONTRACT_OPT_RENEW.equals(opt)) {
            errorState = EmployeeContractNewStateEnum.ENDED.getAlias();
        } else if ((endDateReal != null || sourceContract.getNewState() == EmployeeContractNewStateEnum.ENDED) && CONTRACT_OPT_CHANGE.equals(opt)) {
            errorState = EmployeeContractNewStateEnum.ENDED.getAlias();
        }
        if (errorState != null) {
            throw new ContractException(ContractException.CONTRACT_CANNOT_OPT, new Object[]{personParm, errorState, SHRServerResource.getString((String)CONTRACT_RES_CLASSNAME, (String)opt, (Locale)ctx.getLocale())});
        }
    }

    public static EmployeeOtherContractInfo getEmployeeOtherContractInfoById(Context ctx, String contractId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)contractId));
        EmployeeOtherContractCollection coll = ContractUtils.getEmployeeOtherContractInfoByFilter(ctx, filter);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public static EmployeeOtherContractCollection getEmployeeOtherContractInfoByFilter(Context ctx, FilterInfo filter) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = ContractUtils.getEmployeeOtherContractInfoSelector();
        view.setSelector(selector);
        view.setFilter(filter);
        EmployeeOtherContractCollection coll = EmployeeOtherContractFactory.getLocalInstance((Context)ctx).getEmployeeOtherContractCollection(view);
        return coll;
    }

    public static SelectorItemCollection getEmployeeOtherContractInfoSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("newState"));
        selector.add(new SelectorItemInfo("endDateReal"));
        selector.add(new SelectorItemInfo("endDate"));
        selector.add(new SelectorItemInfo("effectDate"));
        selector.add(new SelectorItemInfo("freeDate"));
        selector.add(new SelectorItemInfo("contractNo"));
        selector.add(new SelectorItemInfo("employee.id"));
        selector.add(new SelectorItemInfo("employee.number"));
        selector.add(new SelectorItemInfo("employee.name"));
        selector.add(new SelectorItemInfo("employee.idCardNO"));
        selector.add(new SelectorItemInfo("employee.passportNO"));
        selector.add(new SelectorItemInfo("signStatus"));
        selector.add(new SelectorItemInfo("contractClassify"));
        return selector;
    }

    public static Date getContractEndDateField(EmployeeContractInfo contract) {
        if (contract.getFreeDate() == null && contract.getEndDateReal() != null) {
            return contract.getEndDateReal();
        }
        return contract.getEndDate();
    }

    public static Date getContractEndDateField(HRContractInfoInfo contract) {
        if (contract.getFreeDate() == null && contract.getEndDateReal() != null) {
            return contract.getEndDateReal();
        }
        return contract.getEndDate();
    }

    public static Date getContractEndDateField(EmployeeOtherContractInfo contract) {
        if (contract.getFreeDate() == null && contract.getEndDateReal() != null) {
            return contract.getEndDateReal();
        }
        return contract.getEndDate();
    }

    public static void checkContractInBillByType(Context ctx, String sourceContract, BOSUuid billId, BillTypeEnum billTypeEnum, Integer index) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer("select cb.FNumber, cb.FID from ").append(billTypeEnum.getEntryTableName()).append(" ce ").append("inner join ").append(billTypeEnum.getTableName()).append(" cb on ce.FBillID = cb.FID where ");
        if (billTypeEnum.getValue() == 3 || billTypeEnum.getValue() == 4) {
            sql.append(" ce.FContractNo = '").append(sourceContract);
        } else {
            sql.append(" ce.FSourceContractId = '").append(sourceContract);
        }
        if (billId != null) {
            sql.append("' and cb.FID <> '");
            sql.append(billId.toString());
        }
        sql.append("' and (cb.FBillState in (0, 1, 2) or (cb.FBillState = 3 and ce.FBizDate >= CURDATE()");
        sql.append("))");
        if (sql.length() > 0) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    String billNumber = rs.getString(1);
                    if (index == null || index == 0) {
                        index = 1;
                    }
                    NumericExceptionSubItem exceptionItem = null;
                    switch (billTypeEnum.getValue()) {
                        case 1: {
                            exceptionItem = ContractException.CONTRACT_ISRENEW;
                            break;
                        }
                        case 2: {
                            exceptionItem = ContractException.CONTRACT_ISUSED;
                            break;
                        }
                        case 3: {
                            exceptionItem = ContractException.CONTRACT_ISEND;
                            break;
                        }
                        case 4: {
                            exceptionItem = ContractException.CONTRACT_ISFREE;
                        }
                    }
                    if (exceptionItem == null) continue;
                    EmployeeContractInfo employeeContract = null;
                    employeeContract = ContractUtils.getEmployeeContractInfoByNo(ctx, sourceContract, null);
                    if (employeeContract == null) {
                        employeeContract = ContractUtils.getEmployeeContractInfo(ctx, sourceContract);
                    }
                    throw new ContractException(exceptionItem, new Object[]{employeeContract.getEmployee().getNumber() + "_" + employeeContract.getEmployee().getName(), billNumber});
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void checkContractInBillByHRContractInfo(Context ctx, String contractId, BOSUuid billId) throws BOSException, EASBizException {
        HRContractInfoCollection hrContractInfoColl;
        String curDateStr = HRUtilExtend.getDateStringWithoutMininuteTs((Date)new Date());
        StringBuilder oql = new StringBuilder("select entryID,billID,billBOSType,billState,entryBizDate where sourceContract.id='").append(contractId).append("' and billID is not null and (billState in (0, 1, 2) or (billState = 3 and entryBizDate > ").append(curDateStr).append(")) ");
        if (billId != null) {
            oql.append(" and billID <> '").append(billId.toString()).append("'");
        }
        if ((hrContractInfoColl = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoCollection(oql.toString())).size() > 0) {
            HRContractInfoInfo hrContractInfo = hrContractInfoColl.get(0);
            BillTypeEnum billTypeEnum = BillTypeEnum.getEnum((String)hrContractInfo.getBillBOSType());
            StringBuilder sql = new StringBuilder("select fnumber from ").append(billTypeEnum.getTableName()).append(" where fid = '").append(hrContractInfo.getBillID().toString()).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    String billNumber = rs.getString("fnumber");
                    NumericExceptionSubItem exceptionItem = null;
                    switch (billTypeEnum.getValue()) {
                        case 1: {
                            exceptionItem = ContractException.CONTRACT_ISRENEW;
                            break;
                        }
                        case 2: {
                            exceptionItem = ContractException.CONTRACT_ISUSED;
                            break;
                        }
                        case 3: {
                            exceptionItem = ContractException.CONTRACT_ISEND;
                            break;
                        }
                        case 4: {
                            exceptionItem = ContractException.CONTRACT_ISFREE;
                        }
                    }
                    if (exceptionItem != null) {
                        EmployeeContractInfo employeeInfo = ContractUtils.getEmployeeContractInfo(ctx, contractId);
                        throw new ContractException(exceptionItem, new Object[]{employeeInfo.getEmployee().getNumber() + "_" + employeeInfo.getEmployee().getName(), billNumber});
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void checkSourceContractTimeIsCrossing(Context ctx, EmployeeContractInfo currentContractInfo, EmployeeContractInfo sourceContractInfo) throws ContractException, BOSException {
        try {
            HROrgUnitInfo hrOrgInfo = currentContractInfo.getHrOrgUnit();
            String hrOrgId = hrOrgInfo == null ? null : hrOrgInfo.getId().toString();
            Date currentEFFDate = currentContractInfo.getEffectDate();
            Date currentEndDate = currentContractInfo.getEndDate();
            Date sourceStartDate = sourceContractInfo.getEffectDate();
            Date sourceEndDate = ContractUtils.getContractEndDateField(sourceContractInfo);
            String personParm = ContractUtils.getPersonInfo(ctx, currentContractInfo.getEmployee().getId().toString());
            if (HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_ALLOW_CONTRACT_CROSSING", (String)hrOrgId)) {
                if (DateTimeUtils.dayBefore((Date)currentEFFDate, (Date)sourceStartDate)) {
                    throw new ContractException(ContractException.BIZDATE_BEFORE_EFFDT, new Object[]{personParm});
                }
                if (currentEndDate != null && sourceEndDate != null && DateTimeUtils.dayBefore((Date)currentEndDate, (Date)sourceEndDate)) {
                    throw new ContractException(ContractException.ENDDATE_BEFORE_ENDDATE, new Object[]{personParm});
                }
            } else if (sourceEndDate != null && DateTimeUtils.dayBefore((Date)currentEFFDate, (Date)sourceEndDate)) {
                throw new ContractException(ContractException.BIZDATE_BEFORE_ENDDATE, new Object[]{personParm});
            }
        }
        catch (EASBizException e) {
            if (e instanceof ContractException) {
                throw (ContractException)e;
            }
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void setEmployeeContractInfoIsElectronicSign(EmployeeContractInfo contractInfo) {
        contractInfo.setIsElectronicSign(false);
    }

    public static boolean checkIsEnrollAgainPersonWhenRenewAction(Context ctx, String contractId, Map<Object, Object> personMap) throws BOSException {
        try {
            String l = LocaleUtils.getShortCode((Context)ctx);
            StringBuilder sql = new StringBuilder("select person.FName_" + l + " as personName, person.FNumber as personNumber, person.Fid as personId, eor.Fid as eorId, eor.FEFFDT as eorEffdt, eor.FactionId as actionId ").append("from T_HR_EmpOrgRelation eor ").append("left join T_HR_EmployeeContract contract on eor.FPersonId = contract.FEmployeeId and eor.FEFFDT>contract.FEffectDate ").append("left join T_BD_Person person on person.Fid = contract.FEmployeeId ").append(" where eor.FactionId = '").append("DawAAAApC9TmaL7Z").append("' and contract.Fid = '").append(contractId).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                if (personMap != null) {
                    personMap.put("name", rs.getString("personName"));
                    personMap.put("number", rs.getString("personNumber"));
                }
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static boolean checkCanContractIdBeBatchRenew(Context ctx, String[] contractIds) throws EASBizException, BOSException {
        if (contractIds.length == 0) {
            return true;
        }
        if (contractIds.length == 1) {
            if (EmployeeContractFactory.getLocalInstance((Context)ctx).exists("where id = '" + contractIds[0] + "'and contractLimitType = " + "2")) {
                throw new ContractException(ContractException.PLS_SELECT_RIGHT_CONTRACT_TO_RENEW, new String[]{"", "", ResourceBase.getString((String)CONTRACT_RES_CLASSNAME, (String)"RENEW_NOT_NONE_LIMITED", (Locale)ctx.getLocale())});
            }
        } else {
            ArrayList<String> paramList = new ArrayList<String>();
            ArrayList<String> prifixList = new ArrayList<String>();
            for (int i = 0; i < 3; ++i) {
                for (String id : contractIds) {
                    if (i == 1) {
                        prifixList.add("?");
                    }
                    paramList.add(id);
                }
            }
            paramList.add("2");
            Object[] paramArr = paramList.toArray();
            String delimiter = ",";
            String joinSql = String.join((CharSequence)delimiter, prifixList);
            StringBuilder sql = new StringBuilder("select count(1) as countNum from (select FHRORGUNITID  from T_HR_EmployeeContract where Fid in ").append("(").append(joinSql).append(") group by FHRORGUNITID) as T1 ").append(" union all ").append("select count(1) as countNum from (select FCONTFIRSTPARTYID from T_HR_EmployeeContract where Fid in ").append("(").append(joinSql).append(") group by FCONTFIRSTPARTYID) as T2 ").append(" union all ").append("select count(1) as countNum from T_HR_EmployeeContract where Fid in ").append("(").append(joinSql).append(") and FCONTRACTLIMITTYPE = ").append("?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramArr);
            int i = 0;
            boolean checkResult = true;
            Object[] errorPoint = new String[]{"", "", ""};
            try {
                while (rs.next()) {
                    int countNum = rs.getInt("countNum");
                    if (i == 0 && countNum > 1) {
                        checkResult = false;
                        errorPoint[i] = ResourceBase.getString((String)CONTRACT_RES_CLASSNAME, (String)"RENEW_SAME_HRORG", (Locale)ctx.getLocale());
                    }
                    if (i == 1 && countNum > 1) {
                        if (!checkResult) {
                            errorPoint[i] = ResourceBase.getString((String)CONTRACT_RES_CLASSNAME, (String)"DUN_HAO", (Locale)ctx.getLocale());
                        }
                        errorPoint[i] = (String)errorPoint[i] + ResourceBase.getString((String)CONTRACT_RES_CLASSNAME, (String)"RENEW_SAME_FIRSTPARTY", (Locale)ctx.getLocale());
                        checkResult = false;
                    }
                    if (i == 2 && countNum > 0) {
                        if (!checkResult) {
                            errorPoint[i] = ResourceBase.getString((String)CONTRACT_RES_CLASSNAME, (String)"AND", (Locale)ctx.getLocale());
                        }
                        errorPoint[i] = (String)errorPoint[i] + ResourceBase.getString((String)CONTRACT_RES_CLASSNAME, (String)"RENEW_NOT_NONE_LIMITED", (Locale)ctx.getLocale());
                        checkResult = false;
                    }
                    ++i;
                }
                --i;
                if (!checkResult) {
                    errorPoint[i] = (String)errorPoint[i] + ResourceBase.getString((String)CONTRACT_RES_CLASSNAME, (String)"OF", (Locale)ctx.getLocale());
                }
                if (!checkResult) {
                    throw new ContractException(ContractException.PLS_SELECT_RIGHT_CONTRACT_TO_RENEW, errorPoint);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    public static void checkContractIsInOtherBill(Context ctx, EmployeeContractInfo ecInfo, String fromPage, int rowIndex) throws ContractException, BOSException, EASBizException {
        String hroId = null;
        Object[] params = new Object[3];
        HROrgUnitInfo hrOrgUnitInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        String oql = "where sourcecontract.id= '" + ecInfo.getId().toString() + "'";
        if (HRContractInfoFactory.getLocalInstance(ctx).exists(oql)) {
            HRContractInfoInfo hRContractInfo = HRContractInfoFactory.getLocalInstance(ctx).getHRContractInfoInfo(oql);
            if (hrOrgUnitInfo != null) {
                IRowSet rs;
                StringBuffer sql;
                hroId = hrOrgUnitInfo.getId().toString();
                if (!fromPage.endsWith(ContractRenewBizBill.class.getName())) {
                    sql = new StringBuffer("select cb.FNumber, cb.FID from T_HR_ContractRenewBizBillEntry ce ");
                    sql.append("inner join T_HR_ContractRenewBizBill cb on ce.FBillID = cb.FID where ce.FSourceContractId = (");
                    sql.append("select fid from T_HR_EmployeeContract where FContractNo = '");
                    sql.append(ecInfo.getContractNo());
                    sql.append("') and (cb.FBillState in (0, 1, 2, 3) ) ");
                    if (sql.length() > 0) {
                        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                        try {
                            if (rs.next()) {
                                params[0] = rs.getString(1);
                                params[1] = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.HRContractResource", (String)"label8", (Context)ctx);
                                params[2] = hRContractInfo.getContractNo();
                                throw new ContractException(ContractException.CONTRACT_ISOTHERBILL, params);
                            }
                        }
                        catch (SQLException e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                }
                if (!fromPage.equals(ContractChangeBizBill.class.getName())) {
                    sql = new StringBuffer("select cb.FNumber, cb.FID from T_HR_ContractChangeBillEntry ce ");
                    sql.append("inner join T_HR_ContractChangeBizBill cb on ce.FBillID = cb.FID where ce.FSourceContractId = (");
                    sql.append("select fid from T_HR_EmployeeContract where FContractNo = '");
                    sql.append(ecInfo.getContractNo());
                    sql.append("') and (cb.FBillState in (0, 1, 2, 3) )");
                    if (sql.length() > 0) {
                        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                        try {
                            if (rs.next()) {
                                params[0] = rs.getString(1);
                                params[1] = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.HRContractResource", (String)"label9", (Context)ctx);
                                params[2] = hRContractInfo.getContractNo();
                                throw new ContractException(ContractException.CONTRACT_ISOTHERBILL, params);
                            }
                        }
                        catch (SQLException e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                }
                if (!fromPage.equals(ContractEndBizBill.class.getName())) {
                    sql = new StringBuffer("select cb.FNumber, cb.FID from T_HR_ContractEndBizBillEntry ce ");
                    sql.append("inner join T_HR_ContractEndBizBill cb on ce.FBillID = cb.FID where ce.FContractNo = '");
                    sql.append(ecInfo.getContractNo());
                    sql.append("' and (cb.FBillState in (0, 1, 2, 3) )");
                    if (sql.length() > 0) {
                        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                        try {
                            if (rs.next()) {
                                params[0] = rs.getString(1);
                                params[1] = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.HRContractResource", (String)"label10", (Context)ctx);
                                params[2] = hRContractInfo.getContractNo();
                                throw new ContractException(ContractException.CONTRACT_ISOTHERBILL, params);
                            }
                        }
                        catch (SQLException e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                }
                if (!fromPage.equals(ContractFreeBizBill.class.getName())) {
                    sql = new StringBuffer("select cb.FNumber, cb.FID from T_HR_ContractFreeBizBillEntry ce ");
                    sql.append("inner join T_HR_ContractFreeBizBill cb on ce.FBillID = cb.FID where ce.FContractNo = '");
                    sql.append(ecInfo.getContractNo());
                    sql.append("' and (cb.FBillState in (0, 1, 2, 3))");
                    if (sql.length() > 0) {
                        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                        try {
                            if (rs.next()) {
                                params[0] = rs.getString(1);
                                params[1] = SHRServerResource.getString((String)"com.kingdee.eas.hr.contract.HRContractResource", (String)"label11", (Context)ctx);
                                params[2] = hRContractInfo.getContractNo();
                                throw new ContractException(ContractException.CONTRACT_ISOTHERBILL, params);
                            }
                        }
                        catch (SQLException e) {
                            throw new BOSException((Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public static void checkContractIsInOther(Context ctx, EmployeeContractInfo ecInfo) throws ContractException, BOSException, EASBizException {
        HROrgUnitInfo hrOrgUnitInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        String oql = "where sourcecontract.id= '" + ecInfo.getId().toString() + "'";
        if (EmployeeContractFactory.getLocalInstance((Context)ctx).exists(oql) && hrOrgUnitInfo != null) {
            String optType = null;
            if (ecInfo.getNewState().equals((Object)EmployeeContractNewStateEnum.CHANGED)) {
                optType = ResourceBase.getString((String)CONTRACT_RES_CLASSNAME, (String)CONTRACT_OPT_CHANGE, (Locale)ctx.getLocale());
            } else if (ecInfo.getNewState().equals((Object)EmployeeContractNewStateEnum.RESUMED)) {
                optType = ResourceBase.getString((String)CONTRACT_RES_CLASSNAME, (String)CONTRACT_OPT_RENEW, (Locale)ctx.getLocale());
            }
            throw new ContractException(ContractException.CONTRACT_ISOTHERCITED, new Object[]{ecInfo.getContractNo(), optType});
        }
    }

    public static void deleteEmployeeContractInfo(Context ctx, String id) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)id)) {
            EmployeeContractFactory.getLocalInstance((Context)ctx).delete("where id = '" + id + "'");
        }
    }

    public static void checkContractIsEleSignPro(Context ctx, EmployeeContractInfo contractInfo) throws EASBizException, BOSException {
        EmpEleContractSignRecordCollection recordCollection = EmpEleContractSignRecordFactory.getLocalInstance(ctx).getEmpEleContractSignRecordCollection("select fid, isInvalid, signStatus where contract.id= '" + contractInfo.getId().toString() + "'");
        for (int i = 0; i < recordCollection.size(); ++i) {
            EmpEleContractSignRecordInfo recordInfo = recordCollection.get(i);
            if (contractInfo.getSignStatus() == EContractSignState.uninitiated || recordInfo.getSignStatus() == EContractSignState.uninitiated || recordInfo.isIsInvalid()) continue;
            throw new ContractException(ContractException.CONTRACT_CANNOT_DELETE, new Object[]{recordInfo.getEContractNO()});
        }
    }

    public static void deleteEmpEleContractSignRecordInfo(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        IEmpEleContractSignRecord contractSignRecordInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordCollection recordCollection = contractSignRecordInstance.getEmpEleContractSignRecordCollection("where contract.id= '" + contractInfo.getId().toString() + "'");
        for (int i = 0; i < recordCollection.size(); ++i) {
            EmpEleContractSignRecordInfo recordInfo = recordCollection.get(i);
            ContractUtils.checkWhetherdeleteEmpEleContractSignRecordInfo(ctx, recordInfo);
            EmpEleContractDelLogInfo logInfo = new EmpEleContractDelLogInfo();
            logInfo.setEContractNo(recordInfo.getEContractNO());
            logInfo.setEmpName(contractInfo.getEmployee().getName(com.kingdee.util.LocaleUtils.locale_l1), com.kingdee.util.LocaleUtils.locale_l1);
            logInfo.setEmpName(contractInfo.getEmployee().getName(com.kingdee.util.LocaleUtils.locale_l2), com.kingdee.util.LocaleUtils.locale_l2);
            logInfo.setEmpName(contractInfo.getEmployee().getName(com.kingdee.util.LocaleUtils.locale_l3), com.kingdee.util.LocaleUtils.locale_l3);
            logInfo.setEmpNum(contractInfo.getEmployee().getNumber());
            logInfo.setIdCardNO(contractInfo.getEmployee().getIdCardNO());
            logInfo.setPassportNO(contractInfo.getEmployee().getPassportNO());
            logInfo.setCreator(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            logInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            logInfo.setCreateTime(HRUtilExtend.getCurTimestamp());
            logInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            EmpEleContractDelLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)logInfo);
        }
        EmpElectronicContractUtilsEx.deleteEmpEleContractSignRecordInfo(contractSignRecordInstance, contractInfo.getId().toString());
    }

    public static void checkWhetherdeleteEmpEleContractSignRecordInfo(Context ctx, EmpEleContractSignRecordInfo empEleContractSignRecordInfo) throws ContractException {
        int signStatusValue;
        EContractSignState signStatus = empEleContractSignRecordInfo.getSignStatus();
        int n = signStatusValue = signStatus != null ? signStatus.getValue() : -999;
        if (!empEleContractSignRecordInfo.isIsInvalid() && -1 != signStatusValue) {
            throw new ContractException(ContractException.CONTRACTBIZBILL_CANNOT_UNTICHECK_BY_EMPELECONTRACT, new Object[]{empEleContractSignRecordInfo.getEContractNO()});
        }
    }

    public static void deleteEmpEleContractRelatedTable(Context ctx, EmployeeContractInfo contractInfo) throws BOSException, EASBizException {
        IEmpEleContractSignRecord contractSignRecordInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordCollection recordCollection = contractSignRecordInstance.getEmpEleContractSignRecordCollection("where contract.id= '" + contractInfo.getId().toString() + "'");
        for (int i = 0; i < recordCollection.size(); ++i) {
            EmpEleContractSignRecordInfo recordInfo = recordCollection.get(i);
            EmpEleContractDelLogInfo logInfo = new EmpEleContractDelLogInfo();
            logInfo.setEContractNo(recordInfo.getEContractNO());
            logInfo.setEmpName(contractInfo.getEmployee().getName(com.kingdee.util.LocaleUtils.locale_l1), com.kingdee.util.LocaleUtils.locale_l1);
            logInfo.setEmpName(contractInfo.getEmployee().getName(com.kingdee.util.LocaleUtils.locale_l2), com.kingdee.util.LocaleUtils.locale_l2);
            logInfo.setEmpName(contractInfo.getEmployee().getName(com.kingdee.util.LocaleUtils.locale_l3), com.kingdee.util.LocaleUtils.locale_l3);
            logInfo.setEmpNum(contractInfo.getEmployee().getNumber());
            logInfo.setIdCardNO(contractInfo.getEmployee().getIdCardNO());
            logInfo.setPassportNO(contractInfo.getEmployee().getPassportNO());
            logInfo.setCreator(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            logInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            logInfo.setCreateTime(HRUtilExtend.getCurTimestamp());
            logInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            EmpEleContractDelLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)logInfo);
        }
        EmpElectronicContractUtilsEx.deleteEmpEleContractSignRecordInfo(contractSignRecordInstance, contractInfo.getId().toString());
        EmpElectronicContractUtilsEx.deleteContractBillMiddleInfo(ctx, contractInfo.getId().toString());
    }

    public static void deleteEmpOtherEleContractRelatedTable(Context ctx, EmployeeOtherContractInfo employeeOtherContract) throws BOSException, EASBizException {
        IEmpOtherEleContractSignRecord contractOtherSignRecordInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpOtherEleContractSignRecordCollection otherContrctRecordCollection = contractOtherSignRecordInstance.getEmpOtherEleContractSignRecordCollection("where contract.id= '" + employeeOtherContract.getId().toString() + "'");
        for (int i = 0; i < otherContrctRecordCollection.size(); ++i) {
            EmpOtherEleContractSignRecordInfo recordInfo = otherContrctRecordCollection.get(i);
            EmpEleContractDelLogInfo logInfo = new EmpEleContractDelLogInfo();
            logInfo.setEContractNo(recordInfo.getEContractNO());
            logInfo.setEmpName(employeeOtherContract.getEmployee().getName(com.kingdee.util.LocaleUtils.locale_l1), com.kingdee.util.LocaleUtils.locale_l1);
            logInfo.setEmpName(employeeOtherContract.getEmployee().getName(com.kingdee.util.LocaleUtils.locale_l2), com.kingdee.util.LocaleUtils.locale_l2);
            logInfo.setEmpName(employeeOtherContract.getEmployee().getName(com.kingdee.util.LocaleUtils.locale_l3), com.kingdee.util.LocaleUtils.locale_l3);
            logInfo.setEmpNum(employeeOtherContract.getEmployee().getNumber());
            logInfo.setIdCardNO(employeeOtherContract.getEmployee().getIdCardNO());
            logInfo.setPassportNO(employeeOtherContract.getEmployee().getPassportNO());
            logInfo.setCreator(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            logInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            logInfo.setCreateTime(HRUtilExtend.getCurTimestamp());
            logInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            EmpEleContractDelLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)logInfo);
        }
        EmpElectronicOtherContractUtilsEx.deleteEmpEleContractSignRecordInfo(contractOtherSignRecordInstance, employeeOtherContract.getId().toString());
        EmpElectronicContractUtilsEx.deleteContractBillMiddleInfo(ctx, employeeOtherContract.getId().toString());
    }

    public static void deleteContractBillMiddle(Context ctx, EmployeeOtherContractInfo employeeOtherContract) throws BOSException, EASBizException {
        IContractBillMiddle contractBillMiddleInstance = ContractBillMiddleFactory.getLocalInstance(ctx);
        EmpElectronicOtherContractUtilsEx.deleteContractBillMiddle(contractBillMiddleInstance, employeeOtherContract.getId().toString());
    }

    public static void setEmpContractInfo(Context ctx, EmployeeContractInfo contractInfo) throws EASBizException, BOSException {
        ContractTempletInfo contractTempletInfo;
        if (contractInfo.getContractTemplet() != null && contractInfo.getContractTemplet().getId() != null && (contractTempletInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(contractInfo.getContractTemplet().getId()))) != null) {
            boolean isElectronicSign = contractTempletInfo.isIsElectronicSign();
            contractInfo.setIsElectronicSign(false);
            contractInfo.setContractClassify(isElectronicSign ? ContractClassifyEnum.ElectronicEmp : ContractClassifyEnum.Normal);
        }
        contractInfo.setSignStatus(EContractSignState.uninitiated);
    }

    public static void checkPersonHasInPreSignBill(Context ctx, PersonInfo person) throws EASBizException, BOSException {
        ContractUtils.checkPersonHasInPreSignBill(ctx, person.getId().toString());
    }

    public static void checkPersonHasInPreSignBill(Context ctx, String personId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("realPersonId"));
        coll.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("realPersonId", (Object)personId));
        view.setFilter(filter);
        view.setSelector(coll);
        PreEntryPersonCollection personCollection = PreEntryPersonFactory.getLocalInstance((Context)ctx).getPreEntryPersonCollection(view);
        if (personCollection != null && personCollection.size() > 0) {
            PreEntryPersonInfo entryPersonInfo = personCollection.get(0);
            view = new EntityViewInfo();
            coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("id"));
            coll.add(new SelectorItemInfo("bill.id"));
            coll.add(new SelectorItemInfo("bill.number"));
            coll.add(new SelectorItemInfo("bill.billState"));
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)entryPersonInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)0));
            filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)2));
            filter.setMaskString("#0 AND (#1 OR #2 OR #3)");
            view.setFilter(filter);
            view.setSelector(coll);
            ContractPreSignBizBillEntryCollection collection = ContractPreSignBizBillEntryFactory.getLocalInstance(ctx).getContractPreSignBizBillEntryCollection(view);
            if (collection != null && collection.size() > 0) {
                ContractPreSignBizBillInfo bill = collection.get(0).getBill();
                throw new ContractBizException(ContractBizException.PERSON_HASING_PRESIGNBILL, new Object[]{bill.getNumber()});
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("preEntryPerson.id", (Object)entryPersonInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)0));
            filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)2));
            filter.setMaskString("#0 AND (#1 OR #2 OR #3)");
            view.setFilter(filter);
            ContractPreNewSignBizBillEntryCollection preNewSignBizBillEntryCollection = ContractPreNewSignBizBillEntryFactory.getLocalInstance(ctx).getContractPreNewSignBizBillEntryCollection(view);
            if (preNewSignBizBillEntryCollection != null && preNewSignBizBillEntryCollection.size() > 0) {
                ContractPreNewSignBizBillInfo bill = preNewSignBizBillEntryCollection.get(0).getBill();
                throw new ContractBizException(ContractBizException.PERSON_HASING_PRESIGNBILL, new Object[]{bill.getNumber()});
            }
        }
    }

    public static String getPersonInfo(Context ctx, String personId) throws EASBizException, BOSException {
        String personParm = "";
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("number"));
        coll.add(new SelectorItemInfo("name"));
        PersonInfo personInfo = null;
        BOSObjectType bosType = BOSUuid.read((String)personId).getType();
        if (bosType.toString().equals("80EF7DED")) {
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId), coll);
        }
        if (personInfo == null) {
            PreEntryPersonInfo prePersonInfo = PreEntryPersonFactory.getLocalInstance((Context)ctx).getPreEntryPersonInfo((IObjectPK)new ObjectUuidPK(personId), coll);
            personParm = prePersonInfo.getName();
        } else {
            personParm = personInfo.getNumber() + "_" + personInfo.getName();
        }
        return personParm;
    }

    public static ContractTempletCollection getAvailableContractTemplateColls(Context ctx, String hrOrgUnitIds, String permItemId, FilterInfo filter, SelectorItemCollection selector) throws EASBizException, BOSException {
        String entityName = CONTRACT_TEMPLET_ENTITYNAME;
        BaseItemParam param = ContractUtils.getBaseItemParam(null, entityName, hrOrgUnitIds, permItemId);
        String filterSql = SHRBaseItemApi.queryAvailableRelationBaseSql((Context)ctx, (BaseItemParam)param, (boolean)Boolean.TRUE);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)filterSql, CompareType.INNER));
        filterInfo.mergeFilter(filter, "AND");
        if (selector == null) {
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        view.setSelector(selector);
        return ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletCollection(view);
    }

    public static ContractTypeCollection getAvailableContractTypeColls(Context ctx, String hrOrgUnitIds, String permItemId, FilterInfo filter, SelectorItemCollection selector) throws EASBizException, BOSException {
        String entityName = "com.kingdee.eas.hr.emp.app.ContractType";
        BaseItemParam param = ContractUtils.getBaseItemParam(null, entityName, hrOrgUnitIds, permItemId);
        String filterSql = SHRBaseItemApi.queryAvailableRelationBaseSql((Context)ctx, (BaseItemParam)param, (boolean)Boolean.TRUE);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)filterSql, CompareType.INNER));
        filterInfo.mergeFilter(filter, "AND");
        if (selector == null) {
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        view.setSelector(selector);
        return ContractTypeFactory.getLocalInstance((Context)ctx).getContractTypeCollection(view);
    }

    public static BaseItemParam getBaseItemParam(String realEntityName, String entityName, String hrOrgUnitIds, String permItemId) {
        BaseItemParam param = new BaseItemParam();
        param.setEntityName(entityName);
        param.setRealEntityName(realEntityName);
        param.setHrOrgUnitIds(hrOrgUnitIds);
        param.setPermItemId(permItemId);
        param.setRespBaseItemId(Boolean.TRUE.booleanValue());
        param.setRelationStates("100");
        return param;
    }

    public static void processPersonContractStateWithEnrollAgain(Context ctx, String personId) throws BOSException, EASBizException {
        EmployeeContractInfo employeeContractInfo;
        EmployeeContractState state;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("employee.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("effectDate", (Object)new Date(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("contractTemplet.contractType.isLaborContract", (Object)true));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("effectDate"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("newState"));
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("effectDate");
        sorter.setSortType(SortType.DESCEND);
        sorters.add(sorter);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(selector);
        view.setSorter(sorters);
        EmployeeContractCollection collection = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(view);
        if (collection.size() > 0 && ((state = (employeeContractInfo = collection.get(0)).getState()) == EmployeeContractState.END || state == EmployeeContractState.FREE)) {
            PersonContractPageInfoInfo contractPageInfoInfo;
            PersonContractState hasSignContract;
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
            view.setFilter(filter);
            IPersonContractPageInfo iPersonContractPageInfo = PersonContractPageInfoFactory.getLocalInstance(ctx);
            PersonContractPageInfoCollection pageCollection = iPersonContractPageInfo.getPersonContractPageInfoCollection(view);
            if (pageCollection.size() > 0 && PersonContractState.notSign != (hasSignContract = (contractPageInfoInfo = pageCollection.get(0)).getHasSignContract())) {
                contractPageInfoInfo.setHasSignContract(PersonContractState.notSign);
                selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("hasSignContract"));
                iPersonContractPageInfo.updatePartial(contractPageInfoInfo, selector);
            }
        }
    }

    public static Date getEndDate(Date bizDate, int contractLimit) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(bizDate);
        cal.add(1, contractLimit);
        return cal.getTime();
    }

    public static Object getEnumValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Enum) {
            if (obj instanceof StringEnum) {
                return ((StringEnum)obj).getValue();
            }
            if (obj instanceof IntEnum) {
                return ((IntEnum)obj).getValue();
            }
            if (obj instanceof DoubleEnum) {
                return ((DoubleEnum)obj).getValue();
            }
            if (obj instanceof FloatEnum) {
                return Float.valueOf(((FloatEnum)obj).getValue());
            }
            if (obj instanceof LongEnum) {
                return ((LongEnum)obj).getValue();
            }
            if (obj instanceof DynamicEnum) {
                return ((DynamicEnum)obj).getValue();
            }
        }
        return obj;
    }
}

