/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.basedata.hraux.EmployeeEntityPropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.EmployeePageInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class DynamicColumnToXmlHelper {
    public static String convertListToXML(Context ctx, CoreBaseInfo info, ArrayList propertyList) throws BOSException, EASBizException {
        Document doc = new Document();
        Element root = new Element("ui");
        doc.setRootElement(root);
        Element fieldList = new Element("fieldList");
        root.addContent((Content)fieldList);
        String sql = "SELECT FEntityName,FEntityInfoName,FType,FQueryInfo,FSelector FROM T_HR_F7Info";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        EmployeeEntityPropertyInfo epInfo = null;
        EntityObjectInfo entityInfo = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        HashMap entityMap = new HashMap();
        int size = propertyList.size();
        for (int i = 0; i < size; ++i) {
            epInfo = (EmployeeEntityPropertyInfo)propertyList.get(i);
            Element field = new Element("field");
            field.addContent((Content)new Element("name").setText(epInfo.getPropertyName()));
            field.addContent((Content)new Element("displayName").setText(epInfo.getPropertyAlias()));
            field.addContent((Content)new Element("entityName").setText(epInfo.getEntityName()));
            field.addContent((Content)new Element("entityDisplayName").setText(epInfo.getEntityAlias()));
            field.addContent((Content)new Element("notNull").setText(Boolean.toString(epInfo.isNotNull())));
            field.addContent((Content)new Element("enable").setText(Boolean.toString(epInfo.isEnable())));
            field.addContent((Content)new Element("notClear").setText(Boolean.toString(epInfo.isNotClear())));
            if (epInfo.isSystemProperty()) {
                field.addContent((Content)new Element("systemProperty").setText(Boolean.toString(epInfo.isSystemProperty())));
            }
            Element dataType = new Element("dataType");
            field.addContent((Content)dataType);
            entityInfo = entityMap.get(epInfo.getEntityName()) == null ? loader.getEntity((IMetaDataPK)new MetaDataPK(epInfo.getEntityName())) : (EntityObjectInfo)entityMap.get(epInfo.getEntityName());
            PropertyInfo propertyInfo = entityInfo.getPropertyByName(epInfo.getPropertyName());
            if (propertyInfo instanceof OwnPropertyInfo) {
                dataType.addContent((Content)new Element("name").setText(((OwnPropertyInfo)propertyInfo).getDataType().getName()));
                if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.STRING)) {
                    int stringLength = ((OwnPropertyInfo)propertyInfo).getMappingField().getLength();
                    dataType.addContent((Content)new Element("length").setText(Integer.toString(stringLength)));
                    if (((OwnPropertyInfo)propertyInfo).isMultilingual()) {
                        dataType.addContent((Content)new Element("isMultiLang").setText(String.valueOf(((OwnPropertyInfo)propertyInfo).isMultilingual())));
                    }
                } else if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.ENUM)) {
                    dataType.addContent((Content)new Element("enumName").setText(((OwnPropertyInfo)propertyInfo).getEnumType().getFullName()));
                }
            }
            if (propertyInfo instanceof LinkPropertyInfo) {
                DynamicColumnToXmlHelper.addF7Info(dataType, rows, ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject());
            }
            fieldList.addContent((Content)field);
        }
        if (info.get("DISPLAYTYPE") != null) {
            Element displayTypeElement = new Element("displayType");
            displayTypeElement.setText(((Boolean)info.get("DISPLAYTYPE")).toString());
            root.addContent((Content)displayTypeElement);
        }
        if (info.get("MultiLinePage_List") != null) {
            ArrayList pageList = (ArrayList)info.get("MultiLinePage_List");
            EmployeePageInfo pageInfo = null;
            Element pageListElement = new Element("pageList");
            root.addContent((Content)pageListElement);
            Element pageInfoElement = null;
            int size2 = pageList.size();
            for (int i = 0; i < size2; ++i) {
                pageInfo = (EmployeePageInfo)pageList.get(i);
                pageInfoElement = new Element("pageInfo");
                pageInfoElement.addContent((Content)new Element("id").setText(pageInfo.getId().toString()));
                pageInfoElement.addContent((Content)new Element("name").setText(pageInfo.getName()));
                pageInfoElement.addContent((Content)new Element("canAdd").setText(((Boolean)pageInfo.get("CANADD")).toString()));
                pageInfoElement.addContent((Content)new Element("canView").setText(((Boolean)pageInfo.get("CANVIEW")).toString()));
                pageInfoElement.addContent((Content)new Element("canEdit").setText(((Boolean)pageInfo.get("CANEDIT")).toString()));
                pageInfoElement.addContent((Content)new Element("canDelete").setText(((Boolean)pageInfo.get("CANDELETE")).toString()));
                pageInfoElement.addContent((Content)new Element("displayHeight").setText(((Integer)pageInfo.get("DISPLAYHEIGHT")).toString()));
                pageListElement.addContent((Content)pageInfoElement);
            }
        }
        return null;
    }

    protected static void addF7Info(Element dataType, IRowSet rows, EntityObjectInfo entityObjectInfo) throws BOSException, EASBizException {
        try {
            String defaultF7Query;
            rows.beforeFirst();
            boolean hasF7Info = false;
            String entityName = entityObjectInfo.getFullName();
            while (rows.next()) {
                if (!rows.getString("FEntityName").equals(entityName)) continue;
                if (rows.getInt("FType") == 0) {
                    dataType.addContent((Content)new Element("name").setText("CommonF7"));
                } else {
                    dataType.addContent((Content)new Element("name").setText("CustomF7"));
                    dataType.addContent((Content)new Element("selector").setText(rows.getString("FSelector")));
                }
                dataType.addContent((Content)new Element("queryInfo").setText(rows.getString("FQueryInfo")));
                dataType.addContent((Content)new Element("refEntity").setText(rows.getString("FEntityInfoName")));
                hasF7Info = true;
                break;
            }
            if (!hasF7Info && (defaultF7Query = entityObjectInfo.getExtendedProperty("defaultF7Query")) != null) {
                dataType.addContent((Content)new Element("name").setText("CommonF7"));
                dataType.addContent((Content)new Element("refEntity").setText(entityObjectInfo.getObjectValueClass()));
                dataType.addContent((Content)new Element("queryInfo").setText(defaultF7Query));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

