/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOUPartAdmin;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OUPartAdminFactory;
import com.kingdee.eas.basedata.org.OUPartAdminInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.ICodingRuleManageFacade;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.PersonPhotoCollection;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.app.AbstractEmpRpcFacadeControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EmpRpcFacadeControllerBean
extends AbstractEmpRpcFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpRpcFacadeControllerBean");

    @Override
    protected Map _getPerPhotoAndCodManage(Context ctx, IObjectValue personInfo) throws BOSException, EASBizException {
        HashMap<String, Object> perPhotoAndCodMngMap = new HashMap<String, Object>();
        PersonInfo person = (PersonInfo)personInfo;
        IPersonPhoto iPhoto = PersonPhotoFactory.getLocalInstance(ctx);
        PersonPhotoCollection ppColl = iPhoto.getPersonPhotoCollection(" select imageData where person='" + person.getId() + "'");
        perPhotoAndCodMngMap.put("personPhotoCollection", (Object)ppColl);
        ICodingRuleManageFacade icrm = CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx);
        perPhotoAndCodMngMap.put("codRuleModifable", icrm.isModifiable((IObjectValue)person, null));
        return perPhotoAndCodMngMap;
    }

    @Override
    protected void _checkAdminIsSealupByPosition(Context ctx, String positionId) throws BOSException, EASBizException {
        IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
        PositionInfo info = iPosition.getPositionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)positionId)));
        IFullOrgUnit iFull = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo fullInfo = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getAdminOrgUnit().getId().toString())));
        IOUPartAdmin iOUPartAdmin = OUPartAdminFactory.getLocalInstance((Context)ctx);
        OUPartAdminInfo partAdminInfo = iOUPartAdmin.getOUPartAdminInfo((IObjectPK)new ObjectUuidPK(fullInfo.getPartAdmin().getId()));
        if (partAdminInfo.isIsSealUp()) {
            Object[] param = new Object[]{fullInfo.getName()};
            throw new BaseException(BaseException.ADMIN_IS_SEALUP, param);
        }
    }

    @Override
    protected Map _getPersonPositionsInReport(Context ctx, Set personIdSet, Map queryParams) throws BOSException, EASBizException {
        HashMap<String, Map> personPositionMap = new HashMap<String, Map>();
        IMetaDataPK mainQueryPk = (IMetaDataPK)queryParams.get("mainQueryPK");
        EntityViewInfo mainQuery = (EntityViewInfo)queryParams.get("mainQuery");
        if (mainQueryPk != null && mainQuery != null) {
            try {
                Map personSeemlyPositionMap = this.getPersonSeemlyPositionsMap(ctx, personIdSet, mainQueryPk, mainQuery);
                personPositionMap.put("personSeemlyPositionMap", personSeemlyPositionMap);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        Map personAllPositionsMap = this.getPersonAllPositionsMap(ctx, personIdSet);
        personPositionMap.put("personAllPositionsMap", personAllPositionsMap);
        return personPositionMap;
    }

    private Map getPersonAllPositionsMap(Context ctx, Set personIdSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("position.name"));
        view.setSelector(selectors);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo psort = new SorterItemInfo("isPrimary");
        psort.setSortType(SortType.DESCEND);
        sorter.add(psort);
        sorter.add(new SorterItemInfo("position.adminOrgUnit.longNumber"));
        view.setSorter(sorter);
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection col = iPositionMember.getPositionMemberCollection(view);
        HashMap<String, String> personAllPositionsMap = new HashMap<String, String>();
        for (int i = 0; i < col.size(); ++i) {
            PositionMemberInfo pm = col.get(i);
            String personId = pm.getPerson().getId().toString();
            String positionNames = (String)personAllPositionsMap.get(personId);
            positionNames = positionNames == null ? "" : positionNames + ";";
            positionNames = positionNames + pm.getPosition().getName();
            personAllPositionsMap.put(personId, positionNames);
        }
        return personAllPositionsMap;
    }

    private Map getPersonSeemlyPositionsMap(Context ctx, Set personIdSet, IMetaDataPK mainQueryPk, EntityViewInfo mainQuery) throws Exception {
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPk);
        EntityViewInfo entityView = (EntityViewInfo)mainQuery.clone();
        SelectorItemCollection selector = entityView.getSelector();
        selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("Position.name"));
        selector.add(new SelectorItemInfo("AdminOrgUnit.level"));
        selector.add(new SelectorItemInfo("AdminOrgUnit.displayName"));
        selector.add(new SelectorItemInfo("PositionMember.isPrimary"));
        selector.add(new SelectorItemInfo("PositionType.name"));
        entityView.setSelector(selector);
        entityView.setSorter(null);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personIdSet, CompareType.INCLUDE));
        FilterInfo entityFilter = entityView.getFilter();
        if (entityFilter == null) {
            entityFilter = filter;
        } else {
            entityFilter.mergeFilter(filter, "and");
        }
        entityView.setFilter(entityFilter);
        queryExcu.setObjectView(entityView);
        IRowSet rs = queryExcu.executeQuery();
        HashMap personSeemlyPositionMap = new HashMap();
        while (rs.next()) {
            String personId = rs.getString("id");
            HashMap<String, String> positionMap = new HashMap<String, String>();
            positionMap.put("Position.name", rs.getString("Position.name"));
            positionMap.put("AdminOrgUnit.level", rs.getString("AdminOrgUnit.level"));
            positionMap.put("AdminOrgUnit.displayName", rs.getString("AdminOrgUnit.displayName"));
            positionMap.put("PositionType.name", rs.getString("PositionType.name"));
            if (personSeemlyPositionMap.get(personId) != null && !rs.getBoolean("PositionMember.isPrimary")) continue;
            personSeemlyPositionMap.put(personId, positionMap);
        }
        return personSeemlyPositionMap;
    }

    @Override
    protected Map _getEmpMainListParam(Context ctx, String hrOrgId) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String clientName = AffairUtil.getCurrentClientName((Context)ctx);
        paramMap.put("clientName", clientName);
        boolean showPerson = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AdminOrgOrHROrg_ShowPerson", (String)hrOrgId);
        paramMap.put("IS_AdminOrgOrHROrg_ShowPerson", showPerson);
        return paramMap;
    }
}

