/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.emp.EmployeeHistoryCollection;
import com.kingdee.eas.hr.emp.EmployeeHistoryInfo;
import com.kingdee.eas.hr.emp.app.AbstractEmployeeHistoryControllerBean;
import com.kingdee.util.enums.EnumUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class EmployeeHistoryControllerBean
extends AbstractEmployeeHistoryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmployeeHistoryControllerBean");

    @Override
    protected void _saveEmployeeHistory(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        PropertyCollection pc = this.getSaveProperties(ctx, model);
        PropertyInfo property = null;
        int size = pc.size();
        for (int i = 0; i < size; ++i) {
            property = pc.get(i);
            this.saveProperty(ctx, model, property, loader.getEntity(model.getBOSType()).getFullName());
            logger.debug((Object)(loader.getEntity(model.getBOSType()).getName() + "   " + property.getName()));
        }
    }

    private String getEnumAlias(Object value, String enumName) throws BOSException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            try {
                return EnumUtils.getEnum(Class.forName(enumName), (int)((Integer)value)).getAlias();
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
        }
        try {
            return EnumUtils.getEnum(Class.forName(enumName), (String)value.toString()).getAlias();
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void saveProperty(Context ctx, IObjectValue model, PropertyInfo property, String entityName) throws BOSException, EASBizException {
        String personId = null;
        personId = model instanceof PersonInfo ? ((PersonInfo)model).getId().toString() : ((PersonInfo)model.get("person")).getId().toString();
        String oql = "select * where entity = '" + entityName + "' and property = '" + property.getName() + "' and personId = '" + personId + "' and beginTime is not null and endTime is null";
        EmployeeHistoryCollection ec = this.getEmployeeHistoryCollection(ctx, oql);
        EmployeeHistoryInfo oldInfo = null;
        Date date = new Date();
        Object obj = null;
        if (ec.size() == 0) {
            EmployeeHistoryInfo info = new EmployeeHistoryInfo();
            info.setPersonId(personId);
            info.setBeginTime(new Timestamp(date.getTime()));
            info.setType(this.getHisPropertyType(property));
            info.setProperty(property.getName());
            info.setEntity(entityName);
            if (info.getType().equals("ENUM")) {
                obj = model.get(property.getName());
                if (obj != null) {
                    info.setValueString(obj.toString());
                }
                info.setRefEnum(property.get("metadataRef").toString());
                info.setAlias(this.getEnumAlias(obj, info.getRefEnum()));
            } else if (info.getType().equals("REF")) {
                LinkPropertyInfo lproperty = (LinkPropertyInfo)property;
                info.setRefEntity(lproperty.getRelationship().getSupplierObject().getName());
                info.setRefTable(lproperty.getRelationship().getSupplierObject().getTable().getName());
                info.setRefProperty(lproperty.getRelationship().getSupplierProperty().getName());
                info.setRefField(lproperty.getRelationship().getSupplierProperty().getMappingField().getName());
                obj = model.get(property.getName());
                if (obj == null) {
                    info.setValueString(null);
                    info.setAlias(null);
                } else {
                    info.setValueString(((IObjectValue)obj).get("id").toString());
                    if (obj instanceof DataBaseInfo) {
                        info.setAlias(((DataBaseInfo)obj).getName());
                    } else {
                        info.setAlias(obj.toString());
                    }
                }
            } else if (model.get(property.getName()) != null) {
                obj = model.get(property.getName());
                if (info.getType().equals("DATE")) {
                    info.setValueString(String.valueOf(((Date)obj).getTime()));
                    info.setAlias(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format((Date)obj));
                } else if (info.getType().equals("TIMESTAMP")) {
                    info.setValueString(String.valueOf(((Timestamp)obj).getTime()));
                    info.setAlias(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date(((Timestamp)obj).getTime())));
                } else {
                    info.setValueString(obj.toString());
                    info.setAlias(obj.toString());
                }
            }
            this._addnew(ctx, (IObjectValue)info);
        } else {
            oldInfo = ec.get(0);
            if (!this.equals(oldInfo, model)) {
                oldInfo.setEndTime(new Timestamp(date.getTime()));
                this._update(ctx, (IObjectPK)new ObjectUuidPK(oldInfo.getId()), (IObjectValue)oldInfo);
                EmployeeHistoryInfo info = new EmployeeHistoryInfo();
                info.setEntity(oldInfo.getEntity());
                info.setProperty(oldInfo.getProperty());
                info.setType(oldInfo.getType());
                info.setRefEntity(oldInfo.getRefEntity());
                info.setRefTable(oldInfo.getRefTable());
                info.setRefProperty(oldInfo.getRefProperty());
                info.setRefField(oldInfo.getRefField());
                info.setBeginTime(oldInfo.getEndTime());
                info.setPersonId(oldInfo.getPersonId());
                if (info.getType().equals("REF")) {
                    obj = model.get(property.getName());
                    if (obj == null) {
                        info.setValueString(null);
                        info.setAlias(null);
                    } else {
                        info.setValueString(((IObjectValue)obj).get("id").toString());
                        if (obj instanceof DataBaseInfo) {
                            info.setAlias(((DataBaseInfo)obj).getName());
                        } else {
                            info.setAlias(obj.toString());
                        }
                    }
                } else if (info.getType().equals("ENUM")) {
                    obj = model.get(property.getName());
                    if (obj != null) {
                        info.setValueString(obj.toString());
                    }
                    info.setRefEnum(property.get("metadataRef").toString());
                    info.setAlias(this.getEnumAlias(obj, info.getRefEnum()));
                } else if (model.get(property.getName()) != null) {
                    obj = model.get(property.getName());
                    if (info.getType().equals("DATE")) {
                        info.setValueString(String.valueOf(((Date)obj).getTime()));
                        info.setAlias(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format((Date)obj));
                    } else if (info.getType().equals("TIMESTAMP")) {
                        info.setValueString(String.valueOf(((Timestamp)obj).getTime()));
                        info.setAlias(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date(((Timestamp)obj).getTime())));
                    } else {
                        info.setValueString(obj.toString());
                        info.setAlias(obj.toString());
                    }
                }
                this._addnew(ctx, (IObjectValue)info);
            }
        }
    }

    private boolean equals(EmployeeHistoryInfo empInfo, IObjectValue model) {
        String obj1 = empInfo.getValueString();
        String name = empInfo.getProperty();
        Object obj2 = model.get(name);
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null && obj2 != null) {
            if (empInfo.getType().equals("REF")) {
                obj2 = ((IObjectValue)obj2).get("id").toString();
            } else if (empInfo.getType().equals("DATE")) {
                obj2 = String.valueOf(((Date)obj2).getTime());
            } else if (empInfo.getType().equals("TIMESTAMP")) {
                obj2 = String.valueOf(((Timestamp)obj2).getTime());
            }
            if (obj1.toString().equals(obj2.toString())) {
                return true;
            }
        } else {
            if (obj1 == null && obj2 != null && obj2.toString().equals("")) {
                return true;
            }
            if (obj2 == null && obj1 != null && obj1.toString().equals("")) {
                return true;
            }
        }
        return false;
    }

    private String getHisPropertyType(PropertyInfo property) {
        if (property instanceof OwnPropertyInfo) {
            OwnPropertyInfo oproperty = (OwnPropertyInfo)property;
            DataType dataType = oproperty.getDataType();
            if (dataType.equals((Object)DataType.BOOLEAN)) {
                return "BOOLEAN";
            }
            if (dataType.equals((Object)DataType.INTEGER)) {
                return "INT";
            }
            if (dataType.equals((Object)DataType.FLOAT)) {
                return "FLOAT";
            }
            if (dataType.equals((Object)DataType.DOUBLE)) {
                return "DOUBLE";
            }
            if (dataType.equals((Object)DataType.DECIMAL)) {
                return "DECIMAL";
            }
            if (dataType.equals((Object)DataType.DATE)) {
                return "DATE";
            }
            if (dataType.equals((Object)DataType.TIMESTAMP)) {
                return "TIMESTAMP";
            }
            if (dataType.equals((Object)DataType.STRING)) {
                return "STRING";
            }
            if (dataType.equals((Object)DataType.ENUM)) {
                return "ENUM";
            }
            return "STRING";
        }
        return "REF";
    }

    private PropertyCollection getSaveProperties(Context ctx, IObjectValue model) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        PropertyCollection pc = loader.getEntity(model.getBOSType()).getEntityProperties();
        return pc;
    }
}

