/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.app.AbstractHREmpRptFormulaFacadeControllerBean;
import com.kingdee.eas.hr.org.Period;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class HREmpRptFormulaFacadeControllerBean
extends AbstractHREmpRptFormulaFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.HREmpRptFormulaFacadeControllerBean");
    private static final String MONTH = "month";
    private static final String QUARTER = "quarter";
    private static final String YEAR = "year";

    private HashMap getInitHashMap() {
        HashMap<String, String[]> hs = new HashMap<String, String[]>();
        hs.put("EMPRELATE", new String[]{"left", "T_HR_EmpOrgRelation", "EMPRELATE.FPersonID", "PERSON.FID"});
        hs.put("REASON", new String[]{"left", "T_HR_AffairActionReason", "EMPRELATE.FActionReasonID", "REASON.FID"});
        hs.put("POSTATE", new String[]{"left", "T_HR_PositionState", "EMPRELATE.FPositionstateID", "POSTATE.FID"});
        hs.put("PERSONPOSITION", new String[]{"left", "T_HR_PersonPosition", "PERSONPOSITION.FPersonID", "PERSON.FID"});
        hs.put("POSITION", new String[]{"left", "T_ORG_Position", "POSITION.Fid", "PERSONPOSITION.Fprimarypositionid"});
        hs.put("JOB", new String[]{"left", "T_ORG_Job", "JOB.FID", "POSITION.FJobID"});
        hs.put("JOBCATEGORY", new String[]{"left", "T_ORG_JobCategory", "JOB.FJobCategoryID", "JOBCATEGORY.FID"});
        hs.put("FOLK", new String[]{"left", "T_BD_HRFolk", "PERSON.FFolkID", "FOLK.FID"});
        hs.put("DIPLOMA", new String[]{"left", "T_BD_HRDiploma", "PERSON.FHighestDegreeID", "DIPLOMA.FID"});
        hs.put("TECHNICALPOST", new String[]{"left", "T_HR_BDTechnicalPost", "PERSON.FHighestTechPostID", "TECHNICALPOST.FID"});
        hs.put("HEALTH", new String[]{"left", "T_BD_HRHealth", "PERSON.FHealthID", "HEALTH.FID"});
        hs.put("WED", new String[]{"left", "T_BD_HRWed", "PERSON.FWedID", "WED.FID"});
        hs.put("EMPLOYEETYPE", new String[]{"left", "T_HR_BDEmployeeType", "PERSON.FEmployeeTypeID", "EMPLOYEETYPE.FID"});
        hs.put("EMPLOYEEFENLEI", new String[]{"left", "T_HR_EmployeeFenLei", "EMPLOYEETYPE.FEmployeeFenLeiID", "EmployeeFenLei.FID"});
        hs.put("STANDING", new String[]{"left", "T_BD_HRStanding", "PERSON.FStandingID", "STANDING.FID"});
        hs.put("POLITICALFACE", new String[]{"left", "T_BD_HRPolitical", "PERSON.FPoliticalFaceID", "POLITICALFACE.FID"});
        hs.put("BIRTH", new String[]{"left", "T_BD_HRBirth", "PERSON.FBirthID", "BIRTH.FID"});
        hs.put("PERSONDEP", new String[]{"left", "T_ORG_Admin", "PERSONPOSITION.FPersonDep", "PERSONDEP.FID"});
        hs.put("JOBGRADE", new String[]{"left", "T_HR_JobGrade", "PERSONPOSITION.FJobGrade", "JOBGRADE.FID"});
        hs.put("JOBLEVEL", new String[]{"left", "T_HR_JobLevel", "PERSONPOSITION.FJobLevelID", "JOBLEVEL.FID"});
        hs.put("EMPLOYEECLASSIFY", new String[]{"left", "T_HR_EmployeeClassify", "PERSON.FEmployeeClassifyID", "EMPLOYEECLASSIFY.FID"});
        hs.put("TECHPOSTTYPE", new String[]{"left", "T_HR_BDTechPostType", "TECHNICALPOST.FCategoryID", "TECHPOSTTYPE.FID"});
        hs.put("TECHPOSTLEVEL", new String[]{"left", "T_HR_BDTechPostLevel", "TECHNICALPOST.FLevelID", "TECHPOSTLEVEL.FID"});
        hs.put("PERSONLANGUAGE", new String[]{"left", "T_HR_PersonLanguage", "PERSON.FID", "PERSONLANGUAGE.FPersonID"});
        hs.put("PERSONDEGREE", new String[]{"left", "T_HR_PersonDegree", "PERSON.FID", "PERSONDEGREE.FPersonId and PERSONDEGREE.FIsHighest = 1 "});
        hs.put("DEGREE", new String[]{"left", "T_BD_HRDegree", "PERSONDEGREE.FDegree", "DEGREE.FID"});
        hs.put("SPECIALTYTYPE", new String[]{"left", "T_HR_BDSpecialtyType", "PERSONDEGREE.FSpecialtyType", "SPECIALTYTYPE.FID"});
        hs.put("PERSONCOMMUNIST", new String[]{"left", "T_HR_PersonCommunist", "PERSON.FID", "PERSONCOMMUNIST.FPersonID"});
        hs.put("LANGUAGE", new String[]{"left", "T_BD_Language", "PERSONLANGUAGE.FLanguage", "LANGUAGE.FID"});
        hs.put("LANGGRADE", new String[]{"left", "T_HR_BDLangGrade", "PERSONLANGUAGE.FGrade", "LANGGRADE.FID"});
        hs.put("EMPSH", new String[]{"left", "T_HR_EMPSH ", "PERSON.FID", "EMPSH.FPersonIDID"});
        hs.put("PERSONSTATUS", new String[]{"left", "T_HR_BDEmployeeType ", "EMPSH.FPersonStatusID", "PERSONSTATUS.FID"});
        hs.put("PERSONCONTACTMETHOD", new String[]{"left", "T_HR_PersonContactMethod ", "PERSON.FID", "PERSONCONTACTMETHOD.FPersonID"});
        hs.put("PERSONCERCOMPETENCY", new String[]{"left", "T_HR_PersonCertifyCompetency ", "PERSON.FID", "PERSONCERCOMPETENCY.FPersonID and PERSONCERCOMPETENCY.FIsHighest = 1"});
        hs.put("CERTIFIEDCOMPETENCY", new String[]{"left", "T_HR_BDCertifyCompetency ", "PERSONCERCOMPETENCY.FCertifiedCompetencyID", "CERTIFIEDCOMPETENCY.FID"});
        hs.put("CERTIFYCOMPETENCYLEVEL", new String[]{"left", "T_HR_BDCertifyCompetencyLevel", "CERTIFIEDCOMPETENCY.FLevelID", "CERTIFYCOMPETENCYLEVEL.FID"});
        hs.put("PERSONCHECKUP", new String[]{"left", "T_HR_PersonCheckUp", "PERSONCHECKUP.FPersonID", "PERSON.FID"});
        hs.put("GRADUATETYPE", new String[]{"left", "T_HR_GraduateType ", "PERSONDEGREE.FGraduateType", "GRADUATETYPE.FID"});
        return hs;
    }

    @Override
    protected int _getHREmpCount(Context ctx, Map map) throws BOSException, EASBizException {
        String hrOrgUnit = null;
        hrOrgUnit = map.get("hrOrgUnit") != null && !map.get("hrOrgUnit").toString().equals("") ? map.get("hrOrgUnit").toString() : ContextUtil.getCurrentHRUnit((Context)ctx).getNumber().toString();
        if (hrOrgUnit == null) {
            return 0;
        }
        String hrDimension = map.get("hrDimension").toString();
        String hrEmpFilter = null;
        if (map.get("hrEmpFilter") != null && !map.get("hrEmpFilter").toString().equals("")) {
            hrEmpFilter = map.get("hrEmpFilter").toString();
        }
        String hrEmpStatMode = map.get("hrEmpStatMode").toString();
        if (hrDimension.equals("E@F_01")) {
            return this.getPersonAvgCount(ctx, hrOrgUnit);
        }
        if (hrDimension.equals("E@F_02")) {
            return this.getPersonAgeAvgCount(ctx, hrOrgUnit);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT count(PERSON.FID) as empCount ");
        sql.append(" FROM T_BD_Person PERSON ");
        HashMap existHs = new HashMap();
        String strLongNumberSql = "";
        if (hrOrgUnit != null) {
            try {
                String[] hrOrgUnitNunmbers = hrOrgUnit.split(";");
                String strUnitLongNumber = " PERSONDEP.FLongNumber ";
                int size = hrOrgUnitNunmbers.length;
                for (int i = 0; i < size; ++i) {
                    IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)("select FLongNumber from t_org_admin where fnumber = '" + hrOrgUnitNunmbers[i].trim() + "'"));
                    rsTemp.beforeFirst();
                    while (rsTemp.next()) {
                        if (rsTemp.getString("FLongNumber") == null) continue;
                        String strLongNumber = rsTemp.getString("FLongNumber");
                        if (!strLongNumberSql.equals("")) {
                            strLongNumberSql = strLongNumberSql + " or ";
                        }
                        strLongNumberSql = strLongNumberSql + "(" + strUnitLongNumber + " = '" + strLongNumber + "' or " + strUnitLongNumber + " like '" + strLongNumber + "!%') ";
                    }
                }
                sql.append(this._getJoinSql(ctx, strLongNumberSql, existHs));
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        String strLongNumberSqlTmp = "";
        strLongNumberSqlTmp = this.countTimes(ctx, map, strLongNumberSqlTmp, sql, existHs);
        strLongNumberSqlTmp = this.countPointTime(ctx, map, strLongNumberSqlTmp, sql, existHs);
        if (hrEmpFilter != null) {
            sql.append(this._getJoinSql(ctx, hrEmpFilter, existHs));
        }
        if (hrOrgUnit != null || hrEmpFilter != null) {
            sql.append(" where ");
        }
        if (strLongNumberSql.length() > 0) {
            sql.append(" (");
            sql.append(strLongNumberSql);
            sql.append(") ");
        }
        if (strLongNumberSqlTmp.length() > 0) {
            if (strLongNumberSql.length() > 0) {
                sql.append(" and ");
            }
            sql.append(strLongNumberSqlTmp);
        }
        if (hrEmpFilter != null) {
            if (hrOrgUnit != null) {
                sql.append(" and " + hrEmpFilter);
            } else {
                sql.append(" " + hrEmpFilter);
            }
        }
        int iReturnCount = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            rs.beforeFirst();
            while (rs.next()) {
                iReturnCount = rs.getInt("empCount");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return iReturnCount;
    }

    private String countTimes(Context ctx, Map map, String strLongNumberSqlTmp, StringBuffer sql, HashMap existHs) throws EASBizException, BOSException {
        if (map.get("reasonLongNumber") != null && !map.get("reasonLongNumber").toString().equals("")) {
            String reasonLongNumber = map.get("reasonLongNumber").toString();
            String[] reasonLongNumberStrs = reasonLongNumber.split(";");
            String strUnitLongNumber = " REASON.FLongNumber ";
            int size = reasonLongNumberStrs.length;
            for (int i = 0; i < size; ++i) {
                if (!strLongNumberSqlTmp.equals("")) {
                    strLongNumberSqlTmp = strLongNumberSqlTmp + " or ";
                }
                strLongNumberSqlTmp = strLongNumberSqlTmp + "(" + strUnitLongNumber + " = '" + reasonLongNumberStrs[i] + "' or " + strUnitLongNumber + " like '" + reasonLongNumberStrs[i] + "!%') ";
            }
            sql.append(this._getJoinSql(ctx, strLongNumberSqlTmp, existHs));
            StringBuffer strLongNumberFilter = new StringBuffer();
            Date startDate = (Date)map.get("startDate");
            Date endDate = (Date)map.get("endDate");
            strLongNumberFilter.append("(");
            strLongNumberFilter.append(strLongNumberSqlTmp);
            strLongNumberFilter.append(" and EMPRELATE.FEffectStartDate>=");
            strLongNumberFilter.append("{");
            strLongNumberFilter.append(DateTimeUtils.format((Date)startDate));
            strLongNumberFilter.append("}");
            strLongNumberFilter.append(" and EMPRELATE.FEffectStartDate <= ");
            strLongNumberFilter.append("{");
            strLongNumberFilter.append(DateTimeUtils.format((Date)endDate));
            strLongNumberFilter.append("}");
            if (map.get("isPrimary").toString().equals("true")) {
                strLongNumberFilter.append(" and EMPRELATE.FIsPartTime = 0 ");
            }
            strLongNumberFilter.append(")");
            strLongNumberSqlTmp = strLongNumberFilter.toString();
        }
        return strLongNumberSqlTmp;
    }

    private String countPointTime(Context ctx, Map map, String strLongNumberSqlTmp, StringBuffer sql, HashMap existHs) throws EASBizException, BOSException {
        if (map.get("onlyCurrentTime") != null && !map.get("onlyCurrentTime").toString().equals("")) {
            Date countTime = map.get("onlyCurrentTime").toString().equals("true") ? new Date() : (Date)map.get("countTime");
            StringBuffer strLongNumberFilter = new StringBuffer();
            strLongNumberFilter.append("(");
            strLongNumberFilter.append(" EMPRELATE.FEffectStartDate <=");
            strLongNumberFilter.append("{");
            strLongNumberFilter.append(DateTimeUtils.format((Date)countTime));
            strLongNumberFilter.append("}");
            strLongNumberFilter.append(" and ");
            strLongNumberFilter.append(" EMPRELATE.FEffectEndDate >");
            strLongNumberFilter.append("{");
            strLongNumberFilter.append(DateTimeUtils.format((Date)countTime));
            strLongNumberFilter.append("}");
            strLongNumberFilter.append(" and FPositionStatus = ");
            strLongNumberFilter.append(10);
            sql.append(this._getJoinSql(ctx, strLongNumberFilter.toString(), existHs));
            if (map.get("isPrimary").toString().equals("true")) {
                strLongNumberFilter.append(" and EMPRELATE.FIsPartTime = 0 ");
            }
            strLongNumberFilter.append(")");
            strLongNumberSqlTmp = strLongNumberFilter.toString();
        }
        return strLongNumberSqlTmp;
    }

    @Override
    protected StringBuffer _getJoinSql(Context ctx, String strFilter, HashMap existHash) throws BOSException, EASBizException {
        HashMap allHs = this.getInitHashMap();
        StringBuffer sb = new StringBuffer();
        String[] strNames = strFilter.split("\\.");
        int length = strNames.length;
        for (int i = 0; i < length; ++i) {
            String strAsTableName = this.getAsTableName(allHs, strNames[i]);
            if (strAsTableName == null || existHash.containsKey(strAsTableName)) continue;
            String[] strValue = (String[])allHs.get(strAsTableName);
            String strOnLeftTbName = strValue[2].split("\\.")[0];
            String strOnRightTbName = strValue[3].split("\\.")[0];
            if (strOnLeftTbName.equalsIgnoreCase(strAsTableName)) {
                sb.append(this.getJoinSqlByAsTableName(existHash, strOnRightTbName));
            } else {
                sb.append(this.getJoinSqlByAsTableName(existHash, strOnLeftTbName));
            }
            existHash.put(strAsTableName, "");
            sb.append(" " + strValue[0] + " join " + strValue[1] + " " + strAsTableName + " on " + strValue[2] + " = " + strValue[3]);
        }
        return sb;
    }

    private StringBuffer getJoinSqlByAsTableName(HashMap existHs, String strAsTableName) {
        HashMap allHs = this.getInitHashMap();
        StringBuffer sb = new StringBuffer();
        if (!existHs.containsKey(strAsTableName)) {
            if (allHs.get(strAsTableName) == null) {
                return sb;
            }
            String[] strValue = (String[])allHs.get(strAsTableName);
            String strOnLeftTbName = strValue[2].split("\\.")[0];
            String strOnRightTbName = strValue[3].split("\\.")[0];
            if (strOnLeftTbName.equalsIgnoreCase(strAsTableName)) {
                sb.append(this.getJoinSqlByAsTableName(existHs, strOnRightTbName));
            } else {
                sb.append(this.getJoinSqlByAsTableName(existHs, strOnLeftTbName));
            }
            existHs.put(strAsTableName, "");
            sb.append(" " + strValue[0] + " join " + strValue[1] + " " + strAsTableName + " on " + strValue[2] + " = " + strValue[3]);
        }
        return sb;
    }

    private String getAsTableName(HashMap allHs, String splitSql) {
        Iterator it = allHs.keySet().iterator();
        while (it.hasNext()) {
            String strKey = it.next().toString();
            if (splitSql.indexOf(strKey) < 0) continue;
            return strKey;
        }
        return null;
    }

    private int getPersonAgeAvgCount(Context ctx, String paramString) throws EASBizException, BOSException {
        if (paramString == null) {
            return -1;
        }
        HashMap paramMap = HRUtils.parseValue((String)paramString.toLowerCase());
        String sql = "select FLongNumber from t_org_admin where lower(Fnumber) = '" + paramMap.get("hrorgunitkey").toString().toLowerCase() + "'";
        String strLongNumber = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.beforeFirst();
            while (rs.next()) {
                strLongNumber = rs.getString("FLongNumber");
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1.getMessage());
        }
        paramMap.put("hrorgunitlongnumber", strLongNumber);
        IRowSet rsSumAge = DbUtil.executeQuery((Context)ctx, (String)this.getSqlofGetAvgAge(true, paramMap));
        IRowSet rsEmpCount = DbUtil.executeQuery((Context)ctx, (String)this.getSqlofGetAvgAge(false, paramMap));
        int sumAge = 0;
        int empCount = 0;
        try {
            while (rsSumAge.next()) {
                sumAge = rsSumAge.getInt("COUNTNUMBER");
            }
            while (rsEmpCount.next()) {
                empCount = rsEmpCount.getInt("COUNTNUMBER");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        if (sumAge > 0 && empCount > 0) {
            return sumAge / empCount;
        }
        return 0;
    }

    private String getSqlofGetAvgAge(boolean isAgeFlag, HashMap paramMap) {
        StringBuffer sbSql = new StringBuffer();
        if (isAgeFlag) {
            sbSql.append(" SELECT SUM(ISNULL(YEAR(GetDate())-YEAR(Fbirthday),0)) AS COUNTNUMBER ");
        } else {
            sbSql.append(" SELECT COUNT(*) AS COUNTNUMBER ");
        }
        sbSql.append(" FROM T_BD_PERSON ");
        sbSql.append(" INNER JOIN t_hr_personposition ON t_Hr_Personposition.Fpersonid = t_bd_person.fid ");
        sbSql.append(" INNER JOIN t_org_admin On t_org_admin.fid = t_hr_personposition.fpersondep ");
        sbSql.append(" INNER JOIN t_Hr_Bdemployeetype ON t_bd_person.femployeetypeid = t_Hr_Bdemployeetype.Fid ");
        sbSql.append(" INNER JOIN T_HR_EmployeeClassify ON t_bd_person.femployeeclassifyid = T_HR_EmployeeClassify.Fid ");
        sbSql.append(" WHERE lower(t_org_admin.Flongnumber) like'" + paramMap.get("hrorgunitlongnumber").toString().toLowerCase() + "%' ");
        String EmpType = null;
        if (paramMap.get("emptype") != null) {
            EmpType = paramMap.get("emptype").toString();
        }
        if (EmpType != null && !EmpType.equals("")) {
            String strNums = "'" + EmpType.replaceAll(",", "','") + "'";
            sbSql.append(" AND lower(t_Hr_Bdemployeetype.Fnumber) in (" + strNums.toLowerCase() + ")");
        }
        String EmpClass = null;
        if (paramMap.get("empclass") != null) {
            EmpClass = paramMap.get("empclass").toString();
        }
        if (EmpClass != null && !EmpClass.equals("")) {
            String strNums = "'" + EmpClass.replaceAll(",", "','") + "'";
            sbSql.append(" AND lower(T_HR_EmployeeClassify.Fnumber) in (" + strNums.toLowerCase() + ")");
        }
        return sbSql.toString();
    }

    private int getPersonAvgCount(Context ctx, String paramString) throws EASBizException, BOSException {
        String strNums;
        HashMap paramMap = HRUtils.parseValue((String)paramString.toLowerCase());
        if (paramMap.get("hrorgunitkey") == null) {
            return -1;
        }
        String strBeginYM = "";
        String strEndYM = "";
        int iBeginY = 0;
        int iBeginM = 0;
        int iEndM = 0;
        if (paramMap.get("yearmontharea") == null) {
            strEndYM = paramMap.get("enddatekey").toString();
            Calendar ca = Calendar.getInstance();
            try {
                ca.setTime(DateTimeUtils.parseDate((String)strEndYM));
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage());
            }
            ca.getTime();
            ca.add(2, -1);
            strEndYM = Integer.valueOf(ca.get(1)).toString() + Integer.valueOf(ca.get(2) + 1).toString();
            strBeginYM = Integer.valueOf(ca.get(1)).toString() + "1";
        } else {
            String YearMonthArea = paramMap.get("yearmontharea").toString();
            String[] YearMonthAreas = YearMonthArea.split(",");
            if (YearMonthAreas.length != 2 || YearMonthAreas[0].length() > 6 || YearMonthAreas[1].length() > 6) {
                return -1;
            }
            strBeginYM = YearMonthAreas[0];
            strEndYM = YearMonthAreas[1];
        }
        iBeginY = Integer.valueOf(strBeginYM.substring(0, 4));
        iBeginM = Integer.valueOf(strBeginYM.substring(4, strBeginYM.length()));
        iEndM = Integer.valueOf(strEndYM.substring(4, strEndYM.length()));
        String EmpType = null;
        if (paramMap.get("emptype") != null) {
            EmpType = paramMap.get("emptype").toString();
        }
        String EmpClass = null;
        if (paramMap.get("empclass") != null) {
            EmpClass = paramMap.get("empclass").toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select sum(ISNULL(perFix.fcount,0)) as empCount ");
        sb.append(" from T_HR_ZYDPersonFix perFix");
        sb.append(" inner join T_HR_BDEmployeeType empType on empType.Fid = perFix.Ftype and perFix.Fcategory = 0");
        sb.append(" left join T_HR_EmployeeClassify empClass on empClass.Fid = perFix.Ftype and perFix.Fcategory = 1");
        sb.append(" inner join T_org_admin adminOrg on adminOrg.Fid = perFix.FORGID");
        sb.append(" where ");
        sb.append(" lower(adminOrg.Fnumber)='" + paramMap.get("hrorgunitkey").toString().toLowerCase() + "' AND ");
        String strWhere = "";
        if (EmpType != null && !EmpType.equals("")) {
            strNums = "'" + EmpType.replaceAll(",", "','") + "'";
            strWhere = strWhere + " (perFix.FCategory = 0 and lower(empType.Fnumber) in (" + strNums.toLowerCase() + "))";
        }
        if (EmpClass != null && !EmpClass.equals("")) {
            if (!strWhere.equals("")) {
                strWhere = strWhere + " and ";
            }
            strNums = "'" + EmpClass.replaceAll(",", "','") + "'";
            strWhere = strWhere + " (perFix.FCategory = 1 and lower(empClass.Fnumber) in (" + strNums.toLowerCase() + "))";
        }
        String strWhereYM = "";
        strWhereYM = iBeginM < iEndM ? strWhereYM + " (perFix.FYear = " + iBeginY + " and perFix.FMonth >= " + iBeginM + " and perFix.FMonth <= " + iEndM + ")" : strWhereYM + " (perFix.FYear = " + iBeginY + " and perFix.FMonth = " + iBeginM + ")";
        if (!strWhere.equals("")) {
            strWhere = strWhere + " and ";
        }
        strWhere = strWhere + "(" + strWhereYM + ")";
        sb.append(strWhere);
        int iReturnCount = 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            rs.beforeFirst();
            while (rs.next()) {
                iReturnCount = rs.getInt("empCount");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        if (iReturnCount == 0) {
            return 0;
        }
        int monthCount = 0;
        String selectSql = "SELECT DISTINCT FMonth FROM T_HR_ZYDPersonFix WHERE FYear=" + iBeginY + " AND FMonth<=" + iEndM;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        if (rsTemp.size() <= 0) {
            return -1;
        }
        monthCount = rsTemp.size();
        return iReturnCount / monthCount;
    }

    @Override
    protected double _getHrEmpDimissionRate(Context ctx, Map map) throws BOSException, EASBizException {
        String hrFrequency = (String)map.get("hrFrequency");
        if (StringUtils.isEmpty((String)hrFrequency)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"82_HREmpRptFormulaFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String hrOrgUnit = (String)map.get("hrOrgUnit");
        if (StringUtils.isEmpty((String)hrOrgUnit)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"83_HREmpRptFormulaFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String hrPeriod = (String)map.get("hrPeriod");
        if (!YEAR.equals(hrFrequency) && StringUtils.isEmpty((String)hrPeriod)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"84_HREmpRptFormulaFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String hrYear = (String)map.get("hrYear");
        if (StringUtils.isEmpty((String)hrYear)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"85_HREmpRptFormulaFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String hrDimissionFilter = (String)map.get("hrDimissionFilter");
        int dimissionCount = this.getLeaveCount(ctx, hrFrequency, hrOrgUnit, hrPeriod, hrYear, hrDimissionFilter);
        int personFixedCount = this.getOnSchemeCount(ctx, hrFrequency, hrOrgUnit, hrPeriod, hrYear);
        if (personFixedCount != 0) {
            return (double)dimissionCount * 1.0 / (double)personFixedCount;
        }
        throw new EmployeeException(EmployeeException.NOHISTORYDATA);
    }

    private int getLeaveCount(Context ctx, String hrFrequency, String hrOrgUnit, String hrPeriod, String hrYear, String hrDimissionFilter) throws EASBizException, BOSException {
        StringBuffer affairHistorySb = new StringBuffer("");
        affairHistorySb.append("SELECT \"PERSON\".FID AS \"FID\" ");
        affairHistorySb.append("FROM T_HR_AffairHistory AS \"AFFAIRHISTORY\" ");
        affairHistorySb.append("LEFT OUTER JOIN T_HR_JobLevel AS \"OLDJOBLEVEL\" ");
        affairHistorySb.append("ON \"AFFAIRHISTORY\".FOldJobLevelID = \"OLDJOBLEVEL\".FID ");
        affairHistorySb.append("LEFT OUTER JOIN T_BD_Person as \"PERSON\" ");
        affairHistorySb.append("ON \"AFFAIRHISTORY\".FPersonId = \"PERSON\".FID ");
        affairHistorySb.append("LEFT OUTER JOIN T_HR_JobGrade AS \"OLDJOBGRADE\" ");
        affairHistorySb.append("ON \"AFFAIRHISTORY\".FOldJobGrade = \"OLDJOBGRADE\".FID ");
        affairHistorySb.append(" LEFT OUTER JOIN T_HR_PersonWorkExpCur AS \"PWE\" on \"PWE\".FPersonID=\"AFFAIRHISTORY\".FPersonID  ");
        affairHistorySb.append("LEFT OUTER JOIN T_ORG_Position AS \"POS\" on \"PWE\".FPositionId=\"POS\".FId ");
        affairHistorySb.append("LEFT OUTER JOIN T_ORG_Admin AS \"OLDDEPT\" ON \"POS\".FAdminOrgUnitID = \"OLDDEPT\".FID ");
        affairHistorySb.append(" where \"AFFAIRHISTORY\".FAffairType in (3,4,5) ");
        affairHistorySb.append(" AND \"AFFAIRHISTORY\".FIsOnTheStrength='1' ");
        affairHistorySb.append(" AND YEAR(\"PWE\".FEndDate)=YEAR(\"AFFAIRHISTORY\".FEffectDate) ");
        affairHistorySb.append(" AND DATENAME(dayofyear,\"PWE\".FEndDate)=DATENAME(dayofyear,\"AFFAIRHISTORY\".FEffectDate) ");
        try {
            List ls = this.getLongNumberOfAdmin(ctx, hrOrgUnit);
            StringBuffer hrOrgUnitSb = new StringBuffer("");
            int size = ls.size();
            for (int i = 0; i < size; ++i) {
                hrOrgUnitSb.append(" \"OLDDEPT\".FLongNumber like " + (String)ls.get(i) + " OR");
            }
            if (hrOrgUnitSb != null && hrOrgUnitSb.length() > 0) {
                String hrOrgUnitStr = hrOrgUnitSb.substring(0, hrOrgUnitSb.length() - 2);
                affairHistorySb.append(" AND (" + hrOrgUnitStr + ") ");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new EASBizException(EASBizException.DBDEADLOCK, e.getCause());
        }
        if (MONTH.equals(hrFrequency)) {
            affairHistorySb.append(" AND MONTH(\"AFFAIRHISTORY\".FEffectDate)=" + hrPeriod);
        } else if (QUARTER.equals(hrFrequency)) {
            if ("1".equals(hrPeriod)) {
                affairHistorySb.append(" AND (MONTH(\"AFFAIRHISTORY\".FEffectDate)=1 or MONTH(\"AFFAIRHISTORY\".FEffectDate)=2 or MONTH(\"AFFAIRHISTORY\".FEffectDate)=3)");
            } else if ("2".equals(hrPeriod)) {
                affairHistorySb.append(" AND (MONTH(\"AFFAIRHISTORY\".FEffectDate)=4 or MONTH(\"AFFAIRHISTORY\".FEffectDate)=5 or MONTH(\"AFFAIRHISTORY\".FEffectDate)=6)");
            } else if ("3".equals(hrPeriod)) {
                affairHistorySb.append(" AND (MONTH(\"AFFAIRHISTORY\".FEffectDate)=7 or MONTH(\"AFFAIRHISTORY\".FEffectDate)=8 or MONTH(\"AFFAIRHISTORY\".FEffectDate)=9)");
            } else if ("4".equals(hrPeriod)) {
                affairHistorySb.append(" AND (MONTH(\"AFFAIRHISTORY\".FEffectDate)=10 or MONTH(\"AFFAIRHISTORY\".FEffectDate)=11 or MONTH(\"AFFAIRHISTORY\".FEffectDate)=12)");
            }
        }
        affairHistorySb.append(" AND YEAR(\"AFFAIRHISTORY\".FEffectDate)=" + hrYear);
        hrDimissionFilter = hrDimissionFilter.replaceAll("OLDPS.FId", "\"POS\".FId");
        if (!StringUtils.isEmpty((String)hrDimissionFilter)) {
            affairHistorySb.append(" AND (" + hrDimissionFilter + ")");
        }
        String sql = affairHistorySb.toString();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sql + " AND \"PWE\".FIsPrimary=1 "));
        int dimissionCount = rs.size();
        String hrOrgId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        boolean is_AUTH = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AUTH", (String)hrOrgId);
        if (is_AUTH) {
            rs = DbUtil.executeQuery((Context)ctx, (String)(sql + " AND \"PWE\".FIsPrimary=0 "));
            dimissionCount += rs.size();
        }
        return dimissionCount;
    }

    private int getOnSchemeCount(Context ctx, String hrFrequency, String hrOrgUnit, String hrPeriod, String hrYear) throws BOSException, EASBizException, EmployeeException {
        int year = Integer.parseInt(hrYear);
        StringBuffer sb = new StringBuffer("");
        sb.append("select \"PFT\".FId,\"PFT\".FFixedTime from T_HR_PersonFixedTime \"PFT\" where 1=1 ");
        if (MONTH.equals(hrFrequency)) {
            sb.append(" AND \"PFT\".FMonth =" + hrPeriod);
        } else if (QUARTER.equals(hrFrequency)) {
            sb.append(" AND \"PFT\".FQuarter =" + hrPeriod);
        }
        sb.append(" AND \"PFT\".FYear=" + year);
        sb.append(" order by \"PFT\".FFixedTime desc ");
        IRowSet personFixedTimeRs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        String personFixedTimeId = "";
        try {
            if (personFixedTimeRs.next()) {
                personFixedTimeId = personFixedTimeRs.getString("FId");
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1);
            throw new EASBizException(EASBizException.DBDEADLOCK, e1.getCause());
        }
        StringBuffer personFixedSb = new StringBuffer("");
        String hrOrgId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String selField = "FOnStreCount2";
        if (!HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AUTH", (String)hrOrgId)) {
            selField = "FOnStreCount";
        }
        personFixedSb.append("select " + selField + " as \"onStreCount\" from T_HR_PersonFixedHistory \"PFH\"");
        personFixedSb.append(" left outer join  T_HR_PersonFixedTime \"PFT\" on \"PFH\".FFixedTimeId = \"PFT\".FId");
        personFixedSb.append(" left outer join  T_ORG_Admin \"OA\" on \"PFH\".FAdminOrgId = \"OA\".FId");
        personFixedSb.append(" where \"PFT\".FIsSuccess = 1 AND \"PFT\".FId ='" + personFixedTimeId + "' ");
        try {
            List ls = this.getLongNumberOfAdmin(ctx, hrOrgUnit);
            StringBuffer hrOrgUnitSb = new StringBuffer("");
            int size = ls.size();
            for (int i = 0; i < size; ++i) {
                hrOrgUnitSb.append(" \"OA\".FLongNumber like " + (String)ls.get(i) + " OR");
            }
            if (hrOrgUnitSb != null && hrOrgUnitSb.length() > 0) {
                String hrOrgUnitStr = hrOrgUnitSb.substring(0, hrOrgUnitSb.length() - 2);
                personFixedSb.append(" AND (" + hrOrgUnitStr + ") ");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new EASBizException(EASBizException.DBDEADLOCK, e.getCause());
        }
        IRowSet personFixedRs = DbUtil.executeQuery((Context)ctx, (String)personFixedSb.toString());
        int personFixedCount = 0;
        if (personFixedRs.size() == 0) {
            throw new EmployeeException(EmployeeException.NOHISTORYDATA);
        }
        try {
            while (personFixedRs.next()) {
                personFixedCount += personFixedRs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new EASBizException(EASBizException.DBDEADLOCK, e.getCause());
        }
        return personFixedCount;
    }

    private int getOnSchemeCount(Context ctx, String hrFrequency, String hrOrgUnit, String hrPeriod, String hrYear, String hrOnDutyFilter) throws BOSException, EASBizException, EmployeeException {
        int year = Integer.parseInt(hrYear);
        StringBuffer sb = new StringBuffer("");
        sb.append("select \"PFT\".FId,\"PFT\".FFixedTime from T_HR_PersonFixedTime \"PFT\" where 1=1 ");
        if (MONTH.equals(hrFrequency)) {
            sb.append(" AND \"PFT\".FMonth =" + hrPeriod);
        } else if (QUARTER.equals(hrFrequency)) {
            sb.append(" AND \"PFT\".FQuarter =" + hrPeriod);
        }
        sb.append(" AND \"PFT\".FYear=" + year);
        sb.append(" order by \"PFT\".FFixedTime desc ");
        IRowSet personFixedTimeRs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        String personFixedTimeId = "";
        try {
            if (personFixedTimeRs.next()) {
                personFixedTimeId = personFixedTimeRs.getString("FId");
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1);
            throw new EASBizException(EASBizException.DBDEADLOCK, e1.getCause());
        }
        StringBuffer personFixedSb = new StringBuffer("");
        String hrOrgId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String selField = "FOnStreCount2";
        if (!HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AUTH", (String)hrOrgId)) {
            selField = "FOnStreCount";
        }
        personFixedSb.append("select " + selField + " as \"onStreCount\" from T_HR_PersonFixedHistory \"PFH\"");
        personFixedSb.append(" left outer join  T_HR_PersonFixedTime \"PFT\" on \"PFH\".FFixedTimeId = \"PFT\".FId");
        personFixedSb.append(" left outer join  T_ORG_Admin \"OA\" on \"PFH\".FAdminOrgId = \"OA\".FId");
        personFixedSb.append(" where \"PFT\".FIsSuccess = 1 AND \"PFT\".FId ='" + personFixedTimeId + "' ");
        hrOnDutyFilter = hrOnDutyFilter.replaceAll("Job.FId", "\"PFH\".FJobId");
        hrOnDutyFilter = hrOnDutyFilter.replaceAll("PS.FId", "\"PFH\".FPositionID");
        if (!StringUtils.isEmpty((String)hrOnDutyFilter)) {
            personFixedSb.append(" AND (" + hrOnDutyFilter + ") ");
        }
        try {
            List ls = this.getLongNumberOfAdmin(ctx, hrOrgUnit);
            StringBuffer hrOrgUnitSb = new StringBuffer("");
            int size = ls.size();
            for (int i = 0; i < size; ++i) {
                hrOrgUnitSb.append(" \"OA\".FLongNumber like " + (String)ls.get(i) + " OR");
            }
            if (hrOrgUnitSb != null && hrOrgUnitSb.length() > 0) {
                String hrOrgUnitStr = hrOrgUnitSb.substring(0, hrOrgUnitSb.length() - 2);
                personFixedSb.append(" AND (" + hrOrgUnitStr + ") ");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new EASBizException(EASBizException.DBDEADLOCK, e.getCause());
        }
        IRowSet personFixedRs = DbUtil.executeQuery((Context)ctx, (String)personFixedSb.toString());
        int personFixedCount = 0;
        if (personFixedRs.size() == 0) {
            throw new EmployeeException(EmployeeException.NOHISTORYDATA);
        }
        try {
            while (personFixedRs.next()) {
                personFixedCount += personFixedRs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new EASBizException(EASBizException.DBDEADLOCK, e.getCause());
        }
        return personFixedCount;
    }

    private StringBuffer tranHrOrgUnit(String hrOrgUnit) {
        String[] hrOrgUnits = null;
        if (hrOrgUnit != null && hrOrgUnit.length() > 0) {
            hrOrgUnits = hrOrgUnit.split(";");
        }
        StringBuffer hrOrgUnitsSb = new StringBuffer("");
        if (hrOrgUnits != null) {
            for (int i = 0; i < hrOrgUnits.length; ++i) {
                if (i == 0) {
                    hrOrgUnitsSb.append("('");
                    hrOrgUnitsSb.append(hrOrgUnits[i].trim());
                    if (hrOrgUnits.length == 1) {
                        hrOrgUnitsSb.append("')");
                        continue;
                    }
                    hrOrgUnitsSb.append("',");
                    continue;
                }
                if (i == hrOrgUnits.length - 1) {
                    hrOrgUnitsSb.append("'");
                    hrOrgUnitsSb.append(hrOrgUnits[i].trim());
                    hrOrgUnitsSb.append("')");
                    continue;
                }
                hrOrgUnitsSb.append("'");
                hrOrgUnitsSb.append(hrOrgUnits[i].trim());
                hrOrgUnitsSb.append("',");
            }
        }
        return hrOrgUnitsSb;
    }

    @Override
    protected double _getHrEmpOnDutyRate(Context ctx, Map map) throws BOSException, EASBizException {
        String hrFrequency = (String)map.get("hrFrequency");
        if (StringUtils.isEmpty((String)hrFrequency)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"82_HREmpRptFormulaFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String hrOrgUnit = (String)map.get("hrOrgUnit");
        if (StringUtils.isEmpty((String)hrOrgUnit)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"83_HREmpRptFormulaFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String hrPeriod = (String)map.get("hrPeriod");
        if (!YEAR.equals(hrFrequency) && StringUtils.isEmpty((String)hrPeriod)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"84_HREmpRptFormulaFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String onSchemeCount = (String)map.get("onSchemeCount");
        if (StringUtils.isEmpty((String)onSchemeCount)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"86_HREmpRptFormulaFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String hrYear = (String)map.get("hrYear");
        if (StringUtils.isEmpty((String)hrYear)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"85_HREmpRptFormulaFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        int year = Integer.parseInt(hrYear);
        String hrOnDutyFilter = (String)map.get("hrOnDutyFilter");
        int personFixedCount = this.getOnSchemeCount(ctx, hrFrequency, hrOrgUnit, hrPeriod, hrYear, hrOnDutyFilter);
        if (personFixedCount == 0) {
            throw new EmployeeException(EmployeeException.NOHISTORYDATA);
        }
        int personPlanCnt = this.getPlanSchemeCount(ctx, hrFrequency, hrOrgUnit, hrPeriod, onSchemeCount, year, hrOnDutyFilter);
        if (personPlanCnt == 0) {
            throw new EmployeeException(EmployeeException.NO_ONDUTY_PERSON);
        }
        return (double)personFixedCount * 1.0 / (double)personPlanCnt;
    }

    private int getPlanSchemeCount(Context ctx, String hrFrequency, String hrOrgUnit, String hrPeriod, String onSchemeCount, int year, String hrOnDutyFilter) throws EASBizException, BOSException {
        StringBuffer personPlanSb = new StringBuffer("");
        personPlanSb.append("select \"PP\".FPlan1,\"PP\".FPlan2,\"PP\".FPlan3,\"PP\".FPlan4,\"PP\".FPlan5,\"PP\".FPlan6,\"PP\".FPlan7,\"PP\".FPlan8,\"PP\".FPlan9,\"PP\".FPlan10,\"PP\".FPlan11,\"PP\".FPlan12 from T_HR_PersonPlan \"PP\"");
        personPlanSb.append(" left outer join T_HR_PersonPlanScheme \"PPS\" on \"PP\".FSchemeId = \"PPS\".FId");
        personPlanSb.append(" left outer join T_ORG_Admin \"OA\" on \"PP\".FAdminOrgId = \"OA\".FId where 1=1 ");
        hrOnDutyFilter = hrOnDutyFilter.replaceAll("Job.FId", "\"PP\".FJobId");
        hrOnDutyFilter = hrOnDutyFilter.replaceAll("PS.FId", "\"PP\".FPositionID");
        if (!StringUtils.isEmpty((String)hrOnDutyFilter)) {
            personPlanSb.append(" AND (" + hrOnDutyFilter + ") ");
        }
        try {
            List ls = this.getLongNumberOfAdmin(ctx, hrOrgUnit);
            StringBuffer hrOrgUnitSb = new StringBuffer("");
            int size = ls.size();
            for (int i = 0; i < size; ++i) {
                hrOrgUnitSb.append(" \"OA\".FLongNumber like " + (String)ls.get(i) + " OR");
            }
            if (hrOrgUnitSb != null && hrOrgUnitSb.length() > 0) {
                String hrOrgUnitStr = hrOrgUnitSb.substring(0, hrOrgUnitSb.length() - 2);
                personPlanSb.append(" AND (" + hrOrgUnitStr + ") ");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new EASBizException(EASBizException.DBDEADLOCK, e.getCause());
        }
        personPlanSb.append(" AND \"PPS\".FNumber='" + onSchemeCount + "'");
        personPlanSb.append(" AND \"PP\".FYear =" + year);
        IRowSet personPlanRs = DbUtil.executeQuery((Context)ctx, (String)personPlanSb.toString());
        int personPlanCnt = 0;
        try {
            while (personPlanRs.next()) {
                if (MONTH.equals(hrFrequency)) {
                    personPlanCnt += personPlanRs.getInt("FPlan" + hrPeriod);
                    continue;
                }
                if (QUARTER.equals(hrFrequency)) {
                    if ("1".equals(hrPeriod)) {
                        personPlanCnt += personPlanRs.getInt("FPlan3");
                        continue;
                    }
                    if ("2".equals(hrPeriod)) {
                        personPlanCnt += personPlanRs.getInt("FPlan6");
                        continue;
                    }
                    if ("3".equals(hrPeriod)) {
                        personPlanCnt += personPlanRs.getInt("FPlan9");
                        continue;
                    }
                    if (!"4".equals(hrPeriod)) continue;
                    personPlanCnt += personPlanRs.getInt("FPlan12");
                    continue;
                }
                if (!YEAR.equals(hrFrequency)) continue;
                personPlanCnt += personPlanRs.getInt("FPlan12");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new EASBizException(EASBizException.DBDEADLOCK, e.getCause());
        }
        return personPlanCnt;
    }

    private List getLongNumberOfAdmin(Context ctx, String hrOrgUnit) throws BOSException, SQLException {
        StringBuffer hrOrgUnitsSb = this.tranHrOrgUnit(hrOrgUnit);
        ArrayList<String> ls = new ArrayList<String>();
        if (null != hrOrgUnitsSb && hrOrgUnitsSb.length() > 0) {
            String sql = "select FLongNumber from T_ORG_Admin where FNumber in " + hrOrgUnitsSb;
            IRowSet hrOrgRs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (hrOrgRs.next()) {
                ls.add("'" + hrOrgRs.getString("FLongNumber") + "%'");
            }
        }
        return ls;
    }

    @Override
    protected int _getHRPersonPlanCount(Context ctx, Map map) throws BOSException, EASBizException {
        int count = 0;
        String hrPersonPlanScheme = (String)map.get("hrPersonPlanScheme");
        String hrPersonPlanPeriod = (String)map.get("hrPersonPlanPeriod");
        String hrPersonPlanFilter = (String)map.get("hrPersonPlanFilter");
        int year = 0;
        int halfYear = 0;
        int quarter = 0;
        int month = 0;
        if (StringUtils.isEmpty((String)hrPersonPlanPeriod)) {
            return 0;
        }
        String[] tmp = hrPersonPlanPeriod.split(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.BaseBizResourse", (String)YEAR, (Context)ctx));
        year = Integer.parseInt(tmp[0]);
        PersonPlanSchemeInfo info = PersonPlanSchemeFactory.getLocalInstance((Context)ctx).getPersonPlanSchemeInfo("where number ='" + hrPersonPlanScheme + "'");
        if (info == null) {
            return 0;
        }
        Period period = info.getPeriod();
        if (period == Period.HALF_YEAR) {
            if (tmp[1].equals(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"87_HREmpRptFormulaFacadeControllerBean", (Locale)ctx.getLocale()))) {
                halfYear = 0;
            }
            if (tmp[1].equals(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"88_HREmpRptFormulaFacadeControllerBean", (Locale)ctx.getLocale()))) {
                halfYear = 1;
            }
        }
        if (period == Period.QUARTER) {
            quarter = Integer.parseInt(tmp[1].substring(0, 1));
        }
        if (period == Period.MONTH) {
            String[] tmp1 = tmp[1].split(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.BaseBizResourse", (String)MONTH, (Context)ctx));
            month = Integer.parseInt(tmp1[0]);
        }
        StringBuffer personPlanSb = new StringBuffer("");
        personPlanSb.append("select \"PP\".FPlan1,\"PP\".FPlan2,\"PP\".FPlan3,\"PP\".FPlan4,\"PP\".FPlan5,\"PP\".FPlan6,\"PP\".FPlan7,\"PP\".FPlan8,\"PP\".FPlan9,\"PP\".FPlan10,\"PP\".FPlan11,\"PP\".FPlan12 from T_HR_PersonPlan \"PP\"");
        personPlanSb.append(" left outer join T_HR_PersonPlanScheme \"PPS\" on \"PP\".FSchemeId = \"PPS\".FId");
        personPlanSb.append(" left outer join T_ORG_Admin \"OA\" on \"PP\".FAdminOrgId = \"OA\".FId ");
        personPlanSb.append(" where \"PPS\".fnumber ='" + hrPersonPlanScheme + "' ");
        personPlanSb.append(" and \"PP\".FYear =" + year + " ");
        if (!StringUtils.isEmpty((String)hrPersonPlanFilter)) {
            hrPersonPlanFilter = hrPersonPlanFilter.replaceAll("Job.FId", "\"PP\".FJobId");
            hrPersonPlanFilter = hrPersonPlanFilter.replaceAll("PS.FId", "\"PP\".FPositionID");
            hrPersonPlanFilter = hrPersonPlanFilter.replaceAll("OA.FId", "\"OA\".FID");
            personPlanSb.append(" AND (" + hrPersonPlanFilter + ") ");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)personPlanSb.toString());
        try {
            while (rows.next()) {
                if (period == Period.YEAR) {
                    count += rows.getInt("FPlan1");
                }
                if (period == Period.HALF_YEAR) {
                    switch (halfYear) {
                        case 0: {
                            count += rows.getInt("FPlan1");
                            break;
                        }
                        case 1: {
                            count += rows.getInt("FPlan12");
                        }
                    }
                }
                if (period == Period.QUARTER) {
                    switch (quarter) {
                        case 1: {
                            count += rows.getInt("FPlan3");
                            break;
                        }
                        case 2: {
                            count += rows.getInt("FPlan6");
                            break;
                        }
                        case 3: {
                            count += rows.getInt("FPlan9");
                            break;
                        }
                        case 4: {
                            count += rows.getInt("FPlan12");
                        }
                    }
                }
                if (period != Period.MONTH) continue;
                switch (month) {
                    case 1: {
                        count += rows.getInt("FPlan1");
                        break;
                    }
                    case 2: {
                        count += rows.getInt("FPlan2");
                        break;
                    }
                    case 3: {
                        count += rows.getInt("FPlan3");
                        break;
                    }
                    case 4: {
                        count += rows.getInt("FPlan4");
                        break;
                    }
                    case 5: {
                        count += rows.getInt("FPlan5");
                        break;
                    }
                    case 6: {
                        count += rows.getInt("FPlan6");
                        break;
                    }
                    case 7: {
                        count += rows.getInt("FPlan7");
                        break;
                    }
                    case 8: {
                        count += rows.getInt("FPlan8");
                        break;
                    }
                    case 9: {
                        count += rows.getInt("FPlan9");
                        break;
                    }
                    case 10: {
                        count += rows.getInt("FPlan10");
                        break;
                    }
                    case 11: {
                        count += rows.getInt("FPlan11");
                        break;
                    }
                    case 12: {
                        count += rows.getInt("FPlan12");
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return count;
    }
}

