/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.PersonTechnicalPostCollection;
import com.kingdee.eas.hr.emp.PersonTechnicalPostInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonTechnicalPostControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;

public class PersonTechnicalPostControllerBean
extends AbstractPersonTechnicalPostControllerBean {
    @Override
    protected IObjectPK[] _saveAll(Context ctx, IObjectCollection techCols, IObjectPK[] deleteList) throws BOSException, EASBizException {
        if (deleteList != null) {
            for (int i = 0; i < deleteList.length; ++i) {
                if (deleteList[i] == null) continue;
                this._delete(ctx, deleteList[i]);
            }
        }
        if (techCols != null) {
            return this.addAndUpdate(ctx, (PersonTechnicalPostCollection)techCols);
        }
        return null;
    }

    private IObjectPK[] addAndUpdate(Context ctx, PersonTechnicalPostCollection degreeColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        for (int i = 0; i < degreeColl.size(); ++i) {
            if (degreeColl.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)degreeColl.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(degreeColl.get(i).getId()), (IObjectValue)degreeColl.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PersonTechnicalPostInfo info = this.getPersonTechnicalPostInfo(ctx, pk);
        if (info.isIsHighTechnical()) {
            String personId = info.getPerson().getId().toString();
            String id = info.getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
            if (this._exists(ctx, filter)) {
                throw new EmployeeException(EmployeeException.MUST_EXIST_LESS_ONE_TECHNICAL);
            }
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonTechnicalPostInfo info = (PersonTechnicalPostInfo)model;
        PersonTechnicalPostInfo oldInfo = this.getPersonTechnicalPostInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        if (oldInfo.isIsHighTechnical() && info.getTechnicalPost() != null && !info.isIsHighTechnical()) {
            throw new EmployeeException(EmployeeException.MUST_EXIST_LESS_ONE_TECHNICAL);
        }
        if (info.isIsHighTechnical()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonTechPost SET FIsHighTechnical = 0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(info.getPerson().getId()));
            personInfo.setHighestTechPost(info.getTechnicalPost());
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("highestTechPost"));
            iPerson.updatePartial((CoreBaseInfo)personInfo, selector);
        }
        if (info.isIsEmploy()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonTechPost SET FIsEmploy = 0 WHERE FPersonId='" + info.getPerson().getId() + "'"));
        }
        super._update(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonTechnicalPostInfo pInfo = (PersonTechnicalPostInfo)model;
        if (!this._exists(ctx, "where person.id='" + pInfo.getPerson().getId() + "' and isHighTechnical=1") && !pInfo.isIsHighTechnical()) {
            throw new EmployeeException(EmployeeException.MUST_HAVE_HIGH_TENICALPOST);
        }
        if (pInfo.isIsHighTechnical()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonTechPost SET FIsHighTechnical = 0 WHERE FPersonId='" + pInfo.getPerson().getId() + "'"));
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(pInfo.getPerson().getId()));
            personInfo.setHighestTechPost(pInfo.getTechnicalPost());
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("highestTechPost"));
            iPerson.updatePartial((CoreBaseInfo)personInfo, selector);
        }
        if (pInfo.isIsEmploy()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonTechPost SET FIsEmploy = 0 WHERE FPersonId='" + pInfo.getPerson().getId() + "'"));
        }
        return super._addnew(ctx, (IObjectValue)pInfo);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        PersonTechnicalPostInfo info = (PersonTechnicalPostInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }
}

