/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.app.util.CoreBaseObjectUtil;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.emp.EmployeeAuditEntryCollection;
import com.kingdee.eas.hr.emp.EmployeeAuditEntryInfo;
import com.kingdee.eas.hr.emp.EmployeeAuditFactory;
import com.kingdee.eas.hr.emp.EmployeeAuditInfo;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.common.util.SHREnumUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmployeePageAuditServerUtil {
    private static final String RESOURCE = "com.kingdee.eas.hr.emp.EmployeeResource";
    private static Logger logger = LoggerFactory.getLogger(EmployeePageAuditServerUtil.class);

    public static CoreBaseInfo getValue(Context ctx, String pk) throws EASBizException, BOSException, UuidException {
        if (StringUtils.isEmpty((String)pk)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        return MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)pk).getType()).getValue((IObjectPK)new ObjectUuidPK(pk), sic);
    }

    public static void deleteEmployeeAudit(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        if (billId == null || StringUtils.isEmpty((String)billId.toString())) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("pk", (Object)billId));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        EmployeeAuditFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    public static void confirmEmployeeAudit(Context ctx, IObjectPK billId) throws BOSException {
        if (billId == null || StringUtils.isEmpty((String)billId.toString())) {
            return;
        }
        Object[] params = new Object[]{billId.toString()};
        String sql = "update t_hr_employeeAudit set FConfirmStatus = 1 where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static void updateEmployeeAuditStatus(Context ctx, EmployeeAuditInfo auditInfo) throws BOSException, EASBizException {
        if (auditInfo.getId() == null || StringUtils.isEmpty((String)auditInfo.getId().toString())) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("saveTime"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("auditor"));
        selector.add(new SelectorItemInfo("status"));
        EmployeeAuditFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)auditInfo, selector);
    }

    public static PersonInfo getPersonInfo(CoreBaseInfo newInfo) {
        PersonInfo personInfo = null;
        if (newInfo == null) {
            return personInfo;
        }
        personInfo = newInfo instanceof PersonInfo ? (PersonInfo)newInfo : (newInfo instanceof EmployeeContractInfo ? ((EmployeeContractInfo)newInfo).getEmployee() : (PersonInfo)newInfo.get("person"));
        return personInfo;
    }

    public static String getFieldDescription(Context ctx, String fieldName, Object value, boolean isDifferent) throws EASBizException, BOSException {
        StringBuffer desc = new StringBuffer();
        if (isDifferent) {
            desc.append("<different>");
            desc.append(fieldName).append("\uff1a").append(EmployeePageAuditServerUtil.getValueDescription(ctx, value)).append("\uff1b");
            desc.append("</different>");
        } else {
            desc.append(fieldName).append("\uff1a").append(EmployeePageAuditServerUtil.getValueDescription(ctx, value)).append("\uff1b");
        }
        return desc.toString();
    }

    public static String getValueDescription(Context ctx, Object value) throws EASBizException, BOSException, UuidException {
        String description = null;
        if (value instanceof String) {
            description = (String)value;
        } else if (value instanceof CoreBaseInfo) {
            Object nameValue;
            CoreBaseInfo info = (CoreBaseInfo)value;
            if (CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)info, (String)"name") == null) {
                String pk = info.getId().toString();
                info = EmployeePageAuditServerUtil.getValue(ctx, pk);
            }
            description = (nameValue = CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)info, (String)"name")) != null && nameValue instanceof BigDecimal ? ((BigDecimal)value).setScale(2).toString() : (String)CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)info, (String)"name");
        } else if (value instanceof BOSUuid) {
            description = (String)value;
        } else if (value instanceof Boolean) {
            description = Boolean.TRUE.equals(value) ? ResourceBase.getString((String)RESOURCE, (String)"YES", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RESOURCE, (String)"NOT", (Locale)ctx.getLocale());
        } else if (value instanceof Integer) {
            description = ((Integer)value).toString();
        } else if (value instanceof Long) {
            description = ((Long)value).toString();
        } else if (value instanceof Float) {
            description = BigDecimal.valueOf(((Float)value).floatValue()).setScale(2, 4).toString();
        } else if (value instanceof Double) {
            description = value.toString();
        } else if (value instanceof BigDecimal) {
            description = value.toString();
        } else if (value instanceof Date) {
            String dateFormat = EmployeePageAuditServerUtil.dateFormat((Date)value);
            description = DateTimeUtils.format((Date)((Date)value), (String)dateFormat);
        } else if (value instanceof Timestamp) {
            Date date = new Date(((Timestamp)value).getTime());
            String dateFormat = EmployeePageAuditServerUtil.dateFormat(date);
            description = DateTimeUtils.format((Date)date, (String)dateFormat);
        } else if (value instanceof IntEnum) {
            description = ((IntEnum)value).getAlias();
        } else if (value instanceof StringEnum) {
            description = ((StringEnum)value).getAlias();
        }
        if (description == null) {
            description = "";
        }
        return description;
    }

    public static EmployeeAuditEntryInfo assembleAuditEntryInfo(EmployeeAuditInfo auditInfo, String fieldName, Object newValue) {
        EmployeeAuditEntryInfo entryInfo = new EmployeeAuditEntryInfo();
        entryInfo.setParent(auditInfo);
        entryInfo.setFieldName(fieldName);
        String value_string = null;
        BigDecimal value_number = null;
        Date value_date = null;
        if (newValue instanceof String) {
            value_string = (String)newValue;
        } else if (newValue instanceof CoreBaseInfo) {
            value_string = ((CoreBaseInfo)newValue).getId().toString();
        } else if (newValue instanceof BOSUuid) {
            value_string = ((BOSUuid)newValue).toString();
        } else if (newValue instanceof Boolean) {
            value_number = Boolean.TRUE.equals(newValue) ? new BigDecimal("1") : new BigDecimal("0");
        } else if (newValue instanceof Integer) {
            value_number = new BigDecimal((Integer)newValue);
        } else if (newValue instanceof Long) {
            value_number = new BigDecimal((Long)newValue);
        } else if (newValue instanceof Float) {
            value_number = BigDecimal.valueOf(((Float)newValue).floatValue());
        } else if (newValue instanceof Double) {
            value_number = BigDecimal.valueOf((Double)newValue);
        } else if (newValue instanceof BigDecimal) {
            value_number = (BigDecimal)newValue;
        } else if (newValue instanceof Date) {
            value_date = (Date)newValue;
        } else if (newValue instanceof Timestamp) {
            value_date = new Date(((Timestamp)newValue).getTime());
        } else if (newValue instanceof IntEnum) {
            value_number = new BigDecimal(((IntEnum)newValue).getValue());
        } else if (newValue instanceof StringEnum) {
            value_string = ((StringEnum)newValue).getValue();
        }
        entryInfo.setValueString(value_string);
        entryInfo.setValueNumber(value_number);
        entryInfo.setValueDate(value_date);
        return entryInfo;
    }

    public static CoreBaseInfo convertObjectValue(Context ctx, EmployeeAuditInfo auditInfo) throws BOSException {
        CoreBaseInfo objectValue = null;
        try {
            Class clazz = MetaDataServerUtil.getObjectValueClass((Context)ctx, (String)auditInfo.getEntity());
            objectValue = (CoreBaseInfo)clazz.newInstance();
            objectValue.setId(auditInfo.getPk());
            EmployeeAuditEntryCollection entrys = auditInfo.getEntrys();
            EmployeeAuditEntryInfo entryInfo = null;
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entrys.get(i);
                EmployeePageAuditServerUtil.setModelField(ctx, objectValue, entryInfo, auditInfo.getEntity());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return objectValue;
    }

    public static void setModelField(Context ctx, CoreBaseInfo objectValue, EmployeeAuditEntryInfo entryInfo, String entityName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, BOSException, UuidException, EASBizException {
        EntityObjectInfo entityInfo;
        PropertyInfo property;
        String fieldName = entryInfo.getFieldName();
        if (StringUtils.isEmpty((String)entityName)) {
            entityName = entryInfo.getParent().getEntity();
        }
        if ((property = (entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName))).getPropertyByName(fieldName)) == null && fieldName.contains("ext_")) {
            entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.hr.emp.app.PersonOtherInfo"));
            property = entityInfo.getPropertyByName(fieldName.replaceAll("ext_", ""));
        }
        Object value = null;
        if (property instanceof OwnPropertyInfo) {
            String valueString;
            Date valueDate;
            DataType dataType = ((OwnPropertyInfo)property).getDataType();
            BigDecimal valueNumber = entryInfo.getValueNumber();
            if (valueNumber != null) {
                if (DataType.SHORT.equals((Object)dataType)) {
                    value = new Short(valueNumber.shortValue());
                } else if (DataType.INTEGER.equals((Object)dataType)) {
                    value = new Integer(valueNumber.intValue());
                } else if (DataType.FLOAT.equals((Object)dataType)) {
                    value = new Float(valueNumber.floatValue());
                } else if (DataType.LONG.equals((Object)dataType)) {
                    value = new Long(valueNumber.longValue());
                } else if (DataType.DOUBLE.equals((Object)dataType)) {
                    value = new Double(valueNumber.doubleValue());
                } else if (DataType.DECIMAL.equals((Object)dataType)) {
                    value = valueNumber;
                } else if (DataType.BOOLEAN.equals((Object)dataType)) {
                    value = valueNumber.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
                } else if (DataType.ENUM.equals((Object)dataType)) {
                    value = valueNumber;
                }
            }
            if ((valueDate = entryInfo.getValueDate()) != null) {
                if (DataType.DATE.equals((Object)dataType)) {
                    value = valueDate;
                } else if (DataType.TIME.equals((Object)dataType)) {
                    value = new Time(valueDate.getTime());
                } else if (DataType.TIMESTAMP.equals((Object)dataType)) {
                    value = new Timestamp(valueDate.getTime());
                }
            }
            if (!StringUtils.isEmpty((String)(valueString = entryInfo.getValueString()))) {
                value = DataType.STRING.equals((Object)dataType) ? valueString : (DataType.OBJECTPK.equals((Object)dataType) ? new ObjectUuidPK(valueString) : (DataType.BOSUUID.equals((Object)dataType) ? BOSUuid.read((String)valueString) : (DataType.UUID.equals((Object)dataType) ? Uuid.read((String)valueString) : (DataType.ENUM.equals((Object)dataType) ? valueString : (entryInfo.getValueNumber() == null && !StringUtils.isEmpty((String)valueString) && DataType.INTEGER.equals((Object)dataType) ? Integer.valueOf(valueString) : (entryInfo.getValueNumber() == null && !StringUtils.isEmpty((String)valueString) && DataType.DECIMAL.equals((Object)dataType) ? new BigDecimal(valueString) : entryInfo.getValueString()))))));
            }
        } else if (property instanceof LinkPropertyInfo) {
            String valueString = entryInfo.getValueString();
            value = EmployeePageAuditServerUtil.getValue(ctx, valueString);
        } else {
            value = entryInfo.getValueString();
        }
        CoreBaseObjectUtil.setValue((Context)ctx, (CoreBaseInfo)objectValue, (String)fieldName, (Object)value);
    }

    public static SelectorItemCollection getSelectors(EmployeeAuditInfo info) {
        SelectorItemCollection sic = new SelectorItemCollection();
        EmployeeAuditEntryCollection entrys = info.getEntrys();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            sic.add(new SelectorItemInfo(entrys.get(i).getFieldName()));
        }
        return sic;
    }

    public static Object getValueDescription(Context ctx, CoreBaseInfo pageInfo, String propName) throws EASBizException, BOSException, UuidException {
        String description = null;
        BOSObjectType bosType = pageInfo.getBOSType();
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        PropertyInfo property = entity.getPropertyByNameRuntime(propName);
        if (null == pageInfo.get(propName)) {
            return "";
        }
        if (null == property || !property.isConfigured()) {
            Object tarValue = CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)pageInfo, (String)propName);
            description = EmployeePageAuditServerUtil.getValueDescription(ctx, tarValue);
        } else {
            description = EmployeePageAuditServerUtil.getCustomValueDescription(ctx, pageInfo, property, propName);
        }
        return description;
    }

    public static String getFieldDescription(Context ctx, String fieldName, CoreBaseInfo pageInfo, String propName, boolean isDifferent) throws BOSException, EASBizException, UuidException {
        StringBuffer desc = new StringBuffer();
        StringBuffer result = new StringBuffer();
        BOSObjectType bosType = pageInfo.getBOSType();
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        PropertyInfo property = entity.getPropertyByNameRuntime(propName);
        if (property == null || !property.isConfigured()) {
            desc.append(fieldName).append("\uff1a").append(EmployeePageAuditServerUtil.getValueDescription(ctx, pageInfo.get(propName)));
        } else if (property instanceof OwnPropertyInfo) {
            OwnPropertyInfo p = (OwnPropertyInfo)property;
            DataType dataType = p.getDataType();
            if (pageInfo.get(propName) != null) {
                if (DataType.ENUM.equals((Object)dataType)) {
                    BizEnumInfo bizEnumInfo = SHREnumUtil.getBizEnumInfoByOwnProperty((OwnPropertyInfo)p);
                    if (null == pageInfo.get(propName)) {
                        desc.append(fieldName).append("\uff1a");
                    } else if (pageInfo.get(propName) instanceof Enum) {
                        desc.append(fieldName).append("\uff1a").append(pageInfo.get(propName).toString());
                    } else {
                        desc.append(fieldName).append("\uff1a").append(EmployeePageAuditServerUtil.decideFieldValueIfEnumConfig(ctx, bizEnumInfo, pageInfo.get(propName).toString()));
                    }
                } else if (DataType.STRING.equals((Object)dataType)) {
                    desc.append(fieldName).append("\uff1a").append((String)pageInfo.get(propName));
                } else if (DataType.DATE.equals((Object)dataType)) {
                    Date date = (Date)pageInfo.get(propName);
                    String dateFormat = EmployeePageAuditServerUtil.dateFormat(date);
                    desc.append(fieldName).append("\uff1a").append(DateTimeUtils.format((Date)date, (String)dateFormat));
                } else if (DataType.DECIMAL.equals((Object)dataType)) {
                    desc.append(fieldName).append("\uff1a").append(pageInfo.get(propName).toString());
                } else if (DataType.BOOLEAN.equals((Object)dataType)) {
                    desc.append(fieldName).append("\uff1a");
                    if (Boolean.TRUE.equals((Boolean)pageInfo.get(propName))) {
                        desc.append(ResourceBase.getString((String)RESOURCE, (String)"YES", (Locale)ctx.getLocale()));
                    } else {
                        desc.append(ResourceBase.getString((String)RESOURCE, (String)"NOT", (Locale)ctx.getLocale()));
                    }
                }
            } else {
                desc.append(fieldName).append("\uff1a");
            }
        } else {
            CoreBaseInfo info = (CoreBaseInfo)pageInfo.get(propName);
            if (info == null) {
                desc.append(fieldName).append("\uff1a");
            } else {
                if (CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)info, (String)"name") == null) {
                    String pk = info.getId().toString();
                    info = EmployeePageAuditServerUtil.getValue(ctx, pk);
                }
                desc.append(fieldName).append("\uff1a").append((String)CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)info, (String)"name"));
            }
        }
        if (isDifferent) {
            result.append("<different>");
            result.append(desc).append("\uff1b");
            result.append("</different>");
        } else {
            result.append(desc).append("\uff1b");
        }
        return result.toString();
    }

    private static String getCustomValueDescription(Context ctx, CoreBaseInfo pageInfo, PropertyInfo property, String propName) throws EASBizException, BOSException, UuidException {
        String description = null;
        if (property instanceof OwnPropertyInfo) {
            OwnPropertyInfo p = (OwnPropertyInfo)property;
            DataType dataType = p.getDataType();
            if (DataType.ENUM.equals((Object)dataType)) {
                BizEnumInfo bizEnumInfo = SHREnumUtil.getBizEnumInfoByOwnProperty((OwnPropertyInfo)p);
                description = null == pageInfo.get(propName) ? "" : (pageInfo.get(propName) instanceof Enum ? pageInfo.get(propName).toString() : EmployeePageAuditServerUtil.decideFieldValueIfEnumConfig(ctx, bizEnumInfo, pageInfo.get(propName).toString()));
            } else if (DataType.OBJECTVALUE.equals((Object)dataType)) {
                CoreBaseInfo info = (CoreBaseInfo)pageInfo.get(propName);
                if (CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)info, (String)"name") == null) {
                    String pk = info.getId().toString();
                    info = EmployeePageAuditServerUtil.getValue(ctx, pk);
                }
                description = (String)CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)info, (String)"name");
            } else if (DataType.STRING.equals((Object)dataType)) {
                description = (String)pageInfo.get(propName);
            } else if (DataType.BOOLEAN.equals((Object)dataType)) {
                description = Boolean.TRUE.equals((Boolean)pageInfo.get(propName)) ? ResourceBase.getString((String)RESOURCE, (String)"YES", (Locale)ctx.getLocale()) : ResourceBase.getString((String)RESOURCE, (String)"NOT", (Locale)ctx.getLocale());
            } else if (DataType.DATE.equals((Object)dataType)) {
                Date date = (Date)pageInfo.get(propName);
                String dateFormat = EmployeePageAuditServerUtil.dateFormat(date);
                description = DateTimeUtils.format((Date)date, (String)dateFormat);
            } else if (DataType.DECIMAL.equals((Object)dataType)) {
                description = pageInfo.get(propName).toString();
            } else if (DataType.INTEGER.equals((Object)dataType)) {
                description = pageInfo.get(propName).toString();
            }
        } else {
            CoreBaseInfo info = (CoreBaseInfo)pageInfo.get(propName);
            if (CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)info, (String)"name") == null) {
                String pk = info.getId().toString();
                info = EmployeePageAuditServerUtil.getValue(ctx, pk);
                description = (String)CoreBaseObjectUtil.getValue((Context)ctx, (CoreBaseInfo)info, (String)"name");
            }
        }
        return description;
    }

    protected static String dateFormat(Date date) {
        String dateFormat = "yyyy-MM-dd";
        if (date == null) {
            return dateFormat;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        if ((hour > 0 || min > 0) && sec == 0) {
            dateFormat = "yyyy-MM-dd HH:mm";
        } else if ((hour > 0 || min > 0) && sec > 0) {
            dateFormat = "yyyy-MM-dd HH:mm:ss";
        }
        return dateFormat;
    }

    public static String decideFieldValueIfEnumConfig(Context ctx, BizEnumInfo bizEnum, String fieldValue) {
        String enumValue = "";
        BizEnumValueInfo enumValie = null;
        if (bizEnum.getDataType() == BizEnumValueType.INTEGER) {
            enumValie = bizEnum.getInnerEnumValue(Double.valueOf(fieldValue).intValue());
        } else if (bizEnum.getDataType() == BizEnumValueType.STRING) {
            enumValie = bizEnum.getInnerEnumValue(fieldValue);
        } else if (bizEnum.getDataType() == BizEnumValueType.LONG) {
            enumValie = bizEnum.getInnerEnumValue(Long.parseLong(fieldValue));
        } else if (bizEnum.getDataType() == BizEnumValueType.FLOAT) {
            enumValie = bizEnum.getInnerEnumValue(Float.parseFloat(fieldValue));
        } else if (bizEnum.getDataType() == BizEnumValueType.DOUBLE) {
            enumValie = bizEnum.getInnerEnumValue(Double.parseDouble(fieldValue));
        }
        if (enumValie != null) {
            enumValue = enumValie.getAlias();
        } else {
            logger.error("decideFieldValueIfEnumConfig error | bizEnum:" + bizEnum.toString() + ",fieldValue :" + fieldValue);
        }
        return enumValue;
    }
}

